#!/usr/bin/perl -w
##

package Bundle::Modules::Apache;

use 5.005;

our $VERSION = 2006.0528; ## (YYYY.MMDD)

##
## Bundle::Modules::Apache
##

package main;

use strict;

use warnings;

require Shell;

require XML::Dumper;

require CPANPLUS::Backend;

require Bundle::Modules::Test::Reporter;

my $context = 'Bundle::Modules::Apache';

$context =~ m/::(\w)$/;

$context = lc( $1 );

$context = 'stable' if ( $context ne 'unstable' );

my $xml = XML::Dumper->new();

$xml->dtd();

my $sh = Shell->new();

my $plus = CPANPLUS::Backend->new( 'conf' => { 'no_update'  => 0,
                                                 'allow_build_interactivity' => 1,
                                                 'verbose' => 1,
                                               } );

my $conf = $plus->configure_object();

$conf->set_conf( 'force' => 0 );

my $perm = ( $conf->get_conf( 'cpantest' ) )? 'Y' : 'N';

$conf->set_conf( 'cpantest' => 0 );

$conf->set_conf( 'prereqs' => 3 ); ## follow

$conf->set_conf( 'signature' => 1 );

$conf->set_conf( 'skiptest' => 0 );

$conf->set_conf( 'timeout' => 1 );

if ( defined( $ENV{'TEST_POD'} ) && ( $ENV{'TEST_POD'} == 1 ) )
{

}
else
{
   $plus->reload_indices( 'update_source' => 1, 'verbose' => 1 );

} ## end if

eval
{
   local $SIG{'ALRM'} = sub { die( "alarm\n" ) };

   alarm 30;

   $perm = ExtUtils::MakeMaker::prompt( "May I report installation security and stability statistics, via email, about the installs performed on your system?", $perm );

   alarm 0;

}; ## end eval

if ( $@ )
{
   ##
   ## timeout
   ##
   die( $@ ) unless ( $@ eq "alarm\n" );

   $perm = 'y';

   print "\n";

} ## end if

if ( $perm =~ /^y/i )
{
   $perm = 1;

}
else
{
   $perm = 0;

} ## end if

my $reporter = Bundle::Modules::Test::Reporter->new(
   'grade' => 'unstable',
   'distribution' => 'TBD',
   'comments' => 'Generated by Bundle::Modules::Apache.',
   'via' => 'Bundle::Modules::Apache 2006.0528'

   );

my @module = ();



push( @module, 'Apache::GTopLimit' );
push( @module, 'HTTP::WebTest::Plugin::Apache' );
push( @module, 'Apache::App::Gallery::Simple' );
push( @module, 'Apache::AuthenRadius' );
push( @module, 'Apache::GzipChain' );
push( @module, 'Apache::ACEProxy' );
push( @module, 'Apache::Access::Headers' );
push( @module, 'Apache2::ShowStatus' );
push( @module, 'Apache::SiteControl' );
push( @module, 'Apache::Imager::Resize' );
push( @module, 'Apache::DumpHeaders' );
push( @module, 'XML::ApacheFOP' );
push( @module, 'Apache::AxKit::Provider::PodSAX' );
push( @module, 'Apache::Sybase::ConPool' );
push( @module, 'Apache::ShowStatus' );
push( @module, 'Apache::PageKit' );
push( @module, 'Apache::AuthNetLDAP' );
push( @module, 'Apache::Session::Serialize::Dumper' );
push( @module, 'DynaPage::Apache2' );
push( @module, 'Apache::Album' );
push( @module, 'CGI::Application::Plugin::Apache' );
push( @module, 'Apache::Session::Memcached' );
push( @module, 'Apache::Session::Memorycached' );
push( @module, 'Apache::AuthExpire' );
push( @module, 'Apache::AxKit::Provider::File::Syntax' );
push( @module, 'Apache::AuthChecker' );
push( @module, 'Apache::AuthPOP3' );
push( @module, 'Apache::AuthenNIS' );
push( @module, 'Apache::Stage' );
push( @module, 'Apache::Backend::POE' );
push( @module, 'Apache::Voodoo' );
push( @module, 'Apache::AliasList' );
push( @module, 'Apache::Quota' );
push( @module, 'Apache::GeoIP' );
push( @module, 'Apache::Motd' );
push( @module, 'Apache::No404Proxy' );
push( @module, 'Apache::AxKit::Provider::RDBMS' );
push( @module, 'Apache::Session::Manager' );
push( @module, 'Apache::Gateway' );
push( @module, 'Apache::Session::Generate::ModUniqueId' );
push( @module, 'Apache::Session::Generate::AutoIncrement' );
push( @module, 'Apache::GopherHandler' );
push( @module, 'Apache2::Protocol' );
push( @module, 'Apache::AddReqHeader' );
push( @module, 'Apache::LoadAvgLimit' );
push( @module, 'Apache::ParseFormData' );
push( @module, 'Apache::ConfigParser' );
push( @module, 'Apache::PrettyText' );
push( @module, 'Apache::Usertrack' );
push( @module, 'Apache::Session::Generate::ModUsertrack' );
push( @module, 'Apache::GD::Thumbnail' );
push( @module, 'Apache::AuthenN2' );
push( @module, 'Apache::Precompress' );
push( @module, 'Apache::TimedRedirect' );
push( @module, 'Apache::TopicMaps' );
push( @module, 'Apache::AxKit::Language::XSP::ObjectTaglib' );
push( @module, 'Apache::Module' );
push( @module, 'Apache::DnsZone' );
push( @module, 'Apache::CacheContent' );
push( @module, 'Data::Phrasebook::Loader::ApacheFormat' );
push( @module, 'Apache::MultiAuth' );
push( @module, 'Apache::DBI' );
push( @module, 'Apache::CompressClientFixup' );
push( @module, 'Apache::AuthLDAP' );
push( @module, 'Apache::AuthCookie' );
push( @module, 'Catalyst::Engine::Apache' );
push( @module, 'Apache::Perldoc' );
push( @module, 'Apache2::SOAP' );
push( @module, 'Apache::Wombat' );
push( @module, 'Apache2::AuthenMSAD' );
push( @module, 'Apache::AuthzNetLDAP' );
push( @module, 'OpenFrame::Segment::Apache' );
push( @module, 'Apache::AxKit::Plugin::QueryStringCacheRegexp' );
push( @module, 'Apache::Session::Counted' );
push( @module, 'Apache::Mmap' );
push( @module, 'Apache::ProxyPass' );
push( @module, 'Apache::Session::SharedMem' );
push( @module, 'Apache::Archive' );
push( @module, 'Apache::DB' );
push( @module, 'Apache::Bwlog' );
push( @module, 'Apache::Blog' );
push( @module, 'Apache::AutoLogin' );
push( @module, 'Apache2::JemplateFilter' );
push( @module, 'Apache::AxKit::Provider::File::Formatter' );
push( @module, 'Apache::FakeCookie' );
push( @module, 'Apache::AuthenURL' );
push( @module, 'Apache::AxKit::Plugin::AddXSLParams::Request' );
push( @module, 'Apache::MP3::Skin' );
push( @module, 'Apache::VimColor' );
push( @module, 'Apache::ErrorControl' );
push( @module, 'Apache::Keywords' );
push( @module, 'Apache::Session::PHP' );
push( @module, 'Apache::CookieToQuery' );
push( @module, 'Apache::CGI::Builder' );
push( @module, 'Apache::CustomKeywords' );
push( @module, 'Apache::AuthenNISPlus' );
push( @module, 'Apache::ReverseProxy' );
push( @module, 'Apache::ForwardedFor' );
push( @module, 'Apache::FakeTable' );
push( @module, 'Apache::Gestinanna' );
push( @module, 'Apache::AuthPerLDAP' );
push( @module, 'Apache::UploadSvr' );
push( @module, 'Apache::SubProcess' );
push( @module, 'Apache::XPointer' );
push( @module, 'Apache::PerlVINC' );
push( @module, 'Apache::JemplateFilter' );
push( @module, 'Apache::TaintRequest' );
push( @module, 'Log::Agent::Driver::Apache' );
push( @module, 'Apache::EnvDir' );
push( @module, 'Apache::AuthenSecurID' );
push( @module, 'Apache::Htpasswd' );
push( @module, 'Apache::SecSess' );
push( @module, 'Apache::AuthTicket' );
push( @module, 'Apache::CodeRed' );
push( @module, 'Apache::Icon' );
push( @module, 'Apache::AuthPAM' );
push( @module, 'Apache::AuthenProgram' );
push( @module, 'Apache::LangPrefCookie' );
push( @module, 'Config::ApacheExtended' );
push( @module, 'Apache::AntiSpam' );
push( @module, 'Apache::SimpleTemplate' );
push( @module, 'Apache::AuthzCache' );
push( @module, 'Apache2::AuthenDBMCache' );
push( @module, 'Apache2::AuthenSmb' );
push( @module, 'Apache::AuthzLDAP' );
push( @module, 'Apache::FileManager' );
push( @module, 'MasonX::Request::WithApacheSession' );
push( @module, 'Apache::SharedMem' );
push( @module, 'Apache::ProxyConf' );
push( @module, 'Apache::MP3' );
push( @module, 'Apache::Action' );
push( @module, 'Apache::Session' );
push( @module, 'Apache2::AuthColloquy' );
push( @module, 'Apache2::DebugFilter' );
push( @module, 'Apache::DoCoMoUID' );
push( @module, 'Apache::MSIISProbes' );
push( @module, 'Apache::MiniWiki' );
push( @module, 'Apache::Singleton' );
push( @module, 'Apache::Scriptor' );
push( @module, 'Apache::Filter::HanConvert' );
push( @module, 'Apache2::TrapSubRequest' );
push( @module, 'Apache::Session::Serialize::YAML' );
push( @module, 'Apache::AuthenCache' );
push( @module, 'Apache::FormatLog' );
push( @module, 'Apache::LogRegex' );
push( @module, 'Apache::HTMLView' );
push( @module, 'Apache::Session::Lazy' );
push( @module, 'MasonX::Request::WithApache2Session' );
push( @module, 'Apache::OneTimeDownload' );
push( @module, 'Apache::PHLogin' );
push( @module, 'Apache::AuthenLDAP' );
push( @module, 'Apache::Watchdog::RunAway' );
push( @module, 'Apache::App::Mercury' );
push( @module, 'Apache::AuthDigest' );
push( @module, 'Apache::ParseControl' );
push( @module, 'HTML::Mason::ApacheHandler2' );
push( @module, 'Apache::Template' );
push( @module, 'Apache::PSP' );
push( @module, 'Apache::XPointer::RDQL' );
push( @module, 'SML::Apache' );
push( @module, 'Apache::MONITOR' );
push( @module, 'Apache::DAV' );
push( @module, 'Apache::Htgroup' );
push( @module, 'Apache::DoCoMoProxy' );
push( @module, 'Apache2::TieBucketBrigade' );
push( @module, 'Apache::Reload' );
push( @module, 'Apache::ProxyRewrite' );
push( @module, 'Apache::BruteWatch' );
push( @module, 'Apache::LogIgnore' );
push( @module, 'Apache::WinBitHack' );
push( @module, 'Apache::Session::Serialize::SOAPEnvelope' );
push( @module, 'Apache::AuthCookieDBI' );
push( @module, 'Apache::ContentHandler' );
push( @module, 'Apache::AuthenPasswd' );
push( @module, 'Apache::AuthTkt' );
push( @module, 'MasonX::Apache2Handler' );
push( @module, 'Apache2::ExplorerDestroyer' );
push( @module, 'Apache::AxKit::Provider::CGI' );
push( @module, 'Apache::OWA' );
push( @module, 'Apache::AppCluster' );
push( @module, 'Apache::ASP' );
push( @module, 'Apache::Session::Wrapper' );
push( @module, 'Apache2::AuthCookieDBImg' );
push( @module, 'Apache::AuthCookieLDAP' );
push( @module, 'Apache::CryptHash' );
push( @module, 'Apache::AuthenPasswdSrv' );
push( @module, 'Apache::AuthenNTLM' );
push( @module, 'Apache::DBILogin' );
push( @module, 'Apache::XPP' );
push( @module, 'Apache::Emulator' );
push( @module, 'Apache2::AuthenNTLM' );
push( @module, 'Apache::ProxyStuff' );
push( @module, 'Apache::ImageMagick' );
push( @module, 'Apache::Session::SQLite3' );
push( @module, 'Apache::AuthCAS' );
push( @module, 'Apache::DBILogConfig' );
push( @module, 'Apache::Layer' );
push( @module, 'Apache::AuthzPasswd' );
push( @module, 'Apache::Throttle' );
push( @module, 'Apache::Authen::Program' );
push( @module, 'Apache::AxKit::Language::LibXSLTEnhanced' );
push( @module, 'Apache::Htpasswd::Perishable' );
push( @module, 'Template::Plugin::Apache::SessionManager' );
push( @module, 'Apache::Recorder' );
push( @module, 'Apache::DefaultCharset' );
push( @module, 'Sledge::Pages::Apache::I18N' );
push( @module, 'Bundle::Apache::Wombat' );
push( @module, 'Apache::DBI::Cache' );
push( @module, 'Apache::SimpleReplace' );
push( @module, 'Apache2::ModSSL' );
push( @module, 'Apache::Handlers' );
push( @module, 'Apache::SMTP' );
push( @module, 'Apache::AddHostPath' );
push( @module, 'Apache::Test' );
push( @module, 'Config::ApacheFormat' );
push( @module, 'Apache::DebugLog' );
push( @module, 'Apache::Dispatch' );
push( @module, 'Apache::AxKit::Provider::OpenOffice' );
push( @module, 'Apache::JavaScript::DocumentWrite' );
push( @module, 'Apache::OutputChain' );
push( @module, 'Apache::AuthenSmb' );
push( @module, 'Apache::AxKit::Plugin::Upload' );
push( @module, 'Apache::Auth::UserDB' );
push( @module, 'Apache2::SafePnotes' );
push( @module, 'Apache::AuthLDAPBind' );
push( @module, 'Apache::WebSNMP' );
push( @module, 'Apache::Description' );
push( @module, 'Apache::Profiler' );
push( @module, 'Apache::Syntax::Highlight::Perl' );
push( @module, 'Apache::Request::Redirect' );
push( @module, 'Apache::AuthCookieNTLM' );
push( @module, 'Maypole::Plugin::Config::Apache' );
push( @module, 'Apache::Clickable' );
push( @module, 'Apache::HeavyCGI' );
push( @module, 'Apache::Lint' );
push( @module, 'Apache::iNcom' );
push( @module, 'Apache::RefererBlock' );
push( @module, 'Apache::VMonitor' );
push( @module, 'Apache::RandomLocation' );
push( @module, 'Apache::PrettyPerl' );
push( @module, 'Apache2::UploadProgress' );
push( @module, 'Apache::MagicPOST' );
push( @module, 'Apache::AuthCookiePAM' );
push( @module, 'Apache::SetWWWTheme' );
push( @module, 'Apache2::ClickPath' );
push( @module, 'Apache::LoggedAuthDBI' );
push( @module, 'Apache::HEADRegistry' );
push( @module, 'Apache::SessionX' );
push( @module, 'Apache::NavBarDD' );
push( @module, 'Apache::AxKit::Provider::DOM' );
push( @module, 'Apache::Dynagzip' );
push( @module, 'Apache::File::Resumable' );
push( @module, 'Apache2::Filter::HTTPHeadersFixup' );
push( @module, 'Apache::JumpByReferer' );
push( @module, 'Apache::AntiSpam::JavaScript' );
push( @module, 'Apache::AuthCookieURL' );
push( @module, 'Apache::Dir' );
push( @module, 'Apache::WAP::AutoIndex' );
push( @module, 'Apache::Pod' );
push( @module, 'Apache::SearchEngineLog' );
push( @module, 'Apache::Language' );
push( @module, 'Apache::ChooseLanguage' );
push( @module, 'Apache::Sybase::CTlib' );
push( @module, 'Apache::Peek' );
push( @module, 'Sledge::Request::Apache::I18N' );
push( @module, 'Apache2::AuthCookieDBI' );
push( @module, 'Apache::SSI' );
push( @module, 'Apache::Wyrd' );
push( @module, 'Acme::Apache::Werewolf' );
push( @module, 'Apache::Session::SQLite' );
push( @module, 'Apache::RewritingProxy' );
push( @module, 'Apache::AutoIndex' );
push( @module, 'Apache::Authen::Generic' );
push( @module, 'Apache::LogFile' );
push( @module, 'Apache::RSS' );
push( @module, 'Apache::Cache' );
push( @module, 'Apache::AxKit::StyleChooser::Hostname' );
push( @module, 'Apache::AuthzUserDir' );
push( @module, 'Apache::UploadMeter' );
push( @module, 'Apache::AntiSpam::SpamTrap' );
push( @module, 'Apache::Compress' );
push( @module, 'Apache::TieBucketBrigade' );
push( @module, 'Apache::AuthzNIS' );
push( @module, 'Apache::RequestNotes' );
push( @module, 'Apache2::SiteControl' );
push( @module, 'Apache2::Protocol::ESMTP' );
push( @module, 'Apache::Backhand' );
push( @module, 'Apache::TinyCP' );
push( @module, 'Apache::Storage' );
push( @module, 'Apache2::PPI::HTML' );
push( @module, 'Apache::PAR' );
push( @module, 'Apache2::AuthNetLDAP' );
push( @module, 'Apache::AxKit::Language::SpellCheck' );
push( @module, 'Apache::AuthenMT' );
push( @module, 'Apache::AuthKrb5Afs' );
push( @module, 'MasonX::Request::WithApacheSession2' );
push( @module, 'Apache::Scoreboard' );
push( @module, 'Apache::Roaming' );
push( @module, 'Apache::Queue' );
push( @module, 'Apache::Session::CacheAny' );
push( @module, 'Apache::AuthCookieDBIRadius' );
push( @module, 'Apache::ParseLog' );
push( @module, 'Apache::WAP::MailPeek' );
push( @module, 'Apache::AuthTypeKey' );
push( @module, 'Apache::MIMEMapper' );
push( @module, 'Apache::SessionManager' );
push( @module, 'MKDoc::Apache_Cache' );
push( @module, 'Apache::Centipaid' );
push( @module, 'Apache::Request::I18N' );
push( @module, 'Apache2::ModBT' );
push( @module, 'Apache::TempFile' );
push( @module, 'Apache::LogF' );
push( @module, 'Apache2::AUS' );
push( @module, 'Apache::Mailtrack' );
push( @module, 'Apache::StickyQuery' );
push( @module, 'Apache::CVS' );
push( @module, 'Apache::ProxyScan' );
push( @module, 'Apache::LangURI' );
push( @module, 'Apache::NNTPGateway' );
push( @module, 'Apache::XBEL' );
push( @module, 'Apache::AxKit::Plugin::Session' );
push( @module, 'Apache::SWIT' );
push( @module, 'Apache::JAF' );
push( @module, 'Apache::Admin::Config' );
push( @module, 'Apache::Scriptor::Simple' );
push( @module, 'Apache::AxKit::Plugin::Param::Expr' );
push( @module, 'Apache::Sandwich' );
push( @module, 'Apache::Proxy' );
push( @module, 'Apache2::Translation' );
push( @module, 'MasonX::Request::ExtendedCompRoot::WithApacheSession' );
push( @module, 'Apache::HTTunnel' );
push( @module, 'Apache::AuthzSplitDomainUser' );
push( @module, 'Apache::DebugInfo' );
push( @module, 'Apache::FilteringProxy' );
push( @module, 'Apache::Gallery' );
push( @module, 'Apache2::POST200' );
push( @module, 'OpenFrame::Segment::Apache2' );
push( @module, 'Apache::AxKit::Language::Svg2AnyFormat' );
push( @module, 'Apache::iTunes' );
push( @module, 'Apache::DBILogger' );
push( @module, 'Apache::GuessCharset' );
push( @module, 'Apache::OneTimeURL' );
push( @module, 'Apache::TransLDAP' );
push( @module, 'Apache::Traffic' );
push( @module, 'Apache::RandomImage' );
push( @module, 'Apache::Filter' );

fisher_yates_shuffle( \@module );

for ( my $i = 0; $i <= $#module; $i++ )
{
   my $name = $module[$i];

   $name =~ s/[:][:]/-/g;

   my $mi = $plus->module_tree( $module[$i] );


   eval( '$mi->package_name()' );

   next if ( @$ );

   next if ( $name ne $mi->package_name() );

   my $mid = $mi->package_name() . '-' . $mi->package_version();

   printf( "[BEGINNING] Distribution named %s is to be installed.\n", $mid );

   $mi->install();

   my $mist = $mi->status();

   my $xml_gz = undef;

   my $context_pl = undef;

   $reporter->distribution( $mid );

   if ( defined( $mist->extract() ) )
   {
      if ( $perm && ! -f $mist->extract().'/SIGNATURE' )
      {
         printf( "[REPORTING] %s missing SIGNATURE, sending insecurity message.\n", $mid );

         $reporter->grade( 'unsigned' );

         $reporter->send() || die $reporter->errstr();

      } ## end if

   } ## end if

   if ( ( $context eq 'stable' ) && ! $mist->installed() )
   {
      if ( $perm )
      {
         printf( "[REPORTING] %s failed to install, sending instablity message.\n", $mid );

         $reporter->grade( 'unstable' );

         $reporter->send() || die $reporter->errstr();

      } ## end if

      if ( -d '_dat' )
      {
         $xml_gz = 'Bundle::Modules::Apache::Unstable.xml.gz';

         $xml_gz =~ s/[:][:]/__/g;

         $context_pl = $xml->xml2pl( $xml_gz );

         $context_pl->{$module[$i]} = 1;

         $xml->pl2xml( $context_pl, $xml_gz );

      } ## end if

      printf( "[COMPLETED] Distribution named %s is not installed.\n", $mid );

   }
   elsif ( ( $context eq 'unstable' ) && $mist->installed() )
   {
      if ( ( $mist->signature() && $mist->checksum_ok() && -f $mist->extract().'/SIGNATURE' ) || ! $mist->created() )
      {
         if ( defined( $mist->extract() ) )
         {
            if ( $perm )
            {
               printf( "[REPORTING] %s is installed with a trusted signature, sending stablity message.\n", $mid );

               $reporter->grade( 'stable' );

            } ## end if

            if ( -d '_dat' )
            {
               $xml_gz = 'Bundle::Modules::Apache.xml.gz';

               $xml_gz =~ s/[:][:]/__/g;

               $context_pl = $xml->xml2pl( $xml_gz );

               $context_pl->{$module[$i]} = 0;

               $xml->pl2xml( $context_pl, $xml_gz );

            } ## end if

         }
         else
         {
            if ( $perm )
            {
               printf( "[REPORTING] %s is already installed, sending installed message.\n", $mid );

               $reporter->grade( 'installed' );

            } ## end if

         } ## end if

      }
      else
      {
         if ( $perm )
         {
            printf( "[REPORTING] %s is installed without a trusted signature, sending insecurity message.\n", $mid );

         $reporter->grade( 'signature' );

         } ## end if

      } ## end if

      if ( $perm )
      {
         $reporter->send() || die $reporter->errstr();

      } ## end if

      printf( "[COMPLETED] Distribution named %s is installed.\n", $mid );

   }
   elsif ( ( $context eq 'stable' ) && $mist->installed() )
   {
      printf( "[COMPLETED] Distribution named %s is installed.\n", $mid );

   }
   elsif ( ( $context eq 'unstable' ) && ! $mist->installed() )
   {
      printf( "[COMPLETED] Distribution named %s is not installed.\n", $mid );

   } ## end if

   if ( defined( $mist->extract() ) )
   {
      $sh->rm( '-Rf ' . $mist->extract() );

   } ## end if

} ## end for

##
## fisher_yates_shuffle - cookbook's in-place array permutation
##
sub fisher_yates_shuffle
{
   my $a = shift;

   for ( my $i = @$a; $i--; )
   {
      my $j = int( rand( $i + 1 ) );

      next if ( $i == $j );

      @$a[$i,$j] = @$a[$j,$i];

   } ## end for

} ## end sub fisher_yates_shuffle

1;

__END__

=head1 NAME

Bundle::Modules::Apache - All current I<stable> Apache modules in CPAN

=head1 SYNOPSIS

perl -MCPAN -e B<'install Bundle::Modules::Apache'>

cpan B<-i Bundle::Modules::Apache>

perl -MBundle::Modules::Apache

=head1 CONTENTS
Bundle::CPAN
Bundle::CPANPLUS
Bundle::Expect
Bundle::Test
Shell
=head1 CHANGES

=over

=item 2006.0510 (YYYY.MMDD)

Initial version of: Bundle::Modules::Apache-2006.0510

This B<L<Bundle::Modules>> component package is in pre-alpha state with hash ordering.

The ordering of listed modules will eventually be prioritized for efficiency and completeness.

Modules commented out of this module list are either I<unstable> or I<stable> in the B<L<Bundle::Modules>> context.

Optimistically, if there are a lot of the modules commented out, then they are I<stable>, and we're listing I<unstable> context.

Optimistically, if there are a few of the modules commented out, then they are I<unstable>, and we're listing I<stable> context.

If you use the command C<B<man Bundle::Modules::Apache>>, type C<B</#>> to see the commented out modules as they're higlighted for you by B<man>.

=item 2006.0520

This contains a newly refined concept of: Bundle::Modules::Apache-2006.0520

This B<L<Bundle::Modules>> component package is in pre-alpha state with randomized hash ordering.

The ordering of listed modules is now shuffled randomly on each run for better efficiency and completeness.

Modules are no longer listed in CONTENTS, like other 'Bundle::' bundles out there.  I just list Bundle::CPANPLUS.

I support the idea of testing of installations in mass, and I use the information provided by CPANPLUS test reports.

The B<L<Bundle::Modules>> suite has I<stable> and I<unstable> listings that will be updated using the information provided by the testers.db

The B<L<Bundle::Modules>> suite uses Module::Build in its Build.PL, and generates a compatible Makefile.PL.

The B<L<Bundle::Modules>> suite uses the CPANPLUS::Backend to create its own random-ordered installations.

=back

=head1 DESCRIPTION

This Bundle package will install all of the modules listed, if they're not commented out of the B<L<Bundle::Modules>> context.

=head1 SEE ALSO

I<L<Bundle::Modules>>, I<L<Bundle::Modules::Unstable>>, I<L<Bundle::Modules::CPAN>>, I<L<Bundle::Modules::CPAN::Unstable>>, I<L<Bundle::Modules::Apache::Unstable>>

=head1 AUTHORS

Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>

=head1 LICENSE for http://www.cpan.org/authors/id/E/ER/ERMEYERS/Bundle-Modules-2006.0528

perl

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=head1 COPYRIGHT

Copyright (C) 2006 by Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>


