# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.
BEGIN { require v5.8.3; }
use strict;
use warnings;
use ExtUtils::MakeMaker 6.30;
check_conflicts();

my %WriteMakefileArgs = (
  'ABSTRACT' => 'A postmodern object system for Perl 5',
  'AUTHOR' => 'Moose is maintained by the Moose Cabal, along with the help of many contributors. See L<Moose/CABAL> and L<Moose/CONTRIBUTORS> for details.',
  'BUILD_REQUIRES' => {
    'Test::Fatal' => '0.001',
    'Test::More' => '0.88',
    'Test::Requires' => '0.05'
  },
  'CONFIGURE_REQUIRES' => {
    'Dist::CheckConflicts' => '0.02',
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'Moose',
  'EXE_FILES' => [
    'bin/moose-outdated'
  ],
  'LICENSE' => 'perl',
  'NAME' => 'Moose',
  'OBJECT' => 'xs/Attribute$(OBJ_EXT) xs/AttributeCore$(OBJ_EXT) xs/Class$(OBJ_EXT) xs/Generated$(OBJ_EXT) xs/HasAttributes$(OBJ_EXT) xs/HasMethods$(OBJ_EXT) xs/Inlined$(OBJ_EXT) xs/Instance$(OBJ_EXT) xs/Method$(OBJ_EXT) xs/Moose$(OBJ_EXT) xs/MOP$(OBJ_EXT) xs/Overload$(OBJ_EXT) xs/Package$(OBJ_EXT) mop$(OBJ_EXT)',
  'PREREQ_PM' => {
    'Class::Load' => '0.09',
    'Class::Load::XS' => '0.01',
    'Data::OptList' => '0.107',
    'Devel::GlobalDestruction' => '0',
    'Dist::CheckConflicts' => '0.02',
    'Eval::Closure' => '0.04',
    'List::MoreUtils' => '0.28',
    'MRO::Compat' => '0.05',
    'Package::DeprecationManager' => '0.11',
    'Package::Stash' => '0.32',
    'Package::Stash::XS' => '0.24',
    'Params::Util' => '1.00',
    'Scalar::Util' => '1.19',
    'Sub::Exporter' => '0.980',
    'Sub::Name' => '0.05',
    'Task::Weaken' => '0',
    'Try::Tiny' => '0.02'
  },
  'VERSION' => '2.0600',
  'XS' => {
    'xs/Attribute.xs' => 'xs/Attribute.c',
    'xs/AttributeCore.xs' => 'xs/AttributeCore.c',
    'xs/Class.xs' => 'xs/Class.c',
    'xs/Generated.xs' => 'xs/Generated.c',
    'xs/HasAttributes.xs' => 'xs/HasAttributes.c',
    'xs/HasMethods.xs' => 'xs/HasMethods.c',
    'xs/Inlined.xs' => 'xs/Inlined.c',
    'xs/Instance.xs' => 'xs/Instance.c',
    'xs/MOP.xs' => 'xs/MOP.c',
    'xs/Method.xs' => 'xs/Method.c',
    'xs/Moose.xs' => 'xs/Moose.c',
    'xs/Overload.xs' => 'xs/Overload.c',
    'xs/Package.xs' => 'xs/Package.c'
  },
  'clean' => {
    'FILES' => 'xs/Attribute$(OBJ_EXT) xs/AttributeCore$(OBJ_EXT) xs/Class$(OBJ_EXT) xs/Generated$(OBJ_EXT) xs/HasAttributes$(OBJ_EXT) xs/HasMethods$(OBJ_EXT) xs/Inlined$(OBJ_EXT) xs/Instance$(OBJ_EXT) xs/Method$(OBJ_EXT) xs/Moose$(OBJ_EXT) xs/MOP$(OBJ_EXT) xs/Overload$(OBJ_EXT) xs/Package$(OBJ_EXT) mop$(OBJ_EXT)'
  },
  'test' => {
    'TESTS' => 't/*.t t/attributes/*.t t/basics/*.t t/bugs/*.t t/cmop/*.t t/compat/*.t t/examples/*.t t/immutable/*.t t/metaclasses/*.t t/moose_util/*.t t/native_traits/*.t t/recipes/*.t t/roles/*.t t/test_moose/*.t t/todo_tests/*.t t/type_constraints/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

$WriteMakefileArgs{CCFLAGS} = ( $Config::Config{ccflags} || '' ) . ' -I.';

WriteMakefile(%WriteMakefileArgs);



{
package MY;

use Config;

sub const_cccmd {
    my $ret = shift->SUPER::const_cccmd(@_);
    return q{} unless $ret;

    if ($Config{cc} =~ /^cl\b/i) {
        warn 'you are using MSVC... my condolences.';
        $ret .= ' /Fo$@';
    }
    else {
        $ret .= ' -o $@';
    }

    return $ret;
}

sub postamble {
    return <<'EOF';
$(OBJECT) : mop.h
EOF
}
}

sub check_conflicts {
    if ( eval { require 'lib/Moose/Conflicts.pm'; 1; } ) {
        if ( eval { Moose::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually using the 'moose-outdated' script that is installed with
    this distribution once the installation finishes.
***
EOF
    }

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
