package Locales::DB::Territory::lag;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Territory::lag::VERSION = '0.09';

$Locales::DB::Territory::lag::cldr_version = '2.0';

%Locales::DB::Territory::lag::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andóra',
    'ae'  => "Ʉtemi\ wa\ Kɨaráabu",
    'af'  => 'Afuganisitáani',
    'ag'  => "Antigúua\ na\ Baribúuda",
    'ai'  => 'Anguíila',
    'al'  => 'Alubánia',
    'am'  => 'Ariménia',
    'an'  => "Antili\ ya\ Ʉholáanzi",
    'ao'  => 'Angóola',
    'aq'  => 'Antarctica',
    'ar'  => 'Ajentíina',
    'as'  => "Samóoa\ ya\ Amerɨ́ka",
    'at'  => 'Áusitiria',
    'au'  => 'Ausiteréelia',
    'aw'  => 'Arúuba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Azabajáani',
    'ba'  => 'Bósinia',
    'bb'  => 'Babadóosi',
    'bd'  => 'Bangaladéeshi',
    'be'  => 'Ʉbeligíiji',
    'bf'  => 'Bukinafáaso',
    'bg'  => 'Buligaría',
    'bh'  => 'Baharéeni',
    'bi'  => 'Burúundi',
    'bj'  => 'Beníini',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Berimúuda',
    'bn'  => 'Burunéei',
    'bo'  => 'Bolívia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brasíili',
    'bs'  => 'Baháama',
    'bt'  => 'Butáani',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botiswáana',
    'by'  => 'Belarúusi',
    'bz'  => 'Belíise',
    'ca'  => 'Kánada',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Jamuhúuri\ ya\ Kɨdemokurasía\ ya\ Kóongo",
    'cf'  => "Juhúuri\ ya\ Afɨrɨka\ ya\ katɨ\ katɨ",
    'cg'  => 'Kóongo',
    'ch'  => 'Uswíisi',
    'ci'  => "Ivori\ Kositi",
    'ck'  => "Visíiwa\ vya\ Kúuku",
    'cl'  => 'Chíile',
    'cm'  => 'Kamerúuni',
    'cn'  => 'Chíina',
    'co'  => 'Kolómbia',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Kósita\ Rɨ́ɨka",
    'cs'  => "Sebíia\ na\ Montégiro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kyúuba',
    'cv'  => 'Kepuvéede',
    'cx'  => "Christmas\ Island",
    'cy'  => 'Kupuróosi',
    'cz'  => "Jamuhúuri\ ya\ Chéeki",
    'dd'  => "East\ Germany",
    'de'  => 'Ʉjerumáani',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Jibúuti',
    'dk'  => 'Denimaki',
    'dm'  => 'Domínɨka',
    'do'  => "Jamuhúuri\ ya\ Dominɨka",
    'dz'  => 'Alijéria',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Íkwado',
    'ee'  => 'Estonía',
    'eg'  => 'Mísiri',
    'eh'  => "Western\ Sahara",
    'er'  => 'Eriterea',
    'es'  => 'Hisipánia',
    'et'  => 'Ʉhabéeshi',
    'eu'  => "European\ Union",
    'fi'  => 'Ufíini',
    'fj'  => 'Fíiji',
    'fk'  => "Visíiwa\ vya\ Fakulandi",
    'fm'  => 'Mikironésia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Ʉfaráansa',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabóoni',
    'gb'  => 'Ʉɨngeréesa',
    'gd'  => 'Girenáada',
    'ge'  => 'Jójia',
    'gf'  => "Gwiyáana\ yʉ\ Ʉfaráansa",
    'gg'  => 'Guernsey',
    'gh'  => 'Gáana',
    'gi'  => 'Jiburálita',
    'gl'  => 'Giriniláandi',
    'gm'  => 'Gámbia',
    'gn'  => 'Gíine',
    'gp'  => 'Gwadelúupe',
    'gq'  => "Gíine\ Ikwéeta",
    'gr'  => 'Ugiríki',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Gwatemáala',
    'gu'  => 'Gwani',
    'gw'  => "Gíine\ Bisáau",
    'gy'  => 'Guyáana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Honduráasi',
    'hr'  => 'Koréshia',
    'ht'  => 'Haíiti',
    'hu'  => 'Hungária',
    'ic'  => "Canary\ Islands",
    'id'  => 'Indonésia',
    'ie'  => 'Ayaláandi',
    'il'  => 'Isiraéeli',
    'im'  => "Isle\ of\ Man",
    'in'  => 'Índia',
    'io'  => "Ɨsɨ\ yʉ\ Ʉɨngeréesa\ irivii\ ra\ Híindi",
    'iq'  => 'Iráaki',
    'ir'  => 'Ʉajéemi',
    'is'  => 'Aisiláandi',
    'it'  => 'Itália',
    'je'  => 'Jersey',
    'jm'  => 'Jamáika',
    'jo'  => 'Jódani',
    'jp'  => 'Japáani',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kéenya',
    'kg'  => 'Kirigisitáani',
    'kh'  => 'Kambódia',
    'ki'  => 'Kiribáati',
    'km'  => 'Komóoro',
    'kn'  => "Mʉtakatíifu\ kitisi\ na\ Nevíisi",
    'kp'  => "Koréa\ yʉ\ ʉtʉrʉko",
    'kr'  => "Koréa\ ya\ Saame",
    'kw'  => 'Kʉwáiti',
    'ky'  => "Visíiwa\ vya\ Kayimani",
    'kz'  => 'Kazakasitáani',
    'la'  => 'Laóosi',
    'lb'  => 'Lebanóoni',
    'lc'  => "Mʉtakatíifu\ Lusíia",
    'li'  => 'Lishentéeni',
    'lk'  => 'Siriláanka',
    'lr'  => 'Liibéria',
    'ls'  => 'Lesóoto',
    'lt'  => 'Lisuánia',
    'lu'  => 'Lasembáagi',
    'lv'  => 'Lativia',
    'ly'  => 'Líbia',
    'ma'  => 'Moróoko',
    'mc'  => 'Monáako',
    'md'  => 'Molidóova',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Bukíini',
    'mh'  => "Visíiwa\ vya\ Marisháali",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Masedónia',
    'ml'  => 'Máali',
    'mm'  => 'Miáama',
    'mn'  => 'Mongólia',
    'mo'  => 'Macau',
    'mp'  => "Visiwa\ vya\ Mariana\ vya\ Kaskazini",
    'mq'  => 'Maritiníiki',
    'mr'  => 'Moritánia',
    'ms'  => 'Monteráati',
    'mt'  => 'Málita',
    'mu'  => 'Moríisi',
    'mv'  => 'Modíivu',
    'mw'  => 'Maláawi',
    'mx'  => 'Mekisiko',
    'my'  => 'Maleísia',
    'mz'  => 'Musumbíiji',
    'na'  => 'Namíbia',
    'nc'  => "Kaledónia\ Ifya",
    'ne'  => 'Níija',
    'nf'  => "Kisíiwa\ cha\ Nofifóoki",
    'ng'  => 'Niijéria',
    'ni'  => 'Nikarágʉa',
    'nl'  => 'Ʉholáanzi',
    'no'  => 'Norwe',
    'np'  => 'Nepáali',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Naúuru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niúue',
    'nz'  => 'Nyuzílandi',
    'om'  => 'Ómani',
    'pa'  => 'Panáama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Péeru',
    'pf'  => "Polinésia\ yʉ\ Ʉfaráansa",
    'pg'  => 'Papúua',
    'ph'  => 'Ufilipíino',
    'pk'  => 'Pakisitáani',
    'pl'  => 'Pólandi',
    'pm'  => "Mʉtakatíifu\ Peéteri\ na\ Mɨkaéeli",
    'pn'  => 'Patikaírini',
    'pr'  => 'Pwetorɨ́ɨko',
    'ps'  => "Mweemberera\ wa\ kʉmweeri\ wa\ Gáaza",
    'pt'  => 'Ʉréeno',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Paláau',
    'py'  => 'Paraguáai',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katáari',
    'qo'  => "Outlying\ Oceania",
    're'  => 'Reyunióoni',
    'ro'  => 'Romaníia',
    'rs'  => 'Serbia',
    'ru'  => 'Urúusi',
    'rw'  => 'Rwáanda',
    'sa'  => "Saudíia\ Arabíia",
    'sb'  => "Visíiwa\ vya\ Solomóoni",
    'sc'  => 'Shelishéeli',
    'sd'  => 'Sudáani',
    'se'  => 'Uswíidi',
    'sg'  => 'Singapoo',
    'sh'  => "Mʉtakatíifu\ Heléena",
    'si'  => 'Sulovénia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Sulováakia',
    'sl'  => 'Seraleóoni',
    'sm'  => 'Samaríino',
    'sn'  => 'Senegáali',
    'so'  => 'Somália',
    'sr'  => 'Surináamu',
    'st'  => "Sao\ Tóome\ na\ Pirinsipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'Elisalivado',
    'sy'  => 'Síria',
    'sz'  => 'Ʉswáazi',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Visíiwa\ vya\ Turíiki\ na\ Kaíiko",
    'td'  => 'Cháadi',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Tóogo',
    'th'  => 'Táilandi',
    'tj'  => 'Tajikisitáani',
    'tk'  => 'Tokeláau',
    'tl'  => "Timóori\ yi\ Itʉʉmba",
    'tm'  => 'Uturukimenisitáani',
    'tn'  => 'Tunísia',
    'to'  => 'Tóonga',
    'tr'  => 'Uturúuki',
    'tt'  => "Tiriníida\ ya\ Tobáago",
    'tv'  => 'Tuváalu',
    'tw'  => 'Taiwáani',
    'tz'  => 'Taansanía',
    'ua'  => 'Ʉkɨréeni',
    'ug'  => 'Ʉgáanda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'Amerɨka',
    'uy'  => 'Uruguáai',
    'uz'  => 'Usibekisitáani',
    'va'  => 'Vatikáani',
    'vc'  => "Mʉtakatíifu\ Viséenti\ na\ Gernadíini",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuéela',
    'vg'  => "Visíiwa\ vya\ Vigíini\ vya\ Ʉɨngeréesa",
    'vi'  => "Visíiwa\ vya\ Vigíini\ vya\ Amerɨ́ka",
    'vn'  => 'Vietináamu',
    'vu'  => 'Vanuáatu',
    'wf'  => "Walíisi\ na\ Futúuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samóoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yémeni',
    'yt'  => 'Mayóote',
    'za'  => "Afɨrɨka\ ya\ Saame",
    'zm'  => 'Sámbia',
    'zw'  => 'Simbáabwe',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::lag::name_to_code = (
    'africa'                                    => '002',
    'afuganisitáani'                           => 'af',
    'afɨrɨkayasaame'                          => 'za',
    'aisiláandi'                               => 'is',
    'ajentíina'                                => 'ar',
    'alijéria'                                 => 'dz',
    'alubánia'                                 => 'al',
    'americas'                                  => '019',
    'amerɨka'                                  => 'us',
    'andóra'                                   => 'ad',
    'anguíila'                                 => 'ai',
    'angóola'                                  => 'ao',
    'antarctica'                                => 'aq',
    'antigúuanabaribúuda'                     => 'ag',
    'antiliyaɄholáanzi'                       => 'an',
    'ariménia'                                 => 'am',
    'arúuba'                                   => 'aw',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'ausiteréelia'                             => 'au',
    'australiaandnewzealand'                    => '053',
    'ayaláandi'                                => 'ie',
    'azabajáani'                               => 'az',
    'babadóosi'                                => 'bb',
    'baharéeni'                                => 'bh',
    'baháama'                                  => 'bs',
    'bangaladéeshi'                            => 'bd',
    'belarúusi'                                => 'by',
    'belíise'                                  => 'bz',
    'beníini'                                  => 'bj',
    'berimúuda'                                => 'bm',
    'bolívia'                                  => 'bo',
    'botiswáana'                               => 'bw',
    'bouvetisland'                              => 'bv',
    'brasíili'                                 => 'br',
    'britishantarcticterritory'                 => 'bq',
    'bukinafáaso'                              => 'bf',
    'bukíini'                                  => 'mg',
    'buligaría'                                => 'bg',
    'burunéei'                                 => 'bn',
    'burúundi'                                 => 'bi',
    'butáani'                                  => 'bt',
    'bósinia'                                  => 'ba',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'caribbean'                                 => '029',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'channelislands'                            => 830,
    'christmasisland'                           => 'cx',
    'cháadi'                                   => 'td',
    'chíile'                                   => 'cl',
    'chíina'                                   => 'cn',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'commonwealthofindependentstates'           => 172,
    'czechoslovakia'                            => 200,
    'denimaki'                                  => 'dk',
    'diegogarcia'                               => 'dg',
    'domínɨka'                                => 'dm',
    'dronningmaudland'                          => 'nq',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'elisalivado'                               => 'sv',
    'eriterea'                                  => 'er',
    'estonía'                                  => 'ee',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'faroeislands'                              => 'fo',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'fíiji'                                    => 'fj',
    'gabóoni'                                  => 'ga',
    'girenáada'                                => 'gd',
    'giriniláandi'                             => 'gl',
    'guernsey'                                  => 'gg',
    'guyáana'                                  => 'gy',
    'gwadelúupe'                               => 'gp',
    'gwani'                                     => 'gu',
    'gwatemáala'                               => 'gt',
    'gwiyáanayʉɄfaráansa'                   => 'gf',
    'gáana'                                    => 'gh',
    'gámbia'                                   => 'gm',
    'gíine'                                    => 'gn',
    'gíinebisáau'                             => 'gw',
    'gíineikwéeta'                            => 'gq',
    'haíiti'                                   => 'ht',
    'heardislandandmcdonaldislands'             => 'hm',
    'hisipánia'                                => 'es',
    'honduráasi'                               => 'hn',
    'hongkong'                                  => 'hk',
    'hungária'                                 => 'hu',
    'indonésia'                                => 'id',
    'iráaki'                                   => 'iq',
    'isiraéeli'                                => 'il',
    'isleofman'                                 => 'im',
    'itália'                                   => 'it',
    'ivorikositi'                               => 'ci',
    'jamuhúuriyachéeki'                       => 'cz',
    'jamuhúuriyadominɨka'                     => 'do',
    'jamuhúuriyakɨdemokurasíayakóongo'      => 'cd',
    'jamáika'                                  => 'jm',
    'japáani'                                  => 'jp',
    'jersey'                                    => 'je',
    'jiburálita'                               => 'gi',
    'jibúuti'                                  => 'dj',
    'johnstonisland'                            => 'jt',
    'juhúuriyaafɨrɨkayakatɨkatɨ'           => 'cf',
    'jódani'                                   => 'jo',
    'jójia'                                    => 'ge',
    'kaledóniaifya'                            => 'nc',
    'kambódia'                                 => 'kh',
    'kamerúuni'                                => 'cm',
    'katáari'                                  => 'qa',
    'kazakasitáani'                            => 'kz',
    'kepuvéede'                                => 'cv',
    'kiribáati'                                => 'ki',
    'kirigisitáani'                            => 'kg',
    'kisíiwachanofifóoki'                     => 'nf',
    'kolómbia'                                 => 'co',
    'komóoro'                                  => 'km',
    'koréayasaame'                             => 'kr',
    'koréayʉʉtʉrʉko'                       => 'kp',
    'koréshia'                                 => 'hr',
    'kupuróosi'                                => 'cy',
    'kyúuba'                                   => 'cu',
    'kánada'                                   => 'ca',
    'kéenya'                                   => 'ke',
    'kóongo'                                   => 'cg',
    'kósitarɨ́ɨka'                          => 'cr',
    'kʉwáiti'                                 => 'kw',
    'lasembáagi'                               => 'lu',
    'latinamerica'                              => 419,
    'lativia'                                   => 'lv',
    'laóosi'                                   => 'la',
    'lebanóoni'                                => 'lb',
    'lesóoto'                                  => 'ls',
    'liibéria'                                 => 'lr',
    'lishentéeni'                              => 'li',
    'lisuánia'                                 => 'lt',
    'líbia'                                    => 'ly',
    'macau'                                     => 'mo',
    'maleísia'                                 => 'my',
    'maláawi'                                  => 'mw',
    'maritiníiki'                              => 'mq',
    'masedónia'                                => 'mk',
    'mayóote'                                  => 'yt',
    'mekisiko'                                  => 'mx',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'mikironésia'                              => 'fm',
    'miáama'                                   => 'mm',
    'modíivu'                                  => 'mv',
    'molidóova'                                => 'md',
    'mongólia'                                 => 'mn',
    'montenegro'                                => 'me',
    'monteráati'                               => 'ms',
    'monáako'                                  => 'mc',
    'moritánia'                                => 'mr',
    'moríisi'                                  => 'mu',
    'moróoko'                                  => 'ma',
    'musumbíiji'                               => 'mz',
    'mweembererawakʉmweeriwagáaza'            => 'ps',
    'máali'                                    => 'ml',
    'málita'                                   => 'mt',
    'mísiri'                                   => 'eg',
    'mʉtakatíifuheléena'                     => 'sh',
    'mʉtakatíifukitisinanevíisi'             => 'kn',
    'mʉtakatíifulusíia'                      => 'lc',
    'mʉtakatíifupeéterinamɨkaéeli'         => 'pm',
    'mʉtakatíifuviséentinagernadíini'       => 'vc',
    'namíbia'                                  => 'na',
    'naúuru'                                   => 'nr',
    'nepáali'                                  => 'np',
    'neutralzone'                               => 'nt',
    'niijéria'                                 => 'ng',
    'nikarágʉa'                               => 'ni',
    'niúue'                                    => 'nu',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northvietnam'                              => 'vd',
    'norwe'                                     => 'no',
    'nyuzílandi'                               => 'nz',
    'níija'                                    => 'ne',
    'oceania'                                   => '009',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'pakisitáani'                              => 'pk',
    'paláau'                                   => 'pw',
    'panamacanalzone'                           => 'pz',
    'panáama'                                  => 'pa',
    'papúua'                                   => 'pg',
    'paraguáai'                                => 'py',
    'patikaírini'                              => 'pn',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'polinésiayʉɄfaráansa'                  => 'pf',
    'polynesia'                                 => '061',
    'pwetorɨ́ɨko'                            => 'pr',
    'péeru'                                    => 'pe',
    'pólandi'                                  => 'pl',
    'reyunióoni'                               => 're',
    'romaníia'                                 => 'ro',
    'rwáanda'                                  => 'rw',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'saintmartin'                               => 'mf',
    'samaríino'                                => 'sm',
    'samóoa'                                   => 'ws',
    'samóoayaamerɨ́ka'                       => 'as',
    'saotóomenapirinsipe'                      => 'st',
    'saudíiaarabíia'                          => 'sa',
    'sebíianamontégiro'                       => 'cs',
    'senegáali'                                => 'sn',
    'seraleóoni'                               => 'sl',
    'serbia'                                    => 'rs',
    'shelishéeli'                              => 'sc',
    'simbáabwe'                                => 'zw',
    'singapoo'                                  => 'sg',
    'siriláanka'                               => 'lk',
    'somália'                                  => 'so',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'sudáani'                                  => 'sd',
    'sulováakia'                               => 'sk',
    'sulovénia'                                => 'si',
    'surináamu'                                => 'sr',
    'svalbardandjanmayen'                       => 'sj',
    'sámbia'                                   => 'zm',
    'síria'                                    => 'sy',
    'taansanía'                                => 'tz',
    'taiwáani'                                 => 'tw',
    'tajikisitáani'                            => 'tj',
    'timóoriyiitʉʉmba'                       => 'tl',
    'tiriníidayatobáago'                      => 'tt',
    'tokeláau'                                 => 'tk',
    'tristandacunha'                            => 'ta',
    'tunísia'                                  => 'tn',
    'tuváalu'                                  => 'tv',
    'táilandi'                                 => 'th',
    'tóogo'                                    => 'tg',
    'tóonga'                                   => 'to',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'ufilipíino'                               => 'ph',
    'ufíini'                                   => 'fi',
    'ugiríki'                                  => 'gr',
    'unionofsovietsocialistrepublics'           => 'su',
    'unknownregion'                             => 'zz',
    'uruguáai'                                 => 'uy',
    'urúusi'                                   => 'ru',
    'usibekisitáani'                           => 'uz',
    'uswíidi'                                  => 'se',
    'uswíisi'                                  => 'ch',
    'uturukimenisitáani'                       => 'tm',
    'uturúuki'                                 => 'tr',
    'vanuáatu'                                 => 'vu',
    'vatikáani'                                => 'va',
    'venezuéela'                               => 've',
    'vietináamu'                               => 'vn',
    'visiwavyamarianavyakaskazini'              => 'mp',
    'visíiwavyafakulandi'                      => 'fk',
    'visíiwavyakayimani'                       => 'ky',
    'visíiwavyakúuku'                         => 'ck',
    'visíiwavyamarisháali'                    => 'mh',
    'visíiwavyasolomóoni'                     => 'sb',
    'visíiwavyaturíikinakaíiko'              => 'tc',
    'visíiwavyavigíinivyaamerɨ́ka'          => 'vi',
    'visíiwavyavigíinivyaɄɨngeréesa'       => 'vg',
    'wakeisland'                                => 'wk',
    'walíisinafutúuna'                        => 'wf',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'world'                                     => '001',
    'yémeni'                                   => 'ye',
    'Áusitiria'                                => 'at',
    "\Ã\landislands"                         => 'ax',
    'Íkwado'                                   => 'ec',
    'Índia'                                    => 'in',
    'Ómani'                                    => 'om',
    'ƗsɨyʉɄɨngeréesairiviirahíindi'      => 'io',
    'Ʉajéemi'                                 => 'ir',
    'Ʉbeligíiji'                              => 'be',
    'Ʉfaráansa'                               => 'fr',
    'Ʉgáanda'                                 => 'ug',
    'Ʉhabéeshi'                               => 'et',
    'Ʉholáanzi'                               => 'nl',
    'Ʉjerumáani'                              => 'de',
    'Ʉkɨréeni'                               => 'ua',
    'Ʉréeno'                                  => 'pt',
    'Ʉswáazi'                                 => 'sz',
    'Ʉtemiwakɨaráabu'                        => 'ae',
    'Ʉɨngeréesa'                             => 'gb',
);

1;

