package Locales::DB::Language::cy;

# Auto generated from CLDR

$Locales::DB::Language::cy::VERSION = '0.07';

$Locales::DB::Language::cy::cldr_version = '2.0';

%Locales::DB::Language::cy::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'two',
            'few',
            'many',
            'zero',
            'other'
        ],
        'category_rules' => {
            'few'  => "n\ is\ 3",
            'many' => "n\ is\ 6",
            'one'  => "n\ is\ 1",
            'two'  => "n\ is\ 2",
            'zero' => "n\ is\ 0"
        },
        'category_rules_compiled' => {
            'few'  => "sub\ \{\ return\ \'few\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 3\)\)\)\;\ return\;\}\;",
            'many' => "sub\ \{\ return\ \'many\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 6\)\)\)\;\ return\;\}\;",
            'one'  => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;",
            'two'  => "sub\ \{\ return\ \'two\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 2\)\)\)\;\ return\;\}\;",
            'zero' => "sub\ \{\ return\ \'zero\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 0\)\)\)\;\ return\;\}\;"
        }
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::cy::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abcaseg',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Affricaneg',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amhareg',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Arabeg',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Asameg',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerbaijani',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'Belarwsiyn',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'Bwlgareg',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambareg',
    'bn'    => "Bengali\;\ Bangla",
    'bnt'   => 'Bantu',
    'bo'    => 'Tibeteg',
    'br'    => 'Llydaweg',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'Bosnieg',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalaneg',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Tsiec',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'Cymraeg',
    'da'    => 'Daneg',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'Almaeneg',
    'de_at' => "Almaeneg\ Awstria",
    'de_ch' => "Almaeneg\ Safonol\ y\ Swistir",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'Groeg',
    'elx'   => 'Elamite',
    'en'    => 'Saesneg',
    'en_au' => "Saesneg\ Awstralia",
    'en_ca' => "Saesneg\ Canada",
    'en_gb' => "Saesneg\ Prydain",
    'en_us' => "Saesneg\ UDA",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Sbaeneg',
    'es_es' => "Sbaeneg\ Iberia",
    'et'    => 'Estoneg',
    'eu'    => 'Basgeg',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persieg',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Ffineg',
    'fil'   => 'Tagalog',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Ffijïeg',
    'fo'    => 'Ffaroeg',
    'fon'   => 'Fon',
    'fr'    => 'Ffrangeg',
    'fr_ca' => "Ffrangeg\ Canada",
    'fr_ch' => "Ffrangeg\ y\ Swistir",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'Ffrisieg',
    'ga'    => 'Gwyddeleg',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Gaeleg\ yr\ Alban",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Galiseg',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Gwjarati',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hawsa',
    'hai'   => 'Haida',
    'haw'   => 'Hawäieg',
    'he'    => 'Hebraeg',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Croateg',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Hwngareg',
    'hup'   => 'Hupa',
    'hy'    => 'Armeneg',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indonesieg',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Islandeg',
    'it'    => 'Eidaleg',
    'iu'    => 'Inuktitut',
    'ja'    => 'Siapaneeg',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Jafanaeg',
    'ka'    => 'Georgeg',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'Cambodieg',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Corëeg',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Cashmireg',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Cwrdeg',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kyrgyz',
    'la'    => 'Lladin',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Laoeg',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lithwaneg',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'Latfieg',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasi',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'Macedoneg',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongoleg',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malai',
    'mt'    => 'Malteseg',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Byrmaneg',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Nepali',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Iseldireg',
    'nl_be' => 'Fflemineg',
    'nmg'   => 'Kwasio',
    'nn'    => "Norwyeg\ \(Nynorsk\)",
    'no'    => 'Norwyeg',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Ocsitaneg',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Pwnjabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Pwyleg',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pashto',
    'pt'    => 'Portiwgaleg',
    'pt_br' => "Portiwgaleg\ Brasil",
    'pt_pt' => "Portiwgaleg\ Iberia",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'Romansh',
    'rn'    => 'Rundi',
    'ro'    => 'Rwmaneg',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'Rwsieg',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'Sansgrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Iacwteg',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Serbo\-Croateg",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'Sinhaleg',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Slofaceg',
    'sl'    => 'Slofeneg',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somaleg',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albaneg',
    'sr'    => 'Serbeg',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => 'Sesotheg',
    'su'    => 'Sundaneg',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Swedeg',
    'sw'    => 'Swahili',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ Language",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajiceg',
    'th'    => 'Thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Tyrcmeneg',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Tyrceg',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitïeg',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Uighur',
    'uga'   => 'Ugaritic',
    'uk'    => 'Wcreineg',
    'umb'   => 'Umbundu',
    'und'   => 'anh',
    'ur'    => 'Wrdw',
    'uz'    => 'Wsbeceg',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Fietnameg',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Woloff',
    'xal'   => 'Kalmyk',
    'xh'    => 'Xhosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => "Iddew\-Almaeneg",
    'yo'    => 'Iorwba',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantoneg',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Tseineeg',
    'znd'   => 'Zande',
    'zu'    => 'Zwlw',
    'zun'   => 'Zuni',
    'zxx'   => "Dim\ geiriau\ i\'w\ cael",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::cy::name_to_code = (
    'abcaseg'                       => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'affricaneg'                    => 'af',
    'afrihili'                      => 'afh',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albaneg'                       => 'sq',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'almaeneg'                      => 'de',
    'almaenegawstria'               => 'de_at',
    'almaenegsafonolyswistir'       => 'de_ch',
    'altaiclanguage'                => 'tut',
    'amhareg'                       => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'anh'                           => 'und',
    'apachelanguage'                => 'apa',
    'arabeg'                        => 'ar',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armeneg'                       => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asameg'                        => 'as',
    'asturian'                      => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianlanguage'            => 'aus',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'azerbaijani'                   => 'az',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambareg'                      => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'basgeg'                        => 'eu',
    'bashkir'                       => 'ba',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'belarwsiyn'                    => 'be',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    "bengali\;bangla"               => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bihari'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'bosnieg'                       => 'bs',
    'braj'                          => 'bra',
    'buginese'                      => 'bug',
    'buriat'                        => 'bua',
    'bwlgareg'                      => 'bg',
    'byrmaneg'                      => 'my',
    'caddo'                         => 'cad',
    'cambodieg'                     => 'km',
    'cantoneg'                      => 'yue',
    'carib'                         => 'car',
    'cashmireg'                     => 'ks',
    'catalaneg'                     => 'ca',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'comorian'                      => 'swb',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'corëeg'                       => 'ko',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'croateg'                       => 'hr',
    'cushiticlanguage'              => 'cus',
    'cwrdeg'                        => 'ku',
    'cymraeg'                       => 'cy',
    'dakota'                        => 'dak',
    'daneg'                         => 'da',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dimgeiriauiwcael'              => 'zxx',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'eidaleg'                       => 'it',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'esperanto'                     => 'eo',
    'estoneg'                       => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'ffaroeg'                       => 'fo',
    'ffijïeg'                      => 'fj',
    'ffineg'                        => 'fi',
    'fflemineg'                     => 'nl_be',
    'ffrangeg'                      => 'fr',
    'ffrangegcanada'                => 'fr_ca',
    'ffrangegyswistir'              => 'fr_ch',
    'ffrisieg'                      => 'fy',
    'fietnameg'                     => 'vi',
    'finnougrianlanguage'           => 'fiu',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'gaelegyralban'                 => 'gd',
    'galiseg'                       => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'georgeg'                       => 'ka',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'groeg'                         => 'el',
    'guarani'                       => 'gn',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'gwjarati'                      => 'gu',
    'gwyddeleg'                     => 'ga',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hawsa'                         => 'ha',
    'hawäieg'                      => 'haw',
    'hebraeg'                       => 'he',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindi'                         => 'hi',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'hwngareg'                      => 'hu',
    'iacwteg'                       => 'sah',
    'iban'                          => 'iba',
    'iddewalmaeneg'                 => 'yi',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indonesieg'                    => 'id',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iorwba'                        => 'yo',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'iseldireg'                     => 'nl',
    'islandeg'                      => 'is',
    'jafanaeg'                      => 'jv',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kannada'                       => 'kn',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashubian'                     => 'csb',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'klingon'                       => 'tlh',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'kyrgyz'                        => 'ky',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'laoeg'                         => 'lo',
    'latfieg'                       => 'lv',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lithwaneg'                     => 'lt',
    'lladin'                        => 'la',
    'llydaweg'                      => 'br',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'luyia'                         => 'luy',
    'macedoneg'                     => 'mk',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'malagasi'                      => 'mg',
    'malai'                         => 'ms',
    'malayalam'                     => 'ml',
    'malteseg'                      => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'marathi'                       => 'mr',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongoleg'                      => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nepali'                        => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'norwyeg'                       => 'no',
    'norwyegnynorsk'                => 'nn',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ocsitaneg'                     => 'oc',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'pashto'                        => 'ps',
    'persieg'                       => 'fa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portiwgaleg'                   => 'pt',
    'portiwgalegbrasil'             => 'pt_br',
    'portiwgalegiberia'             => 'pt_pt',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'pwnjabi'                       => 'pa',
    'pwyleg'                        => 'pl',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romansh'                       => 'rm',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'rundi'                         => 'rn',
    'rwa'                           => 'rwk',
    'rwmaneg'                       => 'ro',
    'rwsieg'                        => 'ru',
    'saesneg'                       => 'en',
    'saesnegawstralia'              => 'en_au',
    'saesnegcanada'                 => 'en_ca',
    'saesnegprydain'                => 'en_gb',
    'saesneguda'                    => 'en_us',
    'saho'                          => 'ssy',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sangu'                         => 'sbp',
    'sansgrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'sbaeneg'                       => 'es',
    'sbaenegiberia'                 => 'es_es',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serbeg'                        => 'sr',
    'serbocroateg'                  => 'sh',
    'serer'                         => 'srr',
    'sesotheg'                      => 'st',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'siapaneeg'                     => 'ja',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinhaleg'                      => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'slofaceg'                      => 'sk',
    'slofeneg'                      => 'sl',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'somaleg'                       => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'sundaneg'                      => 'su',
    'susu'                          => 'sus',
    'swahili'                       => 'sw',
    'swati'                         => 'ss',
    'swedeg'                        => 'sv',
    'swissgerman'                   => 'gsw',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tagalog'                       => 'tl',
    'tahitïeg'                     => 'ty',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tajiceg'                       => 'tg',
    'tamashek'                      => 'tmh',
    'tamil'                         => 'ta',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tatar'                         => 'tt',
    'telugu'                        => 'te',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'thai'                          => 'th',
    'tibeteg'                       => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tseineeg'                      => 'zh',
    'tsiec'                         => 'cs',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    'tyrceg'                        => 'tr',
    'tyrcmeneg'                     => 'tk',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'uighur'                        => 'ug',
    'umbundu'                       => 'umb',
    'uppersorbian'                  => 'hsb',
    'vai'                           => 'vai',
    'venda'                         => 've',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wcreineg'                      => 'uk',
    'woloff'                        => 'wo',
    'wrdw'                          => 'ur',
    'wsbeceg'                       => 'uz',
    'xhosa'                         => 'xh',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
    'zwlw'                          => 'zu',
);

1;
