package Locales::DB::Language::tr;

# Auto generated from CLDR

$Locales::DB::Language::tr::VERSION = '0.07';

$Locales::DB::Language::tr::cldr_version = '2.0';

%Locales::DB::Language::tr::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Dil\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ ve\ \{1\}",
            'end'    => "\{0\}\ ve\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\%\#\,\#\#0",
        'territory' => "Bölge\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => [ 'other' ],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "hayır\:hayir\:h",
        'yesstr' => "evet\:e"
    },
);

%Locales::DB::Language::tr::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abhazca',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adigece',
    'ae'    => 'Avestçe',
    'af'    => "Afrikaan\ Dili",
    'afa'   => "Afro\-Asyatik\ Diller",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => "Ayni\ Dili",
    'ak'    => 'Akan',
    'akk'   => "Akad\ Dili",
    'ale'   => 'Aleut',
    'alg'   => "Algonkin\ Dili",
    'alt'   => "Güney\ Altayca",
    'am'    => 'Amharca',
    'an'    => 'Aragonca',
    'ang'   => "Eski\ İngilizce",
    'anp'   => 'Angika',
    'apa'   => "Apaçi\ Dilleri",
    'ar'    => 'Arapça',
    'arc'   => 'Aramice',
    'arn'   => "Araukanya\ Dili",
    'arp'   => "Arapaho\ Dili",
    'art'   => "Yapay\ Diller",
    'arw'   => "Arawak\ Dili",
    'as'    => 'Assamca',
    'asa'   => 'Asu',
    'ast'   => 'Asturyasca',
    'ath'   => "Atabaşkan\ Dilleri",
    'aus'   => "Avustralya\ Dilleri",
    'av'    => "Avar\ Dili",
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Başkırtça',
    'bad'   => "Banda\ Dili",
    'bai'   => "Bamileke\ Dilleri",
    'bal'   => 'Baluchi',
    'ban'   => "Bali\ Dili",
    'bas'   => "Basa\ Dili",
    'bat'   => "Baltık\ Dilleri",
    'be'    => "Beyaz\ Rusça",
    'bej'   => "Beja\ Dili",
    'bem'   => 'Bemba',
    'ber'   => 'Berberi',
    'bez'   => 'Bena',
    'bg'    => 'Bulgarca',
    'bh'    => 'Bihari',
    'bho'   => 'Arayanice',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengalce',
    'bnt'   => "Bantu\ Dili",
    'bo'    => 'Tibetçe',
    'br'    => 'Bretonca',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'Boşnakça',
    'btk'   => 'Batak',
    'bua'   => 'Buryat',
    'bug'   => 'Bugis',
    'byn'   => 'Blin',
    'ca'    => 'Katalanca',
    'cad'   => 'Caddo',
    'cai'   => "Orta\ Amerika\ Yerli\ Dilleri",
    'car'   => 'Carib',
    'cau'   => "Kafkas\ Dilleri",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Çeçence',
    'ceb'   => 'Cebuano',
    'cel'   => "Kelt\ Dilleri",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => "Çağatay\ Dili",
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Çeroki',
    'chy'   => "Şayen\ Dili",
    'cmc'   => "Chamic\ Dilleri",
    'co'    => 'Korsikaca',
    'cop'   => 'Kıptice',
    'cpe'   => "İngilizce\ tabanlı\ Creole\ ve\ Pidgin\ Dilleri",
    'cpf'   => "Fransızca\ tabanlı\ Creole\ ve\ Pidgin\ Dilleri",
    'cpp'   => "Portekizce\ tabanlı\ Creole\ ve\ Pidgin\ Dilleri",
    'cr'    => 'Cree',
    'crh'   => "Kırım\ Türkçesi",
    'crp'   => "Creole\ ve\ Pidgin\ Dilleri",
    'cs'    => 'Çekçe',
    'csb'   => 'Kashubian',
    'cu'    => "Kilise\ Slavcası",
    'cus'   => "Kuşitik\ Diller",
    'cv'    => 'Çuvaşça',
    'cy'    => 'Galce',
    'da'    => 'Danca',
    'dak'   => 'Dakota',
    'dar'   => 'Dargince',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'Almanca',
    'de_at' => "Avusturya\ Almancası",
    'de_ch' => "İsviçre\ Yüksek\ Almancası",
    'del'   => 'Delaware',
    'den'   => 'Slavey',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravid\ Dilleri",
    'dsb'   => "Aşağı\ Sorbça",
    'dua'   => 'Duala',
    'dum'   => "Ortaçağ\ Felemenkçesi",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => "Butan\ Dili",
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Eski\ Mısır\ Dili",
    'eka'   => 'Ekajuk',
    'el'    => 'Yunanca',
    'elx'   => 'Elam',
    'en'    => 'İngilizce',
    'en_au' => "Avustralya\ İngilizcesi",
    'en_ca' => "Kanada\ İngilizcesi",
    'en_gb' => "İngiliz\ İngilizcesi",
    'en_us' => "Amerikan\ İngilizcesi",
    'enm'   => "Ortaçağ\ İngilizcesi",
    'eo'    => 'Esperanto',
    'es'    => 'İspanyolca',
    'es_es' => "İber\ İspanyolcası",
    'et'    => 'Estonca',
    'eu'    => 'Baskça',
    'ewo'   => 'Ewondo',
    'fa'    => 'Farsça',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Fince',
    'fil'   => 'Filipino',
    'fiu'   => "Finno\ \-\ Ugrik\ Diller",
    'fj'    => "Fiji\ Dili",
    'fo'    => "Faroe\ Dili",
    'fon'   => 'Fon',
    'fr'    => 'Fransızca',
    'fr_ca' => "Kanada\ Fransızcası",
    'fr_ch' => "İsviçre\ Fransızcası",
    'frm'   => "Ortaçağ\ Fransızcası",
    'fro'   => "Eski\ Fransızca",
    'frr'   => "Kuzey\ Frizce",
    'frs'   => "Doğu\ Frizcesi",
    'fur'   => 'Friulian',
    'fy'    => "Batı\ Frizcesi",
    'ga'    => "İrlanda\ Dili",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "İskoç\ Gal\ Dili",
    'gem'   => "Cermen\ Dilleri",
    'gez'   => 'Geez',
    'gil'   => "Kiribati\ Dili",
    'gl'    => 'Galiçyaca',
    'gmh'   => "Ortaçağ\ Yüksek\ Almancası",
    'gn'    => 'Guarani',
    'goh'   => "Eski\ Yüksek\ Almanca",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gotça',
    'grb'   => 'Grebo',
    'grc'   => "Antik\ Yunanca",
    'gsw'   => "İsviçre\ Almancası",
    'gu'    => "Gücerat\ Dili",
    'guz'   => 'Gusii',
    'gv'    => 'Manks',
    'gwi'   => 'Gwichʼin',
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => "Hawaii\ Dili",
    'he'    => 'İbranice',
    'hi'    => 'Hintçe',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hititçe',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Hırvatça',
    'hsb'   => "Yukarı\ Sorbça",
    'ht'    => "Haiti\ Dili",
    'hu'    => 'Macarca',
    'hup'   => 'Hupa',
    'hy'    => 'Ermenice',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Endonezce',
    'ie'    => 'Interlingue',
    'ig'    => "İgbo\ Dili",
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiak',
    'ilo'   => 'Iloko',
    'inc'   => "Hint\ Dilleri",
    'ine'   => "Hint\-Avrupa\ Dilleri",
    'inh'   => 'İnguşça',
    'io'    => 'Ido',
    'ira'   => "İran\ Dilleri",
    'iro'   => "İroqua\ Dili",
    'is'    => 'İzlandaca',
    'it'    => 'İtalyanca',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japonca',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Yahudi\ Farsçası",
    'jrb'   => "Yahudi\ Arapçası",
    'jv'    => "Cava\ Dili",
    'ka'    => 'Gürcüce',
    'kaa'   => 'Karakalpakça',
    'kab'   => 'Kabile',
    'kac'   => 'Kaçin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardeyce',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Hoisan\ Dilleri",
    'kho'   => 'Hotanca',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakça',
    'kl'    => "Grönland\ Dili",
    'kln'   => 'Kalenjin',
    'km'    => "Kamboçya\ Dili",
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korece',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karaçay\-Balkarca",
    'krl'   => 'Karelyaca',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Keşmirce',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Kürtçe',
    'kum'   => 'Kumukça',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Kernevekçe',
    'ky'    => 'Kırgızca',
    'la'    => 'Latince',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Lüksemburgca',
    'lez'   => 'Lezgice',
    'lg'    => 'Ganda',
    'li'    => 'Limburgca',
    'ln'    => 'Lingala',
    'lo'    => "Laos\ Dili",
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Litvanyaca',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'Letonca',
    'mad'   => "Madura\ Dili",
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Avustronezya\ Dili",
    'mas'   => 'Masai',
    'mdf'   => "Mokşa\ Dili",
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasi',
    'mga'   => "Ortaçağ\ İrlandacası",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => "Marshall\ Adaları\ Dili",
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Çeşitli\ Diller",
    'mk'    => 'Makedonca',
    'mkh'   => "Mon\-Khmer\ Dilleri",
    'ml'    => 'Malayalam',
    'mn'    => 'Moğolca',
    'mnc'   => "Mançurya\ Dili",
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Dilleri",
    'mo'    => 'Moldovaca',
    'moh'   => "Mohavk\ Dili",
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malay',
    'mt'    => 'Maltaca',
    'mua'   => 'Mundang',
    'mul'   => "Birden\ Fazla\ Dil",
    'mun'   => "Munda\ Dilleri",
    'mus'   => 'Creek',
    'mwl'   => "Miranda\ Dili",
    'mwr'   => 'Marvari',
    'my'    => "Birmanya\ Dili",
    'myn'   => "Maya\ Dilleri",
    'myv'   => 'Erzya',
    'na'    => "Nauru\ Dili",
    'nah'   => 'Nahuatl',
    'nai'   => "Kuzey\ Amerika\ Yerli\ Dilleri",
    'nap'   => 'Napolice',
    'naq'   => 'Nama',
    'nb'    => "Norveççe\ Bokmål",
    'nd'    => "Kuzey\ Ndebele",
    'nds'   => "Aşağı\ Almanca",
    'ne'    => 'Nepalce',
    'new'   => 'Nevari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Nijer\-Kordofan\ Dilleri",
    'niu'   => 'Niuean',
    'nl'    => 'Felemenkçe',
    'nl_be' => 'Flamanca',
    'nmg'   => 'Kwasio',
    'nn'    => "Norveççe\ Nynorsk",
    'no'    => 'Norveççe',
    'nog'   => 'Nogayca',
    'non'   => "Eski\ Norse",
    'nqo'   => 'N’Ko',
    'nr'    => "Güney\ Ndebele",
    'nso'   => "Kuzey\ Sotho",
    'nub'   => "Nubian\ Dilleri",
    'nus'   => 'Nuer',
    'nv'    => "Navaho\ Dili",
    'nwc'   => "Klasik\ Nevari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamvezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Oksitanca',
    'oj'    => "Ojibva\ Dili",
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Osetçe',
    'osa'   => 'Osage',
    'ota'   => "Osmanlı\ Türkçesi",
    'oto'   => "Otomi\ Dilleri",
    'pa'    => "Pencap\ Dili",
    'paa'   => "Papua\ Dilleri",
    'pag'   => 'Pangasinan',
    'pal'   => "Pehlevi\ Dili",
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => "Palau\ Dili",
    'peo'   => "Eski\ Farsça",
    'phi'   => "Filipinler\ Dilleri",
    'phn'   => "Fenike\ Dili",
    'pi'    => 'Pali',
    'pl'    => 'Lehçe',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Dilleri",
    'pro'   => "Eski\ Provensal",
    'ps'    => 'Peştuca',
    'pt'    => 'Portekizce',
    'pt_br' => "Brezilya\ Portekizcesi",
    'pt_pt' => "İber\ Portekizcesi",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Roman\ Dili",
    'rn'    => 'Kirundi',
    'ro'    => 'Romence',
    'roa'   => "Roman\ Dilleri",
    'rof'   => 'Rombo',
    'rom'   => 'Romanca',
    'ru'    => 'Rusça',
    'rup'   => 'Ulahça',
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'Sanskritçe',
    'sad'   => 'Sandave',
    'sah'   => 'Yakutça',
    'sai'   => "Güney\ Amerika\ Yerli\ Dilleri",
    'sal'   => "Salishan\ Dilleri",
    'sam'   => "Samarit\ Aramcası",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => "Sardunya\ Dili",
    'scn'   => 'Sicilyaca',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Kuzey\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitik\ Diller",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sangho',
    'sga'   => "Eski\ İrlandaca",
    'sgn'   => "İşaret\ Dilleri",
    'sh'    => "Sırp\-Hırvat\ Dili",
    'shi'   => 'Tachelhit',
    'shn'   => "Shan\ Dili",
    'si'    => 'Seylanca',
    'sid'   => 'Sidamo',
    'sio'   => "Siu\ Dilleri",
    'sit'   => "Sino\-Tibet\ Dilleri",
    'sk'    => 'Slovakça',
    'sl'    => 'Slovence',
    'sla'   => "Slav\ Dilleri",
    'sm'    => "Samoa\ Dili",
    'sma'   => "Güney\ Sami",
    'smi'   => "Sami\ Dilleri",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => "Somali\ Dili",
    'sog'   => 'Sogdiana Dili',
    'son'   => 'Songhai',
    'sq'    => 'Arnavutça',
    'sr'    => 'Sırpça',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Sisvati',
    'ssa'   => "Nil\-Sahara\ Dilleri",
    'ssy'   => 'Saho',
    'st'    => "Güney\ Sotho",
    'su'    => "Sunda\ Dili",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sümerce',
    'sv'    => 'İsveççe',
    'sw'    => 'Svahili',
    'swb'   => 'Komorca',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Klasik\ Süryanice",
    'syr'   => 'Süryanice',
    'ta'    => 'Tamilce',
    'tai'   => "Tai\ Dili",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tacikçe',
    'th'    => 'Tayca',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Türkmence',
    'tkl'   => 'Tokelau',
    'tl'    => 'Takalotça',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamaşek',
    'tn'    => 'Setsvana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Türkçe',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatarca',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Dilleri",
    'tut'   => "Altay\ Dilleri",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Tvi',
    'twq'   => 'Tasawaq',
    'ty'    => "Tahiti\ Dili",
    'tyv'   => 'Tuvaca',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurtça',
    'ug'    => 'Uygurca',
    'uga'   => "Ugarit\ Dili",
    'uk'    => 'Ukraynaca',
    'umb'   => 'Umbundu',
    'und'   => "Bilinmeyen\ Dil",
    'ur'    => 'Urduca',
    'uz'    => 'Özbekçe',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamca',
    'vo'    => 'Volapük',
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Valonca',
    'wae'   => 'Walser',
    'wak'   => "Vakaşan\ Dilleri",
    'wal'   => 'Valamo',
    'war'   => 'Varay',
    'was'   => 'Vaşo',
    'wen'   => "Sorb\ Dilleri",
    'wo'    => 'Volofca',
    'xal'   => 'Kalmıkça',
    'xh'    => 'Zosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapça',
    'yav'   => 'Yangben',
    'yi'    => 'Yidiş',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Dili",
    'yue'   => 'Kantonca',
    'za'    => 'Zhuang',
    'zap'   => "Zapotek\ Dili",
    'zbl'   => "Blis\ Sembolleri",
    'zen'   => 'Zenaga',
    'zh'    => 'Çince',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "Dilbilim\ içeriği\ yok",
    'zza'   => 'Zazaca',
);

%Locales::DB::Language::tr::name_to_code = (
    'abhazca'                                 => 'ab',
    'achinese'                                => 'ace',
    'acoli'                                   => 'ach',
    'adangme'                                 => 'ada',
    'adigece'                                 => 'ady',
    'afar'                                    => 'aa',
    'afrihili'                                => 'afh',
    'afrikaandili'                            => 'af',
    'afroasyatikdiller'                       => 'afa',
    'aghem'                                   => 'agq',
    'akaddili'                                => 'akk',
    'akan'                                    => 'ak',
    'aleut'                                   => 'ale',
    'algonkindili'                            => 'alg',
    'almanca'                                 => 'de',
    'altaydilleri'                            => 'tut',
    'amerikanİngilizcesi'                    => 'en_us',
    'amharca'                                 => 'am',
    'angika'                                  => 'anp',
    'antikyunanca'                            => 'grc',
    'apaçidilleri'                           => 'apa',
    'aragonca'                                => 'an',
    'aramice'                                 => 'arc',
    'arapahodili'                             => 'arp',
    'arapça'                                 => 'ar',
    'araukanyadili'                           => 'arn',
    'arawakdili'                              => 'arw',
    'arayanice'                               => 'bho',
    'arnavutça'                              => 'sq',
    'assamca'                                 => 'as',
    'asturyasca'                              => 'ast',
    'asu'                                     => 'asa',
    'atabaşkandilleri'                       => 'ath',
    'atsam'                                   => 'cch',
    'avardili'                                => 'av',
    'avestçe'                                => 'ae',
    'avustralyadilleri'                       => 'aus',
    'avustralyaİngilizcesi'                  => 'en_au',
    'avustronezyadili'                        => 'map',
    'avusturyaalmancası'                     => 'de_at',
    'awadhi'                                  => 'awa',
    'aymara'                                  => 'ay',
    'aynidili'                                => 'ain',
    'azeri'                                   => 'az',
    'aşağıalmanca'                         => 'nds',
    'aşağısorbça'                         => 'dsb',
    'bafia'                                   => 'ksf',
    'balidili'                                => 'ban',
    'baltıkdilleri'                          => 'bat',
    'baluchi'                                 => 'bal',
    'bambara'                                 => 'bm',
    'bamilekedilleri'                         => 'bai',
    'bandadili'                               => 'bad',
    'bantudili'                               => 'bnt',
    'basadili'                                => 'bas',
    'baskça'                                 => 'eu',
    'batak'                                   => 'btk',
    'batıfrizcesi'                           => 'fy',
    'başkırtça'                            => 'ba',
    'bejadili'                                => 'bej',
    'bemba'                                   => 'bem',
    'bena'                                    => 'bez',
    'bengalce'                                => 'bn',
    'berberi'                                 => 'ber',
    'beyazrusça'                             => 'be',
    'bihari'                                  => 'bh',
    'bikol'                                   => 'bik',
    'bilinmeyendil'                           => 'und',
    'bini'                                    => 'bin',
    'birdenfazladil'                          => 'mul',
    'birmanyadili'                            => 'my',
    'bislama'                                 => 'bi',
    'blin'                                    => 'byn',
    'blissembolleri'                          => 'zbl',
    'bodo'                                    => 'brx',
    'boşnakça'                              => 'bs',
    'braj'                                    => 'bra',
    'bretonca'                                => 'br',
    'brezilyaportekizcesi'                    => 'pt_br',
    'bugis'                                   => 'bug',
    'bulgarca'                                => 'bg',
    'buryat'                                  => 'bua',
    'butandili'                               => 'dz',
    'caddo'                                   => 'cad',
    'carib'                                   => 'car',
    'cavadili'                                => 'jv',
    'cayuga'                                  => 'cay',
    'cebuano'                                 => 'ceb',
    'centralmoroccotamazight'                 => 'tzm',
    'cermendilleri'                           => 'gem',
    'chamicdilleri'                           => 'cmc',
    'chamorro'                                => 'ch',
    'chibcha'                                 => 'chb',
    'chiga'                                   => 'cgg',
    'chinookjargon'                           => 'chn',
    'chipewyan'                               => 'chp',
    'choctaw'                                 => 'cho',
    'chuukese'                                => 'chk',
    'colognian'                               => 'ksh',
    'congoswahili'                            => 'swc',
    'cree'                                    => 'cr',
    'creek'                                   => 'mus',
    'creolevepidgindilleri'                   => 'crp',
    'dakota'                                  => 'dak',
    'danca'                                   => 'da',
    'dargince'                                => 'dar',
    'dayak'                                   => 'day',
    'delaware'                                => 'del',
    'dilbilimiçeriğiyok'                    => 'zxx',
    'dinka'                                   => 'din',
    'divehi'                                  => 'dv',
    'dogri'                                   => 'doi',
    'dogrib'                                  => 'dgr',
    'doğufrizcesi'                           => 'frs',
    'draviddilleri'                           => 'dra',
    'duala'                                   => 'dua',
    'dyula'                                   => 'dyu',
    'efik'                                    => 'efi',
    'ekajuk'                                  => 'eka',
    'elam'                                    => 'elx',
    'embu'                                    => 'ebu',
    'endonezce'                               => 'id',
    'ermenice'                                => 'hy',
    'erzya'                                   => 'myv',
    'eskifarsça'                             => 'peo',
    'eskifransızca'                          => 'fro',
    'eskimısırdili'                         => 'egy',
    'eskinorse'                               => 'non',
    'eskiprovensal'                           => 'pro',
    'eskiyüksekalmanca'                      => 'goh',
    'eskiİngilizce'                          => 'ang',
    'eskiİrlandaca'                          => 'sga',
    'esperanto'                               => 'eo',
    'estonca'                                 => 'et',
    'ewe'                                     => 'ee',
    'ewondo'                                  => 'ewo',
    'fang'                                    => 'fan',
    'fanti'                                   => 'fat',
    'faroedili'                               => 'fo',
    'farsça'                                 => 'fa',
    'felemenkçe'                             => 'nl',
    'fenikedili'                              => 'phn',
    'fijidili'                                => 'fj',
    'filipinlerdilleri'                       => 'phi',
    'filipino'                                => 'fil',
    'fince'                                   => 'fi',
    'finnougrikdiller'                        => 'fiu',
    'flamanca'                                => 'nl_be',
    'fon'                                     => 'fon',
    'fransızca'                              => 'fr',
    'fransızcatabanlıcreolevepidgindilleri' => 'cpf',
    'friulian'                                => 'fur',
    'fulah'                                   => 'ff',
    'ga'                                      => 'gaa',
    'galce'                                   => 'cy',
    'galiçyaca'                              => 'gl',
    'ganda'                                   => 'lg',
    'gayo'                                    => 'gay',
    'gbaya'                                   => 'gba',
    'geez'                                    => 'gez',
    'gondi'                                   => 'gon',
    'gorontalo'                               => 'gor',
    'gotça'                                  => 'got',
    'grebo'                                   => 'grb',
    'grönlanddili'                           => 'kl',
    'guarani'                                 => 'gn',
    'gusii'                                   => 'guz',
    'gwichʼin'                               => 'gwi',
    'güceratdili'                            => 'gu',
    'güneyaltayca'                           => 'alt',
    'güneyamerikayerlidilleri'               => 'sai',
    'güneyndebele'                           => 'nr',
    'güneysami'                              => 'sma',
    'güneysotho'                             => 'st',
    'gürcüce'                               => 'ka',
    'haida'                                   => 'hai',
    'haitidili'                               => 'ht',
    'hausa'                                   => 'ha',
    'hawaiidili'                              => 'haw',
    'herero'                                  => 'hz',
    'hiligaynon'                              => 'hil',
    'himachali'                               => 'him',
    'hintavrupadilleri'                       => 'ine',
    'hintdilleri'                             => 'inc',
    'hintçe'                                 => 'hi',
    'hirimotu'                                => 'ho',
    'hititçe'                                => 'hit',
    'hmong'                                   => 'hmn',
    'hoisandilleri'                           => 'khi',
    'hotanca'                                 => 'kho',
    'hupa'                                    => 'hup',
    'hırvatça'                              => 'hr',
    'iban'                                    => 'iba',
    'ido'                                     => 'io',
    'ijo'                                     => 'ijo',
    'iloko'                                   => 'ilo',
    'inarisami'                               => 'smn',
    'interlingua'                             => 'ia',
    'interlingue'                             => 'ie',
    'inuktitut'                               => 'iu',
    'inupiak'                                 => 'ik',
    'japonca'                                 => 'ja',
    'jju'                                     => 'kaj',
    'jolafonyi'                               => 'dyo',
    'kabardeyce'                              => 'kbd',
    'kabile'                                  => 'kab',
    'kabuverdianu'                            => 'kea',
    'kafkasdilleri'                           => 'cau',
    'kalenjin'                                => 'kln',
    'kalmıkça'                              => 'xal',
    'kamba'                                   => 'kam',
    'kamboçyadili'                           => 'km',
    'kanadafransızcası'                     => 'fr_ca',
    'kanadaİngilizcesi'                      => 'en_ca',
    'kannada'                                 => 'kn',
    'kantonca'                                => 'yue',
    'kanuri'                                  => 'kr',
    'karakalpakça'                           => 'kaa',
    'karaçaybalkarca'                        => 'krc',
    'karelyaca'                               => 'krl',
    'karen'                                   => 'kar',
    'kashubian'                               => 'csb',
    'katalanca'                               => 'ca',
    'kawi'                                    => 'kaw',
    'kazakça'                                => 'kk',
    'kaçin'                                  => 'kac',
    'keltdilleri'                             => 'cel',
    'kernevekçe'                             => 'kw',
    'keşmirce'                               => 'ks',
    'khasi'                                   => 'kha',
    'kikuyu'                                  => 'ki',
    'kiliseslavcası'                         => 'cu',
    'kimbundu'                                => 'kmb',
    'kinyarwanda'                             => 'rw',
    'kiribatidili'                            => 'gil',
    'kirundi'                                 => 'rn',
    'klasiknevari'                            => 'nwc',
    'klasiksüryanice'                        => 'syc',
    'klingon'                                 => 'tlh',
    'komi'                                    => 'kv',
    'komorca'                                 => 'swb',
    'kongo'                                   => 'kg',
    'konkani'                                 => 'kok',
    'korece'                                  => 'ko',
    'koro'                                    => 'kfo',
    'korsikaca'                               => 'co',
    'kosraean'                                => 'kos',
    'koyraborosenni'                          => 'ses',
    'koyrachiini'                             => 'khq',
    'kpelle'                                  => 'kpe',
    'kru'                                     => 'kro',
    'kuanyama'                                => 'kj',
    'kumukça'                                => 'kum',
    'kurukh'                                  => 'kru',
    'kutenai'                                 => 'kut',
    'kuzeyamerikayerlidilleri'                => 'nai',
    'kuzeyfrizce'                             => 'frr',
    'kuzeyndebele'                            => 'nd',
    'kuzeysami'                               => 'se',
    'kuzeysotho'                              => 'nso',
    'kuşitikdiller'                          => 'cus',
    'kwasio'                                  => 'nmg',
    'kürtçe'                                => 'ku',
    'kıptice'                                => 'cop',
    'kırgızca'                              => 'ky',
    'kırımtürkçesi'                       => 'crh',
    'ladino'                                  => 'lad',
    'lahnda'                                  => 'lah',
    'lamba'                                   => 'lam',
    'langi'                                   => 'lag',
    'laosdili'                                => 'lo',
    'latince'                                 => 'la',
    'lehçe'                                  => 'pl',
    'letonca'                                 => 'lv',
    'lezgice'                                 => 'lez',
    'limburgca'                               => 'li',
    'lingala'                                 => 'ln',
    'litvanyaca'                              => 'lt',
    'lojban'                                  => 'jbo',
    'lozi'                                    => 'loz',
    'lubakatanga'                             => 'lu',
    'lubalulua'                               => 'lua',
    'luiseno'                                 => 'lui',
    'lulesami'                                => 'smj',
    'lunda'                                   => 'lun',
    'luo'                                     => 'luo',
    'lushai'                                  => 'lus',
    'luyia'                                   => 'luy',
    'lüksemburgca'                           => 'lb',
    'macarca'                                 => 'hu',
    'machame'                                 => 'jmc',
    'maduradili'                              => 'mad',
    'magahi'                                  => 'mag',
    'maithili'                                => 'mai',
    'makasar'                                 => 'mak',
    'makedonca'                               => 'mk',
    'makhuwameetto'                           => 'mgh',
    'makonde'                                 => 'kde',
    'malagasi'                                => 'mg',
    'malay'                                   => 'ms',
    'malayalam'                               => 'ml',
    'maltaca'                                 => 'mt',
    'mandar'                                  => 'mdr',
    'mandingo'                                => 'man',
    'manipuri'                                => 'mni',
    'manks'                                   => 'gv',
    'manobodilleri'                           => 'mno',
    'mançuryadili'                           => 'mnc',
    'maori'                                   => 'mi',
    'marathi'                                 => 'mr',
    'mari'                                    => 'chm',
    'marshalladalarıdili'                    => 'mh',
    'marvari'                                 => 'mwr',
    'masai'                                   => 'mas',
    'mayadilleri'                             => 'myn',
    'mende'                                   => 'men',
    'meru'                                    => 'mer',
    'micmac'                                  => 'mic',
    'minangkabau'                             => 'min',
    'mirandadili'                             => 'mwl',
    'mohavkdili'                              => 'moh',
    'mokşadili'                              => 'mdf',
    'moldovaca'                               => 'mo',
    'mongo'                                   => 'lol',
    'monkhmerdilleri'                         => 'mkh',
    'morisyen'                                => 'mfe',
    'mossi'                                   => 'mos',
    'moğolca'                                => 'mn',
    'mundadilleri'                            => 'mun',
    'mundang'                                 => 'mua',
    'nahuatl'                                 => 'nah',
    'nama'                                    => 'naq',
    'napolice'                                => 'nap',
    'naurudili'                               => 'na',
    'navahodili'                              => 'nv',
    'ndonga'                                  => 'ng',
    'nepalce'                                 => 'ne',
    'nevari'                                  => 'new',
    'nias'                                    => 'nia',
    'nijerkordofandilleri'                    => 'nic',
    'nilsaharadilleri'                        => 'ssa',
    'niuean'                                  => 'niu',
    'nogayca'                                 => 'nog',
    'norveççe'                              => 'no',
    'norveççebokmål'                       => 'nb',
    'norveççenynorsk'                       => 'nn',
    'nubiandilleri'                           => 'nub',
    'nuer'                                    => 'nus',
    'nyamvezi'                                => 'nym',
    'nyanja'                                  => 'ny',
    'nyankole'                                => 'nyn',
    'nyasatonga'                              => 'tog',
    'nyoro'                                   => 'nyo',
    'nzima'                                   => 'nzi',
    'n’ko'                                  => 'nqo',
    'ojibvadili'                              => 'oj',
    'oksitanca'                               => 'oc',
    'oriya'                                   => 'or',
    'oromo'                                   => 'om',
    'ortaamerikayerlidilleri'                 => 'cai',
    'ortaçağfelemenkçesi'                  => 'dum',
    'ortaçağfransızcası'                  => 'frm',
    'ortaçağyüksekalmancası'              => 'gmh',
    'ortaçağİngilizcesi'                   => 'enm',
    'ortaçağİrlandacası'                  => 'mga',
    'osage'                                   => 'osa',
    'osetçe'                                 => 'os',
    'osmanlıtürkçesi'                      => 'ota',
    'otomidilleri'                            => 'oto',
    'palaudili'                               => 'pau',
    'pali'                                    => 'pi',
    'pampanga'                                => 'pam',
    'pangasinan'                              => 'pag',
    'papiamento'                              => 'pap',
    'papuadilleri'                            => 'paa',
    'pehlevidili'                             => 'pal',
    'pencapdili'                              => 'pa',
    'peştuca'                                => 'ps',
    'pohnpeian'                               => 'pon',
    'portekizce'                              => 'pt',
    'portekizcetabanlıcreolevepidgindilleri' => 'cpp',
    'prakritdilleri'                          => 'pra',
    'quechua'                                 => 'qu',
    'rajasthani'                              => 'raj',
    'rapanui'                                 => 'rap',
    'rarotongan'                              => 'rar',
    'rhaetoromandili'                         => 'rm',
    'romanca'                                 => 'rom',
    'romandilleri'                            => 'roa',
    'rombo'                                   => 'rof',
    'romence'                                 => 'ro',
    'rusça'                                  => 'ru',
    'rwa'                                     => 'rwk',
    'saho'                                    => 'ssy',
    'salishandilleri'                         => 'sal',
    'samaritaramcası'                        => 'sam',
    'samburu'                                 => 'saq',
    'samidilleri'                             => 'smi',
    'samoadili'                               => 'sm',
    'sandave'                                 => 'sad',
    'sangho'                                  => 'sg',
    'sangu'                                   => 'sbp',
    'sanskritçe'                             => 'sa',
    'santali'                                 => 'sat',
    'sardunyadili'                            => 'sc',
    'sasak'                                   => 'sas',
    'scots'                                   => 'sco',
    'selkup'                                  => 'sel',
    'semitikdiller'                           => 'sem',
    'sena'                                    => 'seh',
    'seneca'                                  => 'see',
    'serer'                                   => 'srr',
    'setsvana'                                => 'tn',
    'seylanca'                                => 'si',
    'shambala'                                => 'ksb',
    'shandili'                                => 'shn',
    'shona'                                   => 'sn',
    'sichuanyi'                               => 'ii',
    'sicilyaca'                               => 'scn',
    'sidamo'                                  => 'sid',
    'siksika'                                 => 'bla',
    'sindhi'                                  => 'sd',
    'sinotibetdilleri'                        => 'sit',
    'sisvati'                                 => 'ss',
    'siudilleri'                              => 'sio',
    'skoltsami'                               => 'sms',
    'slavdilleri'                             => 'sla',
    'slavey'                                  => 'den',
    'slovakça'                               => 'sk',
    'slovence'                                => 'sl',
    'soga'                                    => 'xog',
    'sogdianadili'                            => 'sog',
    'somalidili'                              => 'so',
    'songhai'                                 => 'son',
    'soninke'                                 => 'snk',
    'sorbdilleri'                             => 'wen',
    'sranantongo'                             => 'srn',
    'sukuma'                                  => 'suk',
    'sundadili'                               => 'su',
    'susu'                                    => 'sus',
    'svahili'                                 => 'sw',
    'sümerce'                                => 'sux',
    'süryanice'                              => 'syr',
    'sırphırvatdili'                        => 'sh',
    'sırpça'                                => 'sr',
    'tachelhit'                               => 'shi',
    'tacikçe'                                => 'tg',
    'tahitidili'                              => 'ty',
    'taidili'                                 => 'tai',
    'taita'                                   => 'dav',
    'takalotça'                              => 'tl',
    'tamaşek'                                => 'tmh',
    'tamilce'                                 => 'ta',
    'taroko'                                  => 'trv',
    'tasawaq'                                 => 'twq',
    'tatarca'                                 => 'tt',
    'tayca'                                   => 'th',
    'telugu'                                  => 'te',
    'tereno'                                  => 'ter',
    'teso'                                    => 'teo',
    'tetum'                                   => 'tet',
    'tibetçe'                                => 'bo',
    'tigre'                                   => 'tig',
    'tigrinya'                                => 'ti',
    'timne'                                   => 'tem',
    'tiv'                                     => 'tiv',
    'tlingit'                                 => 'tli',
    'tokelau'                                 => 'tkl',
    'tokpisin'                                => 'tpi',
    'tonga'                                   => 'to',
    'tsimshian'                               => 'tsi',
    'tsonga'                                  => 'ts',
    'tumbuka'                                 => 'tum',
    'tupidilleri'                             => 'tup',
    'tuvaca'                                  => 'tyv',
    'tuvalu'                                  => 'tvl',
    'tvi'                                     => 'tw',
    'tyap'                                    => 'kcg',
    'türkmence'                              => 'tk',
    'türkçe'                                => 'tr',
    'udmurtça'                               => 'udm',
    'ugaritdili'                              => 'uga',
    'ukraynaca'                               => 'uk',
    'ulahça'                                 => 'rup',
    'umbundu'                                 => 'umb',
    'urduca'                                  => 'ur',
    'uygurca'                                 => 'ug',
    'vai'                                     => 'vai',
    'vakaşandilleri'                         => 'wak',
    'valamo'                                  => 'wal',
    'valonca'                                 => 'wa',
    'varay'                                   => 'war',
    'vaşo'                                   => 'was',
    'venda'                                   => 've',
    'vietnamca'                               => 'vi',
    'volapük'                                => 'vo',
    'volofca'                                 => 'wo',
    'votic'                                   => 'vot',
    'vunjo'                                   => 'vun',
    'walser'                                  => 'wae',
    'yahudiarapçası'                        => 'jrb',
    'yahudifarsçası'                        => 'jpr',
    'yakutça'                                => 'sah',
    'yangben'                                 => 'yav',
    'yao'                                     => 'yao',
    'yapaydiller'                             => 'art',
    'yapça'                                  => 'yap',
    'yidiş'                                  => 'yi',
    'yoruba'                                  => 'yo',
    'yukarısorbça'                          => 'hsb',
    'yunanca'                                 => 'el',
    'yupikdili'                               => 'ypk',
    'zande'                                   => 'znd',
    'zapotekdili'                             => 'zap',
    'zarma'                                   => 'dje',
    'zazaca'                                  => 'zza',
    'zenaga'                                  => 'zen',
    'zhuang'                                  => 'za',
    'zosa'                                    => 'xh',
    'zulu'                                    => 'zu',
    'zuni'                                    => 'zun',
    'Çağataydili'                           => 'chg',
    'Çekçe'                                 => 'cs',
    'Çeroki'                                 => 'chr',
    'Çeçence'                               => 'ce',
    'Çeşitlidiller'                         => 'mis',
    'Çince'                                  => 'zh',
    'Çuvaşça'                              => 'cv',
    'Özbekçe'                               => 'uz',
    'İberportekizcesi'                       => 'pt_pt',
    'İberİspanyolcası'                     => 'es_es',
    'İbranice'                               => 'he',
    'İgbodili'                               => 'ig',
    'İngilizce'                              => 'en',
    'İngilizcetabanlıcreolevepidgindilleri' => 'cpe',
    'İngilizİngilizcesi'                    => 'en_gb',
    'İnguşça'                              => 'inh',
    'İrandilleri'                            => 'ira',
    'İrlandadili'                            => 'ga',
    'İroquadili'                             => 'iro',
    'İskoçgaldili'                          => 'gd',
    'İspanyolca'                             => 'es',
    'İsveççe'                              => 'sv',
    'İsviçrealmancası'                     => 'gsw',
    'İsviçrefransızcası'                  => 'fr_ch',
    'İsviçreyüksekalmancası'              => 'de_ch',
    'İtalyanca'                              => 'it',
    'İzlandaca'                              => 'is',
    'İşaretdilleri'                         => 'sgn',
    'Şayendili'                              => 'chy',
);

1;
