package Locales::DB::Language::id;

# Auto generated from CLDR

$Locales::DB::Language::id::VERSION = '0.07';

$Locales::DB::Language::id::cldr_version = '2.0';

%Locales::DB::Language::id::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Bahasa\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ dan\ \{1\}",
            'end'    => "\{0\}\,\ dan\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Wilayah\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => [ 'other' ],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "tidak\:t",
        'yesstr' => "ya\:y"
    },
);

%Locales::DB::Language::id::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhaz',
    'ace'   => 'Aceh',
    'ach'   => 'Acholi',
    'ada'   => 'Adangme',
    'ady'   => 'Adygei',
    'ae'    => 'Avestan',
    'af'    => 'Afrikaans',
    'afa'   => "Rumpun\ Bahasa\ Afro\-Asia",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadien',
    'ale'   => 'Aleut',
    'alg'   => "Bahasa\ Algonquia",
    'alt'   => "Altai\ Selatan",
    'am'    => 'Amharik',
    'an'    => 'Aragon',
    'ang'   => "Inggris\ Kuno\ \(kl\.450\-1100\)",
    'anp'   => 'Angika',
    'apa'   => "Rumpun\ Bahasa\ Apache",
    'ar'    => 'Arab',
    'arc'   => 'Aram',
    'arn'   => 'Araukan',
    'arp'   => 'Arapaho',
    'art'   => "Buatan\ \(Lainnya\)",
    'arw'   => 'Arawak',
    'as'    => 'Assam',
    'asa'   => 'Asu',
    'ast'   => 'Astur',
    'ath'   => "Rumpun\ Bahasa\ Athapaska",
    'aus'   => "Rumpun\ Bahasa\ Australia",
    'av'    => 'Avar',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azeri',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Rumpun\ Bahasa\ Bamileke",
    'bal'   => 'Baluchi',
    'ban'   => 'Bali',
    'bas'   => 'Basa',
    'bat'   => "Rumpun\ Bahasa\ Baltik",
    'be'    => 'Belarusia',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => "Rumpun\ Bahasa\ Berber",
    'bez'   => 'Bena',
    'bg'    => 'Bulgaria',
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpur',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengali',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibet',
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'Bosnia',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Bugis',
    'byn'   => 'Blin',
    'ca'    => 'Katalan',
    'cad'   => 'Kado',
    'cai'   => "India\ Amerika\ Tengah\ \(Lainnnya\)",
    'car'   => 'Karib',
    'cau'   => "Rumpun\ Bahasa\ Kaukasia",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ \(Lainnya\)",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuuke',
    'chm'   => 'Mari',
    'chn'   => "Jargon\ Chinook",
    'cho'   => 'Koktaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Bahasa\ Chamik",
    'co'    => 'Korsika',
    'cop'   => 'Koptik',
    'cpe'   => "Kreol\ dan\ Pijin\ Lain\ berbasis\ Inggris",
    'cpf'   => "Kreol\ dan\ Pidgins\ Lain\ berbasis\ Prancis",
    'cpp'   => "Kreol\ dan\ Pijin\ Lain\ berbasis\ Portugis",
    'cr'    => 'Kree',
    'crh'   => "Tatar\ Krimea",
    'crp'   => "Kreol\ dan\ Pijin\ Lain",
    'cs'    => 'Cheska',
    'csb'   => 'Kashubia',
    'cu'    => "Bahasa\ Gereja\ Slavonia",
    'cus'   => "Rumpun\ Bahasa\ Kush",
    'cv'    => 'Chuvash',
    'cy'    => 'Welsh',
    'da'    => 'Dansk',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'Jerman',
    'de_at' => "Jerman\ Austria",
    'de_ch' => "Jerman\ Tinggi\ Swiss",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Rumpun\ Bahasa\ Dravidia",
    'dsb'   => "Sorbia\ Rendah",
    'dua'   => 'Duala',
    'dum'   => "Belanda\ Tengah",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Mesir\ Kuno",
    'eka'   => 'Ekajuk',
    'el'    => 'Yunani',
    'elx'   => 'Elam',
    'en'    => 'Inggris',
    'en_au' => "Inggris\ Australia",
    'en_ca' => "Inggris\ Kanada",
    'en_gb' => "Inggris\ Inggris",
    'en_us' => "Inggris\ A\.S\.",
    'enm'   => "Inggris\,\ Abad\ Pertengahan\ \(1100\-1500\)",
    'eo'    => 'Esperanto',
    'es'    => 'Spanyol',
    'es_es' => "Spanyol\ \(Iberia\)",
    'et'    => 'Estonian',
    'eu'    => 'Basque',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persia',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Suomi',
    'fil'   => 'Filipina',
    'fiu'   => "Rumpun\ Bahasa\ Finno\-Ugrik",
    'fj'    => 'Fiji',
    'fo'    => 'Faro',
    'fon'   => 'Fon',
    'fr'    => 'Perancis',
    'fr_ca' => "Prancis\ Kanada",
    'fr_ch' => "Prancis\ Swiss",
    'frm'   => "Perancis\,\ Abad\ Pertengahan\ \(kl\.1400\-1600\)",
    'fro'   => "Perancis\ Kuno\ \(842\-kl\.1400\)",
    'frr'   => "Frisia\ Utara",
    'frs'   => "Frisia\ Timur",
    'fur'   => 'Friuli',
    'fy'    => "Frisia\ Barat",
    'ga'    => 'Irlandia',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Gaelik\ Skotlandia",
    'gem'   => "Jermanik\ \(Lainnya\)",
    'gez'   => 'Geez',
    'gil'   => 'Gilbert',
    'gl'    => 'Galisia',
    'gmh'   => "Jerman\,\ Abad\ Pertengahan\ \(kl\.1050\-1500\)",
    'gn'    => 'Guarani',
    'goh'   => "Jerman\ Kuno\ \(kl\.750\-1050\)",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothik',
    'grb'   => 'Grebo',
    'grc'   => "Yunani\ Kuno\ \(sd\ 1453\)",
    'gsw'   => "Jerman\ Swiss",
    'gu'    => 'Gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\'in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaii',
    'he'    => 'Ibrani',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hitit',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Kroasia',
    'hsb'   => "Sorbia\ Atas",
    'ht'    => 'Haiti',
    'hu'    => 'Hungaria',
    'hup'   => 'Hupa',
    'hy'    => 'Armenia',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => "Bahasa\ Indonesia",
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiak',
    'ilo'   => 'Iloko',
    'inc'   => "Rumpun\ Bahasa\ Indik",
    'ine'   => "Rumpun\ Bahasa\ Indo\-Eropa",
    'inh'   => 'Ingushetia',
    'io'    => 'Ido',
    'ira'   => "Rumpun\ Bahasa\ Iran",
    'iro'   => "Rumpun\ Bahasa\ Iroquis",
    'is'    => 'Islandia',
    'it'    => 'Italia',
    'iu'    => 'Inuktitut',
    'ja'    => 'Jepang',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Ibrani\-Persia",
    'jrb'   => "Ibrani\-Arab",
    'jv'    => 'Jawa',
    'ka'    => 'Georgia',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardi',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Rumpun\ Bahasa\ Khoisa",
    'kho'   => 'Khotan',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => 'Khmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korea',
    'kok'   => 'Konkani',
    'kos'   => 'Kosre',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachai\ Balkar",
    'krl'   => 'Karelia',
    'kro'   => 'Kru',
    'kru'   => 'Kuruk',
    'ks'    => 'Kashmir',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Kurdi',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Kornish',
    'ky'    => 'Kirgiz',
    'la'    => 'Latin',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourg',
    'lez'   => 'Lezghia',
    'lg'    => 'Ganda',
    'li'    => 'Limburgia',
    'ln'    => 'Lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Lithuania',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'Latvia',
    'mad'   => 'Madura',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makassar',
    'man'   => 'Mandingo',
    'map'   => 'Austronesia',
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasi',
    'mga'   => "Irlandia\ Abad\ Pertengahan\ \(900\-1200\)",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshall',
    'mi'    => 'Maori',
    'mic'   => 'Mikmak',
    'min'   => 'Minangkabau',
    'mis'   => "Bahasa\ Lain\-lain",
    'mk'    => 'Makedonia',
    'mkh'   => "Mon\-Khmer\ \(Lainnya\)",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolian',
    'mnc'   => 'Manchuria',
    'mni'   => 'Manipur',
    'mno'   => "Rumpun\ Bahasa\ Manobo",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malay',
    'mt'    => 'Malta',
    'mua'   => 'Mundang',
    'mul'   => "Beberapa\ Bahasa",
    'mun'   => "Rumpun\ Bahasa\ Munda",
    'mus'   => "Bahasa\ Muskogee",
    'mwl'   => 'Miranda',
    'mwr'   => 'Marwari',
    'my'    => 'Burma',
    'myn'   => "Rumpun\ Bahasa\ Maya",
    'myv'   => 'Erza',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "Rumpun\ Bahasa\ Indian\ Amerika\ Utara",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Bokmål\ Norwegia",
    'nd'    => "Ndebele\ Utara",
    'nds'   => "Jerman\ Rendah",
    'ne'    => 'Nepal',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Rumpun\ Bahasa\ Niger\-Kordofania",
    'niu'   => 'Niuea',
    'nl'    => 'Belanda',
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => 'Norwegian',
    'nog'   => 'Nogai',
    'non'   => "Norse\ Kuno",
    'nqo'   => "N\'Ko",
    'nr'    => "Ndebele\ Selatan",
    'nso'   => "Sotho\ Utara",
    'nub'   => "Rumpun\ Bahasa\ Nubia",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Newari\ Klasik",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Ositania',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetia',
    'osa'   => 'Osage',
    'ota'   => "Turki\ Osmani",
    'oto'   => "Rumpun\ Bahasa\ Otomia",
    'pa'    => 'Punjabi',
    'paa'   => "Rumpun\ Bahasa\ Papua",
    'pag'   => 'Pangasina',
    'pal'   => 'Pahlevi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palau',
    'peo'   => "Persia\ Kuno\ \(kl\.600\-400\ SM\.\)",
    'phi'   => "Rumpun\ Bahasa\ Filipina",
    'phn'   => 'Funisia',
    'pi'    => 'Pali',
    'pl'    => 'Polandia',
    'pon'   => 'Pohnpeia',
    'pra'   => "Rumpun\ Bahasa\ Prakrit",
    'pro'   => "Provençal\ Lama",
    'ps'    => 'Pashto',
    'pt'    => 'Portugis',
    'pt_br' => "Portugis\ Brasil",
    'pt_pt' => "Portugis\ \(Iberia\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotonga',
    'rm'    => "Reto\-Roman",
    'rn'    => 'Rundi',
    'ro'    => 'Rumania',
    'roa'   => "Rumpun\ Bahasa\ Roman",
    'rof'   => 'Rombo',
    'rom'   => 'Romani',
    'ru'    => 'Rusia',
    'rup'   => "Makedo\-Rumania",
    'rw'    => 'Kinyarwanda',
    'rwk'   => 'Rwa',
    'sa'    => 'Sansekerta',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "Rumpun\ Bahasa\ Indian\ Amerika\ Selatan",
    'sal'   => "Rumpun\ Bahasa\ Salisha",
    'sam'   => "Aram\ Samaria",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinia',
    'scn'   => 'Sisilia',
    'sco'   => 'Skotlandia',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Rumpun\ Bahasa\ Semit",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Irlandia\ Kuno",
    'sgn'   => "Bahasa\ Isyarat",
    'sh'    => "Serbo\-Croatian",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'Sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Rumpun\ Bahasa\ Sioux",
    'sit'   => "Rumpun\ Bahasa\ Sino\-Tibet",
    'sk'    => 'Slowakia',
    'sl'    => 'Slovenia',
    'sla'   => "Rumpun\ Bahasa\ Slavik",
    'sm'    => 'Samoan',
    'sma'   => "Sami\ Selatan",
    'smi'   => "Rumpun\ Bahasa\ Sami",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albanian',
    'sr'    => 'Serb',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Rumpun\ Bahasa\ Nilo\-Sahara",
    'ssy'   => 'Saho',
    'st'    => "Sotho\ Selatan",
    'su'    => 'Sunda',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumeria',
    'sv'    => 'Swedia',
    'sw'    => 'Swahili',
    'swb'   => 'Komoria',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Suriah',
    'ta'    => 'Tamil',
    'tai'   => "Rumpun\ Bahasa\ Tai",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetun',
    'tg'    => 'Tajik',
    'th'    => 'Thai',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Turki',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshia',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Rumpun\ Bahasa\ Tupi",
    'tut'   => 'Altai',
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahiti',
    'tyv'   => 'Tuvinia',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugarit',
    'uk'    => 'Ukraina',
    'umb'   => 'Umbundu',
    'und'   => "Bahasa\ Tidak\ Dikenal",
    'ur'    => 'Urdu',
    'uz'    => 'Uzbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnam',
    'vo'    => 'Volapük',
    'vot'   => 'Votia',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Rumpun\ Bahasa\ Wakasha",
    'wal'   => 'Walamo',
    'war'   => 'Warai',
    'was'   => 'Washo',
    'wen'   => "Rumpun\ Bahasa\ Sorbia",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmuk',
    'xh'    => 'Xhosa',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapois',
    'yav'   => 'Yangben',
    'yi'    => 'Yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Rumpun\ Bahasa\ Yupik",
    'yue'   => 'Kanton',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotek',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Mandarin',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "Tidak\ ada\ konten\ linguistik",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::id::name_to_code = (
    'abkhaz'                                => 'ab',
    'aceh'                                  => 'ace',
    'acholi'                                => 'ach',
    'adangme'                               => 'ada',
    'adygei'                                => 'ady',
    'afar'                                  => 'aa',
    'afrihili'                              => 'afh',
    'afrikaans'                             => 'af',
    'aghem'                                 => 'agq',
    'ainu'                                  => 'ain',
    'akan'                                  => 'ak',
    'akkadien'                              => 'akk',
    'albanian'                              => 'sq',
    'aleut'                                 => 'ale',
    'altai'                                 => 'tut',
    'altaiselatan'                          => 'alt',
    'amharik'                               => 'am',
    'angika'                                => 'anp',
    'arab'                                  => 'ar',
    'aragon'                                => 'an',
    'aram'                                  => 'arc',
    'aramsamaria'                           => 'sam',
    'arapaho'                               => 'arp',
    'araukan'                               => 'arn',
    'arawak'                                => 'arw',
    'armenia'                               => 'hy',
    'assam'                                 => 'as',
    'astur'                                 => 'ast',
    'asu'                                   => 'asa',
    'atsam'                                 => 'cch',
    'austronesia'                           => 'map',
    'avar'                                  => 'av',
    'avestan'                               => 'ae',
    'awadhi'                                => 'awa',
    'aymara'                                => 'ay',
    'azeri'                                 => 'az',
    'bafia'                                 => 'ksf',
    'bahasaalgonquia'                       => 'alg',
    'bahasachamik'                          => 'cmc',
    'bahasagerejaslavonia'                  => 'cu',
    'bahasaindonesia'                       => 'id',
    'bahasaisyarat'                         => 'sgn',
    'bahasalainlain'                        => 'mis',
    'bahasamuskogee'                        => 'mus',
    'bahasatidakdikenal'                    => 'und',
    'bali'                                  => 'ban',
    'baluchi'                               => 'bal',
    'bambara'                               => 'bm',
    'banda'                                 => 'bad',
    'bantu'                                 => 'bnt',
    'basa'                                  => 'bas',
    'bashkir'                               => 'ba',
    'basque'                                => 'eu',
    'batak'                                 => 'btk',
    'beberapabahasa'                        => 'mul',
    'beja'                                  => 'bej',
    'belanda'                               => 'nl',
    'belandatengah'                         => 'dum',
    'belarusia'                             => 'be',
    'bemba'                                 => 'bem',
    'bena'                                  => 'bez',
    'bengali'                               => 'bn',
    'bhojpur'                               => 'bho',
    'bihari'                                => 'bh',
    'bikol'                                 => 'bik',
    'bini'                                  => 'bin',
    'bislama'                               => 'bi',
    'blin'                                  => 'byn',
    'blissymbols'                           => 'zbl',
    'bodo'                                  => 'brx',
    'bokmålnorwegia'                       => 'nb',
    'bosnia'                                => 'bs',
    'braj'                                  => 'bra',
    'breton'                                => 'br',
    'buatanlainnya'                         => 'art',
    'bugis'                                 => 'bug',
    'bulgaria'                              => 'bg',
    'buriat'                                => 'bua',
    'burma'                                 => 'my',
    'cayuga'                                => 'cay',
    'cebuano'                               => 'ceb',
    'celticlainnya'                         => 'cel',
    'centralmoroccotamazight'               => 'tzm',
    'chagatai'                              => 'chg',
    'chamorro'                              => 'ch',
    'chechen'                               => 'ce',
    'cherokee'                              => 'chr',
    'cheska'                                => 'cs',
    'cheyenne'                              => 'chy',
    'chibcha'                               => 'chb',
    'chiga'                                 => 'cgg',
    'chipewyan'                             => 'chp',
    'chuuke'                                => 'chk',
    'chuvash'                               => 'cv',
    'classicalsyriac'                       => 'syc',
    'colognian'                             => 'ksh',
    'congoswahili'                          => 'swc',
    'dakota'                                => 'dak',
    'dansk'                                 => 'da',
    'dargwa'                                => 'dar',
    'dayak'                                 => 'day',
    'delaware'                              => 'del',
    'dinka'                                 => 'din',
    'divehi'                                => 'dv',
    'dogri'                                 => 'doi',
    'dogrib'                                => 'dgr',
    'duala'                                 => 'dua',
    'dyula'                                 => 'dyu',
    'dzongkha'                              => 'dz',
    'efik'                                  => 'efi',
    'ekajuk'                                => 'eka',
    'elam'                                  => 'elx',
    'embu'                                  => 'ebu',
    'erza'                                  => 'myv',
    'esperanto'                             => 'eo',
    'estonian'                              => 'et',
    'ewe'                                   => 'ee',
    'ewondo'                                => 'ewo',
    'fang'                                  => 'fan',
    'fanti'                                 => 'fat',
    'faro'                                  => 'fo',
    'fiji'                                  => 'fj',
    'filipina'                              => 'fil',
    'flemish'                               => 'nl_be',
    'fon'                                   => 'fon',
    'frisiabarat'                           => 'fy',
    'frisiatimur'                           => 'frs',
    'frisiautara'                           => 'frr',
    'friuli'                                => 'fur',
    'fulah'                                 => 'ff',
    'funisia'                               => 'phn',
    'ga'                                    => 'gaa',
    'gaelikskotlandia'                      => 'gd',
    'galisia'                               => 'gl',
    'ganda'                                 => 'lg',
    'gayo'                                  => 'gay',
    'gbaya'                                 => 'gba',
    'geez'                                  => 'gez',
    'georgia'                               => 'ka',
    'gilbert'                               => 'gil',
    'gondi'                                 => 'gon',
    'gorontalo'                             => 'gor',
    'gothik'                                => 'got',
    'grebo'                                 => 'grb',
    'guarani'                               => 'gn',
    'gujarati'                              => 'gu',
    'gusii'                                 => 'guz',
    'gwichin'                               => 'gwi',
    'haida'                                 => 'hai',
    'haiti'                                 => 'ht',
    'hausa'                                 => 'ha',
    'hawaii'                                => 'haw',
    'herero'                                => 'hz',
    'hiligaynon'                            => 'hil',
    'himachali'                             => 'him',
    'hindi'                                 => 'hi',
    'hirimotu'                              => 'ho',
    'hitit'                                 => 'hit',
    'hmong'                                 => 'hmn',
    'hungaria'                              => 'hu',
    'hupa'                                  => 'hup',
    'iban'                                  => 'iba',
    'ibrani'                                => 'he',
    'ibraniarab'                            => 'jrb',
    'ibranipersia'                          => 'jpr',
    'ido'                                   => 'io',
    'igbo'                                  => 'ig',
    'ijo'                                   => 'ijo',
    'iloko'                                 => 'ilo',
    'inarisami'                             => 'smn',
    'indiaamerikatengahlainnnya'            => 'cai',
    'inggris'                               => 'en',
    "inggris\,abadpertengahan11001500"      => 'enm',
    "inggrisa\.s\."                         => 'en_us',
    'inggrisaustralia'                      => 'en_au',
    'inggrisinggris'                        => 'en_gb',
    'inggriskanada'                         => 'en_ca',
    "inggriskunokl\.4501100"                => 'ang',
    'ingushetia'                            => 'inh',
    'interlingua'                           => 'ia',
    'interlingue'                           => 'ie',
    'inuktitut'                             => 'iu',
    'inupiak'                               => 'ik',
    'irlandia'                              => 'ga',
    'irlandiaabadpertengahan9001200'        => 'mga',
    'irlandiakuno'                          => 'sga',
    'islandia'                              => 'is',
    'italia'                                => 'it',
    'jargonchinook'                         => 'chn',
    'jawa'                                  => 'jv',
    'jepang'                                => 'ja',
    'jerman'                                => 'de',
    "jerman\,abadpertengahankl\.10501500"   => 'gmh',
    'jermanaustria'                         => 'de_at',
    'jermaniklainnya'                       => 'gem',
    "jermankunokl\.7501050"                 => 'goh',
    'jermanrendah'                          => 'nds',
    'jermanswiss'                           => 'gsw',
    'jermantinggiswiss'                     => 'de_ch',
    'jju'                                   => 'kaj',
    'jolafonyi'                             => 'dyo',
    'kabardi'                               => 'kbd',
    'kabuverdianu'                          => 'kea',
    'kabyle'                                => 'kab',
    'kachin'                                => 'kac',
    'kado'                                  => 'cad',
    'kalaallisut'                           => 'kl',
    'kalenjin'                              => 'kln',
    'kalmuk'                                => 'xal',
    'kamba'                                 => 'kam',
    'kannada'                               => 'kn',
    'kanton'                                => 'yue',
    'kanuri'                                => 'kr',
    'karachaibalkar'                        => 'krc',
    'karakalpak'                            => 'kaa',
    'karelia'                               => 'krl',
    'karen'                                 => 'kar',
    'karib'                                 => 'car',
    'kashmir'                               => 'ks',
    'kashubia'                              => 'csb',
    'katalan'                               => 'ca',
    'kawi'                                  => 'kaw',
    'kazakh'                                => 'kk',
    'khasi'                                 => 'kha',
    'khmer'                                 => 'km',
    'khotan'                                => 'kho',
    'kikuyu'                                => 'ki',
    'kimbundu'                              => 'kmb',
    'kinyarwanda'                           => 'rw',
    'kirgiz'                                => 'ky',
    'klingon'                               => 'tlh',
    'koktaw'                                => 'cho',
    'komi'                                  => 'kv',
    'komoria'                               => 'swb',
    'kongo'                                 => 'kg',
    'konkani'                               => 'kok',
    'koptik'                                => 'cop',
    'korea'                                 => 'ko',
    'kornish'                               => 'kw',
    'koro'                                  => 'kfo',
    'korsika'                               => 'co',
    'kosre'                                 => 'kos',
    'koyraborosenni'                        => 'ses',
    'koyrachiini'                           => 'khq',
    'kpelle'                                => 'kpe',
    'kree'                                  => 'cr',
    'kreoldanpidginslainberbasisprancis'    => 'cpf',
    'kreoldanpijinlain'                     => 'crp',
    'kreoldanpijinlainberbasisinggris'      => 'cpe',
    'kreoldanpijinlainberbasisportugis'     => 'cpp',
    'kroasia'                               => 'hr',
    'kru'                                   => 'kro',
    'kuanyama'                              => 'kj',
    'kumyk'                                 => 'kum',
    'kurdi'                                 => 'ku',
    'kuruk'                                 => 'kru',
    'kutenai'                               => 'kut',
    'kwasio'                                => 'nmg',
    'ladino'                                => 'lad',
    'lahnda'                                => 'lah',
    'lamba'                                 => 'lam',
    'langi'                                 => 'lag',
    'lao'                                   => 'lo',
    'latin'                                 => 'la',
    'latvia'                                => 'lv',
    'lezghia'                               => 'lez',
    'limburgia'                             => 'li',
    'lingala'                               => 'ln',
    'lithuania'                             => 'lt',
    'lojban'                                => 'jbo',
    'lozi'                                  => 'loz',
    'lubakatanga'                           => 'lu',
    'lubalulua'                             => 'lua',
    'luiseno'                               => 'lui',
    'lulesami'                              => 'smj',
    'lunda'                                 => 'lun',
    'luo'                                   => 'luo',
    'lushai'                                => 'lus',
    'luxembourg'                            => 'lb',
    'luyia'                                 => 'luy',
    'machame'                               => 'jmc',
    'madura'                                => 'mad',
    'magahi'                                => 'mag',
    'maithili'                              => 'mai',
    'makassar'                              => 'mak',
    'makedonia'                             => 'mk',
    'makedorumania'                         => 'rup',
    'makhuwameetto'                         => 'mgh',
    'makonde'                               => 'kde',
    'malagasi'                              => 'mg',
    'malay'                                 => 'ms',
    'malayalam'                             => 'ml',
    'malta'                                 => 'mt',
    'manchuria'                             => 'mnc',
    'mandar'                                => 'mdr',
    'mandarin'                              => 'zh',
    'mandingo'                              => 'man',
    'manipur'                               => 'mni',
    'manx'                                  => 'gv',
    'maori'                                 => 'mi',
    'marathi'                               => 'mr',
    'mari'                                  => 'chm',
    'marshall'                              => 'mh',
    'marwari'                               => 'mwr',
    'masai'                                 => 'mas',
    'mende'                                 => 'men',
    'meru'                                  => 'mer',
    'mesirkuno'                             => 'egy',
    'mikmak'                                => 'mic',
    'minangkabau'                           => 'min',
    'miranda'                               => 'mwl',
    'mohawk'                                => 'moh',
    'moksha'                                => 'mdf',
    'moldavian'                             => 'mo',
    'mongo'                                 => 'lol',
    'mongolian'                             => 'mn',
    'monkhmerlainnya'                       => 'mkh',
    'morisyen'                              => 'mfe',
    'mossi'                                 => 'mos',
    'mundang'                               => 'mua',
    'nahuatl'                               => 'nah',
    'nama'                                  => 'naq',
    'nauru'                                 => 'na',
    'navajo'                                => 'nv',
    'ndebeleselatan'                        => 'nr',
    'ndebeleutara'                          => 'nd',
    'ndonga'                                => 'ng',
    'neapolitan'                            => 'nap',
    'nepal'                                 => 'ne',
    'newari'                                => 'new',
    'newariklasik'                          => 'nwc',
    'nias'                                  => 'nia',
    'niuea'                                 => 'niu',
    'nko'                                   => 'nqo',
    'nogai'                                 => 'nog',
    'norsekuno'                             => 'non',
    'northernsami'                          => 'se',
    'norwegian'                             => 'no',
    'norwegiannynorsk'                      => 'nn',
    'nuer'                                  => 'nus',
    'nyamwezi'                              => 'nym',
    'nyanja'                                => 'ny',
    'nyankole'                              => 'nyn',
    'nyasatonga'                            => 'tog',
    'nyoro'                                 => 'nyo',
    'nzima'                                 => 'nzi',
    'ojibwa'                                => 'oj',
    'oriya'                                 => 'or',
    'oromo'                                 => 'om',
    'osage'                                 => 'osa',
    'ositania'                              => 'oc',
    'ossetia'                               => 'os',
    'pahlevi'                               => 'pal',
    'palau'                                 => 'pau',
    'pali'                                  => 'pi',
    'pampanga'                              => 'pam',
    'pangasina'                             => 'pag',
    'papiamento'                            => 'pap',
    'pashto'                                => 'ps',
    'perancis'                              => 'fr',
    "perancis\,abadpertengahankl\.14001600" => 'frm',
    "peranciskuno842kl\.1400"               => 'fro',
    'persia'                                => 'fa',
    "persiakunokl\.600400sm\."              => 'peo',
    'pohnpeia'                              => 'pon',
    'polandia'                              => 'pl',
    'portugis'                              => 'pt',
    'portugisbrasil'                        => 'pt_br',
    'portugisiberia'                        => 'pt_pt',
    'pranciskanada'                         => 'fr_ca',
    'prancisswiss'                          => 'fr_ch',
    'provençallama'                        => 'pro',
    'punjabi'                               => 'pa',
    'quechua'                               => 'qu',
    'rajasthani'                            => 'raj',
    'rapanui'                               => 'rap',
    'rarotonga'                             => 'rar',
    'retoroman'                             => 'rm',
    'romani'                                => 'rom',
    'rombo'                                 => 'rof',
    'rumania'                               => 'ro',
    'rumpunbahasaafroasia'                  => 'afa',
    'rumpunbahasaapache'                    => 'apa',
    'rumpunbahasaathapaska'                 => 'ath',
    'rumpunbahasaaustralia'                 => 'aus',
    'rumpunbahasabaltik'                    => 'bat',
    'rumpunbahasabamileke'                  => 'bai',
    'rumpunbahasaberber'                    => 'ber',
    'rumpunbahasadravidia'                  => 'dra',
    'rumpunbahasafilipina'                  => 'phi',
    'rumpunbahasafinnougrik'                => 'fiu',
    'rumpunbahasaindianamerikaselatan'      => 'sai',
    'rumpunbahasaindianamerikautara'        => 'nai',
    'rumpunbahasaindik'                     => 'inc',
    'rumpunbahasaindoeropa'                 => 'ine',
    'rumpunbahasairan'                      => 'ira',
    'rumpunbahasairoquis'                   => 'iro',
    'rumpunbahasakaukasia'                  => 'cau',
    'rumpunbahasakhoisa'                    => 'khi',
    'rumpunbahasakush'                      => 'cus',
    'rumpunbahasamanobo'                    => 'mno',
    'rumpunbahasamaya'                      => 'myn',
    'rumpunbahasamunda'                     => 'mun',
    'rumpunbahasanigerkordofania'           => 'nic',
    'rumpunbahasanilosahara'                => 'ssa',
    'rumpunbahasanubia'                     => 'nub',
    'rumpunbahasaotomia'                    => 'oto',
    'rumpunbahasapapua'                     => 'paa',
    'rumpunbahasaprakrit'                   => 'pra',
    'rumpunbahasaroman'                     => 'roa',
    'rumpunbahasasalisha'                   => 'sal',
    'rumpunbahasasami'                      => 'smi',
    'rumpunbahasasemit'                     => 'sem',
    'rumpunbahasasinotibet'                 => 'sit',
    'rumpunbahasasioux'                     => 'sio',
    'rumpunbahasaslavik'                    => 'sla',
    'rumpunbahasasorbia'                    => 'wen',
    'rumpunbahasatai'                       => 'tai',
    'rumpunbahasatupi'                      => 'tup',
    'rumpunbahasawakasha'                   => 'wak',
    'rumpunbahasayupik'                     => 'ypk',
    'rundi'                                 => 'rn',
    'rusia'                                 => 'ru',
    'rwa'                                   => 'rwk',
    'saho'                                  => 'ssy',
    'sakha'                                 => 'sah',
    'samburu'                               => 'saq',
    'samiselatan'                           => 'sma',
    'samoan'                                => 'sm',
    'sandawe'                               => 'sad',
    'sango'                                 => 'sg',
    'sangu'                                 => 'sbp',
    'sansekerta'                            => 'sa',
    'santali'                               => 'sat',
    'sardinia'                              => 'sc',
    'sasak'                                 => 'sas',
    'selkup'                                => 'sel',
    'sena'                                  => 'seh',
    'seneca'                                => 'see',
    'serb'                                  => 'sr',
    'serbocroatian'                         => 'sh',
    'serer'                                 => 'srr',
    'shambala'                              => 'ksb',
    'shan'                                  => 'shn',
    'shona'                                 => 'sn',
    'sichuanyi'                             => 'ii',
    'sidamo'                                => 'sid',
    'siksika'                               => 'bla',
    'sindhi'                                => 'sd',
    'sinhala'                               => 'si',
    'sisilia'                               => 'scn',
    'skoltsami'                             => 'sms',
    'skotlandia'                            => 'sco',
    'slave'                                 => 'den',
    'slovenia'                              => 'sl',
    'slowakia'                              => 'sk',
    'soga'                                  => 'xog',
    'sogdien'                               => 'sog',
    'somali'                                => 'so',
    'songhai'                               => 'son',
    'soninke'                               => 'snk',
    'sorbiaatas'                            => 'hsb',
    'sorbiarendah'                          => 'dsb',
    'sothoselatan'                          => 'st',
    'sothoutara'                            => 'nso',
    'spanyol'                               => 'es',
    'spanyoliberia'                         => 'es_es',
    'sranantongo'                           => 'srn',
    'sukuma'                                => 'suk',
    'sumeria'                               => 'sux',
    'sunda'                                 => 'su',
    'suomi'                                 => 'fi',
    'suriah'                                => 'syr',
    'susu'                                  => 'sus',
    'swahili'                               => 'sw',
    'swati'                                 => 'ss',
    'swedia'                                => 'sv',
    'tachelhit'                             => 'shi',
    'tagalog'                               => 'tl',
    'tahiti'                                => 'ty',
    'taita'                                 => 'dav',
    'tajik'                                 => 'tg',
    'tamashek'                              => 'tmh',
    'tamil'                                 => 'ta',
    'taroko'                                => 'trv',
    'tasawaq'                               => 'twq',
    'tatar'                                 => 'tt',
    'tatarkrimea'                           => 'crh',
    'telugu'                                => 'te',
    'tereno'                                => 'ter',
    'teso'                                  => 'teo',
    'tetun'                                 => 'tet',
    'thai'                                  => 'th',
    'tibet'                                 => 'bo',
    'tidakadakontenlinguistik'              => 'zxx',
    'tigre'                                 => 'tig',
    'tigrinya'                              => 'ti',
    'timne'                                 => 'tem',
    'tiv'                                   => 'tiv',
    'tlingit'                               => 'tli',
    'tokelau'                               => 'tkl',
    'tokpisin'                              => 'tpi',
    'tonga'                                 => 'to',
    'tsimshia'                              => 'tsi',
    'tsonga'                                => 'ts',
    'tswana'                                => 'tn',
    'tumbuka'                               => 'tum',
    'turki'                                 => 'tr',
    'turkiosmani'                           => 'ota',
    'turkmen'                               => 'tk',
    'tuvalu'                                => 'tvl',
    'tuvinia'                               => 'tyv',
    'twi'                                   => 'tw',
    'tyap'                                  => 'kcg',
    'udmurt'                                => 'udm',
    'ugarit'                                => 'uga',
    'ukraina'                               => 'uk',
    'umbundu'                               => 'umb',
    'urdu'                                  => 'ur',
    'uyghur'                                => 'ug',
    'uzbek'                                 => 'uz',
    'vai'                                   => 'vai',
    'venda'                                 => 've',
    'vietnam'                               => 'vi',
    'volapük'                              => 'vo',
    'votia'                                 => 'vot',
    'vunjo'                                 => 'vun',
    'walamo'                                => 'wal',
    'walloon'                               => 'wa',
    'walser'                                => 'wae',
    'warai'                                 => 'war',
    'washo'                                 => 'was',
    'welsh'                                 => 'cy',
    'wolof'                                 => 'wo',
    'xhosa'                                 => 'xh',
    'yangben'                               => 'yav',
    'yao'                                   => 'yao',
    'yapois'                                => 'yap',
    'yiddish'                               => 'yi',
    'yoruba'                                => 'yo',
    'yunani'                                => 'el',
    'yunanikunosd1453'                      => 'grc',
    'zande'                                 => 'znd',
    'zapotek'                               => 'zap',
    'zarma'                                 => 'dje',
    'zaza'                                  => 'zza',
    'zenaga'                                => 'zen',
    'zhuang'                                => 'za',
    'zulu'                                  => 'zu',
    'zuni'                                  => 'zun',
);

1;
