#!/usr/bin/perl -w -I ../../../lib

use 5.018;

use strict;

use Carp;

{ package Narwhal::Effect::Flanger;

    use Moose;
    use Moose::Util::TypeConstraints;

    extends 'Narwhal::Effect';
    
    enum 'Form', [qw(sine triangle)];
    
    our %gencmd_form = ('sine' => 'sin','triangle' => 'tri');
    our %gencmd_interp = ('linear' => 'lin','quadratic' => 'quad');
    
    has 'delay' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'depth' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'regen' => (
        is => 'rw',
        isa => 'Num',
    );
    
    has 'width' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'speed' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'phase' => (
        is => 'rw',
        isa => 'Num',
    );

    has 'interpolation' => (
        is => 'rw',
        isa => 'Str',
    );

    has 'form' => (
        is => 'rw',
        isa => 'Str',
    );

    sub gencmd {
        my $self = shift;        
        my $ret = sprintf("%s %s %s %s %s %s %s %s %s",$self->fx,$self->delay,$self->depth,$self->regen,$self->width,$self->speed,$Narwhal::Effect::Flanger::gencmd_form{$self->form},$self->phase,$Narwhal::Effect::Flanger::gencmd_interp{$self->interpolation});
        return($ret);
    }
}

1;
