#!/usr/bin/perl -w -I ../../lib

use 5.018;

use strict;

use Carp;

{ package Narwhal::Preset;
  
    use Moose;
    use Moose::Util::TypeConstraints;
    
    use YAML::Tiny;
    
    enum 'Format', [qw(YAML XML JSON)];
    enum 'Process', [qw(play)];

    has 'format' => (
        is => 'rw',
        isa => 'Format',
    );

    has 'diamond' => (
        is => 'rw',
        isa => 'Str',
    );

    has 'buffer' => (
        is => 'rw',
        isa => 'HashRef',
    );
  
    has 'synth' => (
        is => 'rw',
        isa => 'Narwhal::Synth',
    );
  
    has 'tone' => (
        is => 'rw',
        isa => 'Narwhal::Tone',
    );
  
    has 'process' => (
        is => 'rw',
        isa => 'Process',
    );
    
    has 'effect' => (
        is => 'rw',
        isa => 'Narwhal::Effect',
    );
  
    sub parse {
        my $self = shift;
        my $yaml;
        given($self->format) {
            when(/^YAML$/) {                
                eval {
                    $yaml = YAML::Tiny->read_string($self->diamond);
                };
                die "Regrettably, this file is not a valid narwhal preset. $@." if $@;
                $self->buffer($yaml->[0]) or die "Regrettably, this file is not a valid narwhal preset.";
                return(1);
            }
        }
        
        return(0);
    }
}

1;