#!/usr/bin/env perl
use strict;
use warnings;
use Test::More;
use lib 'lib';
use List::Util 'sum';

BEGIN { use_ok 'Settlers::Game::Player' }

ok my $player = Settlers::Game::Player->new({number => 1}), 'constructor';

# ratios
cmp_ok sum(values %{$player->ratios}), '==', 20, 'vanilla resource ratios add up to 20';
cmp_ok scalar keys %{$player->ratios}, '==', 5, '5 resource ratio types';
done_testing;
