use strict;
use warnings;
use utf8;

package SDK::SoundCloud::Connect;

use Moo::Role;
use namespace::clean;

use Params::Validate qw(:all);

requires 'client_id';

sub connect_url {
    my $self = shift @_;

    my %params = validate(
        @_, {
        redirect_uri => { type => SCALAR },
        response_type => { 
            type => SCALAR,
            default => 'code',
            callbacks => {
                'code or token_and_code' => sub {
                    return $_[0] if $_[0] =~ /^code|token_and_code$/
                }
            }
        },
        scope => {
            type => SCALAR,
            default => '*',
            callbacks => {
                'code or token_and_code' => sub {
                    return $_[0] if $_[0] =~ /^\*|non-expiring$/
                }
            }
        },
        display => { type => SCALAR, optional => 1 },
        scope => { type => SCALAR, optional => 1 }
    });

    $params{client_id} = $self->client_id;     
             
    my $q_string = $self->build_query(\%params);

    return $self->url . '/connect' . $q_string;
}

1;
