use strict;
use warnings;
use utf8;

package SDK::SoundCloud::Connect;

use Data::Dumper;

use Moo::Role;
use namespace::clean;

use MooseX::Params::Validate;

requires 'client_id';

sub connect_url {
    my ($self, %params) = validated_hash(
        \@_,
        redirect_uri => { isa => 'Str' },
        response_type => { 
            isa => 'Str',
            default => 'code' #token_and_code
        },
        scope => {
            isa => 'Str',
            default => '*' #non-expiring
        },
        display => { isa => 'Str', optional => 1 },
        scope => { isa => 'Str', optional => 1 }
    );

    $params{client_id} = $self->client_id;     
             
    my $q_string = $self->build_query(\%params);

    return $self->url . '/connect' . $q_string;
}

1;
