# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240910191016;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"814775", "船橋",
"818949", "宇和",
"811856", "能代",
"814753", "茂原",
"817735", "福知山",
"819737", "玖珠",
"811862", "鹿角",
"8152", "名古屋",
"811362", "倶知安",
"814223", "武蔵野三鷹",
"81964", "松橋",
"818264", "安芸吉田",
"811356", "岩内",
"812968", "笠間",
"812797", "渋川",
"81462", "厚木",
"817688", "能都",
"811336", "石狩",
"819746", "竹田",
"812387", "長井",
"818246", "三次",
"812914", "鉾田",
"8161", "大阪",
"8128798", "大田原",
"815743", "美濃加茂",
"819593", "大瀬戸",
"8188096", "土佐清水",
"81535", "浜松",
"812672", "小諸",
"81833", "下松",
"815368", "設楽",
"811541", "弟子屈",
"811643", "石狩深川",
"81585", "揖斐川",
"8125489", "津川",
"817963", "豊岡",
"81124", "芦別",
"814240", "国分寺",
"81228", "築館",
"81583", "岐阜",
"815987", "三瀬谷",
"818466", "木江",
"812553", "上越",
"818596", "米子",
"81885", "小松島",
"81484", "川口",
"819974", "屋久島",
"812575", "十日町",
"818368", "宇部",
"81932", "北九州",
"814289", "青梅",
"81533", "豊橋",
"817474", "五条",
"81434", "千葉",
"81835", "防府",
"812419", "田島",
"818946", "宇和",
"81538", "磐田",
"818473", "甲山",
"8112393", "夕張",
"81929", "福岡",
"812572", "柏崎",
"811543", "釧路",
"818957", "御荘",
"8186992", "備前",
"81225", "石巻",
"812830", "宇都宮",
"815957", "上野",
"812675", "佐久",
"819943", "鹿屋",
"812583", "長岡",
"812551", "上越",
"812653", "飯田",
"81888", "高知",
"818696", "備前",
"811527", "美幌",
"818249", "東広島",
"81272", "前橋",
"818804", "土佐中村",
"8186994", "岡山瀬戸",
"8182920", "廿日市",
"818208", "久賀",
"81298", "土浦",
"812837", "佐野",
"814772", "市川",
"812857", "真岡",
"811865", "大館",
"817732", "福知山",
"81766", "高岡",
"814286", "相模原",
"811365", "倶知安",
"817617", "加賀",
"819787", "国東",
"812416", "田島",
"81984", "小林",
"811647", "羽幌",
"819965", "川内",
"812564", "三条",
"817967", "八鹿",
"81482", "川口",
"81934", "北九州",
"817942", "加古川",
"811656", "美深",
"811586", "中湧別",
"815399", "天竜",
"819434", "八女",
"817465", "吉野",
"815972", "尾鷲",
"819597", "福江",
"81432", "千葉",
"819805", "名護",
"811636", "北見枝幸",
"818972", "新居浜",
"8153962", "天竜",
"812546", "村上",
"812557", "新井",
"817954", "西脇",
"814220", "国分寺",
"817486", "水口",
"815983", "松阪",
"812999", "潮来",
"81565", "豊田",
"812550", "安塚",
"812793", "渋川",
"811978", "北上",
"815736", "中津川",
"814227", "武蔵野三鷹",
"819726", "臼杵",
"81863", "玉野",
"812372", "村山",
"8147950", "八日市場",
"811559", "帯広",
"812872", "大田原",
"8167", "大阪",
"819733", "日田",
"814757", "東金",
"815747", "美濃白川",
"811539", "根室標津",
"812383", "米沢",
"812649", "長野",
"81563", "西尾",
"818668", "井原",
"81962", "熊本",
"815756", "郡上八幡",
"819578", "島原",
"817960", "八鹿",
"815762", "下呂",
"81464", "厚木",
"817459", "大和榛原",
"8112391", "夕張",
"81568", "春日井",
"81555", "吉田",
"812580", "十日町",
"819940", "志布志",
"811874", "角館",
"81853", "出雲",
"812833", "宇都宮",
"81192", "大船渡",
"811374", "森",
"811589", "興部",
"815396", "浜松",
"817724", "宮津",
"818514", "海士",
"815765", "下呂",
"81721", "富田林",
"811639", "利尻礼文",
"812549", "津川",
"812375", "村山",
"819783", "豊後高田",
"817613", "小松",
"8186995", "岡山瀬戸",
"81952", "佐賀",
"814708", "大原",
"818568", "津和野",
"81553", "山梨",
"812875", "大田原",
"818896", "須崎",
"812853", "小山",
"819678", "矢部",
"812996", "潮来",
"818953", "宇和島",
"818975", "新居浜",
"811547", "白糠",
"8153977", "天竜",
"811562", "本別",
"818477", "東城",
"811556", "帯広",
"819936", "加世田",
"81429", "所沢",
"812618", "大町",
"811536", "厚岸",
"81178", "八戸",
"819956", "加治木",
"812646", "長野",
"819962", "川内",
"812587", "長岡",
"819947", "志布志",
"817945", "加古川",
"811523", "斜里",
"812657", "伊那",
"81940", "宗像",
"819802", "南大東",
"817456", "大和高田",
"815953", "上野",
"8125482", "村上",
"81827", "岩国",
"818544", "木次",
"818673", "福渡",
"818585", "倉吉",
"815398", "浜松",
"8199343", "鹿児島",
"818655", "鴨方",
"8183767", "下関",
"815566", "身延",
"817993", "洲本",
"81460", "小田原",
"81977", "別府",
"819676", "高森",
"8125484", "村上",
"812475", "石川",
"818552", "浜田",
"818682", "津山",
"814706", "大原",
"81724", "岸和田貝塚",
"818398", "小郡",
"815585", "下田",
"8126177", "長野",
"812977", "竜ケ崎",
"818877", "嶺北",
"812742", "藤岡",
"819938", "加世田",
"811558", "広尾",
"818294", "廿日市",
"811392", "木古内",
"818377", "下関",
"812998", "潮来",
"817458", "大和榛原",
"817915", "相生",
"811735", "五所川原",
"818669", "総社",
"812648", "長野",
"811538", "根室標津",
"817356", "串本",
"81930", "行橋",
"817902", "福崎",
"817362", "和歌山橋本",
"812616", "大町",
"817912", "相生",
"81166", "旭川",
"811732", "五所川原",
"811588", "興部",
"811658", "上川",
"8198298", "日向",
"81944", "瀬高",
"817905", "福崎",
"817365", "和歌山橋本",
"812894", "宇都宮",
"817488", "水口",
"819679", "高森",
"812745", "藤岡",
"812784", "沼田",
"814709", "鴨川",
"811395", "江差",
"811752", "むつ",
"8186552", "倉敷",
"81270", "伊勢崎",
"811638", "利尻礼文",
"814992", "伊豆大島",
"819663", "人吉",
"812472", "石川",
"818555", "江津",
"818685", "津山",
"8186999", "岡山瀬戸",
"81926", "福岡",
"819728", "臼杵",
"815582", "下田",
"815738", "中津川",
"811976", "北上",
"815994", "阿児",
"8182942", "広島",
"819576", "島原",
"815758", "郡上八幡",
"818666", "井原",
"8188091", "窪川",
"818582", "倉吉",
"818652", "倉敷",
"812483", "白河",
"817674", "羽咋",
"812619", "大町",
"812232", "岩沼",
"81548", "榛原",
"81480", "久喜",
"818792", "三本松",
"818373", "長門",
"812244", "白石",
"819825", "日向",
"818873", "安芸",
"818948", "宇和",
"814794", "銚子",
"818382", "萩",
"8125485", "津川",
"8112396", "栗山",
"818835", "脇町",
"818698", "備前",
"819913", "硫黄島",
"81848", "尾道",
"819542", "武雄",
"81775", "大津",
"817997", "津名",
"812935", "水戸",
"81722", "堺",
"818677", "新見",
"818206", "柳井",
"817495", "長浜",
"811954", "二戸",
"812955", "常陸大宮",
"819554", "伊万里",
"812418", "会津山口",
"812973", "水海道",
"817714", "亀岡",
"819684", "山鹿",
"818369", "宇部",
"814288", "青梅",
"811934", "釜石",
"811465", "静内",
"81191", "一関",
"811942", "岩泉",
"81778", "武生",
"812694", "中野",
"811456", "門別富川",
"811462", "浦河",
"819667", "水俣",
"811945", "久慈",
"817704", "敦賀",
"811858", "能代",
"811984", "花巻",
"81426", "八王子",
"81739", "田辺",
"818248", "庄原",
"812932", "高萩",
"812487", "須賀川",
"8147957", "八日市場",
"81950", "平戸",
"817686", "能都",
"817492", "彦根",
"81545", "富士",
"818385", "萩",
"818832", "鴨島",
"815366", "設楽",
"811234", "千歳",
"818844", "阿南",
"81792", "姫路",
"812235", "仙台",
"8188093", "窪川",
"818795", "三本松",
"818366", "宇部",
"81543", "静岡",
"818598", "根雨",
"819822", "延岡",
"81942", "久留米",
"81845", "因島",
"812674", "小諸",
"812543", "新発田",
"819789", "杵築",
"81485", "熊谷",
"81834", "徳山",
"812859", "小山",
"817483", "八日市",
"815986", "松阪",
"818597", "根雨",
"8186997", "岡山瀬戸",
"818467", "木江",
"818805", "土佐中村",
"81172", "弘前",
"81433", "千葉",
"812839", "佐野",
"81737", "湯浅",
"819972", "種子島",
"81534", "浜松",
"817472", "五条",
"818240", "東広島",
"81125", "滝川",
"81584", "大垣",
"811653", "士別",
"811551", "十勝池田",
"811583", "紋別",
"812386", "長井",
"818247", "庄原",
"8162", "大阪",
"819233", "前原",
"818391", "小郡",
"81562", "尾張横須賀",
"8124197", "柳津",
"811864", "大館",
"81963", "熊本",
"815753", "関",
"811337", "石狩",
"815959", "亀山",
"812488", "須賀川",
"811364", "倶知安",
"818262", "加計",
"819747", "竹田",
"815733", "恵那",
"819723", "佐伯",
"811357", "岩内",
"8125480", "村上",
"812796", "渋川",
"811857", "能代",
"81862", "岡山",
"819668", "水俣",
"81958", "長崎",
"81294", "常陸太田",
"81965", "八代",
"814287", "青梅",
"819786", "杵築",
"817616", "小松",
"81552", "甲府",
"812417", "会津山口",
"81246", "いわき",
"81259", "佐渡",
"818893", "佐川",
"812856", "真岡",
"812836", "佐野",
"817998", "津名",
"818690", "岡山",
"817734", "福知山",
"81852", "松江",
"818678", "新見",
"818265", "安芸吉田",
"815393", "浜松",
"812389", "米沢",
"819953", "大口",
"812643", "木曾福島",
"819975", "名瀬",
"812574", "柏崎",
"81488", "浦和",
"811533", "根室",
"817475", "下市",
"81438", "木更津",
"817453", "大和高田",
"815956", "上野",
"811526", "網走",
"818697", "備前",
"8198293", "延岡",
"818956", "宇和島",
"812993", "石岡",
"812799", "長野原",
"818947", "宇和",
"8169", "大阪",
"819933", "指宿",
"814280", "立川",
"811553", "帯広",
"818802", "窪川",
"819949", "大根占",
"812589", "長岡",
"812374", "村山",
"812659", "伊那",
"819743", "三重",
"815757", "郡上八幡",
"811333", "当別",
"812874", "大田原",
"815746", "美濃加茂",
"81864", "倉敷",
"81465", "小田原",
"81292", "水戸",
"818243", "東広島",
"814281", "相模原",
"818479", "東城",
"81463", "平塚",
"81564", "岡崎",
"811853", "男鹿",
"814756", "東金",
"811875", "角館",
"815764", "下呂",
"81899", "松山",
"815737", "中津川",
"811375", "八雲",
"814226", "武蔵野三鷹",
"811353", "余市",
"819727", "臼杵",
"811549", "釧路",
"817725", "宮津",
"818463", "竹原",
"818593", "米子",
"812556", "糸魚川",
"81174", "蟹田",
"812562", "三条",
"81933", "北九州",
"81532", "豊橋",
"817487", "水口",
"811637", "北見枝幸",
"815974", "尾鷲",
"81582", "岐阜",
"817944", "加古川",
"812547", "村上",
"81983", "高鍋",
"819432", "八女",
"811587", "中湧別",
"819596", "福江",
"818974", "新居浜",
"81985", "宮崎",
"81832", "下関",
"8153974", "天竜",
"817952", "西脇",
"811646", "羽幌",
"81935", "北九州",
"817966", "八鹿",
"819946", "鹿屋",
"812586", "長岡",
"818693", "邑久",
"812656", "伊那",
"817457", "大和高田",
"81273", "高崎",
"81979", "中津",
"811537", "中標津",
"817955", "三田",
"819957", "加治木",
"811564", "上士幌",
"812647", "長野",
"8188098", "土佐清水",
"818476", "府中",
"819964", "川内",
"812565", "三条",
"811557", "十勝池田",
"819937", "加世田",
"81222", "仙台",
"818943", "八幡浜",
"818878", "嶺北",
"81988", "那覇",
"817464", "吉野",
"812997", "潮来",
"819804", "名護",
"818378", "下関",
"81938", "北九州",
"814229", "武蔵野三鷹",
"811546", "釧路",
"819435", "八女",
"812559", "安塚",
"819208", "対馬佐賀",
"818512", "西郷",
"812978", "竜ケ崎",
"81468", "横須賀",
"812413", "喜多方",
"811372", "鹿部",
"814283", "青梅",
"818397", "小郡",
"817722", "宮津",
"8198291", "延岡",
"815397", "浜松",
"812640", "長野",
"819599", "大瀬戸",
"81554", "大月",
"817969", "浜坂",
"8178", "神戸",
"817357", "串本",
"812744", "藤岡",
"812617", "大町",
"812785", "沼田",
"81266", "諏訪",
"8147955", "八日市場",
"818292", "広島",
"812658", "伊那",
"819948", "志布志",
"811394", "松前",
"812588", "長岡",
"811548", "弟子屈",
"818376", "美祢",
"81798", "西宮",
"814700", "鴨川",
"818490", "尾道",
"818876", "土佐山田",
"817904", "福崎",
"812895", "宇都宮",
"817364", "和歌山橋本",
"818478", "東城",
"81948", "飯塚",
"818542", "安来",
"812976", "竜ケ崎",
"817675", "七尾",
"819677", "矢部",
"81725", "和泉",
"818567", "津和野",
"8186697", "倉敷",
"814707", "大原",
"818554", "浜田",
"818684", "津山",
"81723", "堺",
"81427", "相模原",
"818203", "柳井",
"815995", "阿児",
"81551", "韮崎",
"812474", "石川",
"8125487", "津川",
"81550", "御殿場",
"814994", "三宅",
"815748", "美濃白川",
"817683", "輪島",
"815992", "鳥羽",
"819577", "島原",
"81728", "寝屋川",
"818667", "井原",
"815584", "下田",
"818545", "木次",
"818584", "倉吉",
"818654", "鴨方",
"814228", "武蔵野三鷹",
"811977", "北上",
"812963", "下館",
"818879", "室戸",
"814758", "東金",
"817672", "羽咋",
"81561", "瀬戸",
"81476", "成田",
"811453", "早来",
"811734", "五所川原",
"818363", "宇部",
"81542", "静岡",
"817914", "相生",
"812979", "竜ケ崎",
"812892", "宇都宮",
"81249", "郡山",
"81793", "姫路",
"812558", "新井",
"817968", "浜坂",
"811648", "焼尻",
"812782", "沼田",
"818660", "岡山瀬戸",
"811754", "むつ",
"8112398", "栗山",
"819598", "福江",
"818295", "廿日市",
"815363", "新城",
"81286", "宇都宮",
"818493", "尾道",
"818563", "益田",
"81927", "福岡",
"814703", "館山",
"812858", "真岡",
"819673", "熊本一の宮",
"819544", "武雄",
"81236", "山形",
"811952", "二戸",
"819788", "国東",
"817618", "加賀",
"81877", "丸亀",
"818676", "久世",
"81577", "高山",
"812695", "中野",
"811932", "釜石",
"819552", "伊万里",
"818207", "久賀",
"81774", "宇治",
"817712", "亀岡",
"819682", "山鹿",
"817705", "小浜",
"811944", "岩泉",
"815563", "鰍沢青柳",
"812838", "佐野",
"817996", "津名",
"811528", "美幌",
"81596", "伊勢",
"812489", "須賀川",
"812234", "仙台",
"8153960", "天竜",
"815958", "亀山",
"8198296", "日向",
"81167", "富良野",
"818794", "三本松",
"817353", "新宮",
"812613", "大町",
"812242", "白石",
"818384", "萩",
"814792", "銚子",
"818958", "御荘",
"811235", "夕張",
"818845", "丹生谷",
"81896", "伊予三島",
"818834", "鴨島",
"81157", "北見",
"815988", "三瀬谷",
"814795", "銚子",
"818842", "阿南",
"811232", "千歳",
"818367", "宇部",
"815367", "設楽",
"818679", "新見",
"81220", "迫",
"81544", "富士宮",
"81581", "高富",
"812245", "大河原",
"81531", "田原",
"819824", "延岡",
"818663", "総社",
"814701", "鴨川",
"812486", "須賀川",
"812692", "中野",
"811935", "釜石",
"819555", "唐津",
"819573", "諫早",
"817715", "亀岡",
"817687", "能都",
"819685", "玉名",
"8175", "京都",
"817702", "敦賀",
"811982", "花巻",
"812388", "長井",
"811464", "静内",
"811457", "門別富川",
"819738", "玖珠",
"818360", "小郡",
"819666", "水俣",
"812798", "長野原",
"811973", "水沢",
"817494", "彦根",
"811955", "二戸",
"812967", "笠間",
"812934", "高萩",
"818565", "益田",
"814705", "館山",
"812476", "三春",
"81925", "福岡",
"812878", "烏山",
"81822", "広島",
"817677", "七尾",
"814996", "八丈島",
"819675", "熊本一の宮",
"811972", "水沢",
"815586", "下田",
"81875", "観音寺",
"81474", "船橋",
"812378", "寒河江",
"812890", "宇都宮",
"812693", "中野",
"818656", "笠岡",
"818662", "高梁",
"812780", "前橋",
"818586", "倉吉",
"8198295", "日向",
"819572", "諫早",
"815997", "阿児",
"815768", "下呂",
"81229", "古川",
"817703", "敦賀",
"811983", "花巻",
"81923", "福岡",
"8166", "大阪",
"815565", "鰍沢青柳",
"817948", "三木",
"811736", "五所川原",
"815978", "熊野",
"817916", "竜野",
"812787", "沼田",
"812615", "大町",
"817355", "新宮",
"818689", "岡山",
"818559", "川本",
"812897", "鹿沼",
"8188090", "窪川",
"818843", "阿南",
"811233", "千歳",
"818978", "伯方",
"811756", "野辺地",
"81998", "鹿児島",
"81592", "津",
"814793", "銚子",
"812746", "富岡",
"81743", "奈良",
"815589", "修善寺大仁",
"811396", "江差",
"818374", "長門",
"813", "東京",
"818297", "廿日市",
"817468", "上北山",
"8199331", "鹿児島",
"819808", "八重山",
"817366", "岩出",
"812612", "大町",
"817352", "新宮",
"818874", "安芸",
"817906", "播磨山崎",
"81892", "久万",
"812243", "白石",
"819968", "出水",
"81282", "栃木",
"811933", "釜石",
"818665", "高梁",
"81928", "福岡",
"819575", "諫早",
"817713", "亀岡",
"812974", "水海道",
"819683", "山鹿",
"819553", "伊万里",
"8183766", "下関",
"818290", "広島",
"81878", "高松",
"815562", "鰍沢青柳",
"819204", "郷ノ浦",
"818686", "津山",
"814702", "館山",
"818562", "益田",
"81578", "神岡",
"8145", "横浜",
"818556", "江津",
"819672", "熊本一の宮",
"811953", "二戸",
"81839", "山口",
"811975", "水沢",
"8165", "大阪",
"818547", "掛合",
"818836", "脇町",
"81559", "沼津",
"8198292", "延岡",
"81546", "静岡",
"812783", "沼田",
"81252", "新潟",
"812678", "佐久",
"815362", "新城",
"818362", "宇部",
"8198294", "延岡",
"818847", "牟岐",
"811237", "栗山",
"8168", "大阪",
"812893", "宇都宮",
"819826", "日向",
"8163", "大阪",
"812484", "白河",
"8186698", "倉敷",
"812962", "下館",
"812956", "常陸大宮",
"812239", "仙台",
"817673", "羽咋",
"811868", "鷹巣",
"81727", "池田",
"811466", "えりも",
"81240", "磐城富岡",
"811452", "早来",
"81423", "国分寺",
"811987", "遠野",
"817707", "小浜",
"819664", "人吉",
"81183", "湯沢",
"81425", "立川",
"817496", "長浜",
"817682", "輪島",
"815993", "鳥羽",
"818205", "柳井",
"812697", "飯山",
"812936", "水戸",
"81138", "函館",
"81776", "福井",
"819546", "鹿島",
"817685", "輪島",
"819687", "玉名",
"817717", "園部",
"819557", "唐津",
"818202", "柳井",
"811937", "宮古",
"8125488", "津川",
"81188", "秋田",
"81284", "足利",
"818543", "安来",
"818674", "久世",
"81179", "三戸",
"811957", "岩手",
"812965", "下館",
"811946", "久慈",
"81234", "酒田",
"817738", "舞鶴",
"817994", "洲本",
"811455", "鵡川",
"818365", "宇部",
"818796", "土庄",
"812236", "仙台",
"81569", "半田",
"81262", "長野",
"814797", "八日市場",
"81495", "本庄",
"812578", "六日町",
"81594", "桑名",
"812247", "大河原",
"81797", "西宮",
"81493", "東松山",
"8112397", "栗山",
"812939", "水戸",
"818293", "廿日市",
"81947", "田川",
"819784", "豊後高田",
"817614", "小松",
"812679", "佐久",
"81763", "福野",
"812854", "小山",
"81467", "藤沢",
"818245", "三次",
"81765", "魚津",
"812834", "宇都宮",
"811873", "角館",
"817736", "舞鶴",
"814776", "船橋",
"811855", "能代",
"81244", "原町",
"812412", "喜多方",
"81281", "宇都宮",
"817723", "宮津",
"814282", "青梅",
"818807", "宿毛",
"812576", "十日町",
"818595", "米子",
"811869", "大館",
"818942", "八幡浜",
"812238", "仙台",
"815954", "上野",
"818798", "土庄",
"811524", "網走",
"818692", "邑久",
"81226", "気仙沼",
"818954", "宇和島",
"81987", "日南",
"81591", "津",
"818388", "田万川",
"81937", "北九州",
"818695", "岡山瀬戸",
"812676", "佐久",
"8188097", "土佐清水",
"815984", "松阪",
"819977", "瀬戸内",
"81586", "一宮",
"817953", "西脇",
"818838", "阿波池田",
"8144", "川崎",
"812563", "三条",
"818462", "竹原",
"81886", "徳島",
"818592", "米子",
"819828", "高千穂",
"818945", "八幡浜",
"8164", "大阪",
"819433", "八女",
"81277", "桐生",
"812579", "小出",
"812917", "水戸",
"812384", "米沢",
"811866", "鷹巣",
"81280", "古河",
"811852", "男鹿",
"812415", "柳津",
"811352", "余市",
"814285", "相模原",
"811366", "寿都",
"812938", "水戸",
"819742", "三重",
"818267", "千代田",
"812794", "渋川",
"811332", "当別",
"817498", "長浜",
"819734", "日田",
"818242", "東広島",
"81143", "室蘭",
"812654", "飯田",
"8186998", "岡山瀬戸",
"812545", "村上",
"819944", "鹿屋",
"811398", "熊石",
"8112390", "夕張",
"812584", "長岡",
"81487", "浦和",
"812992", "石岡",
"811635", "浜頓別",
"817485", "八日市",
"812748", "富岡",
"812879", "烏山",
"819932", "指宿",
"811552", "帯広",
"818803", "土佐中村",
"811566", "十勝清水",
"81250", "新津",
"814298", "飯能",
"819966", "出水",
"812642", "木曾福島",
"818474", "府中",
"819952", "大口",
"811532", "根室",
"817908", "播磨山崎",
"817368", "岩出",
"817452", "大和高田",
"819806", "沖縄宮古",
"815769", "荘川",
"817230", "寝屋川",
"817466", "十津川",
"811585", "遠軽",
"811544", "釧路",
"811655", "名寄",
"81549", "静岡",
"81242", "会津若松",
"815755", "関",
"815979", "熊野",
"812911", "鉾田",
"8198299", "日向",
"815392", "浜松",
"817949", "加古川",
"819725", "佐伯",
"817727", "峰山",
"815735", "恵那",
"811377", "八雲",
"8199347", "鹿児島",
"811877", "大曲",
"818892", "佐川",
"81849", "福山",
"818558", "川本",
"818688", "美作",
"812376", "寒河江",
"819722", "佐伯",
"815588", "修善寺大仁",
"815732", "恵那",
"81471", "柏",
"81566", "刈谷",
"812560", "糸魚川",
"818895", "須崎",
"814998", "小笠原",
"812876", "黒磯",
"815744", "美濃加茂",
"812478", "三春",
"812913", "鉾田",
"819969", "中甑",
"819232", "前原",
"814754", "茂原",
"819809", "八重山",
"815766", "下呂",
"817950", "三田",
"815752", "関",
"818263", "加計",
"815395", "浜松",
"818588", "郡家",
"814224", "武蔵野三鷹",
"819973", "種子島",
"812645", "木曾福島",
"817957", "丹波柏原",
"812554", "上越",
"819955", "加治木",
"811535", "厚岸",
"81779", "大野",
"817455", "大和高田",
"817473", "五条",
"811738", "鰺ケ沢",
"811582", "紋別",
"81260", "阿南町",
"817946", "三木",
"811652", "士別",
"81176", "十和田",
"819437", "田主丸",
"812542", "新発田",
"81738", "御坊",
"818976", "新居浜",
"819594", "有川",
"812995", "石岡",
"811632", "天塩",
"817482", "八日市",
"819935", "加世田",
"817964", "豊岡",
"811555", "帯広",
"812567", "巻",
"811644", "留萌",
"811757", "野辺地",
"818375", "美祢",
"81199", "盛岡",
"818549", "石見大田",
"819438", "田主丸",
"819823", "延岡",
"812568", "巻",
"812896", "鹿沼",
"81268", "上田",
"818875", "土佐山田",
"812786", "沼田",
"818833", "鴨島",
"817958", "丹波柏原",
"81253", "新潟",
"81946", "甘木",
"811737", "鰺ケ沢",
"817917", "竜野",
"81473", "市川",
"8125486", "津川",
"8112395", "栗山",
"818657", "笠岡",
"8188099", "土佐清水",
"812933", "高萩",
"818587", "郡家",
"818299", "広島",
"81182", "横手",
"817493", "彦根",
"815996", "阿児",
"811974", "水沢",
"819574", "諫早",
"812975", "水海道",
"815587", "修善寺大仁",
"818664", "高梁",
"81924", "福岡",
"811463", "浦河",
"819205", "厳原",
"812477", "三春",
"817676", "七尾",
"812972", "水海道",
"811378", "今金",
"81489", "草加",
"818546", "掛合",
"817728", "峰山",
"81726", "茨木",
"818687", "美作",
"815564", "鰍沢青柳",
"818557", "川本",
"811943", "岩泉",
"812899", "鹿沼",
"81439", "木更津",
"811878", "大曲",
"812789", "前橋",
"819674", "熊本一の宮",
"819543", "武雄",
"817238", "寝屋川",
"814704", "館山",
"818564", "益田",
"81478", "佐原",
"81547", "島田",
"817367", "岩出",
"817907", "播磨山崎",
"8153963", "天竜",
"81744", "大和高田",
"814297", "飯能",
"818383", "萩",
"818296", "広島",
"81492", "川越",
"815999", "津",
"819912", "中之島",
"818793", "三本松",
"812233", "岩沼",
"818680", "岡山",
"818372", "長門",
"81263", "松本",
"811397", "奥尻",
"81969", "天草",
"812614", "大町",
"812747", "富岡",
"817354", "新宮",
"818872", "室戸",
"812964", "下館",
"817497", "長浜",
"81424", "武蔵野三鷹",
"81825", "広島",
"812696", "飯山",
"81288", "今市",
"812482", "白河",
"8183768", "下関",
"818268", "千代田",
"818675", "久世",
"81922", "福岡",
"818583", "倉吉",
"812937", "水戸",
"817995", "洲本",
"811454", "鵡川",
"81975", "大分",
"817706", "小浜",
"811986", "遠野",
"81134", "小樽",
"819662", "人吉",
"81572", "多治見",
"812473", "石川",
"815583", "下田",
"81823", "呉",
"81184", "本荘",
"817684", "輪島",
"812957", "大子",
"81162", "稚内",
"819827", "高千穂",
"8112394", "夕張",
"814291", "飯能",
"818846", "丹生谷",
"811236", "千歳",
"811753", "むつ",
"818364", "宇部",
"8112392", "夕張",
"811939", "宮古",
"811733", "五所川原",
"818837", "阿波池田",
"81898", "今治",
"819978", "徳之島",
"8111", "札幌",
"812930", "水戸",
"8186993", "備前",
"81893", "大洲",
"8198297", "日向",
"812246", "大河原",
"818387", "田万川",
"817363", "和歌山橋本",
"817903", "福崎",
"814796", "八日市場",
"812743", "藤岡",
"81742", "奈良",
"818808", "土佐清水",
"811393", "松前",
"81494", "秩父",
"818797", "土庄",
"81593", "四日市",
"812237", "仙台",
"81992", "鹿児島",
"811947", "久慈",
"81828", "広島",
"819665", "人吉",
"818683", "津山",
"812230", "仙台",
"8153961", "天竜",
"818553", "浜田",
"811956", "岩手",
"81235", "鶴岡",
"818204", "柳井",
"817716", "園部",
"819686", "玉名",
"81989", "那覇",
"819556", "唐津",
"812485", "白河",
"811936", "宮古",
"818672", "福渡",
"81233", "新庄",
"817992", "洲本",
"81939", "北九州",
"819547", "鹿島",
"8188092", "窪川",
"818944", "八幡浜",
"819963", "川内",
"8182941", "広島",
"812248", "大河原",
"811522", "斜里",
"819803", "名護",
"815952", "上野",
"817463", "吉野",
"8188094", "窪川",
"818952", "宇和島",
"818694", "岡山",
"81177", "青森",
"814770", "市川",
"812577", "六日町",
"818806", "宿毛",
"8186691", "倉敷",
"811563", "本別",
"815985", "松阪",
"814798", "八日市場",
"81567", "津島",
"812795", "渋川",
"812570", "小出",
"811958", "岩手",
"819782", "豊後高田",
"817612", "小松",
"81764", "富山",
"81196", "盛岡",
"817737", "舞鶴",
"819735", "日田",
"812852", "小山",
"81245", "福島",
"814777", "船橋",
"812832", "佐野",
"81243", "二本松",
"819979", "徳之島",
"812385", "米沢",
"81420", "所沢",
"81956", "佐世保",
"81949", "直方",
"814284", "立川",
"811938", "宮古",
"819558", "唐津",
"812414", "柳津",
"817718", "園部",
"819688", "玉名",
"81557", "伊東",
"811854", "男鹿",
"8124196", "柳津",
"812835", "佐野",
"812382", "米沢",
"818266", "千代田",
"811354", "余市",
"812698", "飯山",
"815763", "下呂",
"812792", "渋川",
"81144", "苫小牧",
"819785", "豊後高田",
"812373", "村山",
"817615", "小松",
"819744", "三重",
"811367", "寿都",
"818244", "三次",
"812855", "小山",
"819732", "日田",
"811867", "鷹巣",
"81857", "鳥取",
"812873", "大田原",
"818973", "新居浜",
"8199345", "鹿児島",
"818955", "宇和島",
"811238", "栗山",
"818848", "牟岐",
"81486", "浦和",
"81729", "八尾",
"815982", "松阪",
"81436", "市原",
"8186996", "岡山瀬戸",
"819976", "名瀬",
"818464", "竹原",
"8125481", "村上",
"818594", "米子",
"811525", "網走",
"812677", "佐久",
"817943", "加古川",
"815955", "上野",
"817476", "下市",
"81126", "岩見沢",
"815973", "尾鷲",
"814755", "東金",
"817733", "福知山",
"8182943", "広島",
"811876", "大曲",
"812569", "巻",
"818548", "石見大田",
"815394", "浜松",
"817726", "峰山",
"811376", "八雲",
"814225", "武蔵野三鷹",
"81762", "金沢",
"8188095", "土佐清水",
"817959", "三田",
"818894", "須崎",
"8112399", "栗山",
"815745", "美濃加茂",
"819807", "沖縄宮古",
"812994", "石岡",
"819595", "有川",
"81537", "掛川",
"818298", "廿日市",
"812652", "飯田",
"819942", "大根占",
"812582", "長岡",
"81734", "和歌山",
"819967", "出水",
"811554", "帯広",
"817965", "豊岡",
"81587", "一宮",
"811645", "留萌",
"819934", "指宿",
"8186553", "倉敷",
"811534", "中標津",
"8198290", "延岡",
"812644", "木曾福島",
"812573", "柏崎",
"818472", "甲山",
"819954", "加治木",
"812555", "糸魚川",
"811567", "十勝清水",
"811542", "釧路",
"81276", "太田",
"817454", "大和高田",
"812898", "鹿沼",
"812566", "三条",
"818475", "府中",
"812552", "上越",
"811584", "遠軽",
"811545", "釧路",
"811654", "名寄",
"818977", "伯方",
"81227", "仙台",
"81740", "今津",
"815977", "熊野",
"819592", "大瀬戸",
"81986", "都城",
"811634", "浜頓別",
"812655", "飯田",
"812544", "新発田",
"819945", "鹿屋",
"812673", "小諸",
"812571", "六日町",
"817947", "三木",
"812585", "長岡",
"817962", "豊岡",
"81936", "北九州",
"817956", "三田",
"811642", "石狩深川",
"817239", "寝屋川",
"817484", "八日市",
"812788", "前橋",
"814771", "市川",
"815767", "下呂",
"815998", "阿児",
"81142", "伊達",
"819724", "佐伯",
"815734", "恵那",
"817940", "加古川",
"815742", "美濃加茂",
"81466", "藤沢",
"814752", "茂原",
"817678", "七尾",
"811863", "鹿角",
"8125483", "村上",
"812877", "黒磯",
"812377", "寒河江",
"814222", "武蔵野三鷹",
"811363", "倶知安",
"815754", "関",};
$areanames{en} = {"819592", "Oseto\,\ Nagasaki",
"815977", "Kumano\,\ Mie",
"81986", "Miyakonojo\,\ Miyazaki",
"811634", "Hamatonbetsu\,\ Hokkaido",
"815367", "Shitara\,\ Aichi",
"818679", "Niimi\,\ Okayama",
"81227", "Sendai\,\ Miyagi",
"81740", "Imazu\,\ Shiga",
"812544", "Shibata\,\ Niigata",
"819945", "Kanoya\,\ Kagoshima",
"812673", "Komoro\,\ Nagano",
"812571", "Muika\,\ Niigata",
"817947", "Miki\,\ Hyogo",
"812585", "Nagaoka\,\ Niigata",
"81544", "Fujinomiya\,\ Shizuoka",
"812655", "Iida\,\ Nagano",
"817956", "Sanda\,\ Hyogo",
"817239", "Neyagawa\,\ Osaka",
"817962", "Toyooka\,\ Hyogo",
"81936", "Kitakyushu\,\ Fukuoka",
"81531", "Tahara\,\ Aichi",
"812788", "Maebashi\,\ Gunma",
"819824", "Nobeoka\,\ Miyazaki",
"817484", "Yokaichi\,\ Shiga",
"812245", "Ogawara\,\ Miyagi",
"812898", "Kanuma\,\ Tochigi",
"818834", "Kamojima\,\ Tokushima",
"814795", "Choshi\,\ Chiba",
"818475", "Fuchu\,\ Hiroshima",
"812552", "Joetsu\,\ Niigata",
"81157", "Kitami\,\ Hokkaido",
"812566", "Sanjo\,\ Niigata",
"811654", "Nayoro\,\ Hokkaido",
"818842", "Anan\,\ Tokushima",
"811232", "Chitose\,\ Hokkaido",
"8126175", "Omachi\,\ Nagano",
"811584", "Engaru\,\ Hokkaido",
"811545", "Kushiro\,\ Hokkaido",
"818367", "Ube\,\ Yamaguchi",
"818977", "Hakata\,\ Ehime",
"8125483", "Murakami\,\ Niigata",
"812877", "Kuroiso\,\ Tochigi",
"814752", "Mobara\,\ Chiba",
"817678", "Nanao\,\ Ishikawa",
"811863", "Kazuno\,\ Akita",
"819738", "Kusu\,\ Oita",
"818360", "Ogori\,\ Yamaguchi",
"819666", "Minamata\,\ Kumamoto",
"817494", "Hikone\,\ Shiga",
"812967", "Kasama\,\ Ibaraki",
"811363", "Kutchan\,\ Hokkaido",
"811955", "Ninohe\,\ Iwate",
"812798", "Naganohara\,\ Gunma",
"811973", "Mizusawa\,\ Iwate",
"812377", "Sagae\,\ Yamagata",
"815754", "Sekigahara\,\ Gifu",
"812934", "Takahagi\,\ Ibaraki",
"812486", "Sukagawa\,\ Fukushima",
"812692", "Nakano\,\ Nagano",
"815998", "Ago\,\ Mie",
"81142", "Date\,\ Hokkaido",
"811935", "Kamaishi\,\ Iwate",
"814701", "Kamogawa\,\ Chiba",
"818663", "Soja\,\ Okayama",
"814771", "Ichikawa\,\ Chiba",
"815767", "Gero\,\ Gifu",
"817715", "Kameoka\,\ Kyoto",
"819573", "Isahaya\,\ Nagasaki",
"815734", "Ena\,\ Gifu",
"817687", "Noto\,\ Ishikawa",
"819685", "Tamana\,\ Kumamoto",
"819555", "Karatsu\,\ Saga",
"819724", "Saiki\,\ Oita",
"817702", "Tsuruga\,\ Fukui",
"811982", "Hanamaki\,\ Iwate",
"8175", "Kyoto\,\ Kyoto",
"812388", "Nagai\,\ Yamagata",
"815742", "Minokamo\,\ Gifu",
"81466", "Fujisawa\,\ Kanagawa",
"811464", "Shizunai\,\ Hokkaido",
"817940", "Kakogawa\,\ Hyogo",
"81577", "Takayama\,\ Gifu",
"812695", "Nakano\,\ Nagano",
"811932", "Kamaishi\,\ Iwate",
"818676", "Kuse\,\ Okayama",
"81774", "Uji\,\ Kyoto",
"817712", "Kameoka\,\ Kyoto",
"819682", "Yamaga\,\ Kumamoto",
"8188095", "Tosashimizu\,\ Kochi",
"819552", "Imari\,\ Saga",
"81762", "Kanazawa\,\ Ishikawa",
"817959", "Sanda\,\ Hyogo",
"817705", "Obama\,\ Fukui",
"811944", "Iwaizumi\,\ Iwate",
"815745", "Minokamo\,\ Gifu",
"812838", "Sano\,\ Tochigi",
"818894", "Susaki\,\ Kochi",
"817996", "Tsuna\,\ Hyogo",
"8112399", "Kuriyama\,\ Hokkaido",
"8153979", "Hamamatsu\,\ Shizuoka",
"818493", "Onomichi\,\ Hiroshima",
"818563", "Masuda\,\ Shimane",
"81927", "Fukuoka\,\ Fukuoka",
"814703", "Tateyama\,\ Chiba",
"81286", "Utsunomiya\,\ Tochigi",
"814755", "Togane\,\ Chiba",
"8182943", "Hiroshima\,\ Hiroshima",
"811876", "Omagari\,\ Akita",
"817733", "Fukuchiyama\,\ Kyoto",
"812858", "Mooka\,\ Tochigi",
"819544", "Takeo\,\ Saga",
"81236", "Yamagata\,\ Yamagata",
"811952", "Ninohe\,\ Iwate",
"811376", "Yakumo\,\ Hokkaido",
"815394", "Hamamatsu\,\ Shizuoka",
"819788", "Kunisaki\,\ Oita",
"817618", "Kaga\,\ Ishikawa",
"81877", "Marugame\,\ Kagawa",
"8198290", "Nobeoka\,\ Miyazaki",
"818384", "Hagi\,\ Yamaguchi",
"8153966", "Hamamatsu\,\ Shizuoka",
"811534", "Nakashibetsu\,\ Hokkaido",
"814792", "Choshi\,\ Chiba",
"819954", "Kajiki\,\ Kagoshima",
"812555", "Itoigawa\,\ Niigata",
"812573", "Kashiwazaki\,\ Niigata",
"818958", "Misho\,\ Ehime",
"811235", "Yubari\,\ Hokkaido",
"81276", "Ota\,\ Gunma",
"811542", "Kushiro\,\ Hokkaido",
"81896", "Iyomishima\,\ Ehime",
"817454", "Yamatotakada\,\ Nara",
"812994", "Ishioka\,\ Ibaraki",
"812489", "Sukagawa\,\ Fukushima",
"81537", "Kakegawa\,\ Shizuoka",
"811528", "Bihoro\,\ Hokkaido",
"81596", "Ise\,\ Mie",
"8198296", "Hyuga\,\ Miyazaki",
"81167", "Furano\,\ Hokkaido",
"812582", "Nagaoka\,\ Niigata",
"81734", "Wakayama\,\ Wakayama",
"818298", "Hatsukaichi\,\ Hiroshima",
"812234", "Sendai\,\ Miyagi",
"812652", "Iida\,\ Nagano",
"815958", "Kameyama\,\ Mie",
"811645", "Rumoi\,\ Hokkaido",
"812613", "Omachi\,\ Nagano",
"811554", "Obihiro\,\ Hokkaido",
"819967", "Izumi\,\ Kagoshima",
"817965", "Toyooka\,\ Hyogo",
"817353", "Shingu\,\ Fukuoka",
"81587", "Ichinomiya\,\ Aichi",
"819934", "Ibusuki\,\ Kagoshima",
"8186553", "Kurashiki\,\ Okayama",
"812242", "Shiroishi\,\ Miyagi",
"81144", "Tomakomai\,\ Hokkaido",
"818654", "Kamogata\,\ Okayama",
"818545", "Kisuki\,\ Shimane",
"812792", "Shibukawa\,\ Gunma",
"818584", "Kurayoshi\,\ Tottori",
"812963", "Shimodate\,\ Ibaraki",
"811367", "Suttsu\,\ Hokkaido",
"811977", "Kitakami\,\ Iwate",
"819785", "Bungotakada\,\ Oita",
"812373", "Murayama\,\ Yamagata",
"817615", "Komatsu\,\ Ishikawa",
"819744", "Mie\,\ Oita",
"818244", "Miyoshi\,\ Hiroshima",
"818879", "Muroto\,\ Kochi",
"814758", "Togane\,\ Chiba",
"817672", "Hakui\,\ Ishikawa",
"812873", "Otawara\,\ Tochigi",
"8126172", "Omachi\,\ Nagano",
"819732", "Hita\,\ Oita",
"81561", "Seto\,\ Aichi",
"811867", "Takanosu\,\ Akita",
"812855", "Oyama\,\ Tochigi",
"81476", "Narita\,\ Chiba",
"81857", "Tottori\,\ Tottori",
"811453", "Hayakita\,\ Hokkaido",
"81557", "Ito\,\ Shizuoka",
"811854", "Oga\,\ Akita",
"81550", "Gotenba\,\ Shizuoka",
"812474", "Ishikawa\,\ Fukushima",
"8125487", "Tsugawa\,\ Niigata",
"812382", "Yonezawa\,\ Yamagata",
"812835", "Sano\,\ Tochigi",
"8124196", "Yanaizu\,\ Fukushima",
"817683", "Wajima\,\ Ishikawa",
"812698", "Iiyama\,\ Nagano",
"819577", "Shimabara\,\ Nagasaki",
"815992", "Toba\,\ Mie",
"811354", "Yoichi\,\ Hokkaido",
"815584", "Shimoda\,\ Shizuoka",
"8126174", "Omachi\,\ Nagano",
"81728", "Neyagawa\,\ Osaka",
"815763", "Gero\,\ Gifu",
"818667", "Ibara\,\ Okayama",
"817968", "Hamasaka\,\ Hyogo",
"818464", "Takehara\,\ Hiroshima",
"812782", "Numata\,\ Gunma",
"8125481", "Murakami\,\ Niigata",
"818594", "Yonago\,\ Tottori",
"818660", "Seto\,\ Okayama",
"819976", "Naze\,\ Kagoshima",
"8112398", "Kuriyama\,\ Hokkaido",
"819598", "Fukue\,\ Nagasaki",
"812677", "Saku\,\ Nagano",
"817943", "Kakogawa\,\ Hyogo",
"811525", "Abashiri\,\ Hokkaido",
"811754", "Mutsu\,\ Aomori",
"817476", "Shimonoseki\,\ Yamaguchi",
"81126", "Iwamizawa\,\ Hokkaido",
"815973", "Owase\,\ Mie",
"818295", "Hatsukaichi\,\ Hiroshima",
"815363", "Shinshiro\,\ Aichi",
"818363", "Ube\,\ Yamaguchi",
"818955", "Uwajima\,\ Ehime",
"811238", "Kuriyama\,\ Hokkaido",
"811734", "Goshogawara\,\ Aomori",
"818973", "Niihama\,\ Ehime",
"8199345", "Kagoshima\,\ Kagoshima",
"81486", "Urawa\,\ Saitama",
"81542", "Shizuoka\,\ Shizuoka",
"8153978", "Hamamatsu\,\ Shizuoka",
"817914", "Aioi\,\ Hyogo",
"81249", "Koriyama\,\ Fukushima",
"812892", "Utsunomiya\,\ Tochigi",
"81729", "Yao\,\ Osaka",
"81793", "Himeji\,\ Hyogo",
"815982", "Matsusaka\,\ Mie",
"81436", "Ichihara\,\ Chiba",
"8186996", "Seto\,\ Okayama",
"818952", "Uwajima\,\ Ehime",
"818376", "Mine\,\ Yamaguchi",
"811548", "Teshikaga\,\ Hokkaido",
"81798", "Nishinomiya\,\ Hyogo",
"818694", "Okayama\,\ Okayama",
"814700", "Kamogawa\,\ Chiba",
"81177", "Aomori\,\ Aomori",
"818490", "Onomichi\,\ Hiroshima",
"814770", "Ichikawa\,\ Chiba",
"811563", "Honbetsu\,\ Hokkaido",
"812895", "Utsunomiya\,\ Tochigi",
"812577", "Muika\,\ Niigata",
"817904", "Fukusaki\,\ Hyogo",
"818806", "Sukumo\,\ Kochi",
"8186691", "Kurashiki\,\ Okayama",
"818478", "Tojo\,\ Hiroshima",
"814798", "Yokaichiba\,\ Chiba",
"81948", "Iizuka\,\ Fukuoka",
"815985", "Matsusaka\,\ Mie",
"8178", "Kobe\,\ Hyogo",
"818944", "Yawatahama\,\ Ehime",
"812744", "Fujioka\,\ Gunma",
"812785", "Numata\,\ Gunma",
"819963", "Satsumasendai\,\ Kagoshima",
"8182941", "Hiroshima\,\ Hiroshima",
"812248", "Ogawara\,\ Miyagi",
"817357", "Kushimoto\,\ Wakayama",
"8147955", "Yokaichiba\,\ Chiba",
"811522", "Shari\,\ Hokkaido",
"81266", "Suwa\,\ Nagano",
"819948", "Shibushi\,\ Kagoshima",
"817463", "Yoshino\,\ Nara",
"812588", "Nagaoka\,\ Niigata",
"811394", "Matsumae\,\ Hokkaido",
"818292", "Hiroshima\,\ Hiroshima",
"812658", "Ina\,\ Nagano",
"819803", "Nago\,\ Okinawa",
"818684", "Tsuyama\,\ Okayama",
"818554", "Hamada\,\ Shimane",
"812385", "Yonezawa\,\ Yamagata",
"81420", "Tokorozawa\,\ Saitama",
"81427", "Sagamihara\,\ Kanagawa",
"81723", "Sakai\,\ Osaka",
"812832", "Sano\,\ Tochigi",
"81243", "Nihonmatsu\,\ Fukushima",
"819979", "Tokunoshima\,\ Kagoshima",
"811938", "Miyako\,\ Iwate",
"814284", "Tachikawa\,\ Tokyo",
"815995", "Ago\,\ Mie",
"81956", "Sasebo\,\ Nagasaki",
"818203", "Yanai\,\ Yamaguchi",
"81949", "Nogata\,\ Fukuoka",
"817718", "Sonobe\,\ Kyoto",
"819688", "Tamana\,\ Kumamoto",
"81551", "Nirasaki\,\ Yamanashi",
"819558", "Karatsu\,\ Saga",
"812414", "Yanaizu\,\ Fukushima",
"811958", "Iwate\,\ Iwate",
"818542", "Yasugi\,\ Shimane",
"812795", "Shibukawa\,\ Gunma",
"81567", "Tsushima\,\ Aichi",
"81196", "Morioka\,\ Iwate",
"819782", "Bungotakada\,\ Oita",
"817612", "Komatsu\,\ Ishikawa",
"81764", "Toyama\,\ Toyama",
"817675", "Nanao\,\ Ishikawa",
"818567", "Tsuwano\,\ Shimane",
"8186697", "Kurashiki\,\ Okayama",
"814777", "Funabashi\,\ Chiba",
"81725", "Izumi\,\ Osaka",
"817737", "Maizuru\,\ Kyoto",
"819735", "Hita\,\ Oita",
"812852", "Oyama\,\ Tochigi",
"81245", "Fukushima\,\ Fukushima",
"812565", "Sanjo\,\ Niigata",
"819964", "Satsumasendai\,\ Kagoshima",
"818476", "Fuchu\,\ Hiroshima",
"814796", "Yokaichiba\,\ Chiba",
"812743", "Fujioka\,\ Gunma",
"8153967", "Hamamatsu\,\ Shizuoka",
"818808", "Tosashimizu\,\ Kochi",
"81988", "Naha\,\ Okinawa",
"81742", "Nara\,\ Nara",
"819937", "Kaseda\,\ Kagoshima",
"81222", "Sendai\,\ Miyagi",
"818943", "Yawatahama\,\ Ehime",
"819804", "Nago\,\ Okinawa",
"81494", "Chichibu\,\ Saitama",
"817464", "Yoshino\,\ Nara",
"812997", "Itako\,\ Ibaraki",
"811393", "Matsumae\,\ Hokkaido",
"811546", "Kushiro\,\ Hokkaido",
"819435", "Yame\,\ Fukuoka",
"81992", "Kagoshima\,\ Kagoshima",
"812237", "Sendai\,\ Miyagi",
"818378", "Shimonoseki\,\ Yamaguchi",
"818797", "Tonosho\,\ Kagawa",
"81938", "Kitakyushu\,\ Fukuoka",
"81593", "Yokkaichi\,\ Mie",
"81893", "Ozu\,\ Ehime",
"818693", "Oku\,\ Okayama",
"812656", "Ina\,\ Nagano",
"819946", "Kanoya\,\ Kagoshima",
"812586", "Nagaoka\,\ Niigata",
"817457", "Yamatotakada\,\ Nara",
"81273", "Takasaki\,\ Gunma",
"8198297", "Hyuga\,\ Miyazaki",
"81979", "Nakatsu\,\ Oita",
"812246", "Ogawara\,\ Miyagi",
"811537", "Nakashibetsu\,\ Hokkaido",
"818387", "Tamagawa\,\ Yamaguchi",
"812647", "Nagano\,\ Nagano",
"8188098", "Tosashimizu\,\ Kochi",
"817903", "Fukusaki\,\ Hyogo",
"817955", "Sanda\,\ Hyogo",
"819957", "Kajiki\,\ Kagoshima",
"811564", "Kamishihoro\,\ Hokkaido",
"819556", "Karatsu\,\ Saga",
"817716", "Sonobe\,\ Kyoto",
"8198291", "Nobeoka\,\ Miyazaki",
"81989", "Naha\,\ Okinawa",
"819686", "Tamana\,\ Kumamoto",
"81233", "Shinjo\,\ Yamagata",
"81554", "Otsuki\,\ Yamanashi",
"812640", "Nagano\,\ Nagano",
"819599", "Oseto\,\ Nagasaki",
"812485", "Shirakawa\,\ Fukushima",
"811936", "Miyako\,\ Iwate",
"817992", "Sumoto\,\ Hyogo",
"81939", "Kitakyushu\,\ Fukuoka",
"819547", "Kashima\,\ Saga",
"817969", "Hamasaka\,\ Hyogo",
"81828", "Hiroshima\,\ Hiroshima",
"819665", "Hitoyoshi\,\ Kumamoto",
"811947", "Kuji\,\ Iwate",
"812559", "Yasuzuka\,\ Niigata",
"818553", "Hamada\,\ Shimane",
"818683", "Tsuyama\,\ Okayama",
"812230", "Sendai\,\ Miyagi",
"81468", "Yokosuka\,\ Kanagawa",
"812413", "Kitakata\,\ Fukushima",
"818512", "Nishigo\,\ Fukushima",
"81235", "Tsuruoka\,\ Yamagata",
"817722", "Miyazu\,\ Kyoto",
"818204", "Yanai\,\ Yamaguchi",
"811372", "Shikabe\,\ Hokkaido",
"814283", "Ome\,\ Tokyo",
"818397", "Ogori\,\ Yamaguchi",
"811956", "Iwate\,\ Iwate",
"819662", "Hitoyoshi\,\ Kumamoto",
"81463", "Hiratsuka\,\ Kanagawa",
"81134", "Otaru\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"8126178", "Omachi\,\ Nagano",
"81572", "Tajimi\,\ Gifu",
"814756", "Togane\,\ Chiba",
"812473", "Ishikawa\,\ Fukushima",
"811875", "Kakunodate\,\ Akita",
"81564", "Okazaki\,\ Aichi",
"811853", "Oga\,\ Akita",
"815764", "Gero\,\ Gifu",
"81184", "Yurihonjo\,\ Akita",
"81823", "Kure\,\ Hiroshima",
"815583", "Shimoda\,\ Shizuoka",
"819727", "Usuki\,\ Oita",
"811549", "Kushiro\,\ Hokkaido",
"812957", "Daigo\,\ Ibaraki",
"811353", "Yoichi\,\ Hokkaido",
"817725", "Miyazu\,\ Kyoto",
"817684", "Wajima\,\ Ishikawa",
"81899", "Matsuyama\,\ Ehime",
"815737", "Nakatsugawa\,\ Gifu",
"811375", "Yakumo\,\ Hokkaido",
"81825", "Hiroshima\,\ Hiroshima",
"812659", "Ina\,\ Nagano",
"812374", "Murayama\,\ Yamagata",
"819743", "Mie\,\ Oita",
"812964", "Shimodate\,\ Ibaraki",
"812589", "Nagaoka\,\ Niigata",
"817497", "Nagahama\,\ Shiga",
"818675", "Kuse\,\ Okayama",
"812937", "Mito\,\ Ibaraki",
"81922", "Fukuoka\,\ Fukuoka",
"818583", "Kurayoshi\,\ Tottori",
"811333", "Tobetsu\,\ Hokkaido",
"81288", "Imabari\,\ Ehime",
"812696", "Iiyama\,\ Nagano",
"812482", "Shirakawa\,\ Fukushima",
"8183768", "Shimonoseki\,\ Yamaguchi",
"817995", "Sumoto\,\ Hyogo",
"811454", "Mukawa\,\ Hokkaido",
"81864", "Kurashiki\,\ Okayama",
"81465", "Odawara\,\ Kanagawa",
"812874", "Otawara\,\ Tochigi",
"815746", "Minokamo\,\ Gifu",
"814281", "Sagamihara\,\ Kanagawa",
"81975", "Oita\,\ Oita",
"81292", "Mito\,\ Ibaraki",
"817706", "Obama\,\ Fukui",
"811986", "Tono\,\ Iwate",
"818243", "Higashi\-ku\,\ Hiroshima",
"811587", "Nakayubetsu\,\ Hokkaido",
"818974", "Niihama\,\ Ehime",
"811733", "Goshogawara\,\ Aomori",
"81985", "Miyazaki\,\ Miyazaki",
"819596", "Fukue\,\ Nagasaki",
"818364", "Ube\,\ Yamaguchi",
"8112392", "Yubari\,\ Hokkaido",
"811939", "Miyako\,\ Iwate",
"81898", "Imabari\,\ Ehime",
"819978", "Tokunoshima\,\ Kagoshima",
"8111", "Sapporo\,\ Hokkaido",
"81832", "Shimonoseki\,\ Yamaguchi",
"8186993", "Bizen\,\ Okayama",
"811646", "Haboro\,\ Hokkaido",
"817952", "Nishiwaki\,\ Hyogo",
"812930", "Mito\,\ Ibaraki",
"81935", "Kitakyushu\,\ Fukuoka",
"812562", "Sanjo\,\ Niigata",
"81162", "Wakkanai\,\ Hokkaido",
"818463", "Takehara\,\ Hiroshima",
"818593", "Yonago\,\ Tottori",
"812556", "Itoigawa\,\ Niigata",
"81174", "Kanita\,\ Aomori",
"817487", "Minakuchi\,\ Shiga",
"81532", "Toyohashi\,\ Aichi",
"819827", "Takachiho\,\ Miyazaki",
"8112394", "Yubari\,\ Hokkaido",
"81933", "Kitakyushu\,\ Fukuoka",
"8153972", "Hamamatsu\,\ Shizuoka",
"814291", "Hanno\,\ Saitama",
"815974", "Owase\,\ Mie",
"811753", "Mutsu\,\ Aomori",
"819432", "Yame\,\ Fukuoka",
"81983", "Takanabe\,\ Miyazaki",
"81582", "Gifu\,\ Gifu",
"817944", "Kakogawa\,\ Hyogo",
"811236", "Chitose\,\ Hokkaido",
"812547", "Murakami\,\ Niigata",
"812836", "Sano\,\ Tochigi",
"817998", "Tsuna\,\ Hyogo",
"819543", "Takeo\,\ Saga",
"812789", "Maebashi\,\ Gunma",
"817734", "Fukuchiyama\,\ Kyoto",
"817238", "Neyagawa\,\ Osaka",
"814704", "Tateyama\,\ Chiba",
"818564", "Masuda\,\ Shimane",
"818690", "Okayama\,\ Okayama",
"81478", "Sawara\,\ Chiba",
"81852", "Matsue\,\ Shimane",
"818678", "Niimi\,\ Okayama",
"815393", "Hamamatsu\,\ Shizuoka",
"819786", "Kitsuki\,\ Oita",
"817616", "Komatsu\,\ Ishikawa",
"814287", "Ome\,\ Tokyo",
"81552", "Kofu\,\ Yamanashi",
"818546", "Kakeya\,\ Shimane",
"811378", "Imakane\,\ Hokkaido",
"81489", "Soka\,\ Saitama",
"818893", "Sakawa\,\ Kochi",
"812856", "Mooka\,\ Tochigi",
"818557", "Kawamoto\,\ Shimane",
"81246", "Iwaki\,\ Fukushima",
"81726", "Ibaraki\,\ Osaka",
"81259", "Sado\,\ Niigata",
"818687", "Mimasaka\,\ Okayama",
"81439", "Kisarazu\,\ Chiba",
"811878", "Omagari\,\ Akita",
"811943", "Iwaizumi\,\ Iwate",
"812899", "Kanuma\,\ Tochigi",
"812233", "Iwanuma\,\ Miyagi",
"818680", "Okayama\,\ Okayama",
"8126179", "Omachi\,\ Nagano",
"812799", "Naganohara\,\ Gunma",
"8198293", "Nobeoka\,\ Miyazaki",
"818372", "Nagato\,\ Yamaguchi",
"81263", "Matsumoto\,\ Nagano",
"818956", "Uwajima\,\ Ehime",
"811397", "Okushiri\,\ Hokkaido",
"812993", "Ishioka\,\ Ibaraki",
"814280", "Tachikawa\,\ Tokyo",
"818947", "Uwajima\,\ Ehime",
"81969", "Amakusa\,\ Kumamoto",
"819933", "Ibusuki\,\ Kagoshima",
"8169", "Osaka\,\ Osaka",
"817354", "Shingu\,\ Fukuoka",
"818872", "Muroto\,\ Kochi",
"811553", "Obihiro\,\ Hokkaido",
"812614", "Omachi\,\ Nagano",
"812747", "Tomioka\,\ Gunma",
"812574", "Kashiwazaki\,\ Niigata",
"819975", "Naze\,\ Kagoshima",
"81488", "Urawa\,\ Saitama",
"812389", "Yonezawa\,\ Yamagata",
"81547", "Shimada\,\ Shizuoka",
"817367", "Iwade\,\ Wakayama",
"819953", "Okuchi\,\ Kagoshima",
"818383", "Hagi\,\ Yamaguchi",
"811533", "Nemuro\,\ Hokkaido",
"814297", "Hanno\,\ Saitama",
"81744", "Yamatotakada\,\ Nara",
"817453", "Yamatotakada\,\ Nara",
"818296", "Hiroshima\,\ Hiroshima",
"81492", "Kawagoe\,\ Saitama",
"817475", "Shimonoseki\,\ Yamaguchi",
"81438", "Kisarazu\,\ Chiba",
"811526", "Abashiri\,\ Hokkaido",
"818697", "Bizen\,\ Okayama",
"815999", "Tsu\,\ Mie",
"812839", "Sano\,\ Tochigi",
"81737", "Yuasa\,\ Wakayama",
"81172", "Hirosaki\,\ Aomori",
"81433", "Chiba\,\ Chiba",
"812786", "Numata\,\ Gunma",
"81534", "Hamamatsu\,\ Shizuoka",
"81253", "Niigata\,\ Niigata",
"818833", "Kamojima\,\ Tokushima",
"818240", "Higashi\-ku\,\ Hiroshima",
"81946", "Amagi\,\ Fukuoka",
"81125", "Takikawa\,\ Hokkaido",
"811583", "Monbetsu\,\ Hokkaido",
"81584", "Ogaki\,\ Gifu",
"811653", "Shibetsu\,\ Hokkaido",
"819789", "Kitsuki\,\ Oita",
"81485", "Kumagaya\,\ Saitama",
"811757", "Noheji\,\ Aomori",
"812674", "Komoro\,\ Nagano",
"812543", "Shibata\,\ Niigata",
"819438", "Tanushimaru\,\ Fukuoka",
"818375", "Mine\,\ Yamaguchi",
"81199", "Morioka\,\ Iwate",
"812859", "Oyama\,\ Tochigi",
"817483", "Yokaichi\,\ Shiga",
"815986", "Matsusaka\,\ Mie",
"81834", "Tokuyama\,\ Yamaguchi",
"819823", "Nobeoka\,\ Miyazaki",
"8186997", "Seto\,\ Okayama",
"812896", "Kanuma\,\ Tochigi",
"81268", "Ueda\,\ Nagano",
"818467", "Mima\,\ Tokushima",
"819723", "Saiki\,\ Oita",
"811357", "Iwanai\,\ Hokkaido",
"815733", "Ena\,\ Gifu",
"819574", "Isahaya\,\ Nagasaki",
"818664", "Takahashi\,\ Okayama",
"81924", "Fukuoka\,\ Fukuoka",
"812796", "Shibukawa\,\ Gunma",
"8125480", "Murakami\,\ Niigata",
"81862", "Okayama\,\ Okayama",
"819668", "Minamata\,\ Kumamoto",
"812477", "Miharu\,\ Fukushima",
"811857", "Noshiro\,\ Akita",
"811463", "Urakawa\,\ Hokkaido",
"817676", "Nanao\,\ Ishikawa",
"81965", "Yatsushiro\,\ Kumamoto",
"8153975", "Hamamatsu\,\ Shizuoka",
"81958", "Nagasaki\,\ Nagasaki",
"81294", "Hitachiota\,\ Ibaraki",
"818391", "Ogori\,\ Yamaguchi",
"8112395", "Kuriyama\,\ Hokkaido",
"81473", "Ichikawa\,\ Chiba",
"812386", "Nagai\,\ Yamagata",
"818247", "Shobara\,\ Hiroshima",
"819233", "Maebaru\,\ Fukuoka",
"8125486", "Tsugawa\,\ Niigata",
"8162", "Osaka\,\ Osaka",
"811864", "Odate\,\ Akita",
"81963", "Kumamoto\,\ Kumamoto",
"8124197", "Yanaizu\,\ Fukushima",
"812933", "Takahagi\,\ Ibaraki",
"818587", "Koge\,\ Tottori",
"811337", "Ishikari\,\ Hokkaido",
"818299", "Hiroshima\,\ Hiroshima",
"815959", "Kameyama\,\ Mie",
"81182", "Yokote\,\ Akita",
"815753", "Sekigahara\,\ Gifu",
"818657", "Kasaoka\,\ Okayama",
"8188099", "Tosashimizu\,\ Kochi",
"818262", "Kake\,\ Hiroshima",
"819747", "Taketa\,\ Oita",
"811974", "Mizusawa\,\ Iwate",
"812488", "Sukagawa\,\ Fukushima",
"817493", "Hikone\,\ Shiga",
"811364", "Kutchan\,\ Hokkaido",
"815996", "Ago\,\ Mie",
"81426", "Hachioji\,\ Tokyo",
"819232", "Maebaru\,\ Fukuoka",
"818248", "Shobara\,\ Hiroshima",
"814754", "Mobara\,\ Chiba",
"81739", "Tanabe\,\ Wakayama",
"815752", "Sekigahara\,\ Gifu",
"812487", "Sukagawa\,\ Fukushima",
"819809", "Yaeyama\ District\,\ Okinawa",
"812932", "Takahagi\,\ Ibaraki",
"815766", "Gero\,\ Gifu",
"817950", "Sanda\,\ Hyogo",
"817492", "Hikone\,\ Shiga",
"817686", "Noto\,\ Ishikawa",
"8147957", "Yokaichiba\,\ Chiba",
"818263", "Kake\,\ Hiroshima",
"81950", "Hirado\,\ Nagasaki",
"815395", "Hamamatsu\,\ Shizuoka",
"818588", "Koge\,\ Tottori",
"815732", "Ena\,\ Gifu",
"81778", "Takefu\,\ Fukui",
"812376", "Sagae\,\ Yamagata",
"819722", "Saiki\,\ Oita",
"812694", "Nakano\,\ Nagano",
"812560", "Itoigawa\,\ Niigata",
"81471", "Kashiwa\,\ Chiba",
"81566", "Kariya\,\ Aichi",
"812876", "Kuroiso\,\ Tochigi",
"815744", "Minokamo\,\ Gifu",
"811462", "Urakawa\,\ Hokkaido",
"818895", "Susaki\,\ Kochi",
"814998", "Ogasawara\,\ Tokyo",
"811945", "Kuji\,\ Iwate",
"817704", "Tsuruga\,\ Fukui",
"811858", "Noshiro\,\ Akita",
"812913", "Hokota\,\ Ibaraki",
"811984", "Hanamaki\,\ Iwate",
"812478", "Miharu\,\ Fukushima",
"819667", "Minamata\,\ Kumamoto",
"812542", "Shibata\,\ Niigata",
"81738", "Gobo\,\ Wakayama",
"81792", "Himeji\,\ Hyogo",
"819437", "Tanushimaru\,\ Fukuoka",
"81176", "Towada\,\ Aomori",
"812235", "Sendai\,\ Miyagi",
"818366", "Ube\,\ Yamaguchi",
"812995", "Ishioka\,\ Ibaraki",
"811632", "Teshio\,\ Hokkaido",
"818976", "Niihama\,\ Ehime",
"819822", "Nobeoka\,\ Miyazaki",
"819935", "Kaseda\,\ Kagoshima",
"81942", "Kurume\,\ Fukuoka",
"817482", "Yokaichi\,\ Shiga",
"81543", "Shizuoka\,\ Shizuoka",
"81845", "Innoshima\,\ Hiroshima",
"811644", "Rumoi\,\ Hokkaido",
"817964", "Toyooka\,\ Hyogo",
"811555", "Obihiro\,\ Hokkaido",
"819955", "Kajiki\,\ Kagoshima",
"812554", "Joetsu\,\ Niigata",
"81545", "Fuji\,\ Shizuoka",
"818832", "Kamojima\,\ Tokushima",
"818385", "Hagi\,\ Yamaguchi",
"811535", "Akkeshi\,\ Hokkaido",
"81779", "Ono\,\ Gifu",
"817455", "Yamatotakada\,\ Nara",
"815366", "Shitara\,\ Aichi",
"818844", "Anan\,\ Tokushima",
"811234", "Chitose\,\ Hokkaido",
"817946", "Miki\,\ Hyogo",
"811652", "Shibetsu\,\ Hokkaido",
"811582", "Monbetsu\,\ Hokkaido",
"81260", "Anan\,\ Nagano",
"818474", "Fuchu\,\ Hiroshima",
"814794", "Choshi\,\ Chiba",
"819952", "Okuchi\,\ Kagoshima",
"814298", "Hanno\,\ Saitama",
"819966", "Izumi\,\ Kagoshima",
"8112396", "Kuriyama\,\ Hokkaido",
"817368", "Iwade\,\ Wakayama",
"818835", "Mima\,\ Tokushima",
"811532", "Nemuro\,\ Hokkaido",
"818382", "Hagi\,\ Yamaguchi",
"8125485", "Tsugawa\,\ Niigata",
"817466", "Totsukawa\,\ Nara",
"818698", "Bizen\,\ Okayama",
"817452", "Yamatotakada\,\ Nara",
"815769", "Shokawa\,\ Gifu",
"817230", "Neyagawa\,\ Osaka",
"81848", "Onomichi\,\ Hiroshima",
"811655", "Nayoro\,\ Hokkaido",
"8153970", "Hamamatsu\,\ Shizuoka",
"811585", "Engaru\,\ Hokkaido",
"811544", "Kushiro\,\ Hokkaido",
"81480", "Kuki\,\ Saitama",
"819944", "Kanoya\,\ Kagoshima",
"812545", "Murakami\,\ Niigata",
"812584", "Nagaoka\,\ Niigata",
"8112390", "Yubari\,\ Hokkaido",
"811398", "Kumaishi\,\ Hokkaido",
"81487", "Urawa\,\ Saitama",
"812232", "Iwanuma\,\ Miyagi",
"812654", "Iida\,\ Nagano",
"81548", "Haibara\,\ Shizuoka",
"8186998", "Seto\,\ Okayama",
"812992", "Ishioka\,\ Ibaraki",
"818373", "Nagato\,\ Yamaguchi",
"811635", "Hamatonbetsu\,\ Hokkaido",
"812748", "Tomioka\,\ Gunma",
"812879", "Nasukarasuyama\,\ Tochigi",
"819932", "Ibusuki\,\ Kagoshima",
"819825", "Hyuga\,\ Miyazaki",
"817485", "Yokaichi\,\ Shiga",
"8153976", "Hamamatsu\,\ Shizuoka",
"812244", "Shiroishi\,\ Miyagi",
"81250", "Niitsu\,\ Niigata",
"818948", "Uwajima\,\ Ehime",
"818873", "Aki\,\ Kochi",
"811552", "Obihiro\,\ Hokkaido",
"815735", "Ena\,\ Gifu",
"811377", "Yakumo\,\ Hokkaido",
"817714", "Kameoka\,\ Kyoto",
"819684", "Yamaga\,\ Kumamoto",
"819725", "Saiki\,\ Oita",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"819554", "Imari\,\ Saga",
"818369", "Ube\,\ Yamaguchi",
"814288", "Ome\,\ Tokyo",
"811934", "Kamaishi\,\ Iwate",
"8199347", "Kagoshima\,\ Kagoshima",
"811465", "Shizunai\,\ Hokkaido",
"8153969", "Hamamatsu\,\ Shizuoka",
"811877", "Omagari\,\ Akita",
"818892", "Sakawa\,\ Kochi",
"81849", "Fukuyama\,\ Hiroshima",
"818688", "Mimasaka\,\ Okayama",
"81191", "Ichinoseki\,\ Iwate",
"811942", "Iwaizumi\,\ Iwate",
"818558", "Kawamoto\,\ Shimane",
"81775", "Otsu\,\ Shiga",
"819542", "Takeo\,\ Saga",
"81549", "Shizuoka\,\ Shizuoka",
"817997", "Tsuna\,\ Hyogo",
"815755", "Sekigahara\,\ Gifu",
"815979", "Kumano\,\ Mie",
"81242", "Aizuwakamatsu\,\ Fukushima",
"812935", "Mito\,\ Ibaraki",
"81722", "Sakai\,\ Osaka",
"818677", "Niimi\,\ Okayama",
"817495", "Nagahama\,\ Shiga",
"811954", "Ninohe\,\ Iwate",
"8126173", "Omachi\,\ Nagano",
"817949", "Kakogawa\,\ Hyogo",
"812911", "Hokota\,\ Ibaraki",
"8198299", "Hyuga\,\ Miyazaki",
"818206", "Yanai\,\ Yamaguchi",
"815392", "Hamamatsu\,\ Shizuoka",
"818462", "Takehara\,\ Hiroshima",
"81886", "Tokushima\,\ Tokushima",
"812745", "Fujioka\,\ Gunma",
"812784", "Numata\,\ Gunma",
"819828", "Takachiho\,\ Miyazaki",
"818592", "Yonago\,\ Tottori",
"817488", "Minakuchi\,\ Shiga",
"819679", "Takamori\,\ Kumamoto",
"8144", "Kawasaki\,\ Kanagawa",
"812563", "Sanjo\,\ Niigata",
"818945", "Yawatahama\,\ Ehime",
"814709", "Kamogawa\,\ Chiba",
"811395", "Esashi\,\ Hokkaido",
"8186552", "Kurashiki\,\ Okayama",
"81270", "Isesaki\,\ Gunma",
"81277", "Kiryu\,\ Gunma",
"8153968", "Hamamatsu\,\ Shizuoka",
"811752", "Mutsu\,\ Aomori",
"819433", "Yame\,\ Fukuoka",
"8164", "Osaka\,\ Osaka",
"812676", "Saku\,\ Nagano",
"81166", "Asahikawa\,\ Hokkaido",
"8188097", "Tosashimizu\,\ Kochi",
"818695", "Seto\,\ Okayama",
"817912", "Aioi\,\ Hyogo",
"811658", "Kamikawa\,\ Hokkaido",
"811732", "Goshogawara\,\ Aomori",
"811588", "Okoppe\,\ Hokkaido",
"8198298", "Hyuga\,\ Miyazaki",
"81944", "Setaka\,\ Fukuoka",
"815984", "Matsusaka\,\ Mie",
"817953", "Nishiwaki\,\ Hyogo",
"812894", "Utsunomiya\,\ Tochigi",
"819977", "Setouchi\,\ Kagoshima",
"81586", "Ichinomiya\,\ Aichi",
"817905", "Fukusaki\,\ Hyogo",
"819576", "Shimabara\,\ Nagasaki",
"8182942", "Hiroshima\,\ Hiroshima",
"812938", "Mito\,\ Ibaraki",
"819742", "Mie\,\ Oita",
"817498", "Nagahama\,\ Shiga",
"818652", "Kurashiki\,\ Okayama",
"812483", "Shirakawa\,\ Fukushima",
"818666", "Ibara\,\ Okayama",
"812794", "Shibukawa\,\ Gunma",
"818582", "Kurayoshi\,\ Tottori",
"811332", "Tobetsu\,\ Hokkaido",
"819734", "Hita\,\ Oita",
"818242", "Higashi\-ku\,\ Hiroshima",
"81143", "Muroran\,\ Hokkaido",
"812619", "Omachi\,\ Nagano",
"817674", "Hakui\,\ Ishikawa",
"812917", "Mito\,\ Ibaraki",
"812384", "Yonezawa\,\ Yamagata",
"819663", "Hitoyoshi\,\ Kumamoto",
"818685", "Tsuyama\,\ Okayama",
"8186999", "Seto\,\ Okayama",
"811852", "Oga\,\ Akita",
"81926", "Fukuoka\,\ Fukuoka",
"812472", "Ishikawa\,\ Fukushima",
"811866", "Takanosu\,\ Akita",
"818555", "Gotsu\,\ Shimane",
"81280", "Koga\,\ Ibaraki",
"815582", "Shimoda\,\ Shizuoka",
"815738", "Nakatsugawa\,\ Gifu",
"819728", "Usuki\,\ Oita",
"812415", "Yanaizu\,\ Fukushima",
"815994", "Ago\,\ Mie",
"814285", "Sagamihara\,\ Kanagawa",
"811366", "Suttsu\,\ Hokkaido",
"811976", "Kitakami\,\ Iwate",
"811352", "Yoichi\,\ Hokkaido",
"8125484", "Murakami\,\ Niigata",
"81765", "Uozu\,\ Toyama",
"812834", "Utsunomiya\,\ Tochigi",
"819676", "Takamori\,\ Kumamoto",
"818682", "Tsuyama\,\ Okayama",
"814776", "Funabashi\,\ Chiba",
"811855", "Noshiro\,\ Akita",
"812475", "Ishikawa\,\ Fukushima",
"818552", "Hamada\,\ Shimane",
"811873", "Kakunodate\,\ Akita",
"817736", "Maizuru\,\ Kyoto",
"818398", "Ogori\,\ Yamaguchi",
"815585", "Shimoda\,\ Shizuoka",
"81244", "Hobara\,\ Fukushima",
"81281", "Utsunomiya\,\ Tochigi",
"812412", "Kitakata\,\ Fukushima",
"814282", "Ome\,\ Tokyo",
"817723", "Miyazu\,\ Kyoto",
"812679", "Saku\,\ Nagano",
"81827", "Iwakuni\,\ Yamaguchi",
"8125482", "Murakami\,\ Niigata",
"819784", "Bungotakada\,\ Oita",
"817614", "Komatsu\,\ Ishikawa",
"8199343", "Kagoshima\,\ Kagoshima",
"818655", "Kamogata\,\ Okayama",
"818544", "Kisuki\,\ Shimane",
"818585", "Kurayoshi\,\ Tottori",
"815398", "Hamamatsu\,\ Shizuoka",
"81460", "Odawara\,\ Kanagawa",
"81467", "Fujisawa\,\ Kanagawa",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81763", "Fukuno\,\ Toyama",
"817993", "Sumoto\,\ Hyogo",
"815566", "Minobu\,\ Yamanashi",
"812854", "Oyama\,\ Tochigi",
"818245", "Miyoshi\,\ Hiroshima",
"81977", "Beppu\,\ Oita",
"818692", "Oku\,\ Okayama",
"817915", "Aioi\,\ Hyogo",
"818954", "Uwajima\,\ Ehime",
"81987", "Nichinan\,\ Miyazaki",
"81226", "Kesennuma\,\ Miyagi",
"818669", "Soja\,\ Okayama",
"811735", "Goshogawara\,\ Aomori",
"81591", "Tsu\,\ Mie",
"812648", "Nagano\,\ Nagano",
"812616", "Omachi\,\ Nagano",
"818388", "Tamagawa\,\ Yamaguchi",
"817356", "Kushimoto\,\ Wakayama",
"81930", "Yukuhashi\,\ Fukuoka",
"81937", "Kitakyushu\,\ Fukuoka",
"817902", "Fukusaki\,\ Hyogo",
"812742", "Fujioka\,\ Gunma",
"818595", "Yonago\,\ Tottori",
"819938", "Kaseda\,\ Kagoshima",
"818807", "Sukumo\,\ Kochi",
"812576", "Tokamachi\,\ Niigata",
"818942", "Yawatahama\,\ Ehime",
"811558", "Hiroo\,\ Hokkaido",
"811869", "Odate\,\ Akita",
"811392", "Kikonai\,\ Hokkaido",
"818798", "Tonosho\,\ Kagawa",
"818377", "Shimonoseki\,\ Yamaguchi",
"8126171", "Omachi\,\ Nagano",
"818294", "Hatsukaichi\,\ Hiroshima",
"812238", "Sendai\,\ Miyagi",
"812998", "Itako\,\ Ibaraki",
"811524", "Abashiri\,\ Hokkaido",
"818543", "Yasugi\,\ Shimane",
"818674", "Kuse\,\ Okayama",
"81179", "Sannohe\,\ Aomori",
"81284", "Ashikaga\,\ Tochigi",
"81721", "Tondabayashi\,\ Osaka",
"819783", "Bungotakada\,\ Oita",
"812375", "Murayama\,\ Yamagata",
"817613", "Komatsu\,\ Ishikawa",
"812549", "Tsugawa\,\ Niigata",
"811957", "Iwate\,\ Iwate",
"812965", "Shimodate\,\ Ibaraki",
"81553", "Yamanashi\,\ Yamanashi",
"81234", "Sakata\,\ Yamagata",
"817738", "Maizuru\,\ Kyoto",
"8186995", "Seto\,\ Okayama",
"811946", "Kuji\,\ Iwate",
"81952", "Saga\,\ Saga",
"818568", "Tsuwano\,\ Shimane",
"818896", "Susaki\,\ Kochi",
"817994", "Sumoto\,\ Hyogo",
"812853", "Oyama\,\ Tochigi",
"8153971", "Hamamatsu\,\ Shizuoka",
"811455", "Mukawa\,\ Hokkaido",
"812875", "Otawara\,\ Tochigi",
"812580", "Tokamachi\,\ Niigata",
"81555", "Fujiyoshida\,\ Yamanashi",
"819940", "Shibushi\,\ Kagoshima",
"811874", "Kakunodate\,\ Akita",
"8112391", "Yubari\,\ Hokkaido",
"81568", "Kasugai\,\ Aichi",
"812833", "Utsunomiya\,\ Tochigi",
"819546", "Kashima\,\ Saga",
"81776", "Fukui\,\ Fukui",
"81192", "Ofunato\,\ Iwate",
"81853", "Izumo\,\ Shimane",
"81138", "Hakodate\,\ Hokkaido",
"811589", "Okoppe\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",
"819557", "Karatsu\,\ Saga",
"818202", "Yanai\,\ Yamaguchi",
"817685", "Wajima\,\ Ishikawa",
"819687", "Tamana\,\ Kumamoto",
"817717", "Sonobe\,\ Kyoto",
"811374", "Mori\,\ Hokkaido",
"815765", "Gero\,\ Gifu",
"81188", "Akita\,\ Akita",
"818514", "Ama\,\ Shimane",
"811937", "Miyako\,\ Iwate",
"8125488", "Tsugawa\,\ Niigata",
"812247", "Ogawara\,\ Miyagi",
"811536", "Akkeshi\,\ Hokkaido",
"81594", "Kuwana\,\ Mie",
"812618", "Omachi\,\ Nagano",
"81429", "Tokorozawa\,\ Saitama",
"812646", "Nagano\,\ Nagano",
"81493", "Higashimatsuyama\,\ Saitama",
"819962", "Satsumasendai\,\ Kagoshima",
"8112397", "Kuriyama\,\ Hokkaido",
"81797", "Nishinomiya\,\ Hyogo",
"81178", "Hachinohe\,\ Aomori",
"819956", "Kajiki\,\ Kagoshima",
"811523", "Shari\,\ Hokkaido",
"812657", "Ina\,\ Nagano",
"812587", "Nagaoka\,\ Niigata",
"819947", "Shibushi\,\ Kagoshima",
"817945", "Kakogawa\,\ Hyogo",
"812939", "Mito\,\ Ibaraki",
"819802", "Minamidaito\,\ Okinawa",
"81940", "Munakata\,\ Fukuoka",
"817456", "Yamatotakada\,\ Nara",
"818293", "Hatsukaichi\,\ Hiroshima",
"81947", "Tagawa\,\ Fukuoka",
"818975", "Niihama\,\ Ehime",
"818953", "Uwajima\,\ Ehime",
"818365", "Ube\,\ Yamaguchi",
"812996", "Itako\,\ Ibaraki",
"811547", "Shiranuka\,\ Hokkaido",
"812236", "Sendai\,\ Miyagi",
"81569", "Handa\,\ Aichi",
"818796", "Tonosho\,\ Kagawa",
"811556", "Obihiro\,\ Hokkaido",
"811562", "Honbetsu\,\ Hokkaido",
"81262", "Nagano\,\ Nagano",
"814797", "Yokaichiba\,\ Chiba",
"818477", "Tojo\,\ Hiroshima",
"81495", "Honjo\,\ Saitama",
"812578", "Muika\,\ Niigata",
"819936", "Kaseda\,\ Kagoshima",
"818972", "Niihama\,\ Ehime",
"818362", "Ube\,\ Yamaguchi",
"811237", "Kuriyama\,\ Hokkaido",
"8198294", "Nobeoka\,\ Miyazaki",
"812546", "Murakami\,\ Niigata",
"8168", "Osaka\,\ Osaka",
"817954", "Nishiwaki\,\ Hyogo",
"812893", "Utsunomiya\,\ Tochigi",
"814220", "Kokubunji\,\ Tokyo",
"817486", "Minakuchi\,\ Shiga",
"8163", "Osaka\,\ Osaka",
"815983", "Matsusaka\,\ Mie",
"819826", "Hyuga\,\ Miyazaki",
"8153964", "Hamamatsu\,\ Shizuoka",
"81984", "Kobayashi\,\ Miyazaki",
"818836", "Mima\,\ Tokushima",
"819965", "Satsumasendai\,\ Kagoshima",
"812564", "Sanjo\,\ Niigata",
"81482", "Kawaguchi\,\ Saitama",
"81559", "Numazu\,\ Shizuoka",
"8198292", "Nobeoka\,\ Miyazaki",
"81546", "Shizuoka\,\ Shizuoka",
"812783", "Numata\,\ Gunma",
"811647", "Haboro\,\ Hokkaido",
"811586", "Nakayubetsu\,\ Hokkaido",
"819434", "Yame\,\ Fukuoka",
"81252", "Niigata\,\ Niigata",
"81934", "Kitakyushu\,\ Fukuoka",
"811656", "Bifuka\,\ Hokkaido",
"817942", "Kakogawa\,\ Hyogo",
"819805", "Nago\,\ Okinawa",
"815362", "Shinshiro\,\ Aichi",
"812678", "Saku\,\ Nagano",
"817465", "Yoshino\,\ Nara",
"819597", "Fukue\,\ Nagasaki",
"81432", "Chiba\,\ Chiba",
"815972", "Owase\,\ Mie",
"812649", "Nagano\,\ Nagano",
"819664", "Hitoyoshi\,\ Kumamoto",
"81183", "Yuzawa\,\ Akita",
"81425", "Tachikawa\,\ Tokyo",
"811987", "Tono\,\ Iwate",
"812383", "Yonezawa\,\ Yamagata",
"817707", "Obama\,\ Fukui",
"818668", "Ibara\,\ Okayama",
"81962", "Kumamoto\,\ Kumamoto",
"818205", "Yanai\,\ Yamaguchi",
"817496", "Nagahama\,\ Shiga",
"817682", "Wajima\,\ Ishikawa",
"81563", "Nishio\,\ Aichi",
"815993", "Toba\,\ Mie",
"81464", "Atsugi\,\ Kanagawa",
"815762", "Gero\,\ Gifu",
"812936", "Mito\,\ Ibaraki",
"819578", "Shimabara\,\ Nagasaki",
"812697", "Iiyama\,\ Nagano",
"812550", "Yasuzuka\,\ Niigata",
"811978", "Kitakami\,\ Iwate",
"8186698", "Kurashiki\,\ Okayama",
"812793", "Shibukawa\,\ Gunma",
"812484", "Shirakawa\,\ Fukushima",
"812999", "Itako\,\ Ibaraki",
"81565", "Toyota\,\ Aichi",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"819726", "Usuki\,\ Oita",
"812372", "Murayama\,\ Yamagata",
"81863", "Tamano\,\ Okayama",
"812239", "Sendai\,\ Miyagi",
"812962", "Shimodate\,\ Ibaraki",
"815736", "Nakatsugawa\,\ Gifu",
"817673", "Hakui\,\ Ishikawa",
"811559", "Obihiro\,\ Hokkaido",
"811868", "Takanosu\,\ Akita",
"8147950", "Yokaichiba\,\ Chiba",
"819733", "Hita\,\ Oita",
"8167", "Osaka\,\ Osaka",
"811452", "Hayakita\,\ Hokkaido",
"81423", "Kokubunji\,\ Tokyo",
"814757", "Togane\,\ Chiba",
"812872", "Otawara\,\ Tochigi",
"81727", "Ikeda\,\ Osaka",
"811466", "Erimo\,\ Hokkaido",
"818297", "Hatsukaichi\,\ Hiroshima",
"818374", "Nagato\,\ Yamaguchi",
"81225", "Ishinomaki\,\ Miyagi",
"812830", "Utsunomiya\,\ Tochigi",
"813", "Tokyo",
"812551", "Joetsu\,\ Niigata",
"819808", "Yaeyama\ District\,\ Okinawa",
"81888", "Kochi\,\ Kochi",
"812653", "Iida\,\ Nagano",
"818696", "Bizen\,\ Okayama",
"811527", "Bihoro\,\ Hokkaido",
"817468", "Kamikitayama\,\ Nara",
"819943", "Kanoya\,\ Kagoshima",
"812675", "Saku\,\ Nagano",
"8199331", "Kagoshima\,\ Kagoshima",
"812583", "Nagaoka\,\ Niigata",
"817352", "Shingu\,\ Fukuoka",
"818874", "Aki\,\ Kochi",
"81272", "Maebashi\,\ Gunma",
"8153973", "Hamamatsu\,\ Shizuoka",
"817366", "Iwade\,\ Wakayama",
"812612", "Omachi\,\ Nagano",
"818249", "Higashi\-ku\,\ Hiroshima",
"81892", "Kumakogen\,\ Ehime",
"812243", "Shiroishi\,\ Miyagi",
"8186994", "Seto\,\ Okayama",
"819968", "Izumi\,\ Kagoshima",
"81538", "Iwata\,\ Shizuoka",
"81592", "Tsu\,\ Mie",
"818946", "Uwajima\,\ Ehime",
"812572", "Kashiwazaki\,\ Niigata",
"814793", "Choshi\,\ Chiba",
"8112393", "Yubari\,\ Hokkaido",
"812746", "Tomioka\,\ Gunma",
"81929", "Fukuoka\,\ Fukuoka",
"811543", "Kushiro\,\ Hokkaido",
"81743", "Nara\,\ Nara",
"8186992", "Bizen\,\ Okayama",
"818957", "Misho\,\ Ehime",
"811396", "Esashi\,\ Hokkaido",
"81578", "Kamioka\,\ Akita",
"8145", "Yokohama\,\ Kanagawa",
"811865", "Odate\,\ Akita",
"812857", "Mooka\,\ Tochigi",
"817732", "Fukuchiyama\,\ Kyoto",
"818556", "Gotsu\,\ Shimane",
"818686", "Tsuyama\,\ Okayama",
"814772", "Ichikawa\,\ Chiba",
"814702", "Tateyama\,\ Chiba",
"818562", "Masuda\,\ Shimane",
"81766", "Takaoka\,\ Toyama",
"81839", "Yamaguchi\,\ Yamaguchi",
"817617", "Kaga\,\ Ishikawa",
"811975", "Mizusawa\,\ Iwate",
"819787", "Kunisaki\,\ Oita",
"811365", "Kutchan\,\ Hokkaido",
"811953", "Ninohe\,\ Iwate",
"814286", "Sagamihara\,\ Kanagawa",
"8165", "Osaka\,\ Osaka",
"818547", "Kakeya\,\ Shimane",
"812416", "Tajima\,\ Fukushima",
"8126176", "Omachi\,\ Nagano",
"8182920", "Hatsukaichi\,\ Hiroshima",
"818665", "Takahashi\,\ Okayama",
"81928", "Fukuoka\,\ Fukuoka",
"81282", "Tochigi\,\ Tochigi",
"811933", "Kamaishi\,\ Iwate",
"819553", "Imari\,\ Saga",
"819575", "Isahaya\,\ Nagasaki",
"817713", "Kameoka\,\ Kyoto",
"819683", "Yamaga\,\ Kumamoto",
"812837", "Sano\,\ Tochigi",
"81298", "Tsuchiura\,\ Ibaraki",
"8126170", "Omachi\,\ Nagano",
"818290", "Hiroshima\,\ Hiroshima",
"8183766", "Shimonoseki\,\ Yamaguchi",
"81878", "Takamatsu\,\ Kagawa",
"818662", "Takahashi\,\ Okayama",
"812780", "Maebashi\,\ Gunma",
"818586", "Kurayoshi\,\ Tottori",
"811336", "Ishikari\,\ Hokkaido",
"8198295", "Hyuga\,\ Miyazaki",
"818656", "Kasaoka\,\ Okayama",
"812693", "Nakano\,\ Nagano",
"817688", "Noto\,\ Ishikawa",
"815768", "Gero\,\ Gifu",
"819746", "Taketa\,\ Oita",
"819572", "Isahaya\,\ Nagasaki",
"815997", "Ago\,\ Mie",
"81923", "Fukuoka\,\ Fukuoka",
"8161", "Osaka\,\ Osaka",
"817703", "Tsuruga\,\ Fukui",
"812387", "Nagai\,\ Yamagata",
"811983", "Hanamaki\,\ Iwate",
"818246", "Miyoshi\,\ Hiroshima",
"812914", "Hokota\,\ Ibaraki",
"8166", "Osaka\,\ Osaka",
"815743", "Minokamo\,\ Gifu",
"8128798", "Otawara\,\ Tochigi",
"814753", "Mobara\,\ Chiba",
"812476", "Miharu\,\ Fukushima",
"817735", "Fukuchiyama\,\ Kyoto",
"819737", "Kusu\,\ Oita",
"811862", "Kazuno\,\ Akita",
"81925", "Fukuoka\,\ Fukuoka",
"814775", "Funabashi\,\ Chiba",
"818565", "Masuda\,\ Shimane",
"818949", "Uwajima\,\ Ehime",
"811856", "Noshiro\,\ Akita",
"814705", "Tateyama\,\ Chiba",
"81822", "Hiroshima\,\ Hiroshima",
"817677", "Nanao\,\ Ishikawa",
"8152", "Nagoya\,\ Aichi",
"812878", "Nasukarasuyama\,\ Tochigi",
"8153965", "Hamamatsu\,\ Shizuoka",
"811356", "Iwanai\,\ Hokkaido",
"811972", "Mizusawa\,\ Iwate",
"811362", "Kutchan\,\ Hokkaido",
"812378", "Sagae\,\ Yamagata",
"812797", "Shibukawa\,\ Gunma",
"81462", "Atsugi\,\ Kanagawa",
"812890", "Utsunomiya\,\ Tochigi",
"812968", "Kasama\,\ Ibaraki",
"815586", "Shimoda\,\ Shizuoka",
"81875", "Kan\'onji\,\ Kagawa",
"81474", "Funabashi\,\ Chiba",
"818559", "Kawamoto\,\ Shimane",
"818689", "Okayama\,\ Okayama",
"81583", "Gifu\,\ Gifu",
"81885", "Komatsushima\,\ Tokushima",
"81484", "Kawaguchi\,\ Saitama",
"819974", "Yakushima\,\ Kagoshima",
"812575", "Tokamachi\,\ Niigata",
"818466", "Mima\,\ Tokushima",
"818596", "Yonago\,\ Tottori",
"812553", "Joetsu\,\ Niigata",
"812897", "Kanuma\,\ Tochigi",
"811756", "Noheji\,\ Aomori",
"818978", "Hakata\,\ Ehime",
"81533", "Toyohashi\,\ Aichi",
"81998", "Kagoshima\,\ Kagoshima",
"818368", "Ube\,\ Yamaguchi",
"81932", "Kitakyushu\,\ Fukuoka",
"811233", "Chitose\,\ Hokkaido",
"818843", "Anan\,\ Tokushima",
"814289", "Ome\,\ Tokyo",
"812419", "Tajima\,\ Fukushima",
"81434", "Chiba\,\ Chiba",
"81835", "Hofu\,\ Yamaguchi",
"8188096", "Tosashimizu\,\ Kochi",
"811736", "Goshogawara\,\ Aomori",
"81535", "Hamamatsu\,\ Shizuoka",
"819593", "Oseto\,\ Nagasaki",
"817948", "Miki\,\ Hyogo",
"815368", "Shitara\,\ Aichi",
"81833", "Kudamatsu\,\ Yamaguchi",
"812672", "Komoro\,\ Nagano",
"815978", "Kumano\,\ Mie",
"8125489", "Tsugawa\,\ Niigata",
"817963", "Toyooka\,\ Hyogo",
"817355", "Shingu\,\ Fukuoka",
"811541", "Teshikaga\,\ Hokkaido",
"812787", "Numata\,\ Gunma",
"81585", "Ibigawa\,\ Gifu",
"812615", "Omachi\,\ Nagano",
"81124", "Ashibetsu\,\ Hokkaido",
"814240", "Kokubunji\,\ Tokyo",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;