#!perl
# HopenTest.pm: test kit for Build::Hopen

package HopenTest;
use parent 'Exporter';
use Import::Into;

# Pragmas
use 5.014;
use feature ":5.14";
use strict;
use warnings;

# Packages
use Data::Dumper;
use Carp;
#use Capture::Tiny 'capture';
#use Config;
#use IPC::Run3;
use Test::More;
#use Text::ParseWords qw(shellwords);

# Definitions from this file
use constant {
    true => !!1,
    false => !!0,
};

our @EXPORT = qw(true false);
#our @EXPORT_OK = qw();
#our %EXPORT_TAGS = (
#    default => [@EXPORT],
#    all => [@EXPORT, @EXPORT_OK]
#);

#BEGIN {
#    $SIG{'__DIE__'} = sub { Carp::confess(@_) } unless $SIG{'__DIE__'};
#    #$Exporter::Verbose=1;
#}

sub import {
    my $target = caller;

    # Copy symbols listed in @EXPORT first, in case @_ gets trashed later.
    HopenTest->export_to_level(1, @_);

    # Re-export pragmas and packages
    feature->import::into($target, qw(:5.14));
    Carp->import::into($target, qw(carp croak confess));
    foreach my $pragma (qw(strict warnings Data::Dumper Test::More)) {
        ${pragma}->import::into($target);
    };

} #import()

1;
# vi: set ts=4 sts=0 sw=4 noet ai fdm=marker fdl=1: #
