package Lingua::PT::Nums2Ords;

use 5.008;
use strict;
use warnings;

use Lingua::PT::Nums2Words;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
	num2ord
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	num2ord
);

our $VERSION = '0.02';

=head1 NAME

Lingua::PT::Nums2Ords - Converts numbers to Portuguese ordinals

=head1 SYNOPSIS

  use Lingua::PT::Nums2Ords;

  $ord = num2ord(20)     # "vigsimo"

  @ord = num2ord(1,2,3)  # qw(primeiro segundo terceiro)

=cut

sub num2ord {
  @_ || return ();
  my @numbers = wantarray ? @_ : shift;
  my @results = map {
    $_ < 0 && return $_;
    $_ > 999999999999 && return $_;

    s/(?<!\d)1(?=\d{9}$)/bilionsimo /;
    s/(\d{1,3})(?=\d{9})/num2word($1).' bilionsimos '/e;

    s/(?<!\d)0+//;

    s/(?<!\d)1(?=\d{6}$)/milionsimo /;
    s/(\d{1,3})(?=\d{6})/num2word($1).' milionsimos '/e;

    s/(?<!\d)0+//;

    s/(?<!\d)1(?=\d{3}$)/milsimo /;
    s/(\d{1,3})(?=\d{3})/num2word($1).' milsimos '/e;

    s/(?<!\d)0//;

    s/9(?=\d\d)/nongentsimo /;
    s/8(?=\d\d)/octigentsimo /;
    s/7(?=\d\d)/septigentsimo /;
    s/6(?=\d\d)/seiscentsimo /;
    s/5(?=\d\d)/quingentsimo /;
    s/4(?=\d\d)/quadrigentsimo /;
    s/3(?=\d\d)/tricentsimo /;
    s/2(?=\d\d)/ducentsimo /;
    s/1(?=\d\d)/centsimo /;

    s/(?<!\d)0//;

    s/9(?=\d)/nonagsimo /;
    s/8(?=\d)/octogsimo /;
    s/7(?=\d)/septuagsimo /;
    s/6(?=\d)/sexagsimo /;
    s/5(?=\d)/quinquagsimo /;
    s/4(?=\d)/quadragsimo /;
    s/3(?=\d)/trigsimo /;
    s/2(?=\d)/vigsimo /;
    s/1(?=\d)/dcimo /;

    s/(?<!\d)0//;

    s/9/nono/;
    s/8/oitavo/;
    s/7/stimo/;
    s/6/sexto/;
    s/5/quinto/;
    s/4/quarto/;
    s/3/terceiro/;
    s/2/segundo/;
    s/1/primeiro/;

    s/ +$//;

    $_;
  } @numbers;

  return wantarray ? @numbers : $numbers[0];
}

1;
__END__

=head1 DESCRIPTION

Converts numbers to Portuguese ordinals. Works up to 999.999.999.999
('novecentos e noventa e nove bilionsimos novecentos e noventa e nove
milionsimos novecentos e noventa e nove milsimos nongentsimo nonagsimo
nono').

=head1 DEPENDENCIES

Lingua::PT::Nums2Words

=head1 SEE ALSO

Lingua::PT::Ords2Nums

=head1 AUTHOR

Jose Alves de Castro, E<lt>jac@natura.di.uminho.pt<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2004 by Jose Alves de Castro

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
