/*
 * Decompiled with CFR 0.152.
 */
package org.ttt.salt;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.ttt.salt.XCSValidationException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TBXException
extends Exception
implements Comparable {
    private static final String RCSID = "$Id: TBXException.java 105 2009-04-04 17:40:36Z lanhel $";
    private static int sequenceNext;
    private final Priority priority;
    private final int sequence = sequenceNext++;

    public TBXException(Priority p, Exception c) {
        super(c);
        this.priority = p;
    }

    public String toString() {
        return "org.ttt.salt.TBXFile.TBXError: " + this.getMessage();
    }

    public String getMessage() {
        return this.buildMessage(false);
    }

    public String getLocalizedMessage() {
        return this.buildMessage(true);
    }

    private String buildMessage(boolean localize) {
        String ret = this.priority.toString();
        ResourceBundle bundle = ResourceBundle.getBundle("org.ttt.salt.TBXException");
        Object[] args = new Object[5];
        if (this.getCause() instanceof SAXParseException) {
            SAXParseException serr = (SAXParseException)this.getCause();
            args[0] = new Integer(serr.getLineNumber());
            args[1] = new Integer(serr.getColumnNumber());
            Object object = args[2] = localize ? serr.getLocalizedMessage() : serr.getMessage();
            args[3] = serr.getException() == null ? "" : (localize ? serr.getException().getLocalizedMessage() : serr.getException().getMessage());
            ret = ret + MessageFormat.format(bundle.getString("SAXParseException"), args);
        } else if (this.getCause() instanceof SAXException) {
            SAXException serr = (SAXException)this.getCause();
            args[0] = serr.getLocalizedMessage();
            args[1] = serr.getException() == null ? "" : (localize ? serr.getException().getLocalizedMessage() : serr.getException().getMessage());
            ret = ret + MessageFormat.format(bundle.getString("SAXException"), args);
        } else if (this.getCause() instanceof XCSValidationException) {
            args[0] = localize ? this.getCause().getLocalizedMessage() : this.getCause().getMessage();
            ret = ret + MessageFormat.format(bundle.getString("XCSValidationException"), args);
        } else if (this.getCause() instanceof FileNotFoundException) {
            FileNotFoundException serr = (FileNotFoundException)this.getCause();
            args[0] = localize ? this.getCause().getLocalizedMessage() : this.getCause().getMessage();
            ret = ret + MessageFormat.format(bundle.getString("FileNotFoundException"), args);
        } else if (this.getCause() instanceof UnknownHostException) {
            UnknownHostException serr = (UnknownHostException)this.getCause();
            args[0] = localize ? this.getCause().getLocalizedMessage() : this.getCause().getMessage();
            ret = ret + MessageFormat.format(bundle.getString("UnknownHostException"), args);
        } else {
            args[0] = this.getCause();
            ret = ret + MessageFormat.format(bundle.getString("UnknownException"), args);
            this.printStackTrace();
        }
        return ret.toString();
    }

    public void printStackTrace(PrintStream out) {
        this.getCause().printStackTrace(out);
    }

    public void printStackTrace(PrintWriter out) {
        this.getCause().printStackTrace(out);
    }

    public int compareTo(Object o) {
        TBXException p = (TBXException)o;
        int ret = this.priority.compareTo(p.priority);
        if (ret == 0) {
            ret = this.sequence - p.sequence;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        PRE_PARSE("preparse"),
        WELLFORMED("wellformed"),
        XMLVALID_MAJOR("invalidMajor"),
        XMLVALID_MINOR("invalidMinor"),
        XCS("xcs");

        private final String type;

        private Priority(String t) {
            this.type = t;
        }

        public String toString() {
            ResourceBundle bundle = ResourceBundle.getBundle("org.ttt.salt.TBXException");
            return bundle.getString(this.type);
        }
    }
}

