# $Id: Makefile.PL,v 1.13 2004/02/20 10:27:38 comdog Exp $
use ExtUtils::MakeMaker;

eval "use Test::Manifest";

unless( $@ )
	{
	no warnings;
	
	* ExtUtils::MM_Any::test_via_harness = sub
		   {
		   my($self, $perl, $tests) = @_;
	
		   return qq|\t$perl "-MTest::Manifest" | .
					  qq|"-e" "run_t_manifest(\$(TEST_VERBOSE), '\$(INST_LIB)', | .
					  qq|'\$(INST_ARCHLIB)')"\n|;
		   }
	}

WriteMakefile
		(
		'NAME'            => 'Test::Prereq',
		'VERSION_FROM'    => 'lib/Prereq.pm',
		'PREREQ_PM' => {
			'Module::Build'         => '0',
			'Module::CoreList'      => '0',
			'Module::Info'          => '0',
			'Test::Builder'         => '0',
			'Test::Builder::Tester' => '0',
			'Test::More'            => '0',
			},
        'PM'        => 
			{
			'lib/Prereq.pm'  => '$(INST_LIBDIR)/Prereq.pm',
			'lib/Build.pm'   => '$(INST_LIBDIR)/Prereq/Build.pm',
			},
        'MAN3PODS' =>
        	{
        	'lib/Prereq.pm' => '$(INST_MAN3DIR)/Test::Prereq.3',
        	'lib/Build.pm'  => '$(INST_MAN3DIR)/Test::Prereq::Build.3',
        	},

		clean  => { FILES => 'Test-Prereq-*' },
		);

1;
