#!/usr/local/bin/perl -w

use POSIX "uname";
use strict;
use Getopt::Std;
use vars qw($opt_s $opt_n $opt_r $opt_v $opt_m $opt_a);

my $usage = "usage: uname   [-snrvma]\n";
getopts "snrvma" or die $usage;

my ($sysname, $nodename, $release, $version, $machine ) = uname;
my @out = ();

if ($opt_s || $opt_a) {
	push @out, $sysname;
}
if ($opt_n || $opt_a) {
	push @out, $nodename;
}
if ($opt_r || $opt_a) {
	push @out, $release;
}
if ($opt_v || $opt_a) {
	push @out, $version;
}
if ($opt_m || $opt_a) {
	push @out, $machine;
}

print "@out\n";


=head1 NAME

uname - print system information

=head1 SYNOPSIS

uname [-snrvma]

=head1 DESCRIPTION

uname prints out system identification information.
It's really just a front end for the system call B<uname(2)>.

=head1 OPTIONS AND ARGUMENTS

=over 2

=item I<-s>

system

=item I<-n>

network node name

=item I<-r>

operating system release

=item I<-v>

operating system version

=item I<-m>

machine type

=item I<-a>

All of the above.

=back

Multiple arguments print all information requested,
but always in the order "snrvma".

=head1 AUTHOR

  Jeffrey S. Haemer

=head1 BUGS

There is no standard definition of what actually belongs in these fields.
What are acceptable values for, for example, "machine type"?

=head1 SEE ALSO

  uname(2)
