#!perl

use strict;
use warnings;

use Test::More tests => 9;
use CPAN::Testers::WWW::Statistics::Excel;

ok( my $obj = CPAN::Testers::WWW::Statistics::Excel->new(), "got object" );

# test the attributes generated by Class::Accessor::Fast

# predefined attributes
foreach my $k ( qw/
    logclean
/ ){
  my $label = "[$k]";
  SKIP: {
    ok( $obj->can($k), "$label can" )
	or skip "'$k' attribute missing", 3;
    isnt( $obj->$k(), undef, "$label has default" );
    is( $obj->$k(123), 123, "$label set" );
    is( $obj->$k, 123, "$label get" );
  };
}

# undefined attributes
foreach my $k ( qw/
    logfile
/ ){
  my $label = "[$k]";
  SKIP: {
    ok( $obj->can($k), "$label can" )
	or skip "'$k' attribute missing", 3;
    is( $obj->$k(), undef, "$label has no default" );
    is( $obj->$k(123), 123, "$label set" );
    is( $obj->$k, 123, "$label get" );
  };
}

