package main;
use Evo;
use Evo::Util;
use Test::More;
use Test::Fatal;

sub stash_multi { Evo::Util::stash_multi(@_) }

my $obj = {};

is stash_multi($obj), $obj;

# not spoil empty hash
# not existing group
ok !stash_multi($obj, 'KEY');
is_deeply $obj, {};

# not existing group and key
ok !stash_multi($obj, 'KEY', '404');
is_deeply $obj, {};

# add on el
is stash_multi($obj, 'KEY', bar => 'BAR'), $obj;
is stash_multi($obj, 'KEY', 'bar'), 'BAR';
is_deeply stash_multi($obj, 'KEY'), {bar => 'BAR'};
ok !stash_multi($obj, 'KEY', '404');
is_deeply $obj, {KEY => {bar => 'BAR'}};

# add several values
is stash_multi($obj, 'KEY2', one => '1', two => '2'), $obj;
is stash_multi($obj, 'KEY2', 'one'), 1;
is stash_multi($obj, 'KEY2', 'two'), 2;

done_testing;
