use Evo;
use Test::More;
use Test::Fatal;

use Railway::Train;


like exception { Railway::Train->new->start }, qr/no stations/,
  'not started without stations';

like exception {
  my $t = Railway::Train->new;
  $t->way->add(sub { shift->power(0) });
  $t->start;
  $t->start;
}, qr/already started/, 'not started without stations';

like exception {
  my $t = Railway::Train->new;
  $t->way->add(sub { });
  $t->run;
}, qr/no power/, 'not started without stations';

like exception {
  my $t = Railway::Train->new;
  $t->way->add(sub { });
  $t->power(1)->power(1);
}, qr/same power/i, 'not started without stations';

like exception {
  my $t = Railway::Train->new->depart
}, qr/start train first/i, 'not started without stations';

done_testing;


1;
