package main;
use Evo;
use Test::More;
use Evo::Mdn;
use Evo::Util::Mdn ':all';
use Test::Fatal;

my ($FROM, $MSG, $DESTROYED);
{

  package My::Obj;
  use Evo -class;
}

my $mdn  = Evo::Mdn->new;
my $from = My::Obj->new;


my ($me, $id);

# firstly check if implementation didn't change

# not store
$me = My::Obj->new;
$mdn->subscribe($me, $from, 0, sub { });
ok is_subscribed $mdn, $me, $from;

undef $me;
ok !list_subscribers $mdn, $from;

# store
my $res = 0;
$me = My::Obj->new;
ok !list_subscribers $mdn, $from;
$mdn->subscribe($me, $from, 1, sub { $res += $_[2] });
ok is_subscribed $mdn, $me, $from;
ok is_stored $mdn,     $me, $from;
undef $me;
$mdn->broadcast($from, 22);
is $res, 22;
ok list_subscribers $mdn, $from;


done_testing;
