package main;
use Evo;
use Test::More;
use FindBin;
use lib "$FindBin::Bin/../../lib";


{

  package My::Inline;
  use Evo -class;
  has 'name';
};


# trimm key, but not value
Evo::call {'Foo::' => 'My::Foo::', 'Bar' => 'My::Bar'}, sub {
  is Evo::dep('Foo::'), 'My::Foo::';
  is Evo::dep('Foo'),   'My::Foo::';
  ok Evo::dep_exists('Foo');
  ok Evo::dep_exists('Foo::');

  is Evo::dep('Bar::'), 'My::Bar';
  is Evo::dep('Bar'),   'My::Bar';
  ok Evo::dep_exists('Bar');
  ok Evo::dep_exists('Bar::');
};

is Evo::dep_module('My::Inline'),   'My::Inline';
is Evo::dep_module('My::Inline::'), 'My::Inline';

ok Evo::dep_new 'My::Inline';
ok Evo::dep_new 'My::Inline::';

my $single = Evo::dep_single('My::Inline::');
is Evo::dep_single('My::Inline'),   $single;
is Evo::dep_single('My::Inline::'), $single;
is Evo::dep_single('My::Inline::'), $single;

# with ::
Evo::call {'Foo::' => 'My::Inline'}, sub {
  ok Evo::dep_new 'Foo::';
  ok Evo::dep_new 'Foo';

  my $single = Evo::dep_single 'Foo';
  is Evo::dep_single('Foo'),   $single;
  is Evo::dep_single('Foo::'), $single;
  is Evo::dep_single('Foo::'), $single;

  is Evo::dep_module('Foo'),   'My::Inline';
  is Evo::dep_module('Foo::'), 'My::Inline';
};

# without ::
Evo::call {'Foo' => 'My::Inline'}, sub {
  ok Evo::dep_new 'Foo::';
  ok Evo::dep_new 'Foo';

  ok Evo::dep_single 'Foo';
  ok Evo::dep_single 'Foo::';

  is Evo::dep_module('Foo'),   'My::Inline';
  is Evo::dep_module('Foo::'), 'My::Inline';
};

# load external by key with ::
Evo::call {'my' => 'MyExternal'}, sub {
  Evo::dep_module('my')->can('new');
};

Evo::call {'my' => 'MyExternal::'}, sub {
  Evo::dep_module('my')->can('new');
};

done_testing;
