package main;
use Evo ':all';
use Test::More;


{

  package My::Inline;
  use Evo -class;
  has 'name';

  package My::Inline::Sub;
  use Evo 'My::Inline';

  package My::Inline::Mock;
  use Evo 'My::Inline';
};

# glob
my $obj = dep_new My::Inline, name => 'myname';
is $obj->name, 'myname';
isa_ok $obj, 'My::Inline';

my $sub_obj = dep_new My::Inline::Sub, name => 'myname';
isa_ok $sub_obj, 'My::Inline::Sub';
is $sub_obj->name, 'myname';

# mock in evo
call {'My::Inline' => 'My::Inline::Mock'}, sub {
  my $mock_obj = dep_new My::Inline, name => 'myname';
  is $mock_obj->name, 'myname';
  isa_ok $mock_obj, 'My::Inline::Mock';
};

done_testing;
