package Evo::Spy;
use Evo -class;
use overload '&{}' => sub { shift->fn }, fallback => 1;

use Hash::Util::FieldHash();
use Evo::Guard;

has 'origin';
has calls => sub { [] };

sub fn {
  my $self = shift;
  sub { $self->_execute(@_) };
}

sub _execute {
  my ($self, @args) = @_;
  my $calls = $self->calls;
  my $want  = wantarray;
  my $ret   = [];
  my $call  = {args => \@args, wantarray => $want, return => $ret};
  push @$calls, $call;

  my $orig = $self->origin or return;

  my $guard
    = Evo::dep_new('Evo::Guard', sub { $_[0] and $call->{exception} = $_[0] });
  return $orig->(@args) if !defined $want;
  return $want ? (@$ret = $orig->(@args)) : ($ret->[0] = $orig->(@args));
}

sub new {
  my ($self, @args) = @_;
  push @args, origin => pop @args if @args % 2;
  $self->SUPER::new(@args);
}

1;

# ABSTRACT: A basic spy function-object

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Spy - A basic spy function-object

=head1 VERSION

version 0.0171

=head1 SYNOPSIS

  use Evo::Base -strict;
  use Evo::Spy;
  my $spy = Evo::Spy->new(sub { say "hello ", shift });

  $spy->('foo');
  $spy->fn->('bar');

  use Data::Dumper;
  say Dumper $spy->calls;

=head1 ATTRIBUTES

=head2 origin

An original function.

=head2 calls

Returns an array ref to information of all invocations of C<$spy->()> or
C<$spy->fn()>. Don't rely on implementation and don't use this directly.
Use subclasses of L<Evo::Spy> instead which provide methods for that

=head1 METHODS

=head2 new

Creates a new spy. If no origin will be passed, spy will still record
all invocations, but do nothing (like a noop spy)

=head2 fn

Returns a function that can be used as a spy. This class is overloaded, but you
can use this function if a code checks that callbacks are coderefs by C<ref>
function

  # does nothing
  $spy->() if ref $spy eq 'CODE';

  # does the right thing, fn is CODE
  $spy->fn->() if ref $spy->fn eq 'CODE';

So it's recommended to use L</"fn"> instead of overloading feature. But
if you know, what you're doing, it doesn't matter.

Firstly I implemented a spy as a real coderef using IOC store, but only
L<Scalar::Util::reftype> was able to recognize a spy as a coderef. So I decided
to simplify the implementation (and it works 30% faster than IOC)

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
