use Perlmazing;
use Twilio;
my $t = Twilio::Twiml->new;
my ($response, $name);

#######################################################################
$name = 'say';
$response = $t->Response (
	content	=> [
		$t->Say (
			voice	=> 'woman',
			content	=> 'Hello! Please leave a message after the tone.',
		),
		$t->Say (
			voice	=> 'man',
			content	=> 'Hola! Por favor deje un mensaje despus del tono.',
		),
		$t->Record (
			max_length	=> 20,
		),
	],
);
save_response($name, $response);

#######################################################################
$name =  'play';
$response = $t->Response (
	content	=> $t->Play (
		loop	=> 10,
		content	=> 'https://api.twilio.com/cowbell.mp3',
	)
);
save_response($name, $response);

#######################################################################
$name = 'gather';
$response = $t->Response (
	content	=> [
		$t->Gather (
			action	=> '/process_gather.php',
			method	=> 'GET',
			content	=> $t->Say (
				content	=> "Please enter your account number,\nfollowed by the pound sign",
			),
		),
		$t->Redirect (
			method	=> 'GET',
			content	=> '/process_gather.php?Digits=TIMEOUT',
		)
	],
);
save_response($name, $response);

#######################################################################
$name = 'record';
$response = $t->Response (
	content	=> [
		$t->Say (
			content	=> "Please leave a message at the beep.\nPress the start key when finished.",
		),
		$t->Record (
			action			=> 'http://foo.edu/handleRecording.php',
			method			=> 'GET',
			max_length		=> 20,
			finish_on_key	=> '*',
		),
		$t->Say (
			content	=> 'I did not receive a recording',
		),
	],
);
save_response($name, $response);

#######################################################################
$name = 'sms';
$response = $t->Response (
	content	=> [
		$t->Say (
			content	=> 'Our store is located at 123 Easy St.',
		),
		$t->Sms (
			status_callback =>	'/smsHandler.php',
			content			=> 'Store Location: 123 Esasy St.',
		),
	],
);
save_response($name, $response);

#######################################################################
$name = 'dial';
$response = $t->Response (
	content	=> [
		$t->Dial (
			action	=> '/handleDialCallStatus.php',
			method	=> 'GET',
			content	=> '415-123-4567',
		),
		$t->Say ('I am unreachable'),
	],
);
save_response($name, $response);

#######################################################################
$name = 'enqueue';
$response = $t->Response (
	content	=> $t->Enqueue (
		wait_url	=> 'wait-music.xml',
		content		=> 'support',
	),
);
save_response($name, $response);

#######################################################################
$name = 'leave';
$response = $t->Response($t->Leave);
save_response($name, $response);

#######################################################################
$name = 'hangup';
$response = $t->Response($t->Hangup);
save_response($name, $response);

#######################################################################
$name = 'redirect';
$response = $t->Response (
	content	=> [
		$t->Dial('415-123-4567'),
		$t->Redirect('http://www.foo.com/nextInstructions'),
	],
);
save_response($name, $response);

#######################################################################
$name = 'reject';
$response = $t->Response (
	content	=> $t->Reject (
		reason	=> 'busy',
	),
);
save_response($name, $response);

#######################################################################
$name = 'pause';
$response = $t->Response (
	content	=> [
		$t->Say('I will pause 10 seconds starting now!'),
		$t->Pause( length => 10 ),
		$t->Say('I just paused 10 seconds'),
	],
);
save_response($name, $response);

#######################################################################
$name = 'message';
$response = $t->Response (
	content	=> $t->Message("I'm hungry!"),
);
save_response($name, $response);




sub save_response {
	my ($name, $response) = @_;
	my $file = "twiml_responses/$name.twiml.xml";
	open my $out, '>', $file or die "Cannot write to $file: $!";
	binmode $out;
	print $out $response;
	close $out;
}

