$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6de7f154fda3b454bb9961df50427cdf';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
);
my $test;

###############################################
$test = 'OutgoingCallerIds instance';
is ref($api->OutgoingCallerIds), 'Twilio::OutgoingCallerIds', $test;

###############################################
$test = 'OutgoingCallerIds list';
my @ids = $api->OutgoingCallerIds;
is @ids > 0, 1, $test;

###############################################
$test = 'OutgoingCallerId instances in list';
my $ok = 0;
for my $i (@ids) {
	$ok++ if ref($i) eq 'Twilio::OutgoingCallerIds::OutgoingCallerId';
}
is $ok, scalar @ids, $test;

###############################################
$test = 'Get OutgoingCallerId instances by sid';
my $id = $api->OutgoingCallerIds->get($ids[0]->sid);
is ref($id), 'Twilio::OutgoingCallerIds::OutgoingCallerId', $test;

###############################################
$test = 'Change friendly name of first instance';
my $friendly_name = $id->friendly_name;
my $new_name = 'Test name';
$id->friendly_name = $new_name;
$id = $api->OutgoingCallerIds->get($ids[0]->sid);
is $id->friendly_name, $new_name, $test;

###############################################
$test = 'Change friendly back to original';
$id->friendly_name = $friendly_name;
$id = $api->OutgoingCallerIds->get($ids[0]->sid);
is $id->friendly_name, $friendly_name, $test;

###############################################
$test = 'New OutgoingCallerId request';
my $req = $api->OutgoingCallerIds->create('+14151234567');
is (((ref($req) eq 'Twilio::OutgoingCallerIds::OutgoingCallerId' and $req->{validation_code}) ? 1 : 0), 1, $test);

done_testing;
