$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6de7f154fda3b454bb9961df50427cdf';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
);
my $test;

###############################################
$test = 'Get Messages instance';
my $msgs = $api->Messages;
is ref($msgs), 'Twilio::Messages', $test;

###############################################
$test = 'Get Messages list';
my @msgs = $api->Messages;
is @msgs > 0, 1, $test;

###############################################
$test = 'Items in the list are Twilio::Messages::Message instances';
my $ok = 1;
for my $i (@msgs) {
	$ok = 0 unless ref($i) eq 'Twilio::Messages::Message';
}
is $ok, 1, $test;

###############################################
$test = 'Get instance by sid';
my $msg = $api->Messages->get($msgs[0]->sid);
is ref($msg), 'Twilio::Messages::Message', $test;

###############################################
$test = 'Send SMS in english';
my $body = 'Hello! This is a test message.';
$msg = $msgs->create (
	from	=> '+14158020202',
	to		=> '+525541414570',
	body	=> $body,
);
$msg = $api->Messages->get($msg->sid);
is $msg->body, $body, $test;

###############################################
$test = 'Send SMS with special characters';
$body = 'Ah! S s, el ltimo nio gero es fenmeno?';
$msg = $msgs->create (
	from	=> '+14158020202',
	to		=> '+525541414570',
	body	=> $body,
);
$msg = $api->Messages->get($msg->sid);
is $msg->body, $body, $test;

done_testing;
