$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6de7f154fda3b454bb9961df50427cdf';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
);
my $test;

###############################################
$test = 'AvailablePhoneNumbers instance';
is ref($api->AvailablePhoneNumbers), 'Twilio::AvailablePhoneNumbers', $test;

###############################################
$test = 'Countries resource list';
my @countries = $api->AvailablePhoneNumbers->Countries;
is @countries > 0, 1, $test;

###############################################
$test = 'Country instance in list';
is ref($countries[0]), 'Twilio::AvailablePhoneNumbers::Country', $test;

###############################################
$test = 'Country instance by code';
my $country = $api->AvailablePhoneNumbers('us');
is ref($country), 'Twilio::AvailablePhoneNumbers::Country', $test;

###############################################
$test = 'Subresource Local';
my @local = $country->Local;
is @local > 0, 1, $test;

###############################################
$test = 'Local list have Twilio::AvailablePhoneNumbers::Country::AvailablePhoneNumber instances';
my $ok = 1;
for my $i (@local) {
	$ok = 0 unless ref($i) eq 'Twilio::AvailablePhoneNumbers::Country::AvailablePhoneNumber';
}
is $ok, 1, $test;

###############################################
my $pattern = substr $local[$#local]->phone_number, -3;
$test = 'Find numbers containing pattern '.$pattern;
my @filtered = $api->AvailablePhoneNumbers('us')->Local($pattern);
is @filtered > 0, 1, $test;

###############################################
$test = 'All numbers in list contain the given pattern';
$ok = 1;
for my $i (@filtered) {
	$ok = 0 unless $i->phone_number =~ /$pattern/;
}
is $ok, 1, $test;

done_testing;

