package Twilio::Usage::Records;
use Perlmazing;
use parent 'Twilio::Collection';

sub resource_uri {
	my $self = shift;
	$self->account_uri.'/Usage/Records';
}

sub subresource_name {
	'usage_records';
}

sub subresource_module {
	'Twilio::Usage::Record';
}

sub default_filter {
	'category';
}

BEGIN {
	no strict 'refs';
	for my $i (qw(AllTime Daily LastMonth Monthly ThisMonth Today Yearly Yesterday)) {
		my $pack = "Twilio::Usage::Records::$i";
		*{$pack} = sub {
			my $self = shift;
			$pack->new (
				Twilio => $self->Twilio,
			)->list(@_);
		};
	}
}
1;
