package Twilio::Accounts::Account;
use Perlmazing;
use parent 'Twilio::Collection::Resource';

sub new {
	my $class = shift;
	my $self = __PACKAGE__->SUPER::new(@_);
	my $twilio = Twilio->new (
		sid		=> $self->sid,
		token	=> $self->auth_token,
	);
	merge %{$self->Objects}, %{$twilio->Objects};
	$self;
}

sub close {
	my $self = shift;
	my @call = caller(0);
	if ($self->status eq 'closed') {
		warn "Won't attempt to close an already closed account (sid: ".$self->sid." at $call[1] line $call[2]\n";
		return;
	}
	my $url = $self->root_url.$self->uri;
	$url =~ s/\.json$//;
	my $r = $self->Twilio->post("$url.json", { Status => 'closed' });
	merge %$self, %$r;
	$self->classify_subresources;
	$self;
}

sub delete {
	my $self = shift;
	$self->close;
}

1;
