$| = 1;
use Perlmazing;
use strict;
use warnings;
use Test::More;

BEGIN {
	use_ok 'Twilio';
}

my $sid = 'AC6e1650084fe73e11a80270e3c5878a0c';
my $token = '5d63b031798825773ecd430d3e73805e';

my $api = Twilio->new (
	sid		=> $sid,
	token	=> $token,
);
my $test;

###############################################
$test = 'IncomingPhoneNumbers instance';
my $numbers = $api->IncomingPhoneNumbers;
is ref($numbers), 'Twilio::IncomingPhoneNumbers', $test;

###############################################
$test = 'IncomingPhoneNumbers list';
my @numbers = $api->IncomingPhoneNumbers;
is @numbers > 0, 1, $test;

###############################################
$test = 'IncomingPhoneNumber instances in list';
my $ok = 1;
for my $i (@numbers) {
	$ok = 0 unless ref($i) eq 'Twilio::IncomingPhoneNumbers::IncomingPhoneNumber';
}
is $ok, 1, $test;

###############################################
$test = 'Get IncomingPhoneNumber instance by sid';
my $number = $api->IncomingPhoneNumbers->get($numbers[0]->sid);
is ref($number), 'Twilio::IncomingPhoneNumbers::IncomingPhoneNumber', $test;

###############################################
$test = 'Change friendly name of instance';
my $friendly_name = $number->friendly_name;
my $new_name = 'Test name';
$number->friendly_name = $new_name;
$number = $api->IncomingPhoneNumbers->get($number->sid);
is $number->friendly_name, $new_name, $test;

###############################################
$test = 'Change the friendly_name back to original';
$number->friendly_name = $friendly_name;
$number = $api->IncomingPhoneNumbers->get($number->sid);
is $number->friendly_name, $friendly_name, $test;

done_testing;
