=head1 NAME

PPIx::Regexp::Token::Condition - Represent the condition of a switch

=head1 SYNOPSIS

 use PPIx::Regexp::Dumper;
 PPIx::Regexp::Dumper->new( 'qr{(?(1)foo|bar)}smx' )
     ->print();

=head1 INHERITANCE

C<PPIx::Regexp::Token::Condition> is a
L<PPIx::Regexp::Token::Reference|PPIx::Regexp::Token::Reference>.

C<PPIx::Regexp::Token::Condition> has no descendants.

=head1 DESCRIPTION

This class represents the condition portion of a switch or conditional
expression, provided that condition is reasonably represented as a
token.

=head1 METHODS

This class provides no public methods beyond those provided by its
superclass.

=cut

package PPIx::Regexp::Token::Condition;

use strict;
use warnings;

use base qw{ PPIx::Regexp::Token::Reference };

use PPIx::Regexp::Constant qw{ RE_CAPTURE_NAME };

our $VERSION = '0.011';

my @recognize = (
    [ qr{ \A \( (?: ( \d+ ) | R (\d+) ) \) }smx,
	{ is_named => 0 } ],
    [ qr{ \A \( R \) }smx,
	{ is_named => 0, capture => '0' } ],
    [ qr{ \A \( (?: < ( @{[ RE_CAPTURE_NAME ]} ) > |
	    ' ( @{[ RE_CAPTURE_NAME ]} ) ' |
	    R & ( @{[ RE_CAPTURE_NAME ]} ) ) \) }smxo,
	{ is_named => 1} ],
    [ qr{ \A \( DEFINE \) }smx,
	{ is_named => 0, capture => '0' } ],
);

# Return true if the token can be quantified, and false otherwise
# sub can_be_quantified { return };

sub __PPIX_TOKENIZER__regexp {
    my ( $class, $tokenizer, $character ) = @_;

    foreach ( @recognize ) {
	my ( $re, $arg ) = @{ $_ };
	my $accept = $tokenizer->find_regexp( $re ) or next;
	return $tokenizer->make_token( $accept, __PACKAGE__, $arg );
    }

    return;
}

1;

__END__

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<http://rt.cpan.org>, or in electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2009-2010, Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set textwidth=72 :
