#!perl -T
use warnings; use strict;
use Test::More;
use Test::Exception;
use Test::Builder;
use Elive;
use Elive::Entity::Session;

use lib '.';
use t::Elive;

my $t = Test::Builder->new();

my $class = 'Elive::Entity::Session' ;

use Carp; $SIG{__DIE__} = \&Carp::confess;
use Scalar::Util;
use Try::Tiny;

my $MODULE = 'Test::Taint';
eval "use $MODULE";
plan skip_all => "$MODULE not available for taint tests"
    if $@;

plan tests => 15;
#
# restrict our user tests to the mock connections. Live updates
# are just to dangerous. There is also the possibility that the
# live site is running LDAP, in which case user access becomes
# read only.
#

SKIP: {

    my $skippable = 15;

    my %result = t::Elive->test_connection(only => 'real');
    my $auth = $result{auth};

    skip ($result{reason} || 'skipping live tests', $skippable)
	unless $auth && @$auth;

    my $connection_class = $result{class};
    my $connection = $connection_class->connect(@$auth);
    Elive->connection($connection);

    taint_checking_ok();

    my $session_start = time();
    my $session_end = $session_start + 15 * 10;

    my $session_name_untainted = 'test session, generated by t/soap-taint-mode.t(' . t::Elive::generate_id() . ')';
    taint( my $session_name_tainted = $session_name_untainted);

    untainted_ok($session_name_untainted, 'untainted sanity');
    tainted_ok($session_name_tainted, 'tainted sanity');

    my %session_data = (
	name => $session_name_untainted,
	start =>  $session_start . '000',
	end => $session_end . '000',
    );

    my $session;

    lives_ok( sub {$session = $class->insert(\%session_data);},
	     'insert with no tainted data - lives');

    isa_ok($session, $class, 'session');

    $session_data{name} = $session_name_tainted;
    dies_ok( sub {$class->insert(\%session_data);},
	     'insert with tainted Str data - dies');

    my $user_notes_untainted = 'this is a test';
    my $user_notes_tainted = $user_notes_untainted;
    taint($user_notes_tainted);

    my %update_data = (
	userNotes => $user_notes_untainted,
	);

    lives_ok(sub {$session->update(\%update_data)}, 'update with untainted Str data - lives');

    $update_data{userNotes} = $user_notes_tainted;

    dies_ok(sub {$session->update(\%update_data)}, 'update with tainted data - dies');

    lives_ok(sub {$session->revert}, 'revert tainted data - lives');

    my $session_id = $session->sessionId;

    $session->_db_data(undef);

    dies_ok (sub {Elive::Entity::Session->list(filter => "name = '$session_name_tainted'")},
	'List with tainted filter - dies');
  
    my $sessions;

    lives_ok (sub {$sessions = Elive::Entity::Session->list(filter => "name = '$session_name_untainted'")},
	'List with untainted filter - lives');
  
    is(scalar @$sessions, 1, 'list returns unique session');

    is( try {$sessions->[0]->sessionId}, $session_id, 'listed sessionId as expected');
    $sessions = undef;

    ok ($session = Elive::Entity::Session->retrieve([$session_id]),
	'Refetch of session');

    lives_ok(sub {$session->delete},'session deletion - lives');

}

Elive->disconnect;
