package Catalyst::Helper::Model::DBIC::Schema::ForRapidDbic;

use strict;
use warnings;

use namespace::autoclean;
use Moose;
extends 'Catalyst::Helper::Model::DBIC::Schema';

=head1 NAME

Catalyst::Helper::Model::DBIC::Schema::ForRapidDbic - Helper for DBIC Schema Models

=head1 SYNOPSIS

  rapidapp.pl --helpers RapidDbic My::App -- --from-sqlite /path/to/existing/sqlt.db

=head1 DESCRIPTION

This helper class extends L<Catalyst::Helper::Model::DBIC::Schema>, adding support
for munging SQLite dsns to use runtime paths relative to the Catalyst app root.
It is otherwise exactly the same as the parent class.

This class is used internally by the RapidDbic helper trait for L<RapidApp::Helper>
(L<rapidapp.pl>) and is not meant to be used directly.

=head1 AUTHOR

Henry Van Styn <vanstyn@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by IntelliTree Solutions llc.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

use Try::Tiny;
use Path::Class qw/file dir/;

sub _gen_model {
    my $self = shift;
    my $helper = $self->helper;
    
    try {
      my $nfo = $self->{connect_info};
      
      if($nfo && $nfo->{dsn} && $nfo->{dsn} =~ /\:sqlite\:/i) {
        my ($dbi,$drv,$db) = split(/\:/,$nfo->{dsn},3);
        
        my $db_file = file($db)->resolve->absolute;
        my $base_dir = dir($helper->{base})->resolve->absolute;
        
        if($base_dir->contains($db_file)) {
          my $rel = $db_file->relative($base_dir);
          
          $helper->{pre_config_perl_code} = join('',
            q{use Path::Class qw(file);},"\n",
            q{use Catalyst::Utils;},"\n",
            q{my $db_path = file(Catalyst::Utils::home('},
              $helper->{app},q{'),'},$rel->stringify,q{');},
          );
          
          $helper->{connect_info}{dsn} = join('','"',$dbi,':',$drv,':','$db_path','"');
        }
      
      }
    };
    
    $helper->render_file('compclass', $helper->{file} );
}


1;


__DATA__

=begin pod_to_ignore

__schemaclass__
package [% schema_class %];

use strict;
use base qw/DBIx::Class::Schema::Loader/;

__PACKAGE__->loader_options(
    [%- FOREACH key = loader_args.keys %]
    [% key %] => [% loader_args.${key} %],
    [%- END -%]

);

=head1 NAME

[% schema_class %] - L<DBIx::Class::Schema::Loader> class

=head1 SYNOPSIS

See L<[% app %]>

=head1 DESCRIPTION

Dynamic L<DBIx::Class::Schema::Loader> schema for use in L<[% class %]>

=head1 GENERATED BY

[% generator %] - [% generator_version %]

=head1 AUTHOR

[% author.replace(',+$', '') %]

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;

__compclass__
package [% class %];

use strict;
use base 'Catalyst::Model::DBIC::Schema';

[% pre_config_perl_code %]

__PACKAGE__->config(
    schema_class => '[% schema_class %]',
    [% IF traits %]traits => [% traits %],[% END %]
    [% IF setup_connect_info %]connect_info => {
        [%- FOREACH key = connect_info.keys %]
        [% key %] => [% connect_info.${key} %],
        [%- END -%]

    }[% END %]
);

=head1 NAME

[% class %] - Catalyst/RapidApp DBIC Schema Model

=head1 SYNOPSIS

See L<[% app %]>

=head1 DESCRIPTION

L<Catalyst::Model::DBIC::Schema> Model using schema L<[% schema_class %]>

=head1 GENERATED BY

[% generator %] - [% generator_version %]

=head1 AUTHOR

[% author.replace(',+$', '') %]

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
__END__
# vim:sts=4 sw=4: