# This file was autogenerated.
use 5.008008;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::Topic::Scalar;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.008';

=head1 NAME

Hydrogen::Topic::Scalar - functions from Hydrogen::Scalar applied to C<$_>

=head1 VERSION

This documentation is for Hydrogen::Topic::Scalar 0.008.

=cut

=head1 FUNCTIONS

Each function implicitly operates on C<< $_ >>, expecting it to be a scalar.

=cut

use Exporter::Shiny qw(
    make_getter
    make_setter
);

=head2 C<< make_getter() >>

Operates on C<< $_ >>, which must be a scalar.

Returns a getter coderef.

=cut

sub make_getter {

    package Hydrogen::Scalar::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for make_getter; usage: "
          . "Hydrogen::Topic::Scalar::make_getter()" );
    my $s = $_;
    sub { unshift @_, $s; $_ }
}

=head2 C<< make_setter() >>

Operates on C<< $_ >>, which must be a scalar.

Returns a setter coderef.

=cut

sub make_setter {

    package Hydrogen::Scalar::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for make_setter; usage: "
          . "Hydrogen::Topic::Scalar::make_setter()" );
    my $s = $_;
    sub { my $val = shift; unshift @_, $s; ( $_ = $val ) }
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all
(this is usually a bad idea), use:

    use Hydrogen::Topic::Scalar -all;

To import a particular function, use:

    use Hydrogen::Topic::Scalar 'make_getter';

To rename functions:

    use Hydrogen::Topic::Scalar 'make_getter' => { -as => 'myfunc' };

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::Scalar>,
L<Sub::HandlesVia::HandlerLibrary::Scalar>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.


