# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package JobAd::GEN::Position;

use strict;

use base 'JobAd';

use JobAd::Model::position qw(
    $POSITION
);
use Gantry::Plugins::Calendar qw(
    do_calendar_month
    calendar_month_js
);



#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Position' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my $retval = {
        headings       => [
            'N Openings',
            'Location',
        ],
        header_options => [
            {
                text => 'Add',
                link => $real_location . "add",
            },
        ],
    };

    my $schema = $self->get_schema();
    my @rows   = $POSITION->get_listing( { schema => $schema } );

    foreach my $row ( @rows ) {
        my $id = $row->id;
        push(
            @{ $retval->{rows} }, {
                data => [
                    $row->n_openings,
                    $row->location,
                ],
                options => [
                    {
                        text => 'Edit',
                        link => $real_location . "edit/$id",
                    },
                    {
                        text => 'Delete',
                        link => $real_location . "delete/$id",
                    },
                ],
            }
        );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->form( $row )
#-----------------------------------------------------------------
sub form {
    my ( $self, $row ) = @_;

    my $selections = $POSITION->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        name       => 'position',
        row        => $row,
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        javascript => $self->calendar_month_js( 'position' ),
        fields     => [
            {
                name => 'n_openings',
                constraint => qr{^\d $},
                label => 'N Openings',
                type => 'text',
                is => 'int4',
            },
            {
                name => 'location',
                label => 'Location',
                type => 'text',
                is => 'varchar',
            },
            {
                options => $selections->{job},
                name => 'job',
                label => 'Job',
                type => 'select',
                is => 'int4',
            },
            {
                date_select_text => 'Select Date',
                name => 'closes',
                label => 'Closes',
                type => 'text',
                is => 'date',
            },
            {
                name => 'boss',
                label => 'Boss',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'pay',
                label => 'Pay',
                type => 'text',
                is => 'varchar',
            },
        ],
    };
} # END form


1;

=head1 NAME

JobAd::GEN::Position - generated support module for JobAd::Position

=head1 SYNOPSIS

In JobAd::Position:

    use JobAd::GEN::Position qw(
        do_main
        form
    );

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in JobAd::Position to provide the methods below.
They are exported by default.

=head1 METHODS

=over 4

=item do_main

=item form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

