package CanvasCloud::API::Users;
$CanvasCloud::API::Users::VERSION = '0.006';
# ABSTRACT: extends L<CanvasCloud::API>

use Moose;
use namespace::autoclean;

extends 'CanvasCloud::API';


has user_id => ( is => 'ro', required => 1 );


augment 'uri' => sub {
    my $self = shift;
    my $rest = inner() || '';
    $rest = '/' if ( defined $rest && $rest && $rest !~ /^\// );
    return sprintf( '/users/%s', $self->user_id ) . $rest;
};

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

CanvasCloud::API::Users - extends L<CanvasCloud::API>

=head1 VERSION

version 0.006

=head1 ATTRIBUTES

=head2 user_id

I<required:> set to the user id for Canvas call

=head2 uri

augments base uri to append '/users/user_id'

=head1 AUTHOR

Ted Katseres

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Ted Katseres.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
