use strict;
use XS::Install;
use Alien::CMake;

unless (-f 'libuv/Makefile') {
    my $cmake = Alien::CMake->bin_dir ? Alien::CMake->bin_dir.'/cmake' : 'cmake';
    my $result = system(qq{cd libuv && $cmake CMakeLists.txt -G "Unix Makefiles" -DCMAKE_C_FLAGS="-fPIC -O2"});
    die "FATAL: could not make libuv's Makefile\n" if $result != 0;
}

my $libs = '-lpthread';
$libs .= ' -liphlpapi -lpsapi -luserenv' if $^O eq 'MSWin32'; 

my %params = (
    NAME      => 'Alien::uv',
    CPLUS     => 11,
    LIBS      => $libs,
    PREREQ_PM => {'Alien::CMake' => "0.11"},
    BIN_SHARE => {INCLUDE => {'libuv/include' => '/'}},
    CLIB      => {
        DIR    => 'libuv',
        FILE   => 'libuv_a.a',
        TARGET => 'uv_a',
    },
);

write_makefile(%params);
