#!perl

use strict;
use warnings;

use Test::More;
use Test::Differences;
use Cwd qw(getcwd chdir);
use English qw(-no_match_vars $CHILD_ERROR);

$ENV{AUTHOR_TESTING} or plan
    skip_all => 'Set $ENV{AUTHOR_TESTING} to run this test.';

my @data = (
    {
        test   => '01_try_chain',
        path   => 'example',
        script => '01_try_chain.pl',
        params => '-I../lib -T',
        result => <<'EOT',
1foo
2barbaz
3
4
5undefundef
7try_chain finally
7error of try_chain
9try finally
9error of try
EOT
    },
    {
        test   => '02_call_m',
        path   => 'example',
        script => '02_call_m.pl',
        params => '-I../lib -T',
        result => <<'EOT',
1foo
2barbaz
3
4
EOT
    },
);

plan tests => 0 + @data;

for my $data (@data) {
    my $dir = getcwd();
    chdir("$dir/$data->{path}");
    my $result = qx{perl $data->{params} $data->{script} 2>&1};
    $CHILD_ERROR
        and die "Couldn't run $data->{script} (status $CHILD_ERROR)";
    chdir($dir);
    eq_or_diff
        $result,
        $data->{result},
        $data->{test};
}
