#!perl -T
use strict;
use warnings;

use Test::More tests => 28;
use Test::Differences;
use Test::Exception;
use Test::NoWarnings;

BEGIN {
    use_ok
        'Try::Chain',
        qw( try_chain try catch finally );
}

sub new {
    return bless {}, __PACKAGE__;
}
sub nothing {
    return;
}
sub string {
    return 'foo';
}
sub list {
    return qw( bar baz );
}

CONTEXT_OK: {
    lives_ok
        sub {
            my $scalar = try_chain { return __PACKAGE__->new->string };
            is
                $scalar,
                'foo',
                'check scalar context';
        },
        '...->new->string';
    lives_ok
        sub {
            my @list = try_chain { return __PACKAGE__->new->list };
            eq_or_diff
                \@list,
                [ qw( bar baz ) ],
                'check list context';
        },
        '...->new->list';
}

BROKEN_CHAIN: {
    lives_ok
        sub {
            my @list = try_chain { return __PACKAGE__->nothing->list };
            eq_or_diff
                \@list,
                [],
                'check list';
        },
        '...->nothing->list';
    lives_ok
        sub {
            my @list = try_chain { return __PACKAGE__->nothing->list };
            eq_or_diff
                \@list,
                [],
                'check list';
        },
        '...->nothing->list';
    lives_ok
        sub {
            my $scalar = try_chain { return __PACKAGE__->nothing->[0] };
            is
                $scalar,
                undef,
                'array value';
        },
        '...->nothing->[0]';
    lives_ok
        sub {
            my $scalar = try_chain { return __PACKAGE__->nothing->{key} };
            is
                $scalar,
                undef,
                'check hash value';
        },
        '...->nothing->{key}';
}

NO_AUTOVIVIFIVCATION: {
    lives_ok
        sub {
            my $foo;
            my $scalar = try_chain {
                no autovivification;
                return $foo->{bar}[0];
            };
            is
                $foo,
                undef,
                'autovivification';
        },
        '...->{bar}[0]';
}

TRY_CHAIN_CATCH_FINALLY: {
    lives_ok
        sub {
            my $scalar = try_chain { __PACKAGE__->new->string }
                catch { $_ }
                finally { ok 1, 'finally' };
            is
                $scalar,
                'foo',
                'try_chain ok, no catch, finally';
        },
        '...->new->string';
    lives_ok
        sub {
            my $scalar = try_chain { __PACKAGE__->nothing->string }
                catch { $_ }
                finally { ok 1, 'finally' };
            is
                $scalar,
                undef,
                'try_chain ok, no catch, finally';
        },
        '...->nothing->string';
    lives_ok
        sub {
            my $scalar
                = try_chain { die "error message\n" }
                    catch { $_ }
                    finally { ok 1, 'finally' };
            is
                $scalar,
                "error message\n",
                'try_chain not ok, catch, finally';
        },
        q{die 'error message'};
}

TRY_CATCH_FINALLY: {
    lives_ok
        sub {
            my $scalar = try { die "error message\n" }
                catch { $_ }
                finally { ok 1, 'finally' };
            is
                $scalar,
                "error message\n",
                'try not ok, catch, finally';
        },
        q{die 'error message'};
}
