package Date::Manip::TZ::asbeir00;
# Copyright (c) 2008-2010 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:23 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::asbeir00 - Support for the Asia/Beirut time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,2,22,0],'+02:22:00',[2,22,0],
          'LMT',0,[1879,12,31,21,37,59],[1879,12,31,23,59,59] ],
     ],
   1879 =>
     [
        [ [1879,12,31,21,38,0],[1879,12,31,23,38,0],'+02:00:00',[2,0,0],
          'EET',0,[1920,3,27,21,59,59],[1920,3,27,23,59,59] ],
     ],
   1920 =>
     [
        [ [1920,3,27,22,0,0],[1920,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1920,10,24,20,59,59],[1920,10,24,23,59,59] ],
        [ [1920,10,24,21,0,0],[1920,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1921,4,2,21,59,59],[1921,4,2,23,59,59] ],
     ],
   1921 =>
     [
        [ [1921,4,2,22,0,0],[1921,4,3,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1921,10,2,20,59,59],[1921,10,2,23,59,59] ],
        [ [1921,10,2,21,0,0],[1921,10,2,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1922,3,25,21,59,59],[1922,3,25,23,59,59] ],
     ],
   1922 =>
     [
        [ [1922,3,25,22,0,0],[1922,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1922,10,7,20,59,59],[1922,10,7,23,59,59] ],
        [ [1922,10,7,21,0,0],[1922,10,7,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1923,4,21,21,59,59],[1923,4,21,23,59,59] ],
     ],
   1923 =>
     [
        [ [1923,4,21,22,0,0],[1923,4,22,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1923,9,15,20,59,59],[1923,9,15,23,59,59] ],
        [ [1923,9,15,21,0,0],[1923,9,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1957,4,30,21,59,59],[1957,4,30,23,59,59] ],
     ],
   1957 =>
     [
        [ [1957,4,30,22,0,0],[1957,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1957,9,30,20,59,59],[1957,9,30,23,59,59] ],
        [ [1957,9,30,21,0,0],[1957,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1958,4,30,21,59,59],[1958,4,30,23,59,59] ],
     ],
   1958 =>
     [
        [ [1958,4,30,22,0,0],[1958,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1958,9,30,20,59,59],[1958,9,30,23,59,59] ],
        [ [1958,9,30,21,0,0],[1958,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1959,4,30,21,59,59],[1959,4,30,23,59,59] ],
     ],
   1959 =>
     [
        [ [1959,4,30,22,0,0],[1959,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1959,9,30,20,59,59],[1959,9,30,23,59,59] ],
        [ [1959,9,30,21,0,0],[1959,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1960,4,30,21,59,59],[1960,4,30,23,59,59] ],
     ],
   1960 =>
     [
        [ [1960,4,30,22,0,0],[1960,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1960,9,30,20,59,59],[1960,9,30,23,59,59] ],
        [ [1960,9,30,21,0,0],[1960,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1961,4,30,21,59,59],[1961,4,30,23,59,59] ],
     ],
   1961 =>
     [
        [ [1961,4,30,22,0,0],[1961,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1961,9,30,20,59,59],[1961,9,30,23,59,59] ],
        [ [1961,9,30,21,0,0],[1961,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1972,6,21,21,59,59],[1972,6,21,23,59,59] ],
     ],
   1972 =>
     [
        [ [1972,6,21,22,0,0],[1972,6,22,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1972,9,30,20,59,59],[1972,9,30,23,59,59] ],
        [ [1972,9,30,21,0,0],[1972,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1973,4,30,21,59,59],[1973,4,30,23,59,59] ],
     ],
   1973 =>
     [
        [ [1973,4,30,22,0,0],[1973,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1973,9,30,20,59,59],[1973,9,30,23,59,59] ],
        [ [1973,9,30,21,0,0],[1973,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1974,4,30,21,59,59],[1974,4,30,23,59,59] ],
     ],
   1974 =>
     [
        [ [1974,4,30,22,0,0],[1974,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1974,9,30,20,59,59],[1974,9,30,23,59,59] ],
        [ [1974,9,30,21,0,0],[1974,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1975,4,30,21,59,59],[1975,4,30,23,59,59] ],
     ],
   1975 =>
     [
        [ [1975,4,30,22,0,0],[1975,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1975,9,30,20,59,59],[1975,9,30,23,59,59] ],
        [ [1975,9,30,21,0,0],[1975,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1976,4,30,21,59,59],[1976,4,30,23,59,59] ],
     ],
   1976 =>
     [
        [ [1976,4,30,22,0,0],[1976,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1976,9,30,20,59,59],[1976,9,30,23,59,59] ],
        [ [1976,9,30,21,0,0],[1976,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1977,4,30,21,59,59],[1977,4,30,23,59,59] ],
     ],
   1977 =>
     [
        [ [1977,4,30,22,0,0],[1977,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1977,9,30,20,59,59],[1977,9,30,23,59,59] ],
        [ [1977,9,30,21,0,0],[1977,9,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1978,4,29,21,59,59],[1978,4,29,23,59,59] ],
     ],
   1978 =>
     [
        [ [1978,4,29,22,0,0],[1978,4,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1978,9,29,20,59,59],[1978,9,29,23,59,59] ],
        [ [1978,9,29,21,0,0],[1978,9,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1984,4,30,21,59,59],[1984,4,30,23,59,59] ],
     ],
   1984 =>
     [
        [ [1984,4,30,22,0,0],[1984,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1984,10,15,20,59,59],[1984,10,15,23,59,59] ],
        [ [1984,10,15,21,0,0],[1984,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1985,4,30,21,59,59],[1985,4,30,23,59,59] ],
     ],
   1985 =>
     [
        [ [1985,4,30,22,0,0],[1985,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1985,10,15,20,59,59],[1985,10,15,23,59,59] ],
        [ [1985,10,15,21,0,0],[1985,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1986,4,30,21,59,59],[1986,4,30,23,59,59] ],
     ],
   1986 =>
     [
        [ [1986,4,30,22,0,0],[1986,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1986,10,15,20,59,59],[1986,10,15,23,59,59] ],
        [ [1986,10,15,21,0,0],[1986,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1987,4,30,21,59,59],[1987,4,30,23,59,59] ],
     ],
   1987 =>
     [
        [ [1987,4,30,22,0,0],[1987,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1987,10,15,20,59,59],[1987,10,15,23,59,59] ],
        [ [1987,10,15,21,0,0],[1987,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1988,5,31,21,59,59],[1988,5,31,23,59,59] ],
     ],
   1988 =>
     [
        [ [1988,5,31,22,0,0],[1988,6,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1988,10,15,20,59,59],[1988,10,15,23,59,59] ],
        [ [1988,10,15,21,0,0],[1988,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1989,5,9,21,59,59],[1989,5,9,23,59,59] ],
     ],
   1989 =>
     [
        [ [1989,5,9,22,0,0],[1989,5,10,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1989,10,15,20,59,59],[1989,10,15,23,59,59] ],
        [ [1989,10,15,21,0,0],[1989,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1990,4,30,21,59,59],[1990,4,30,23,59,59] ],
     ],
   1990 =>
     [
        [ [1990,4,30,22,0,0],[1990,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1990,10,15,20,59,59],[1990,10,15,23,59,59] ],
        [ [1990,10,15,21,0,0],[1990,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1991,4,30,21,59,59],[1991,4,30,23,59,59] ],
     ],
   1991 =>
     [
        [ [1991,4,30,22,0,0],[1991,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1991,10,15,20,59,59],[1991,10,15,23,59,59] ],
        [ [1991,10,15,21,0,0],[1991,10,15,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1992,4,30,21,59,59],[1992,4,30,23,59,59] ],
     ],
   1992 =>
     [
        [ [1992,4,30,22,0,0],[1992,5,1,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1992,10,3,20,59,59],[1992,10,3,23,59,59] ],
        [ [1992,10,3,21,0,0],[1992,10,3,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1993,3,27,21,59,59],[1993,3,27,23,59,59] ],
     ],
   1993 =>
     [
        [ [1993,3,27,22,0,0],[1993,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1993,9,25,20,59,59],[1993,9,25,23,59,59] ],
        [ [1993,9,25,21,0,0],[1993,9,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1994,3,26,21,59,59],[1994,3,26,23,59,59] ],
     ],
   1994 =>
     [
        [ [1994,3,26,22,0,0],[1994,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1994,9,24,20,59,59],[1994,9,24,23,59,59] ],
        [ [1994,9,24,21,0,0],[1994,9,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1995,3,25,21,59,59],[1995,3,25,23,59,59] ],
     ],
   1995 =>
     [
        [ [1995,3,25,22,0,0],[1995,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1995,9,23,20,59,59],[1995,9,23,23,59,59] ],
        [ [1995,9,23,21,0,0],[1995,9,23,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1996,3,30,21,59,59],[1996,3,30,23,59,59] ],
     ],
   1996 =>
     [
        [ [1996,3,30,22,0,0],[1996,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1996,9,28,20,59,59],[1996,9,28,23,59,59] ],
        [ [1996,9,28,21,0,0],[1996,9,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1997,3,29,21,59,59],[1997,3,29,23,59,59] ],
     ],
   1997 =>
     [
        [ [1997,3,29,22,0,0],[1997,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1997,9,27,20,59,59],[1997,9,27,23,59,59] ],
        [ [1997,9,27,21,0,0],[1997,9,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1998,3,28,21,59,59],[1998,3,28,23,59,59] ],
     ],
   1998 =>
     [
        [ [1998,3,28,22,0,0],[1998,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1998,9,26,20,59,59],[1998,9,26,23,59,59] ],
        [ [1998,9,26,21,0,0],[1998,9,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1999,3,27,21,59,59],[1999,3,27,23,59,59] ],
     ],
   1999 =>
     [
        [ [1999,3,27,22,0,0],[1999,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1999,10,30,20,59,59],[1999,10,30,23,59,59] ],
        [ [1999,10,30,21,0,0],[1999,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2000,3,25,21,59,59],[2000,3,25,23,59,59] ],
     ],
   2000 =>
     [
        [ [2000,3,25,22,0,0],[2000,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2000,10,28,20,59,59],[2000,10,28,23,59,59] ],
        [ [2000,10,28,21,0,0],[2000,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2001,3,24,21,59,59],[2001,3,24,23,59,59] ],
     ],
   2001 =>
     [
        [ [2001,3,24,22,0,0],[2001,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2001,10,27,20,59,59],[2001,10,27,23,59,59] ],
        [ [2001,10,27,21,0,0],[2001,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2002,3,30,21,59,59],[2002,3,30,23,59,59] ],
     ],
   2002 =>
     [
        [ [2002,3,30,22,0,0],[2002,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2002,10,26,20,59,59],[2002,10,26,23,59,59] ],
        [ [2002,10,26,21,0,0],[2002,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2003,3,29,21,59,59],[2003,3,29,23,59,59] ],
     ],
   2003 =>
     [
        [ [2003,3,29,22,0,0],[2003,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2003,10,25,20,59,59],[2003,10,25,23,59,59] ],
        [ [2003,10,25,21,0,0],[2003,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2004,3,27,21,59,59],[2004,3,27,23,59,59] ],
     ],
   2004 =>
     [
        [ [2004,3,27,22,0,0],[2004,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2004,10,30,20,59,59],[2004,10,30,23,59,59] ],
        [ [2004,10,30,21,0,0],[2004,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2005,3,26,21,59,59],[2005,3,26,23,59,59] ],
     ],
   2005 =>
     [
        [ [2005,3,26,22,0,0],[2005,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2005,10,29,20,59,59],[2005,10,29,23,59,59] ],
        [ [2005,10,29,21,0,0],[2005,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2006,3,25,21,59,59],[2006,3,25,23,59,59] ],
     ],
   2006 =>
     [
        [ [2006,3,25,22,0,0],[2006,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2006,10,28,20,59,59],[2006,10,28,23,59,59] ],
        [ [2006,10,28,21,0,0],[2006,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2007,3,24,21,59,59],[2007,3,24,23,59,59] ],
     ],
   2007 =>
     [
        [ [2007,3,24,22,0,0],[2007,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2007,10,27,20,59,59],[2007,10,27,23,59,59] ],
        [ [2007,10,27,21,0,0],[2007,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2008,3,29,21,59,59],[2008,3,29,23,59,59] ],
     ],
   2008 =>
     [
        [ [2008,3,29,22,0,0],[2008,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2008,10,25,20,59,59],[2008,10,25,23,59,59] ],
        [ [2008,10,25,21,0,0],[2008,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2009,3,28,21,59,59],[2009,3,28,23,59,59] ],
     ],
   2009 =>
     [
        [ [2009,3,28,22,0,0],[2009,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2009,10,24,20,59,59],[2009,10,24,23,59,59] ],
        [ [2009,10,24,21,0,0],[2009,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2010,3,27,21,59,59],[2010,3,27,23,59,59] ],
     ],
   2010 =>
     [
        [ [2010,3,27,22,0,0],[2010,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2010,10,30,20,59,59],[2010,10,30,23,59,59] ],
        [ [2010,10,30,21,0,0],[2010,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2011,3,26,21,59,59],[2011,3,26,23,59,59] ],
     ],
   2011 =>
     [
        [ [2011,3,26,22,0,0],[2011,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2011,10,29,20,59,59],[2011,10,29,23,59,59] ],
        [ [2011,10,29,21,0,0],[2011,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2012,3,24,21,59,59],[2012,3,24,23,59,59] ],
     ],
   2012 =>
     [
        [ [2012,3,24,22,0,0],[2012,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2012,10,27,20,59,59],[2012,10,27,23,59,59] ],
        [ [2012,10,27,21,0,0],[2012,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2013,3,30,21,59,59],[2013,3,30,23,59,59] ],
     ],
   2013 =>
     [
        [ [2013,3,30,22,0,0],[2013,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2013,10,26,20,59,59],[2013,10,26,23,59,59] ],
        [ [2013,10,26,21,0,0],[2013,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2014,3,29,21,59,59],[2014,3,29,23,59,59] ],
     ],
   2014 =>
     [
        [ [2014,3,29,22,0,0],[2014,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2014,10,25,20,59,59],[2014,10,25,23,59,59] ],
        [ [2014,10,25,21,0,0],[2014,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2015,3,28,21,59,59],[2015,3,28,23,59,59] ],
     ],
   2015 =>
     [
        [ [2015,3,28,22,0,0],[2015,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2015,10,24,20,59,59],[2015,10,24,23,59,59] ],
        [ [2015,10,24,21,0,0],[2015,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2016,3,26,21,59,59],[2016,3,26,23,59,59] ],
     ],
   2016 =>
     [
        [ [2016,3,26,22,0,0],[2016,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2016,10,29,20,59,59],[2016,10,29,23,59,59] ],
        [ [2016,10,29,21,0,0],[2016,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2017,3,25,21,59,59],[2017,3,25,23,59,59] ],
     ],
   2017 =>
     [
        [ [2017,3,25,22,0,0],[2017,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2017,10,28,20,59,59],[2017,10,28,23,59,59] ],
        [ [2017,10,28,21,0,0],[2017,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2018,3,24,21,59,59],[2018,3,24,23,59,59] ],
     ],
   2018 =>
     [
        [ [2018,3,24,22,0,0],[2018,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2018,10,27,20,59,59],[2018,10,27,23,59,59] ],
        [ [2018,10,27,21,0,0],[2018,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2019,3,30,21,59,59],[2019,3,30,23,59,59] ],
     ],
   2019 =>
     [
        [ [2019,3,30,22,0,0],[2019,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2019,10,26,20,59,59],[2019,10,26,23,59,59] ],
        [ [2019,10,26,21,0,0],[2019,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2020,3,28,21,59,59],[2020,3,28,23,59,59] ],
     ],
   2020 =>
     [
        [ [2020,3,28,22,0,0],[2020,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2020,10,24,20,59,59],[2020,10,24,23,59,59] ],
        [ [2020,10,24,21,0,0],[2020,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2021,3,27,21,59,59],[2021,3,27,23,59,59] ],
     ],
   2021 =>
     [
        [ [2021,3,27,22,0,0],[2021,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2021,10,30,20,59,59],[2021,10,30,23,59,59] ],
        [ [2021,10,30,21,0,0],[2021,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2022,3,26,21,59,59],[2022,3,26,23,59,59] ],
     ],
   2022 =>
     [
        [ [2022,3,26,22,0,0],[2022,3,27,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2022,10,29,20,59,59],[2022,10,29,23,59,59] ],
        [ [2022,10,29,21,0,0],[2022,10,29,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2023,3,25,21,59,59],[2023,3,25,23,59,59] ],
     ],
   2023 =>
     [
        [ [2023,3,25,22,0,0],[2023,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2023,10,28,20,59,59],[2023,10,28,23,59,59] ],
        [ [2023,10,28,21,0,0],[2023,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2024,3,30,21,59,59],[2024,3,30,23,59,59] ],
     ],
   2024 =>
     [
        [ [2024,3,30,22,0,0],[2024,3,31,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2024,10,26,20,59,59],[2024,10,26,23,59,59] ],
        [ [2024,10,26,21,0,0],[2024,10,26,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2025,3,29,21,59,59],[2025,3,29,23,59,59] ],
     ],
   2025 =>
     [
        [ [2025,3,29,22,0,0],[2025,3,30,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2025,10,25,20,59,59],[2025,10,25,23,59,59] ],
        [ [2025,10,25,21,0,0],[2025,10,25,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2026,3,28,21,59,59],[2026,3,28,23,59,59] ],
     ],
   2026 =>
     [
        [ [2026,3,28,22,0,0],[2026,3,29,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2026,10,24,20,59,59],[2026,10,24,23,59,59] ],
        [ [2026,10,24,21,0,0],[2026,10,24,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2027,3,27,21,59,59],[2027,3,27,23,59,59] ],
     ],
   2027 =>
     [
        [ [2027,3,27,22,0,0],[2027,3,28,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2027,10,30,20,59,59],[2027,10,30,23,59,59] ],
        [ [2027,10,30,21,0,0],[2027,10,30,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2028,3,25,21,59,59],[2028,3,25,23,59,59] ],
     ],
   2028 =>
     [
        [ [2028,3,25,22,0,0],[2028,3,26,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2028,10,28,20,59,59],[2028,10,28,23,59,59] ],
        [ [2028,10,28,21,0,0],[2028,10,28,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2029,3,24,21,59,59],[2029,3,24,23,59,59] ],
     ],
   2029 =>
     [
        [ [2029,3,24,22,0,0],[2029,3,25,1,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[2029,10,27,20,59,59],[2029,10,27,23,59,59] ],
        [ [2029,10,27,21,0,0],[2029,10,27,23,0,0],'+02:00:00',[2,0,0],
          'EET',0,[2030,3,30,21,59,59],[2030,3,30,23,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+03:00:00',
                'stdoff' => '+02:00:00',

               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'EEST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'w',
                         'time'    => '00:00:00',
                         'isdst'   => '0',
                         'abb'     => 'EET',
                        },

               },
);

1;
