package Date::Manip::TZ::atstan00;
# Copyright (c) 2008-2009 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 20 14:19:28 EST 2009
#    Data version: tzdata2009s
#    Code version: tzcode2009r

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::atstan00 - Support for the Atlantic/Stanley time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

use vars qw(%Dates %LastRule);

use vars qw($VERSION);
$VERSION="6.00";

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,20,8,36],'-03:51:24',[-3,-51,-24],
          'LMT',0,[1890,1,1,3,51,23],[1889,12,31,23,59,59] ],
     ],
   1890 =>
     [
        [ [1890,1,1,3,51,24],[1890,1,1,0,0,0],'-03:51:24',[-3,-51,-24],
          'SMT',0,[1912,3,12,3,51,23],[1912,3,11,23,59,59] ],
     ],
   1912 =>
     [
        [ [1912,3,12,3,51,24],[1912,3,11,23,51,24],'-04:00:00',[-4,0,0],
          'FKT',0,[1937,9,26,3,59,59],[1937,9,25,23,59,59] ],
     ],
   1937 =>
     [
        [ [1937,9,26,4,0,0],[1937,9,26,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1938,3,20,2,59,59],[1938,3,19,23,59,59] ],
     ],
   1938 =>
     [
        [ [1938,3,20,3,0,0],[1938,3,19,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1938,9,25,3,59,59],[1938,9,24,23,59,59] ],
        [ [1938,9,25,4,0,0],[1938,9,25,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1939,3,19,2,59,59],[1939,3,18,23,59,59] ],
     ],
   1939 =>
     [
        [ [1939,3,19,3,0,0],[1939,3,18,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1939,10,1,3,59,59],[1939,9,30,23,59,59] ],
        [ [1939,10,1,4,0,0],[1939,10,1,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1940,3,24,2,59,59],[1940,3,23,23,59,59] ],
     ],
   1940 =>
     [
        [ [1940,3,24,3,0,0],[1940,3,23,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1940,9,29,3,59,59],[1940,9,28,23,59,59] ],
        [ [1940,9,29,4,0,0],[1940,9,29,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1941,3,23,2,59,59],[1941,3,22,23,59,59] ],
     ],
   1941 =>
     [
        [ [1941,3,23,3,0,0],[1941,3,22,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1941,9,28,3,59,59],[1941,9,27,23,59,59] ],
        [ [1941,9,28,4,0,0],[1941,9,28,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1942,3,22,2,59,59],[1942,3,21,23,59,59] ],
     ],
   1942 =>
     [
        [ [1942,3,22,3,0,0],[1942,3,21,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1942,9,27,3,59,59],[1942,9,26,23,59,59] ],
        [ [1942,9,27,4,0,0],[1942,9,27,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1943,1,1,2,59,59],[1942,12,31,23,59,59] ],
     ],
   1943 =>
     [
        [ [1943,1,1,3,0,0],[1942,12,31,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1983,5,1,3,59,59],[1983,4,30,23,59,59] ],
     ],
   1983 =>
     [
        [ [1983,5,1,4,0,0],[1983,5,1,1,0,0],'-03:00:00',[-3,0,0],
          'FKT',0,[1983,9,25,2,59,59],[1983,9,24,23,59,59] ],
        [ [1983,9,25,3,0,0],[1983,9,25,1,0,0],'-02:00:00',[-2,0,0],
          'FKST',1,[1984,4,29,1,59,59],[1984,4,28,23,59,59] ],
     ],
   1984 =>
     [
        [ [1984,4,29,2,0,0],[1984,4,28,23,0,0],'-03:00:00',[-3,0,0],
          'FKT',0,[1984,9,16,2,59,59],[1984,9,15,23,59,59] ],
        [ [1984,9,16,3,0,0],[1984,9,16,1,0,0],'-02:00:00',[-2,0,0],
          'FKST',1,[1985,4,28,1,59,59],[1985,4,27,23,59,59] ],
     ],
   1985 =>
     [
        [ [1985,4,28,2,0,0],[1985,4,27,23,0,0],'-03:00:00',[-3,0,0],
          'FKT',0,[1985,9,15,2,59,59],[1985,9,14,23,59,59] ],
        [ [1985,9,15,3,0,0],[1985,9,15,0,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1986,4,20,2,59,59],[1986,4,19,23,59,59] ],
     ],
   1986 =>
     [
        [ [1986,4,20,3,0,0],[1986,4,19,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1986,9,14,3,59,59],[1986,9,13,23,59,59] ],
        [ [1986,9,14,4,0,0],[1986,9,14,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1987,4,19,2,59,59],[1987,4,18,23,59,59] ],
     ],
   1987 =>
     [
        [ [1987,4,19,3,0,0],[1987,4,18,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1987,9,13,3,59,59],[1987,9,12,23,59,59] ],
        [ [1987,9,13,4,0,0],[1987,9,13,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1988,4,17,2,59,59],[1988,4,16,23,59,59] ],
     ],
   1988 =>
     [
        [ [1988,4,17,3,0,0],[1988,4,16,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1988,9,11,3,59,59],[1988,9,10,23,59,59] ],
        [ [1988,9,11,4,0,0],[1988,9,11,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1989,4,16,2,59,59],[1989,4,15,23,59,59] ],
     ],
   1989 =>
     [
        [ [1989,4,16,3,0,0],[1989,4,15,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1989,9,10,3,59,59],[1989,9,9,23,59,59] ],
        [ [1989,9,10,4,0,0],[1989,9,10,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1990,4,22,2,59,59],[1990,4,21,23,59,59] ],
     ],
   1990 =>
     [
        [ [1990,4,22,3,0,0],[1990,4,21,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1990,9,9,3,59,59],[1990,9,8,23,59,59] ],
        [ [1990,9,9,4,0,0],[1990,9,9,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1991,4,21,2,59,59],[1991,4,20,23,59,59] ],
     ],
   1991 =>
     [
        [ [1991,4,21,3,0,0],[1991,4,20,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1991,9,15,3,59,59],[1991,9,14,23,59,59] ],
        [ [1991,9,15,4,0,0],[1991,9,15,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1992,4,19,2,59,59],[1992,4,18,23,59,59] ],
     ],
   1992 =>
     [
        [ [1992,4,19,3,0,0],[1992,4,18,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1992,9,13,3,59,59],[1992,9,12,23,59,59] ],
        [ [1992,9,13,4,0,0],[1992,9,13,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1993,4,18,2,59,59],[1993,4,17,23,59,59] ],
     ],
   1993 =>
     [
        [ [1993,4,18,3,0,0],[1993,4,17,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1993,9,12,3,59,59],[1993,9,11,23,59,59] ],
        [ [1993,9,12,4,0,0],[1993,9,12,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1994,4,17,2,59,59],[1994,4,16,23,59,59] ],
     ],
   1994 =>
     [
        [ [1994,4,17,3,0,0],[1994,4,16,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1994,9,11,3,59,59],[1994,9,10,23,59,59] ],
        [ [1994,9,11,4,0,0],[1994,9,11,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1995,4,16,2,59,59],[1995,4,15,23,59,59] ],
     ],
   1995 =>
     [
        [ [1995,4,16,3,0,0],[1995,4,15,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1995,9,10,3,59,59],[1995,9,9,23,59,59] ],
        [ [1995,9,10,4,0,0],[1995,9,10,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1996,4,21,2,59,59],[1996,4,20,23,59,59] ],
     ],
   1996 =>
     [
        [ [1996,4,21,3,0,0],[1996,4,20,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1996,9,15,3,59,59],[1996,9,14,23,59,59] ],
        [ [1996,9,15,4,0,0],[1996,9,15,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1997,4,20,2,59,59],[1997,4,19,23,59,59] ],
     ],
   1997 =>
     [
        [ [1997,4,20,3,0,0],[1997,4,19,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1997,9,14,3,59,59],[1997,9,13,23,59,59] ],
        [ [1997,9,14,4,0,0],[1997,9,14,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1998,4,19,2,59,59],[1998,4,18,23,59,59] ],
     ],
   1998 =>
     [
        [ [1998,4,19,3,0,0],[1998,4,18,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1998,9,13,3,59,59],[1998,9,12,23,59,59] ],
        [ [1998,9,13,4,0,0],[1998,9,13,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[1999,4,18,2,59,59],[1999,4,17,23,59,59] ],
     ],
   1999 =>
     [
        [ [1999,4,18,3,0,0],[1999,4,17,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[1999,9,12,3,59,59],[1999,9,11,23,59,59] ],
        [ [1999,9,12,4,0,0],[1999,9,12,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2000,4,16,2,59,59],[2000,4,15,23,59,59] ],
     ],
   2000 =>
     [
        [ [2000,4,16,3,0,0],[2000,4,15,23,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2000,9,10,3,59,59],[2000,9,9,23,59,59] ],
        [ [2000,9,10,4,0,0],[2000,9,10,1,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2001,4,15,4,59,59],[2001,4,15,1,59,59] ],
     ],
   2001 =>
     [
        [ [2001,4,15,5,0,0],[2001,4,15,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2001,9,2,5,59,59],[2001,9,2,1,59,59] ],
        [ [2001,9,2,6,0,0],[2001,9,2,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2002,4,21,4,59,59],[2002,4,21,1,59,59] ],
     ],
   2002 =>
     [
        [ [2002,4,21,5,0,0],[2002,4,21,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2002,9,1,5,59,59],[2002,9,1,1,59,59] ],
        [ [2002,9,1,6,0,0],[2002,9,1,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2003,4,20,4,59,59],[2003,4,20,1,59,59] ],
     ],
   2003 =>
     [
        [ [2003,4,20,5,0,0],[2003,4,20,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2003,9,7,5,59,59],[2003,9,7,1,59,59] ],
        [ [2003,9,7,6,0,0],[2003,9,7,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2004,4,18,4,59,59],[2004,4,18,1,59,59] ],
     ],
   2004 =>
     [
        [ [2004,4,18,5,0,0],[2004,4,18,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2004,9,5,5,59,59],[2004,9,5,1,59,59] ],
        [ [2004,9,5,6,0,0],[2004,9,5,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2005,4,17,4,59,59],[2005,4,17,1,59,59] ],
     ],
   2005 =>
     [
        [ [2005,4,17,5,0,0],[2005,4,17,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2005,9,4,5,59,59],[2005,9,4,1,59,59] ],
        [ [2005,9,4,6,0,0],[2005,9,4,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2006,4,16,4,59,59],[2006,4,16,1,59,59] ],
     ],
   2006 =>
     [
        [ [2006,4,16,5,0,0],[2006,4,16,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2006,9,3,5,59,59],[2006,9,3,1,59,59] ],
        [ [2006,9,3,6,0,0],[2006,9,3,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2007,4,15,4,59,59],[2007,4,15,1,59,59] ],
     ],
   2007 =>
     [
        [ [2007,4,15,5,0,0],[2007,4,15,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2007,9,2,5,59,59],[2007,9,2,1,59,59] ],
        [ [2007,9,2,6,0,0],[2007,9,2,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2008,4,20,4,59,59],[2008,4,20,1,59,59] ],
     ],
   2008 =>
     [
        [ [2008,4,20,5,0,0],[2008,4,20,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2008,9,7,5,59,59],[2008,9,7,1,59,59] ],
        [ [2008,9,7,6,0,0],[2008,9,7,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2009,4,19,4,59,59],[2009,4,19,1,59,59] ],
     ],
   2009 =>
     [
        [ [2009,4,19,5,0,0],[2009,4,19,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2009,9,6,5,59,59],[2009,9,6,1,59,59] ],
        [ [2009,9,6,6,0,0],[2009,9,6,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2010,4,18,4,59,59],[2010,4,18,1,59,59] ],
     ],
   2010 =>
     [
        [ [2010,4,18,5,0,0],[2010,4,18,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2010,9,5,5,59,59],[2010,9,5,1,59,59] ],
        [ [2010,9,5,6,0,0],[2010,9,5,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2011,4,17,4,59,59],[2011,4,17,1,59,59] ],
     ],
   2011 =>
     [
        [ [2011,4,17,5,0,0],[2011,4,17,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2011,9,4,5,59,59],[2011,9,4,1,59,59] ],
        [ [2011,9,4,6,0,0],[2011,9,4,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2012,4,15,4,59,59],[2012,4,15,1,59,59] ],
     ],
   2012 =>
     [
        [ [2012,4,15,5,0,0],[2012,4,15,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2012,9,2,5,59,59],[2012,9,2,1,59,59] ],
        [ [2012,9,2,6,0,0],[2012,9,2,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2013,4,21,4,59,59],[2013,4,21,1,59,59] ],
     ],
   2013 =>
     [
        [ [2013,4,21,5,0,0],[2013,4,21,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2013,9,1,5,59,59],[2013,9,1,1,59,59] ],
        [ [2013,9,1,6,0,0],[2013,9,1,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2014,4,20,4,59,59],[2014,4,20,1,59,59] ],
     ],
   2014 =>
     [
        [ [2014,4,20,5,0,0],[2014,4,20,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2014,9,7,5,59,59],[2014,9,7,1,59,59] ],
        [ [2014,9,7,6,0,0],[2014,9,7,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2015,4,19,4,59,59],[2015,4,19,1,59,59] ],
     ],
   2015 =>
     [
        [ [2015,4,19,5,0,0],[2015,4,19,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2015,9,6,5,59,59],[2015,9,6,1,59,59] ],
        [ [2015,9,6,6,0,0],[2015,9,6,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2016,4,17,4,59,59],[2016,4,17,1,59,59] ],
     ],
   2016 =>
     [
        [ [2016,4,17,5,0,0],[2016,4,17,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2016,9,4,5,59,59],[2016,9,4,1,59,59] ],
        [ [2016,9,4,6,0,0],[2016,9,4,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2017,4,16,4,59,59],[2017,4,16,1,59,59] ],
     ],
   2017 =>
     [
        [ [2017,4,16,5,0,0],[2017,4,16,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2017,9,3,5,59,59],[2017,9,3,1,59,59] ],
        [ [2017,9,3,6,0,0],[2017,9,3,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2018,4,15,4,59,59],[2018,4,15,1,59,59] ],
     ],
   2018 =>
     [
        [ [2018,4,15,5,0,0],[2018,4,15,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2018,9,2,5,59,59],[2018,9,2,1,59,59] ],
        [ [2018,9,2,6,0,0],[2018,9,2,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2019,4,21,4,59,59],[2019,4,21,1,59,59] ],
     ],
   2019 =>
     [
        [ [2019,4,21,5,0,0],[2019,4,21,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2019,9,1,5,59,59],[2019,9,1,1,59,59] ],
        [ [2019,9,1,6,0,0],[2019,9,1,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2020,4,19,4,59,59],[2020,4,19,1,59,59] ],
     ],
   2020 =>
     [
        [ [2020,4,19,5,0,0],[2020,4,19,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2020,9,6,5,59,59],[2020,9,6,1,59,59] ],
        [ [2020,9,6,6,0,0],[2020,9,6,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2021,4,18,4,59,59],[2021,4,18,1,59,59] ],
     ],
   2021 =>
     [
        [ [2021,4,18,5,0,0],[2021,4,18,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2021,9,5,5,59,59],[2021,9,5,1,59,59] ],
        [ [2021,9,5,6,0,0],[2021,9,5,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2022,4,17,4,59,59],[2022,4,17,1,59,59] ],
     ],
   2022 =>
     [
        [ [2022,4,17,5,0,0],[2022,4,17,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2022,9,4,5,59,59],[2022,9,4,1,59,59] ],
        [ [2022,9,4,6,0,0],[2022,9,4,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2023,4,16,4,59,59],[2023,4,16,1,59,59] ],
     ],
   2023 =>
     [
        [ [2023,4,16,5,0,0],[2023,4,16,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2023,9,3,5,59,59],[2023,9,3,1,59,59] ],
        [ [2023,9,3,6,0,0],[2023,9,3,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2024,4,21,4,59,59],[2024,4,21,1,59,59] ],
     ],
   2024 =>
     [
        [ [2024,4,21,5,0,0],[2024,4,21,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2024,9,1,5,59,59],[2024,9,1,1,59,59] ],
        [ [2024,9,1,6,0,0],[2024,9,1,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2025,4,20,4,59,59],[2025,4,20,1,59,59] ],
     ],
   2025 =>
     [
        [ [2025,4,20,5,0,0],[2025,4,20,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2025,9,7,5,59,59],[2025,9,7,1,59,59] ],
        [ [2025,9,7,6,0,0],[2025,9,7,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2026,4,19,4,59,59],[2026,4,19,1,59,59] ],
     ],
   2026 =>
     [
        [ [2026,4,19,5,0,0],[2026,4,19,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2026,9,6,5,59,59],[2026,9,6,1,59,59] ],
        [ [2026,9,6,6,0,0],[2026,9,6,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2027,4,18,4,59,59],[2027,4,18,1,59,59] ],
     ],
   2027 =>
     [
        [ [2027,4,18,5,0,0],[2027,4,18,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2027,9,5,5,59,59],[2027,9,5,1,59,59] ],
        [ [2027,9,5,6,0,0],[2027,9,5,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2028,4,16,4,59,59],[2028,4,16,1,59,59] ],
     ],
   2028 =>
     [
        [ [2028,4,16,5,0,0],[2028,4,16,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2028,9,3,5,59,59],[2028,9,3,1,59,59] ],
        [ [2028,9,3,6,0,0],[2028,9,3,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2029,4,15,4,59,59],[2029,4,15,1,59,59] ],
     ],
   2029 =>
     [
        [ [2029,4,15,5,0,0],[2029,4,15,1,0,0],'-04:00:00',[-4,0,0],
          'FKT',0,[2029,9,2,5,59,59],[2029,9,2,1,59,59] ],
        [ [2029,9,2,6,0,0],[2029,9,2,3,0,0],'-03:00:00',[-3,0,0],
          'FKST',1,[2030,4,21,4,59,59],[2030,4,21,1,59,59] ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-03:00:00',
                'stdoff' => '-04:00:00',

               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '15',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'FKT',
                        },
                '09' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'FKST',
                        },

               },
);

1;
