use strict;
use Test::More tests => 3324;
use RTF::Tokenizer;

my $DEBUG  = 0;
my @tokens = (
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '0' ],
    [ 'control', 'irowband',        '-1' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '17' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clcbpatraw',      '17' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '17' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clcbpatraw',      '17' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'tscfirstrow',     '' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'b',               '' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'Header 1',        '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'tscfirstrow',     '' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'b',               '' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'Header 2',        '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '0' ],
    [ 'control', 'irowband',        '-1' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '17' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clcbpatraw',      '17' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '17' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clcbpatraw',      '17' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'row',             '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '1' ],
    [ 'control', 'irowband',        '0' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'A1',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'text',    'B1',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '1' ],
    [ 'control', 'irowband',        '0' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'row',             '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '2' ],
    [ 'control', 'irowband',        '1' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'tscbandhorzeven', '' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'A2',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'tscbandhorzeven', '' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'B2',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '2' ],
    [ 'control', 'irowband',        '1' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'row',             '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '3' ],
    [ 'control', 'irowband',        '2' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'A3',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'text',    'B3',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '3' ],
    [ 'control', 'irowband',        '2' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clshdrawnil',     '' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'row',             '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '4' ],
    [ 'control', 'irowband',        '3' ],
    [ 'control', 'lastrow',         '' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'tscbandhorzeven', '' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'A4',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'tscbandhorzeven', '' ],
    [ 'control', 'yts',             '18' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'text',    'B4',              '' ],
    [ 'control', 'cell',            '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'plain',           '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'intbl',           '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'fs',              '24' ],
    [ 'control', 'lang',            '1033' ],
    [ 'control', 'langfe',          '1033' ],
    [ 'control', 'cgrid',           '' ],
    [ 'control', 'langnp',          '1033' ],
    [ 'control', 'langfenp',        '1033' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '353782' ],
    [ 'control', 'trowd',           '' ],
    [ 'control', 'irow',            '4' ],
    [ 'control', 'irowband',        '3' ],
    [ 'control', 'lastrow',         '' ],
    [ 'control', 'ts',              '18' ],
    [ 'control', 'trgaph',          '108' ],
    [ 'control', 'trleft',          '-108' ],
    [ 'control', 'trbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrh',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trbrdrv',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'trftsWidth',      '1' ],
    [ 'control', 'trftsWidthB',     '3' ],
    [ 'control', 'trftsWidthA',     '3' ],
    [ 'control', 'trautofit',       '1' ],
    [ 'control', 'trpaddl',         '108' ],
    [ 'control', 'trpaddr',         '108' ],
    [ 'control', 'trpaddfl',        '3' ],
    [ 'control', 'trpaddft',        '3' ],
    [ 'control', 'trpaddfb',        '3' ],
    [ 'control', 'trpaddfr',        '3' ],
    [ 'control', 'tscbandsh',       '1' ],
    [ 'control', 'tbllkhdrrows',    '' ],
    [ 'control', 'tbllklastrow',    '' ],
    [ 'control', 'tbllkhdrcols',    '' ],
    [ 'control', 'tbllklastcol',    '' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3208' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '3100' ],
    [ 'control', 'clvertalt',       '' ],
    [ 'control', 'clbrdrt',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrl',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrb',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clbrdrr',         '' ],
    [ 'control', 'brdrs',           '' ],
    [ 'control', 'brdrw',           '10' ],
    [ 'control', 'clcbpat',         '18' ],
    [ 'control', 'cltxlrtb',        '' ],
    [ 'control', 'clftsWidth',      '3' ],
    [ 'control', 'clwWidth',        '3207' ],
    [ 'control', 'clcbpatraw',      '18' ],
    [ 'control', 'cellx',           '6307' ],
    [ 'control', 'row',             '' ],
    [ 'group',   '0',               '' ],
    [ 'control', 'pard',            '' ],
    [ 'control', 'ql',              '' ],
    [ 'control', 'li',              '0' ],
    [ 'control', 'ri',              '0' ],
    [ 'control', 'widctlpar',       '' ],
    [ 'control', 'aspalpha',        '' ],
    [ 'control', 'aspnum',          '' ],
    [ 'control', 'faauto',          '' ],
    [ 'control', 'adjustright',     '' ],
    [ 'control', 'rin',             '0' ],
    [ 'control', 'lin',             '0' ],
    [ 'control', 'itap',            '0' ],
    [ 'group',   '1',               '' ],
    [ 'control', 'insrsid',         '14034704' ],
    [ 'control', 'par',             '' ],
    [ 'group',   '0',               '' ],
    [ 'eof',     '1',               '0' ], );

my $tokenizer = RTF::Tokenizer->new();

# Reading from DATA with read_file() causes all kinds of oddness
$tokenizer->read_string( join '', <DATA> );

if ($DEBUG) {
    while (1) {
        my ( $type, $argument, $param ) = $tokenizer->get_token();
        print "['$type', '$argument', '$param'],\n";
        exit if $type eq 'eof';
    }
} else {

    for (@tokens) {

        my ( $ret_type, $ret_argument, $ret_parameter ) = @{$_};
        my ( $type, $argument, $param ) = $tokenizer->get_token();

        is( $type,     $ret_type,      "Correctly found '$type'" );
        is( $argument, $ret_argument,  "Correctly found '$argument'" );
        is( $param,    $ret_parameter, "Correctly found '$param'" );

    }

}

__DATA__
\trowd \irow0\irowband-1\ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat17\cltxlrtb\clftsWidth3\clwWidth3208\clcbpatraw17 \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat17\cltxlrtb\clftsWidth3\clwWidth3207\clcbpatraw17 \cellx6307\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\tscfirstrow\yts18 \b\fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 Header 1\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\tscfirstrow\yts18 \b\fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 Header 2\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 \trowd \irow0\irowband-1 \ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat17\cltxlrtb\clftsWidth3\clwWidth3208\clcbpatraw17 \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat17\cltxlrtb\clftsWidth3\clwWidth3207\clcbpatraw17 \cellx6307\row }\trowd \irow1\irowband0\ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3208\clshdrawnil \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3207\clshdrawnil \cellx6307\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\yts18 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 A1\cell B1\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 \trowd \irow1\irowband0\ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3208\clshdrawnil \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3207\clshdrawnil \cellx6307\row }\trowd \irow2\irowband1\ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3208\clcbpatraw18 \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3207\clcbpatraw18 \cellx6307\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\tscbandhorzeven\yts18 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 A2\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\tscbandhorzeven\yts18 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 B2\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 \trowd \irow2\irowband1\ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3208\clcbpatraw18 \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3207\clcbpatraw18 \cellx6307\row }\trowd \irow3\irowband2\ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3208\clshdrawnil \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3207\clshdrawnil \cellx6307\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\yts18 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 A3\cell B3\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 \trowd \irow3\irowband2\ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3208\clshdrawnil \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \cltxlrtb\clftsWidth3\clwWidth3207\clshdrawnil \cellx6307\row }\trowd \irow4\irowband3\lastrow \ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3208\clcbpatraw18 \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3207\clcbpatraw18 \cellx6307\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\tscbandhorzeven\yts18 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 A4\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0\tscbandhorzeven\yts18 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 B4\cell }\pard\plain \ql \li0\ri0\widctlpar\intbl\aspalpha\aspnum\faauto\adjustright\rin0\lin0 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 {\insrsid353782 \trowd \irow4\irowband3\lastrow \ts18\trgaph108\trleft-108\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidth1\trftsWidthB3\trftsWidthA3\trautofit1\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tbllkhdrrows\tbllklastrow\tbllkhdrcols\tbllklastcol \clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3208\clcbpatraw18 \cellx3100\clvertalt\clbrdrt\brdrs\brdrw10 \clbrdrl\brdrs\brdrw10 \clbrdrb\brdrs\brdrw10 \clbrdrr\brdrs\brdrw10 \clcbpat18\cltxlrtb\clftsWidth3\clwWidth3207\clcbpatraw18 \cellx6307\row }\pard \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 {\insrsid14034704 \par }
