#!/usr/bin/perl
#
# Name:
#	cgi.app.gen.pl.

use strict;
use warnings;

use Getopt::Long;
use Pod::Usage;
use CGI::Application::Bouquet::Rose;

# -------------------------------------------------

my($option_parser) = Getopt::Long::Parser -> new();

my(%option);

if ($option_parser -> getoptions(\%option, 'docroot=s', 'exclude:s', 'help', 'module=s', 'output_dir:s', 'remove', 'tmpl_path:s', 'verbose') )
{
	pod2usage(1) if ($option{'help'});

	exit CGI::Application::Bouquet::Rose -> new(\%option) -> run();
}
else
{
	pod2usage(2);
}

__END__

=pod

=head1 NAME

cgi.app.gen.pl - Generate a set of CGI::Application- and CGI::Application::Dispatch-based classes

=head1 SYNOPSIS

cgiapp.pl [options]

	Options:
	-docroot The optional path to the web server's doc root
	-exclude An optional regexp of table names to exclude
	-help
	-module A mandatory module name, e.g. Local::Wine
	-output_dir The optional path to the output dir
	-remove
	-tmpl_path The optional path to CGI::Application::Bouquet::Rose's template directory
	-verbose

Exit value: 0.

Note: HTML::Template is used as the template processor.

Typical usage:

Download http://savage.net.au/Perl/Local-Wine-1.06.tgz
	
	shell> cd /home/yourself/perl.modules
	shell> tar xvzf Local-Wine-1.06.tgz
	shell> less README

or examine the documentation for CGI::Application::Bouquet::Rose.

=head1 OPTIONS

=over 4

=item -docroot The optional path to the web server's doc root

The path to the web server's doc root.

If not specified, the value defaults to the value in lib/CGI/Application/Bouquet/Rose/.htcgi.bouquet.conf.

The option defaults to /home/ron/httpd/prefork/htdocs.

Several templates are copied to a directory below this point.

Specifically, if docroot is /var/www/html, say, then this directory is
created: /var/www/html/assets/templates/, and then below that the value of -module
(below) is converted into lower case and appended. So Local::Module would mean adding
local/module/.

Finally, these template are copied into that directory:

=over 4

=item content.tmpl

=item main.menu.tmpl

=item search.form.tmpl

=item web.page.tmpl

=back

Lastly, the output file CGIApp.pm has a call to
tmpl_path('/var/www/html/assets/templates/local/module')
inserted into its code.

This allows for /var/www/html/assets/css/ and /var/www/html/assets/js/ at a later date.

This option is optional.

=item -exclude aRegExp

A regexp (without the //) of table names to exclude

If not specified, the value defaults to the value in lib/CGI/Application/Bouquet/Rose/.htcgi.bouquet.conf.

The default value is ^(?:pg_|sql_), which suits users of Postgres.

This option is optional.

=item -help

Print help and exit.

=item -module A module name, e.g. Local::Wine

Generate a set of modules under this name. So, Local::Wine would result in:

=over 4

=item ./lib/Local/Wine/CGIApp.pm

=item ./lib/Local/Wine/Dispatcher.pm

=item ./lib/Local/Wine/MainMenu.pm

=item ./lib/Local/Wine/CGIApp/*.pm (1 per table)

=back

This option defaults to 'Local::Wine', because the CGI::Application::Bouquet::Rose distro
uses the Local::Wine distro in all its documentation. See examples/Local-Wine-1.06.tgz.

This option is mandatory.

=item -output_dir The optional path to the output dir

The path is where the output modules will be written.

If not specified, the value defaults to the value in lib/CGI/Application/Bouquet/Rose/.htcgi.bouquet.conf.

The option defaults to ./lib.

See the discussion of -module above for more information.

This option is optional.

=item -remove

Remove files generated by an earlier run of this program.

The default value is 0, meaning do not remove files.

This option is optional.

=item -tmpl_path aPath

The optional path to CGI::Application::Bouquet::Rose's template directory

If not specified, the value defaults to the value in lib/CGI/Application/Bouquet/Rose/.htcgi.bouquet.conf.

The option defaults to ./templates.

This option is optional.

=item -verbose

Print verbose messages.

If not specified, the value defaults to the value in lib/CGI/Application/Bouquet/Rose/.htcgi.bouquet.conf.

The default value is 0.

=back

=head1 DESCRIPTION

cgi.app.gen.pl generates a set of CGI::Application- and CGI::Application::Dispatch-based classes.

=cut
