use warnings;
use strict;

use inc::Module::Install '1.01';

use 5.006002;

all_from 'lib/OS/ABI/Constants.pm';

requires 'Sys::Info' => '0.78';

if (my $cc = can_cc) {
  gen_my_abi($cc);
}
### FIXME - temporary, for the duration of the survey
else {
  die "The survey stage requires a compiler\n";
}

# these are also temporary
test_requires 'MIME::Base64' => 0;
test_requires 'IO::Compress::Bzip2' => 0;
test_requires 'Storable' => 0;

resources 'repository'  => 'http://github.com/ribasushi/OS-ABI-Constants';

WriteAll;

sub gen_my_abi {
  my $cc = shift;

  warn "C compiler detected - gathering ABI constants from your system\n";
  my $abi = examine_abi($cc);

  my $fn = 'lib/OS/ABI/MyConstants.pm';
  unlink $fn; # don't care if there or not

  if (grep { keys %$_ } values %$abi) {
    warn "Writing constants to $fn\n";

    open (my $fh, '>', $fn) or die "Unable to open $fn: $!\n";

    require Data::Dumper;
    my $cdump = Data::Dumper->new([$abi])->Indent(1)->Useqq(1)->Terse(1)->Quotekeys(0)->Sortkeys(1)->Pad('  ')->Dump;
    my $ver = time();
    my $ver_comment = gmtime;

    print $fh <<EOC;
#############################################################
###                                                       ###
###    FILE AUTOGENERATED AT THE TIME OF INSTALLATION     ###
###                    DO NOT EDIT!!!                     ###
###                                                       ###
### If your system has changed drastically since - simply ###
### reinstall OS::ABI::Constants                          ###
###                                                       ###
#############################################################

package # not the package you are looking for
  OS::ABI::MyConstants;

use warnings;
use strict;

our \$VERSION = $ver; # $ver_comment

sub constants { return
$cdump}

1;

EOC

  }
  else {
    warn "No constants returned by ABI examination - skipping creatioin of $fn\n";
  }
}

sub examine_abi {
  my $cc = shift;

  require IO::Handle;
  require IPC::Open3;
  require B;
  require Config;
  require Data::Dumper;

  my $examine = {
    time => {
      headers => {
        generic => [ $Config::Config{timeincl} ? split / /, $Config::Config{timeincl} : 'time.h' ],
        linux => [qw| linux/time.h time.h |],
      },
      defs => qr/
        ITIMER_\w+ | CLOCK_\w+
      /x,
    },
    # not everything implements syscall()
    ! $Config::Config{d_syscall} ? () : ( syscall => {
      headers => {
        generic => 'syscall.h',
      },
      defs => qr/
        SYS_[a-z]\w+
      /x,
    }),
    # others...?
  };

  my $my_abi;

  for my $type (keys %$examine) {
    $my_abi->{$type} = {};

    my $qr = sprintf '^ \#define \s+ ( %s ) \s+ \S', $examine->{$type}{defs};
    $qr = qr/$qr/x;

    my $h = $examine->{$type}{headers};
    $h = ( $h->{$^O} || $h->{generic} );

    my $c_src;
    for (ref $h eq 'ARRAY' ? @$h : $h) {
      $c_src .= sprintf "#include %s\n", $_ =~ m|^/| ? qq|"$_"| : "<$_>";
    }

    my %io = map { $_ => IO::Handle->new } qw/i o e/;
    my @args = qw/-E -dD -/;
    my $pid = IPC::Open3::open3 (@io{qw/i o e/}, $cc, @args)
      or die "Unable to start $cc @args";

    $io{i}->print( $c_src );
    $io{i}->close;

    my @consts = map { $_ =~ $qr ? $1 : () } $io{o}->getlines;
    wait;
    warn "$cc @args exited with status $?\n" if $?;

    next unless @consts;

    $my_abi->{$type}{$_} = undef for @consts;

    $c_src .= "int main (void)\n{\n";
    $c_src .= "'$_' => \n__VALUE__START__\n$_\n__VALUE__END__\n,\n" for @consts;  # the 
    $c_src .= "}\n";

    @args = qw/-E -/;
    $pid = IPC::Open3::open3 (@io{qw/i o e/}, $cc, @args)
      or die "Unable to run $cc @args";

    $io{i}->print( $c_src );
    $io{i}->close;

    my ($resolved) = do {
      local $/;
      my $preprocessed = $io{o}->getline;
      $preprocessed =~ s/ \n__VALUE__START__\n (.+?) \n__VALUE__END__\n /B::perlstring($1)/egxms;
      $preprocessed =~ /^int \s main \s \(void\) \n ( \{ .+? \} ) $/xms;
    };
    wait;
    warn "$cc @args exited with status $?\n" if $?;

    $my_abi->{$type} = eval $resolved or die "Unable to eval preprocessed pseudo-source:\n$@";
  }

  $my_abi;
}
