
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Module/App to build and test OTRS packages",
  "AUTHOR" => "Renee Baecker <module\@renee-baecker.de>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "OTRS-OPM-Maker",
  "EXE_FILES" => [
    "bin/opmbuild"
  ],
  "LICENSE" => "artistic_2",
  "NAME" => "OTRS::OPM::Maker",
  "PREREQ_PM" => {
    "App::Cmd" => 0,
    "File::Basename" => 0,
    "File::Find::Rule" => 0,
    "Getopt::Long" => 0,
    "MIME::Base64" => 0,
    "Path::Class" => 0,
    "Sys::Hostname" => 0,
    "XML::LibXML" => 0,
    "XML::LibXML::PrettyPrint" => 0
  },
  "VERSION" => "0.05",
  "test" => {
    "TESTS" => ""
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



