package Net::FullAuto::ISets::Amazon::Chaining_is;

### OPEN SOURCE LICENSE - GNU AFFERO PUBLIC LICENSE Version 3.0 #######
#
#    Net::FullAuto - Powerful Network Process Automation Software
#    Copyright © 2000-2015  Brian M. Kelly
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Affero General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but **WITHOUT ANY WARRANTY**; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Affero General Public License for more details.
#
#    You should have received a copy of the GNU Affero General Public
#    License along with this program.  If not, see:
#    <http://www.gnu.org/licenses/agpl.html>.
#
#######################################################################


our $VERSION='0.01';
our $DISPLAY='FullAuto© Proxy Chaining & RESTful Access';
our $CONNECT='secure';
our $defaultInstanceType='t2.small';

use 5.005;


use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw($select_chaining_setup);

use Net::FullAuto::Cloud::fa_amazon;
use Net::FullAuto::FA_Core qw[cmd_raw];

my $configure_chaining=sub {

   my $server_type=$_[0];
   my $cnt=$_[1];
   my $selection=$_[2]||'';
   my $handle=$main::aws->{$server_type}->[$cnt]->[1];
   my ($stdout,$stderr)=('','');
   ($stdout,$stderr)=$handle->cmd("sudo yum clean all");
   ($stdout,$stderr)=$handle->cmd("sudo yum grouplist hidden");
   ($stdout,$stderr)=$handle->cmd("sudo yum groups mark convert");
   ($stdout,$stderr)=$handle->cmd(
      "sudo yum -y groupinstall 'Development tools'",'__display__');
   ($stdout,$stderr)=$handle->cmd(
      'sudo yum -y install openssl-devel icu cyrus-sasl'.
      ' libicu cyrus-sasl-devel libtool-ltdl-devel libxml2-devel'.
      ' freetype-devel libpng-devel',
      '__display__');
   ($stdout,$stderr)=$handle->cmd('sudo yum -y install cpan',
      '__display__');
   $handle->{_cmd_handle}->print('sudo cpan');
   my $prompt=substr($handle->{_cmd_handle}->prompt(),1,-1);
   while (1) {
      my $output.=Net::FullAuto::FA_Core::fetch($handle);
      last if $output=~/$prompt/;
      print $output;
      if (-1<index $output,'possible automatically') {
         $handle->{_cmd_handle}->print('yes');
         $output='';
         next;
      } elsif (-1<index $output,'by bootstrapping') {
         $handle->{_cmd_handle}->print('sudo');
         $output='';
         next;
      } elsif (-1<index $output,'some CPAN') {
         $handle->{_cmd_handle}->print('no');
         $output='';
         next;
      } elsif (-1<index $output,'pick from') {
         $handle->{_cmd_handle}->print('no');
         $output='';
         next;
      } elsif (-1<index $output,'CPAN site') {
         $handle->{_cmd_handle}->print('http://www.cpan.org');
         $output='';
         next;
      } elsif (-1<index $output,'ENTER to quit') {
         $handle->{_cmd_handle}->print();
         $output='';
         next;
      } elsif ($output=~/cpan[[]\d+[]][>]/) {
         $handle->{_cmd_handle}->print('bye');
         next;
      }
   }
   ($stdout,$stderr)=$handle->cmd("export PERL_MM_USE_DEFAULT=1");
   my $show=<<END;
########################################

   INSTALLING ExtUtils::Embed

########################################
END
   #print $show;
   #cmd_raw($handle,
   #   'sudo perl -MCPAN -e \'CPAN::Shell->force('.
   #   '"install","ExtUtils::Embed")\'',
   #   '__display__');
   my @cpan_modules = qw(

      CPAN::Meta
      ExtUtils::ParseXS
      Package::Generator
      Test::Output
      Compress::Raw::Bzip2
      IO::Compress::Bzip2
      Package::Anon
      Text::Diff
      Archive::Tar
      Archive::Zip
      inc::latest
      PAR::Dist
      Regexp::Common
      Pod::Checker
      Pod::Parser
      Pod::Man
      File::Slurp
      Test::Taint
      Test::Warnings
      Test::Without::Module
      Devel::LexAlias
      BSD::Resource
      IPC::System::Simple
      Sub::Identify
      Fatal
      Sub::Name
      Role::Tiny
      Test::LeakTrace
      Test::CleanNamespaces
      Test::Pod
      Test::Pod::Coverage
      Class::Load
      Class::Load::XS
      Algorithm::C3
      SUPER
      Module::Refresh
      Declare::Constraints::Simple
      Devel::Cycle
      CGI
      Test::Memory::Cycle
      IO::String
      Mouse::Tiny
      DateTime::Format::MySQL
      Moose
      Moo
      MooseX::Role::WithOverloading
      Pod::Coverage::Moose
      MooseX::AttributeHelpers
      MooseX::ConfigFromFile
      MooseX::MarkAsMethods
      MooseX::SimpleConfig
      MooseX::StrictConstructor 
      MooseX::NonMoose
      Net::FullAuto
      Business::ISBN
      App::FatPacker
      JSON
      JSON::XS
      Test::DistManifest
      Term::Size::Any
      Type::Tiny
      File::ReadBackwards
      Imager
      IO::CaptureOutput
      Astro::MoonPhase
      Date::Manip
      XML::LibXML
      SQL::Translator
      Template::Alloy
      URI::Amazon::APA 
      TheSchwartz
      Devel::CheckLib
      Catalyst::Runtime
      Proc::ProcessTable
      Parallel::Forker

   );
   my $install_chaining=<<'END';

          o o    o .oPYo. ooooo    .oo o     o     o o    o .oPYo.
          8 8b   8 8        8     .P 8 8     8     8 8b   8 8    8
          8 8`b  8 `Yooo.   8    .P  8 8     8     8 8`b  8 8
          8 8 `b 8     `8   8   oPooo8 8     8     8 8 `b 8 8   oo
          8 8  `b8      8   8  .P    8 8     8     8 8  `b8 8    8
          8 8   `8 `YooP'   8 .P     8 8oooo 8oooo 8 8   `8 `YooP8
          ........................................................
          ::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                     _
                   ((_)
                    /
                   /              _        _           _
               \__/_     ___ __ _| |_ __ _| |_   _ ___| |_
               /    \   / __/ _` | __/ _` | | | | / __| __|  Perl MVC
            _- |    |  | (_| (_| | || (_| | | |_| \__ \ |    framework
       _ _-'   \____/   \___\__,_|\__\__,_|_|\__, |___/\__|©
     ((_)       ---\                         |___/
                    \
                     \\_          Web Framework
                      (_)

     (Catalyst Foundation is **NOT** a sponsor of the FullAuto© Project.)
END
   foreach my $module (@cpan_modules) {
      next if $module=~/^\s*#/;
      my $show=<<END;
########################################

   INSTALLING $module

########################################
END
      sleep 1;
      print $show;
      if ($module eq 'Catalyst::Runtime') {
         print $install_chaining;
         sleep 10;
      }
      cmd_raw($handle,"sudo cpan $module",'__display__');
   }
   $show=<<END;
########################################

   INSTALLING Regexp::Assemble

########################################
END
   print $show;
   cmd_raw($handle,
      'sudo perl -MCPAN -e \'CPAN::Shell->force('.
      '"install","Regexp::Assemble")\'',
      '__display__');
   $show=<<END;
########################################

   INSTALLING Catalyst::Devel

########################################
END
   print $show;
   $handle->{_cmd_handle}->print('sudo cpan Catalyst::Devel');
   $prompt=substr($handle->{_cmd_handle}->prompt(),1,-1);
   while (1) {
      my $output.=Net::FullAuto::FA_Core::fetch($handle);
      last if $output=~/$prompt/;
      print $output;
      if (-1<index $output,'XS Stash module?') {
         $handle->{_cmd_handle}->print('Y');
         $output='';
         next;
      }
      if (-1<index $output,'XS Stash by default?') {
         $handle->{_cmd_handle}->print('Y');
         $output='';
         next;
      }
   }
   $show=<<END;
########################################

   INSTALLING Catalyst::Controller::HTML::FormFu

########################################
END
   cmd_raw($handle,'sudo cpan Catalyst::Controller::HTML::FormFu',
      '__display__');
   $show=<<END;
########################################

   INSTALLING Task::Catalyst::Tutorial

########################################
END
   print $show;
   sleep 1;
   cmd_raw($handle,'sudo cpan Task::Catalyst::Tutorial','__display__');
   $show=<<END;
########################################

   INSTALLING DBIx::Class::Schema::Loader

########################################
END
   cmd_raw($handle,'sudo cpan DBIx::Class::Schema::Loader',
      '__display__');
   $show=<<END;
########################################

   INSTALLING YAML::Syck

########################################
END
   print $show;
   sleep 1;
   cmd_raw($handle,'sudo cpan YAML::Syck','__display__');
   $show=<<END;
########################################

   INSTALLING Catalyst::Controller::REST

########################################
END
   print $show;
   sleep 1;
   cmd_raw($handle,'sudo cpan Catalyst::Controller::REST','__display__');
   $show=<<END;
########################################

   INSTALLING Catalyst::Model::Adaptor

########################################
END
   print $show;
   sleep 1;
   cmd_raw($handle,'sudo cpan Catalyst::Model::Adaptor','__display__');
   $show=<<END;
########################################

   INSTALLING Catalyst::View::JSON

########################################
END
   print $show;
   sleep 1;
   cmd_raw($handle,'sudo cpan Catalyst::View::JSON','__display__');
   $show=<<END;
   $show=<<END;
########################################

   INSTALLING Catalyst::View::TT::Alloy

########################################
END
   print $show;
   sleep 1;
   cmd_raw($handle,'sudo cpan Catalyst::View::TT::Alloy','__display__');
   $show=<<END;
########################################

   INSTALLING Catalyst::Plugin::Unicode

########################################
END
   print $show;
   sleep 1;
   cmd_raw($handle,'sudo cpan Catalyst::Plugin::Unicode','__display__');
   $show=<<END;
########################################

   INSTALLING Finance::Quote

########################################
END
   print $show;
   $handle->{_cmd_handle}->print('sudo cpan Finance::Quote');
   $prompt=substr($handle->{_cmd_handle}->prompt(),1,-1);
   while (1) {
      my $output.=Net::FullAuto::FA_Core::fetch($handle);
      last if $output=~/$prompt/;
      print $output;
      if (-1<index $output,'traffic to external sites') {
         $handle->{_cmd_handle}->print('Y');
         $output='';
         next;
      }
      if (-1<index $output,'have network connectivity. [n]') {
         $handle->{_cmd_handle}->print('y');
         $output='';
         next;
      }
   }
   ($stdout,$stderr)=$handle->cmd("catalyst.pl Hello",'__display__');
   ($stdout,$stderr)=$handle->cwd("Hello");
   ($stdout,$stderr)=$handle->cmd("perl Makefile.PL",'__display__');
   #$handle->{_cmd_handle}->print(
   #   'script/hello_server.pl --background');
   #$prompt=substr($handle->{_cmd_handle}->prompt(),1,-1);
   #while (1) {
   #   my $output.=Net::FullAuto::FA_Core::fetch($handle);
   #   last if $output=~/$prompt/;
   #   print $output;
   #   if (-1<index $output,'| /end') {
   #      $output=Net::FullAuto::FA_Core::fetch($handle);
   #      print $output;
   #      last;
   #   }
   #}
   ($stdout,$stderr)=$handle->cwd("..");
   ($stdout,$stderr)=$handle->cmd("catalyst.pl AdventREST",'__display__');
   ($stdout,$stderr)=$handle->cwd("AdventREST");
   ($stdout,$stderr)=$handle->cmd("perl Makefile.PL",'__display__');
   ($stdout,$stderr)=$handle->cmd("mkdir -v db lib/AdventREST/Schema",
      '__display__');
   my $db_sql="db.sql";
   my $content=<<'END';
CREATE TABLE user (
 user_id TYPE text NOT NULL PRIMARY KEY,
 fullname TYPE text NOT NULL,
 description TYPE text NOT NULL
); 
END
   ($stdout,$stderr)=$handle->cmd("touch $db_sql");
   ($stdout,$stderr)=$handle->cmd("chmod -v 777 $db_sql",'__display__');
   ($stdout,$stderr)=$handle->cmd("echo \"$content\" > $db_sql");
   ($stdout,$stderr)=$handle->cmd("chmod -v 644 $db_sql",'__display__');
   #($stdout,$stderr)=$handle->cmd('sqlite3 db/adventrest.db < db.sql');
   ($stdout,$stderr)=$handle->cwd('db');
   ($stdout,$stderr)=$handle->cmd(
      "wget --random-wait --progress=dot ".
      "http://dev.catalyst.perl.org/repos/Catalyst/trunk/".
      "examples/RestYUI/db/adventrest.db",
      '__display__');
   ($stdout,$stderr)=$handle->cwd("../lib/AdventREST");
   $content=<<'END';
#
# AdventREST::Schema.pm
#
 
package AdventREST::Schema;
use base qw/DBIx::Class::Schema/;
 
__PACKAGE__->load_classes(qw/User/);
 
1;
END
   ($stdout,$stderr)=$handle->cmd("touch Schema.pm");
   ($stdout,$stderr)=$handle->cmd("chmod -v 777 Schema.pm",'__display__');
   ($stdout,$stderr)=$handle->cmd("echo \"$content\" > Schema.pm");
   ($stdout,$stderr)=$handle->cmd("chmod -v 644 Schema.pm",'__display__');
   $content=<<'END';
package AdventREST::Schema::User;
 
use base qw/DBIx::Class/;
__PACKAGE__->load_components(qw/Core/);
__PACKAGE__->table('user');
__PACKAGE__->add_columns(qw/user_id fullname description/);
__PACKAGE__->set_primary_key('user_id');
 
1;
END
   ($stdout,$stderr)=$handle->cwd("Schema");
   ($stdout,$stderr)=$handle->cmd("touch User.pm");
   ($stdout,$stderr)=$handle->cmd("chmod -v 777 User.pm",'__display__');
   ($stdout,$stderr)=$handle->cmd("echo -e \"$content\" > User.pm");
   ($stdout,$stderr)=$handle->cmd("chmod -v 644 User.pm",'__display__');
   ($stdout,$stderr)=$handle->cwd("../../..");
   ($stdout,$stderr)=$handle->cmd("./script/adventrest_create.pl ".
      "model DB DBIC::Schema AdventREST::Schema",'__display__');
   $content=<<'END';
name: AdventREST
Model::DB:
    schema_class: AdventREST::Schema
    connect_info:
        - DBI:SQLite:dbname=__path_to(db/adventrest.db)__
        - \\x22\\x22
        - \\x22\\x22
END
   ($stdout,$stderr)=$handle->cmd("touch adventrest.yml");
   ($stdout,$stderr)=$handle->cmd("chmod -v 777 adventrest.yml",'__display__');
   ($stdout,$stderr)=$handle->cmd("echo -e \"$content\" > adventrest.yml");
   ($stdout,$stderr)=$handle->cmd("chmod -v 644 adventrest.yml",'__display__');
   ($stdout,$stderr)=$handle->cmd(
      "./script/adventrest_create.pl controller User",'__display__');
   ($stdout,$stderr)=$handle->cmd("mv lib/AdventREST/Controller/User.pm ".
      "lib/AdventREST/Controller/User.bak");
   ($stdout,$stderr)=$handle->cmd(
      "./script/adventrest_create.pl view TT TT",'__display__');
   ($stdout,$stderr)=$handle->cmd(
      "mkdir -vp root/static/jquery",'__display__');
   ($stdout,$stderr)=$handle->cwd('root/static/jquery');
   ($stdout,$stderr)=$handle->cmd(
      "wget --random-wait --progress=dot ".
      "https://code.jquery.com/ui/1.11.3/jquery-ui.js",
      '__display__');
   ($stdout,$stderr)=$handle->cmd(
      "wget --random-wait --progress=dot ".
      "https://code.jquery.com/jquery-1.11.3.js",
      '__display__');
   ($stdout,$stderr)=$handle->cwd('../..');
   # http://www.sitepoint.com/working-jquery-datatables/
   ($stdout,$stderr)=$handle->cmd(
      "wget --random-wait --progress=dot ".
      "https://github.com/DataTables/DataTables/archive/master.zip",
      '__display__');
   ($stdout,$stderr)=$handle->cmd('unzip master.zip','__display__');
   ($stdout,$stderr)=$handle->cmd('sudo rm -rvf master.zip','__display__');
   ($stdout,$stderr)=$handle->cwd('DataTables-master');
   ($stdout,$stderr)=$handle->cmd('cp -Rv media ..','__display__');
   ($stdout,$stderr)=$handle->cwd('examples');
   ($stdout,$stderr)=$handle->cmd('cp -Rv resources ../..','__display__');
   ($stdout,$stderr)=$handle->cwd('../../..');
   $content=<<'END';
package AdventREST::Controller::User;
 
use strict;
use warnings;
use Moose;
use namespace::autoclean;
BEGIN { extends 'Catalyst::Controller::REST' }

__PACKAGE__->config(
    'default' => 'application/json',
    'map'       => {
       'text/html'          => [ 'View', 'TT' ],
       'text/xml'           => [ 'View', 'TT' ],
       'text/x-yaml'        => 'YAML',
       'application/json'   => 'JSON',
       'text/x-json'        => 'JSON',
       'text/x-data-dumper' => [ 'Data::Serializer', 'Data::Dumper' ],
       'text/x-data-denter' => [ 'Data::Serializer', 'Data::Denter' ],
       'text/x-data-taxi'   => [ 'Data::Serializer', 'Data::Taxi'   ],
       'application/x-storable'   => [ 'Data::Serializer', 'Storable' ],
       'application/x-freezethaw' => [ 'Data::Serializer', 'FreezeThaw' ],
       'text/x-config-general'    => [ 'Data::Serializer', 'Config::General' ],
       'application/x-www-form-urlencoded' => 'JSON',
    },
);

sub user_list : Path('/user') :Args(0) : ActionClass('REST') { }

sub user_list_GET {
    my ( \\x24self, \\x24c ) = @_;
    my \\x24draw     = \\x24c->req->params->{draw} || 0;
    my \\x24start    = \\x24c->req->params->{start} || 0;
    my \\x24per_page = \\x24c->req->params->{length} || 10;
    my \\x24page     = 1;
    if (\\x24start<\\x24per_page) {
       \\x24page=1;
    } else {
       \\x24page=int(\\x24start/\\x24per_page)+1;
    }

    # We'll use an array now:
    my @user_list;
    my \\x24rs = \\x24c->model('DB::User')
        ->search(undef, { rows => \\x24per_page })->page( \\x24page );
    while ( my \\x24user_row = \\x24rs->next ) {
        push @user_list, {
            \\x24user_row->get_columns,
            uri => \\x24c->uri_for( '/user/' . \\x24user_row->user_id )->as_string
        };
    }

    \\x24self->status_ok( \\x24c, entity => {
        draw => \\x24draw,
        recordsTotal => \\x24rs->pager->total_entries,
        recordsFiltered => \\x24rs->pager->total_entries,
        data => [ @user_list ]
    });
};

sub single_user : Path('/user') : Args(1) : ActionClass('REST') {
    my ( \\x24self, \\x24c, \\x24user_id ) = @_;
 
    \\x24c->stash->{'user'} = \\x24c->model('DB::User')->find(\\x24user_id);
}

sub single_user_POST {
    my ( \\x24self, \\x24c, \\x24user_id ) = @_;
 
    my \\x24new_user_data = \\x24c->req->data;
    if ( \\x21defined(\\x24new_user_data) ) {
       return \\x24self->status_bad_request(\\x24c,
           message => 'You must provide a user to create or modify\\x21' );
    }

    if ( \\x24new_user_data->{'user_id'} ne \\x24user_id ) {
       return \\x24self->status_bad_request( 
              \\x24c,
              message => 
                 'Cannot create or modify user '
                 . \\x24new_user_data->{'user_id'} . ' at '
                 . \\x24c->req->uri->as_string
                 . '; the user_id does not match\\x21' );
    }

    foreach my \\x24required (qw(user_id fullname description)) {
       return \\x24self->status_bad_request( \\x24c,
          message => 'Missing required field: ' . \\x24required )
       if \\x21exists( \\x24new_user_data->{\\x24required} );
    }

    my \\x24user = \\x24c->model('DB::User')->update_or_create(
       user_id     => \\x24new_user_data->{'user_id'},
       fullname    => \\x24new_user_data->{'fullname'},
       description => \\x24new_user_data->{'description'},
    );
    my \\x24return_entity = {
       user_id     => \\x24user->user_id,
       fullname    => \\x24user->fullname,
       description => \\x24user->description,
    };

    if ( \\x24c->stash->{'user'} ) {
        \\x24self->status_ok( \\x24c, entity => \\x24return_entity, );
    } else {
        \\x24self->status_created(
            \\x24c,
            location => \\x24c->req->uri->as_string,
            entity   => \\x24return_entity,
        );
    }
}

*single_user_PUT = *single_user_POST;

sub single_user_GET {
    my ( \\x24self, \\x24c, \\x24user_id ) = @_;
 
    my \\x24user = \\x24c->stash->{'user'};
    if ( defined(\\x24user) ) {
        \\x24self->status_ok(
            \\x24c,
            entity => {
                user_id     => \\x24user->user_id,
                fullname    => \\x24user->fullname,
                description => \\x24user->description,
            }
        );
    }
    else {
        \\x24self->status_not_found( \\x24c,
            message => 'Could not find User '.\\x24user_id.'\\x21' );
    }
}

sub single_user_DELETE {
    my ( \\x24self, \\x24c, \\x24user_id ) = @_;
 
    my \\x24user = \\x24c->stash->{'user'};
    if ( defined(\\x24user) ) {
        \\x24user->delete;
        \\x24self->status_ok(
            \\x24c,
            entity => {
                user_id     => \\x24user->user_id,
                fullname    => \\x24user->fullname,
                description => \\x24user->description,
            }
        );
    } else {
        \\x24self->status_not_found( \\x24c,
        message => 'Cannot delete non-existent user '.\\x24user_id.'\\x21' );
    }
}

1;
END
   ($stdout,$stderr)=$handle->cwd('lib/AdventREST/Controller');
   ($stdout,$stderr)=$handle->cmd("touch User.pm");
   ($stdout,$stderr)=$handle->cmd("chmod -v 777 User.pm",'__display__');
   ($stdout,$stderr)=$handle->cmd("echo -e \"$content\" > User.pm");
   my $ad='sub index : Private {NL   my ( $self, $c ) = @_;NL'.
          '   $c->forward( $c->view(SQTTSQ) );NL}NLNL';
   ($stdout,$stderr)=$handle->cmd(
      "sudo sed -i '/sub index :Path/i$ad' ./Root.pm");
   ($stdout,$stderr)=$handle->cmd( # bash shell specific
      "sudo sed -i \'s/NL/\'\"`echo \\\\\\n`/g\" ./Root.pm");
   ($stdout,$stderr)=$handle->cmd("sudo sed -i \"s/SQ/\'/g\" ./Root.pm");
   ($stdout,$stderr)=$handle->cmd(
      "sudo sed -i '/index :Path :/,+6d' ./Root.pm");
   ($stdout,$stderr)=$handle->cmd("chmod -v 644 User.pm",'__display__');
   ($stdout,$stderr)=$handle->cwd('../../../root/static');
   ($stdout,$stderr)=$handle->cmd(
      "wget --random-wait --progress=dot ".
      "http://dev.catalyst.perl.org/repos/Catalyst/trunk/".
      "examples/RestYUI/root/static/json2.js",
      '__display__');
   ($stdout,$stderr)=$handle->cmd('mkdir -vp yui','__display__');
   ($stdout,$stderr)=$handle->cwd('yui');
   my @yuifiles=('utilities.js','dom.js','connection.js','event.js',
                 'yahoo.js');
   foreach my $file (@yuifiles) {
      ($stdout,$stderr)=$handle->cmd(
         "wget --random-wait --progress=dot ".
         "http://dev.catalyst.perl.org/repos/Catalyst/trunk/".
         "examples/RestYUI/root/static/yui/$file",
         '__display__');
   }
   ($stdout,$stderr)=$handle->cwd('../..');
   ($stdout,$stderr)=$handle->cmd('mkdir -vp user','__display__');
   ($stdout,$stderr)=$handle->cwd('user');
   ($stdout,$stderr)=$handle->cmd(
      "wget --random-wait --progress=dot ".
      "http://dev.catalyst.perl.org/repos/Catalyst/trunk/".
      "examples/RestYUI/root/user/single_user.tt",
      '__display__');
   ($stdout,$stderr)=$handle->cmd(
      "sed -i 's/POSTT/POST/' single_user.tt");
   ($stdout,$stderr)=$handle->cwd('..');
   #
   # echo-ing/streaming files over ssh can be tricky. Use echo -e
   #          and replace these characters with thier HEX
   #          equivalents (use an external editor for quick
   #          search and replace - and paste back results.
   #          use copy/paste or cat file and copy/paster results.):
   #
   #          !  -   \\x21
   #          "  -   \\x22
   #          $  -   \\x24
   #
   $content=<<END;
<\\x21DOCTYPE html>
<html>
<head>
   <meta charset=\\x22utf-8\\x22>
   <meta name=\\x22viewport\\x22 content=\\x22initial-scale=1.0, maximum-scale=2.0\\x22>

   <title>Catalyst REST Example</title>

   <link rel=\\x22stylesheet\\x22 type=\\x22text/css\\x22 href=\\x22https://cdn.datatables.net/1.10.8/css/jquery.dataTables.min.css\\x22>
   <link rel=\\x22stylesheet\\x22 type=\\x22text/css\\x22 href=\\x22resources/demo.css\\x22></script>
   <script type=\\x22text/javascript\\x22 language=\\x22javascript\\x22 src=\\x22//code.jquery.com/jquery-1.11.3.min.js\\x22></script>
   <script type=\\x22text/javascript\\x22 language=\\x22javascript\\x22 src=\\x22https://cdn.datatables.net/1.10.8/js/jquery.dataTables.min.js\\x22></script>
   <script type=\\x22text/javascript\\x22 language=\\x22javascript\\x22 class=\\x22init\\x22>

   \\x24(document).ready(function() {
      \\x24(\\x22#example\\x22).dataTable({
         \\x22processing\\x22: true,
         \\x22serverSide\\x22: true,
         \\x22ajax\\x22: \\x22[%c.uri_for( c.controller('User').action_for('user_list') ) %]?page=1&content-type=application/json\\x22,
         \\x22aoColumns\\x22: [{
            \\x22mData\\x22:\\x22user_id\\x22,
         },{
            \\x22mData\\x22: \\x22fullname\\x22,
         },{
            \\x22mData\\x22: \\x22description\\x22,
         }]
     });
   } );

  </script>
</head>

<body class=\\x22dt-example\\x22>
   <div class=\\x22container\\x22>
      <section>
         <h1>Catalyst REST Example <span>Using JQuery DataTable</span></h1>

         <div class=\\x22info\\x22>
            <p>FullAuto was used to stand up this fully functional Catalyst REST installation.
               The following table is full of demo user data. To add or update a user, manually
               modify the browser URL like so:

            <br><br><code>[%c.uri_for( c.controller('User').action_for('user_list') ) %]/user_id</code>.</p>

            <p>Data can be accessed on the command line:
                <br><br><code>curl -X GET -H 'Content-Type: application/json'
                [%c.uri_for( c.controller('User').action_for('user_list') ) %]</code></p>
         </div>
            <table id=\\x22example\\x22 class=\\x22display\\x22 cellspacing=\\x220\\x22 width=\\x22100%\\x22>
               <thead>
                  <tr>
                     <th>ID</th>
                     <th>Full Name</th>
                     <th>Description</tn>
                  </tr>
               </thead>

               <tfoot>
                  <tr>
                     <th>ID</th>
                     <th>Full Name</th>
                     <th>Description</th>
                  </tr>
               </tfoot>
            </table>
         </div>
      </section>
   </div>
</body>
</html>
END
   ($stdout,$stderr)=$handle->cmd("echo -e \"$content\" > index.tt");
   ($stdout,$stderr)=$handle->cwd('../..');
   ($stdout,$stderr)=$handle->cmd("catalyst.pl FullAuto_Chaining",
      '__display__');
   my $theswartz_schema=<<END;
CREATE TABLE funcmap (
        funcid INTEGER PRIMARY KEY AUTOINCREMENT,
        funcname VARCHAR(255) NOT NULL,
        UNIQUE(funcname)
);

CREATE TABLE job (
        jobid INTEGER PRIMARY KEY AUTOINCREMENT,
        funcid INTEGER UNSIGNED NOT NULL,
        arg MEDIUMBLOB,
        uniqkey VARCHAR(255) NULL,
        insert_time INTEGER UNSIGNED,
        run_after INTEGER UNSIGNED NOT NULL,
        grabbed_until INTEGER UNSIGNED NOT NULL,
        priority SMALLINT UNSIGNED,
        coalesce VARCHAR(255),
        UNIQUE(funcid,uniqkey)
);

CREATE TABLE error (
        error_time INTEGER UNSIGNED NOT NULL,
        jobid INTEGER NOT NULL,
        message VARCHAR(255) NOT NULL,
        funcid INT UNSIGNED NOT NULL DEFAULT 0
);

CREATE TABLE exitstatus (
        jobid INTEGER PRIMARY KEY NOT NULL,
        funcid INT UNSIGNED NOT NULL DEFAULT 0,
        status SMALLINT UNSIGNED,
        completion_time INTEGER UNSIGNED,
        delete_after INTEGER UNSIGNED
);
END
   ($stdout,$stderr)=$handle->cwd('FullAuto_Chaining');
   ($stdout,$stderr)=$handle->cmd('perl Makefile.PL','__display__');
   ($stdout,$stderr)=$handle->cmd('mkdir -v etc','__display__');
   ($stdout,$stderr)=$handle->cwd('etc');
   ($stdout,$stderr)=$handle->cmd(
      "echo \"$theswartz_schema\" | sqlite3 theschwartz.sqlt");
   ($stdout,$stderr)=$handle->cwd('..');
   ($stdout,$stderr)=$handle->cmd(
      "./script/fullauto_chaining_create.pl model TheSchwartz",'__display__');
   $ad='__PACKAGE__->config( class => "TheSchwartz" );NLNL'. # NL is newline
      'sub mangle_arguments { %{ $_[1]->{args} } }NL';
   ($stdout,$stderr)=$handle->cmd(
      "sudo sed -i \'/Catalyst::Model/a$ad\' ".
      "./lib/FullAuto_Chaining/Model/TheSchwartz.pm");
   ($stdout,$stderr)=$handle->cmd( # bash shell specific
      "sudo sed -i \'s/NL/\'\"`echo \\\\\\n`/g\" ".
      "./lib/FullAuto_Chaining/Model/TheSchwartz.pm");
   $content=<<END;
Model::TheSchwartz:
  args:
    verbose: 1
    databases:
      - dsn: dbi:SQLite:__path_to(etc/theschwartz.sqlt)__
END
   ($stdout,$stderr)=$handle->cmd("echo \"$content\" > fullauto_chaining.yml");
   ($stdout,$stderr)=$handle->cmd(
      "./script/fullauto_chaining_create.pl controller FullAuto_Chaining",
      '__display__');
   $ad='use TheSchwartz::Job;NLuse DBI;'; # NL is newline
   ($stdout,$stderr)=$handle->cmd(
      "sudo sed -i \'/use namespace/a$ad\' ".
      "./lib/FullAuto_Chaining/Controller/FullAuto_Chaining.pm");
   ($stdout,$stderr)=$handle->cmd( # bash shell specific
      "sudo sed -i \'s/NL/\'\"`echo \\\\\\n`/g\" ".
      "./lib/FullAuto_Chaining/Controller/FullAuto_Chaining.pm");
   ($stdout,$stderr)=$handle->cmd(
      "sudo sed -i 's/Catalyst::Controller/Catalyst::Controller::Rest/' ".
      "./lib/FullAuto_Chaining/Controller/FullAuto_Chaining.pm");
   ($stdout,$stderr)=$handle->cwd("..");
   ($stdout,$stderr)=$handle->cmd(
      "wget --random-wait --progress=dot ".
      "https://github.com/pangyre/p5-myapp-10in10/archive/master.zip",
      '__display__');
   ($stdout,$stderr)=$handle->cmd("unzip master.zip",'__display__');
   ($stdout,$stderr)=$handle->cmd("rm -rvf master.zip",'__display__');
   ($stdout,$stderr)=$handle->cwd("p5-myapp-10in10-master");
   ($stdout,$stderr)=$handle->cmd("mkdir -vp root/static/img/title",
      '__display__');
   ($stdout,$stderr)=$handle->cmd("perl Makefile.PL",'__display__');
   ($stdout,$stderr)=$handle->cmd(
      "sed -i 's/static.*=/Plugin::Static::Simple =/' lib/MyApp.pm");
   ($stdout,$stderr)=$handle->cmd(
      "sed -i \"s/Plugin::Static::Simple/'&'/\" lib/MyApp.pm");
   ($stdout,$stderr)=$handle->cmd(
      "sed -i '/Unicode::Encoding/d' lib/MyApp.pm");
   $ad='encoding: utf8';
   ($stdout,$stderr)=$handle->cmd(
      "sed -i \'/default_view/a $ad\' myapp.yml");
   $handle->{_cmd_handle}->print(
      'script/myapp_server.pl --background');
   ($stdout,$stderr)=$handle->cwd("../AdventREST");
   $handle->{_cmd_handle}->print(
      'script/adventrest_server.pl -p 3001 --background');
   $prompt=substr($handle->{_cmd_handle}->prompt(),1,-1);
   while (1) {
      my $output.=Net::FullAuto::FA_Core::fetch($handle);
      last if $output=~/$prompt/;
      print $output;
      if (-1<index $output,'| /end') {
         $output=Net::FullAuto::FA_Core::fetch($handle);
         print $output;
         last;
      }
   }
   my $master=$main::aws->{$server_type}->[0]->[0]->{InstanceId};
   my $c="aws ec2 describe-instances --instance-ids $master 2>&1";
   my ($hash,$output,$error)=('','','');
   ($hash,$output,$error)=run_aws_cmd($c);
   my $mdns=$hash->{Reservations}->[0]->{Instances}->[0]->{PublicDnsName};
   print "\n   ACCESS CATALYST REST EXAMPLE AT:\n\n",
         " http://$mdns:3001\n";
   my $thanks=<<'END';

     ______                  _    ,
       / /              /   ' )  /        /
    --/ /_  __.  ____  /_    /  / __ . . /
   (_/ / /_(_/|_/ / <_/ <_  (__/_(_)(_/_'   For Trying
                             //

           _   _      _         _____      _ _    _         _
          | \ | | ___| |_      |  ___|   _| | |  / \  _   _| |_  |
          |  \| |/ _ \ __| o o | |_ | | | | | | / _ \| | | | __/ | \
          | |\  |  __/ |_  o o |  _|| |_| | | |/ ___ \ |_| | ||     |
          |_| \_|\___|\__|     |_|   \__,_|_|_/_/   \_\__,_|\__\___/ ©


   Copyright © 2000-2015  Brian M. Kelly  Brian.Kelly@FullAuto.com

END
   eval {
      local $SIG{ALRM} = sub { die "alarm\n" }; # \n required
      alarm 15;
      print $thanks;
      print "   \n   Press Any Key to EXIT ... ";
      <STDIN>;
   };alarm(0);
   print "\n\n\n   Please wait at least a minute for the Default Browser\n",
         "   to start with your new Catalyst installation!\n\n\n";
   &Net::FullAuto::FA_Core::cleanup;

};

my $standup_chaining=sub {

   my $type="]T[{select_type}";
   $type=~s/^"//;
   $type=~s/"$//;
   $type=substr($type,0,(index $type,' ->')-3);
   my $catalyst="]T[{select_chaining_setup}";
   my $i=$main::aws->{fullauto}->{ImageId}||'';
   my $s=$main::aws->{fullauto}->
         {NetworkInterfaces}->[0]->{SubnetId}||'';
   my $g=$main::aws->{fullauto}->
         {SecurityGroups}->[0]->{GroupId}||'';
   my $n=$main::aws->{fullauto}->
         {SecurityGroups}->[0]->{GroupName}||'';
   my $c='aws ec2 describe-security-groups '.
         "--group-names $n";
   my ($hash,$output,$error)=('','','');
   ($hash,$output,$error)=run_aws_cmd($c);
   Net::FullAuto::FA_Core::handle_error($error) if $error;
   my $cidr=$hash->{SecurityGroups}->[0]->{IpPermissions}
            ->[0]->{IpRanges}->[0]->{CidrIp};
   $c='aws ec2 create-security-group --group-name '.
      'CatalystSecurityGroup --description '.
      '"CatalystFramework.org Security Group" 2>&1';
   ($hash,$output,$error)=run_aws_cmd($c);
   Net::FullAuto::FA_Core::handle_error($error) if $error
      && $error!~/already exists/;
   $c='aws ec2 authorize-security-group-ingress '.
      '--group-name CatalystSecurityGroup --protocol '.
      'tcp --port 22 --cidr '.$cidr." 2>&1";
   ($hash,$output,$error)=run_aws_cmd($c);
   Net::FullAuto::FA_Core::handle_error($error) if $error
      && $error!~/already exists/;
   $c='aws ec2 authorize-security-group-ingress '.
      '--group-name CatalystSecurityGroup --protocol '.
      'tcp --port 3000 --cidr '.$cidr." 2>&1";
   ($hash,$output,$error)=run_aws_cmd($c);
   Net::FullAuto::FA_Core::handle_error($error) if $error
      && $error!~/already exists/;
   $c='aws ec2 authorize-security-group-ingress '.
      '--group-name CatalystSecurityGroup --protocol '.
      'tcp --port 3001 --cidr '.$cidr." 2>&1";
   ($hash,$output,$error)=run_aws_cmd($c);
   Net::FullAuto::FA_Core::handle_error($error) if $error
      && $error!~/already exists/;
   my $cnt=0;
   my $pemfile=$pem_file;
   $pemfile=~s/\.pem\s*$//s;
   if (exists $main::aws->{'CatalystFramework.org'}) {
      my $g=get_aws_security_id('CatalystSecurityGroup');
      my $c="aws ec2 run-instances --image-id $i --count 1 ".
         "--instance-type $type --key-name $pemfile ".
         "--security-group-ids $g --subnet-id $s";
      if ($#{$main::aws->{'CatalystFramework.org'}}==0) {
         launch_server('CatalystFramework.org',$cnt,$catalyst,'',$c,
         $configure_chaining);
      } else {
         my $num=$#{$main::aws->{'CatalystFramework.org'}}-1;
         foreach my $num (0..$num) {
            launch_server('CatalystFramework',$cnt++,$catalyst,'',$c,
            $configure_chaining);
         }
      }
   }

   return '{choose_demo_setup}<';

};

my $chaining_setup_summary=sub {

   package chaining_setup_summary;
   use JSON::XS;
   my $region="]T[{awsregions}";
   $region=~s/^"//;
   $region=~s/"$//;
   my $type="]T[{select_type}";
   $type=~s/^"//;
   $type=~s/"$//;
   my $money=$type;
   $money=~s/^.*-> \$(.*?) +(?:[(].+[)] )*\s*per hour$/$1/;
   $type=substr($type,0,(index $type,' ->')-3);
   my $catalyst="]T[{select_chaining_setup}";
   $catalyst=~s/^"//;
   $catalyst=~s/"$//;
   print "REGION=$region and TYPE=$type\n";
   print "CATALYST=$catalyst\n";
   my $num_of_servers=0;
   my $ol=$catalyst;
   $ol=~s/^.*(\d+)\sServer.*$/$1/;
   if ($ol==1) {
      $main::aws->{'CatalystFramework.org'}->[0]=[];
   } elsif ($ol=~/^\d+$/ && $ol) {
      foreach my $n (0..$ol) {
         $main::aws->{'CatalystFramework.org'}=[] unless exists
            $main::aws->{'CatalystFramework.org'};
         $main::aws->{'CatalystFramework.org'}->[$n]=[];
      }
   }
   $num_of_servers=$ol;
   my $cost=int($num_of_servers)*$money;
   my $cents='';
   if ($cost=~/^0\./) {
      $cents=$cost;
      $cents=~s/^0\.//;
      if (length $cents>2) {
         $cents=~s/^(..)(.*)$/$1.$2/;
         $cents=~s/^0//;
         $cents=' ('.$cents.' cents)';
      } else {
         $cents=' ('.$cents.' cents)';
      }
   }
   my $show_cost_banner=<<'END';

      _                  _       ___        _  ___
     /_\  __ __ ___ _ __| |_    / __|___ __| ||__ \
    / _ \/ _/ _/ -_) '_ \  _|  | (__/ _ (_-<  _|/_/
   /_/ \_\__\__\___| .__/\__|   \___\___/__/\__(_)
                   |_|

END
   $show_cost_banner.=<<END;
   Note: There is a \$$cost per hour cost$cents to launch $num_of_servers
         AWS EC2 $type servers for the FullAuto Demo:

         $catalyst


END
   my %show_cost=(

      Name => 'show_cost',
      Item_1 => {

         Text => "I accept the \$$cost$cents per hour cost",
         Result => $standup_chaining,

      },
      Item_2 => {

         Text => "Return to Choose Demo Menu",
         Result => sub { return '{choose_demo_setup}<' },

      },
      Item_3 => {

         Text => "Exit FullAuto",
         Result => sub { Net::FullAuto::FA_Core::cleanup() },

      },
      Scroll => 1,
      Banner => $show_cost_banner,

   );
   return \%show_cost;

};

our $select_chaining_setup=sub {

   my @options=('FullAuto© Proxy Chaining & RESTful Access on 1 Server');
   my $chaining_setup_banner=<<'END';

                     _    ___     _ _   _       _                     
                   ((_)  | __|  _| | | /_\ _  _| |_  |                   
                    /    | _| || | | |/ _ \ || |  _/ | \   Automates     _
                   /     |_| \_,_|_|_/_/ \_\_,_|\__\___/©  Everything  _| |_ 
               \__/_     ___ __ _| |_ __ _| |_   _ ___| |_            |_   _|
               /    \   / __/ _` | __/ _` | | | | / __| __|  Perl MVC   |_|
            _- |    |  | (_| (_| | || (_| | | |_| \__ \ |    framework
       _ _-'   \____/   \___\__,_|\__\__,_|_|\__, |___/\__|©
     ((_)       ---\                         |___/
                    \
                     \\_   Web Framework & SSH Proxy Chaining via RESTful
                      (_)

   Choose the Chaining setup you wish to demo. Note that more servers
   means more expense, and more instances means less permformance on a
   small instance type. Consider a medium or large instance type (previous
   screens) if you wish to test more than 1 instance on a server. You can
   navigate backwards and make new selections with the [<] LEFTARROW key.

END
   my %select_chaining_setup=(

      Name => 'select_chaining_setup',
      Item_1 => {

         Text => ']C[',
         Convey => \@options,
         Result => $chaining_setup_summary,

      },
      Scroll => 1,
      Banner => $chaining_setup_banner,
   );
   return \%select_chaining_setup

};

1
