#!/usr/bin/perl
#-------------------------------------------------------------------------------
# Translate the numbers from 0 to 100 into various languages
# Philip R Brenan at gmail dot com, Appa Apps Ltd, 2017
#-------------------------------------------------------------------------------

package Text::Numbers::100;
require v5.16.0;
use warnings FATAL => qw(all);
use strict;
use Carp;

our $VERSION = '2017.224';

#-------------------------------------------------------------------------------
# Translate
#-------------------------------------------------------------------------------

sub translate($$)
 {my ($language, $number) = @_;
  my $l = &translations;
  my $n = $l->{$language};
  $n or confess "No translation for language: $language";
  my $i = $number+0;
  $n->{$i}
 }

#-------------------------------------------------------------------------------
# Languages
#-------------------------------------------------------------------------------

sub languages
 {my $l = &translations;
  sort keys %{&translations};
 }

#-------------------------------------------------------------------------------
# Numbers
#-------------------------------------------------------------------------------

sub translations{{
  cy => {
          "0"   => "dim",
          "1"   => "un",
          "2"   => "dau",
          "3"   => "tri",
          "4"   => "pedwar",
          "5"   => "pump",
          "6"   => "chwech",
          "7"   => "saith",
          "8"   => "wyth",
          "9"   => "naw",
          "10"  => "deg",
          "11"  => "un deg un",
          "12"  => "un deg dau",
          "13"  => "un deg tri",
          "14"  => "un deg pedwar",
          "15"  => "un deg pump",
          "16"  => "un deg chwech",
          "17"  => "un deg saith",
          "18"  => "un deg wyth",
          "19"  => "un deg naw",
          "20"  => "dau ddeg",
          "21"  => "dau ddeg un",
          "22"  => "dau ddeg dau",
          "23"  => "dau ddeg tri",
          "24"  => "dau ddeg pedwar",
          "25"  => "dau ddeg pump",
          "26"  => "dau ddeg chwech",
          "27"  => "dau ddeg saith",
          "28"  => "dau ddeg wyth",
          "29"  => "dau ddeg naw",
          "30"  => "tri deg",
          "31"  => "tri deg un",
          "32"  => "tri deg dau",
          "33"  => "tri deg tri",
          "34"  => "tri deg pedwar",
          "35"  => "tri deg pump",
          "36"  => "tri deg chwech",
          "37"  => "tri deg saith",
          "38"  => "tri deg wyth",
          "39"  => "tri deg naw",
          "40"  => "pedwar deg",
          "41"  => "pedwar deg un",
          "42"  => "pedwar deg dau",
          "43"  => "pedwar deg tri",
          "44"  => "pedwar deg pedwar",
          "45"  => "pedwar deg pump",
          "46"  => "pedwar deg chwech",
          "47"  => "pedwar deg saith",
          "48"  => "pedwar deg wyth",
          "49"  => "pedwar deg naw",
          "50"  => "pum deg",
          "51"  => "pum deg un",
          "52"  => "pum deg dau",
          "53"  => "pum deg tri",
          "54"  => "pum deg pedwar",
          "55"  => "pum deg pump",
          "56"  => "pum deg chwech",
          "57"  => "pum deg saith",
          "58"  => "pum deg wyth",
          "59"  => "pum deg naw",
          "60"  => "chwe deg",
          "61"  => "chwe deg un",
          "62"  => "chwe deg dau",
          "63"  => "chwe deg tri",
          "64"  => "chwe deg pedwar",
          "65"  => "chwe deg pump",
          "66"  => "chwe deg chwech",
          "67"  => "chwe deg saith",
          "68"  => "chwe deg wyth",
          "69"  => "chwe deg naw",
          "70"  => "saith deg",
          "71"  => "saith deg un",
          "72"  => "saith deg dau",
          "73"  => "saith deg tri",
          "74"  => "saith deg pedwar",
          "75"  => "saith deg pump",
          "76"  => "saith deg chwech",
          "77"  => "saith deg saith",
          "78"  => "saith deg wyth",
          "79"  => "saith deg naw",
          "80"  => "wyth deg",
          "81"  => "wyth deg un",
          "82"  => "wyth deg dau",
          "83"  => "wyth deg tri",
          "84"  => "wyth deg pedwar",
          "85"  => "wyth deg pump",
          "86"  => "wyth deg chwech",
          "87"  => "wyth deg saith",
          "88"  => "wyth deg wyth",
          "89"  => "wyth deg naw",
          "90"  => "naw deg",
          "91"  => "naw deg un",
          "92"  => "naw deg dau",
          "93"  => "naw deg tri",
          "94"  => "naw deg pedwar",
          "95"  => "naw deg pump",
          "96"  => "naw deg chwech",
          "97"  => "naw deg saith",
          "98"  => "naw deg wyth",
          "99"  => "naw deg naw",
          "100" => "cant",
        },
  da => {
          "0"   => "nul",
          "1"   => "en",
          "2"   => "to",
          "3"   => "tre",
          "4"   => "fire",
          "5"   => "fem",
          "6"   => "seks",
          "7"   => "syv",
          "8"   => "otte",
          "9"   => "ni",
          "10"  => "ti",
          "11"  => "elleve",
          "12"  => "tolv",
          "13"  => "tretten",
          "14"  => "fjorten",
          "15"  => "femten",
          "16"  => "seksten",
          "17"  => "sytten",
          "18"  => "atten",
          "19"  => "nitten",
          "20"  => "tyve",
          "21"  => "\xC3\xA9nogtyve",
          "22"  => "toogtyve",
          "23"  => "treogtyve",
          "24"  => "fireogtyve",
          "25"  => "femogtyve",
          "26"  => "seksogtyve",
          "27"  => "syvogtyve",
          "28"  => "otteogtyve",
          "29"  => "niogtyve",
          "30"  => "tredive",
          "31"  => "\xC3\xA9nogtredive",
          "32"  => "toogtredive",
          "33"  => "treogtredive",
          "34"  => "fireogtredive",
          "35"  => "femogtredive",
          "36"  => "seksogtredive",
          "37"  => "syvogtredive",
          "38"  => "otteogtredive",
          "39"  => "niogtredive",
          "40"  => "fyrre",
          "41"  => "\xC3\xA9nogfyrre",
          "42"  => "toogfyrre",
          "43"  => "treogfyrre",
          "44"  => "fireogfyrre",
          "45"  => "femogfyrre",
          "46"  => "seksogfyrre",
          "47"  => "syvogfyrre",
          "48"  => "otteogfyrre",
          "49"  => "niogfyrre",
          "50"  => "halvtreds",
          "51"  => "\xC3\xA9noghalvtreds",
          "52"  => "tooghalvtreds",
          "53"  => "treoghalvtreds",
          "54"  => "fireoghalvtreds",
          "55"  => "femoghalvtreds",
          "56"  => "seksoghalvtreds",
          "57"  => "syvoghalvtreds",
          "58"  => "otteoghalvtreds",
          "59"  => "nioghalvtreds",
          "60"  => "tres",
          "61"  => "\xC3\xA9nogtres",
          "62"  => "toogtres",
          "63"  => "treogtres",
          "64"  => "fireogtres",
          "65"  => "femogtres",
          "66"  => "seksogtres",
          "67"  => "syvogtres",
          "68"  => "otteogtres",
          "69"  => "niogtres",
          "70"  => "halvfjerds",
          "71"  => "\xC3\xA9noghalvfjerds",
          "72"  => "tooghalvfjerds",
          "73"  => "treoghalvfjerds",
          "74"  => "fireoghalvfjerds",
          "75"  => "femoghalvfjerds",
          "76"  => "seksoghalvfjerds",
          "77"  => "syvoghalvfjerds",
          "78"  => "otteoghalvfjerds",
          "79"  => "nioghalvfjerds",
          "80"  => "firs",
          "81"  => "\xC3\xA9nogfirs",
          "82"  => "toogfirs",
          "83"  => "treogfirs",
          "84"  => "fireogfirs",
          "85"  => "femogfirs",
          "86"  => "seksogfirs",
          "87"  => "syvogfirs",
          "88"  => "otteogfirs",
          "89"  => "niogfirs",
          "90"  => "halvfems",
          "91"  => "\xC3\xA9noghalvfems",
          "92"  => "tooghalvfems",
          "93"  => "treoghalvfems",
          "94"  => "fireoghalvfems",
          "95"  => "femoghalvfems",
          "96"  => "seksoghalvfems",
          "97"  => "syvoghalvfems",
          "98"  => "otteoghalvfems",
          "99"  => "nioghalvfems",
          "100" => "hundrede",
        },
  en => {
          "0"   => "zero",
          "1"   => "one",
          "2"   => "two",
          "3"   => "three",
          "4"   => "four",
          "5"   => "five",
          "6"   => "six",
          "7"   => "seven",
          "8"   => "eight",
          "9"   => "nine",
          "10"  => "ten",
          "11"  => "eleven",
          "12"  => "twelve",
          "13"  => "thirteen",
          "14"  => "fourteen",
          "15"  => "fifteen",
          "16"  => "sixteen",
          "17"  => "seventeen",
          "18"  => "eighteen",
          "19"  => "nineteen",
          "20"  => "twenty",
          "21"  => "twenty-one",
          "22"  => "twenty-two",
          "23"  => "twenty-three",
          "24"  => "twenty-four",
          "25"  => "twenty-five",
          "26"  => "twenty-six",
          "27"  => "twenty-seven",
          "28"  => "twenty-eight",
          "29"  => "twenty-nine",
          "30"  => "thirty",
          "31"  => "thirty-one",
          "32"  => "thirty-two",
          "33"  => "thirty-three",
          "34"  => "thirty-four",
          "35"  => "thirty-five",
          "36"  => "thirty-six",
          "37"  => "thirty-seven",
          "38"  => "thirty-eight",
          "39"  => "thirty-nine",
          "40"  => "forty",
          "41"  => "forty-one",
          "42"  => "forty-two",
          "43"  => "forty-three",
          "44"  => "forty-four",
          "45"  => "forty-five",
          "46"  => "forty-six",
          "47"  => "forty-seven",
          "48"  => "forty-eight",
          "49"  => "forty-nine",
          "50"  => "fifty",
          "51"  => "fifty-one",
          "52"  => "fifty-two",
          "53"  => "fifty-three",
          "54"  => "fifty-four",
          "55"  => "fifty-five",
          "56"  => "fifty-six",
          "57"  => "fifty-seven",
          "58"  => "fifty-eight",
          "59"  => "fifty-nine",
          "60"  => "sixty",
          "61"  => "sixty-one",
          "62"  => "sixty-two",
          "63"  => "sixty-three",
          "64"  => "sixty-four",
          "65"  => "sixty-five",
          "66"  => "sixty-six",
          "67"  => "sixty-seven",
          "68"  => "sixty-eight",
          "69"  => "sixty-nine",
          "70"  => "seventy",
          "71"  => "seventy-one",
          "72"  => "seventy-two",
          "73"  => "seventy-three",
          "74"  => "seventy-four",
          "75"  => "seventy-five",
          "76"  => "seventy-six",
          "77"  => "seventy-seven",
          "78"  => "seventy-eight",
          "79"  => "seventy-nine",
          "80"  => "eighty",
          "81"  => "eighty-one",
          "82"  => "eighty-two",
          "83"  => "eighty-three",
          "84"  => "eighty-four",
          "85"  => "eighty-five",
          "86"  => "eighty-six",
          "87"  => "eighty-seven",
          "88"  => "eighty-eight",
          "89"  => "eighty-nine",
          "90"  => "ninety",
          "91"  => "ninety-one",
          "92"  => "ninety-two",
          "93"  => "ninety-three",
          "94"  => "ninety-four",
          "95"  => "ninety-five",
          "96"  => "ninety-six",
          "97"  => "ninety-seven",
          "98"  => "ninety-eight",
          "99"  => "ninety-nine",
          "100" => "one hundred",
        },
  es => {
          "0"   => "cero",
          "1"   => "uno",
          "2"   => "dos",
          "3"   => "tres",
          "4"   => "cuatro",
          "5"   => "cinco",
          "6"   => "seis",
          "7"   => "siete",
          "8"   => "ocho",
          "9"   => "nueve",
          "10"  => "diez",
          "11"  => "once",
          "12"  => "doce",
          "13"  => "trece",
          "14"  => "catorce",
          "15"  => "quince",
          "16"  => "diecis\xC3\xA9is",
          "17"  => "diecisiete",
          "18"  => "dieciocho",
          "19"  => "diecinueve",
          "20"  => "veinte",
          "21"  => "veintiuno",
          "22"  => "veintid\xC3\xB3s",
          "23"  => "veintitr\xC3\xA9s",
          "24"  => "veinticuatro",
          "25"  => "veinticinco",
          "26"  => "veintis\xC3\xA9is",
          "27"  => "veintisiete",
          "28"  => "veintiocho",
          "29"  => "veintinueve",
          "30"  => "treinta",
          "31"  => "treintay uno",
          "32"  => "treintay dos",
          "33"  => "treintay tres",
          "34"  => "treintay cuatro",
          "35"  => "treintay cinco",
          "36"  => "treintay seis",
          "37"  => "treintay siete",
          "38"  => "treintay ocho",
          "39"  => "treintay nueve",
          "40"  => "cuarenta",
          "41"  => "cuarentay uno",
          "42"  => "cuarentay dos",
          "43"  => "cuarentay tres",
          "44"  => "cuarentay cuatro",
          "45"  => "cuarentay cinco",
          "46"  => "cuarentay seis",
          "47"  => "cuarentay siete",
          "48"  => "cuarentay ocho",
          "49"  => "cuarentay nueve",
          "50"  => "cincuenta",
          "51"  => "cincuentay uno",
          "52"  => "cincuentay dos",
          "53"  => "cincuentay tres",
          "54"  => "cincuentay cuatro",
          "55"  => "cincuentay cinco",
          "56"  => "cincuentay seis",
          "57"  => "cincuentay siete",
          "58"  => "cincuentay ocho",
          "59"  => "cincuentay nueve",
          "60"  => "sesenta",
          "61"  => "sesentay uno",
          "62"  => "sesentay dos",
          "63"  => "sesentay tres",
          "64"  => "sesentay cuatro",
          "65"  => "sesentay cinco",
          "66"  => "sesentay seis",
          "67"  => "sesentay siete",
          "68"  => "sesentay ocho",
          "69"  => "sesentay nueve",
          "70"  => "setenta",
          "71"  => "setentay uno",
          "72"  => "setentay dos",
          "73"  => "setentay tres",
          "74"  => "setentay cuatro",
          "75"  => "setentay cinco",
          "76"  => "setentay seis",
          "77"  => "setentay siete",
          "78"  => "setentay ocho",
          "79"  => "setentay nueve",
          "80"  => "ochenta",
          "81"  => "ochentay uno",
          "82"  => "ochentay dos",
          "83"  => "ochentay tres",
          "84"  => "ochentay cuatro",
          "85"  => "ochentay cinco",
          "86"  => "ochentay seis",
          "87"  => "ochentay siete",
          "88"  => "ochentay ocho",
          "89"  => "ochentay nueve",
          "90"  => "noventa",
          "91"  => "noventay uno",
          "92"  => "noventay dos",
          "93"  => "noventay tres",
          "94"  => "noventay cuatro",
          "95"  => "noventay cinco",
          "96"  => "noventay seis",
          "97"  => "noventay siete",
          "98"  => "noventay ocho",
          "99"  => "noventay nueve",
          "100" => "cien",
        },
  is => {
          "0"   => "n\xC3\xBAll",
          "1"   => "einn",
          "2"   => "tveir",
          "3"   => "\xC3\xBEr\xC3\xADr",
          "4"   => "fj\xC3\xB3rir",
          "5"   => "fimm",
          "6"   => "sex",
          "7"   => "sj\xC3\xB6",
          "8"   => "\xC3\xA1tta",
          "9"   => "n\xC3\xADu",
          "10"  => "t\xC3\xADu",
          "11"  => "ellefu",
          "12"  => "t\xC3\xB3lf",
          "13"  => "\xC3\xBErett\xC3\xA1n",
          "14"  => "fj\xC3\xB3rt\xC3\xA1n",
          "15"  => "fimmt\xC3\xA1n",
          "16"  => "sext\xC3\xA1n",
          "17"  => "sautj\xC3\xA1n",
          "18"  => "\xC3\xA1tj\xC3\xA1n",
          "19"  => "n\xC3\xADtj\xC3\xA1n",
          "20"  => "tuttugu",
          "21"  => "tuttugu og einn",
          "22"  => "tuttugu og tveir",
          "23"  => "tuttugu og \xC3\xBEr\xC3\xADr",
          "24"  => "tuttugu og fj\xC3\xB3rir",
          "25"  => "tuttugu og fimm",
          "26"  => "tuttugu og sex",
          "27"  => "tuttugu og sj\xC3\xB6",
          "28"  => "tuttugu og \xC3\xA1tta",
          "29"  => "tuttugu og n\xC3\xADu",
          "30"  => "\xC3\xBErj\xC3\xA1t\xC3\xADu",
          "31"  => "\xC3\xBErj\xC3\xA1t\xC3\xADu og einn",
          "32"  => "\xC3\xBErj\xC3\xA1t\xC3\xADu og tveir",
          "33"  => pack("H*","c3be726ac3a174c3ad75206f6720c3be72c3ad72"),
          "34"  => pack("H*","c3be726ac3a174c3ad75206f6720666ac3b3726972"),
          "35"  => "\xC3\xBErj\xC3\xA1t\xC3\xADu og fimm",
          "36"  => "\xC3\xBErj\xC3\xA1t\xC3\xADu og sex",
          "37"  => pack("H*","c3be726ac3a174c3ad75206f6720736ac3b6"),
          "38"  => pack("H*","c3be726ac3a174c3ad75206f6720c3a1747461"),
          "39"  => pack("H*","c3be726ac3a174c3ad75206f67206ec3ad75"),
          "40"  => "fj\xC3\xB6rut\xC3\xADu",
          "41"  => "Fj\xC3\xB6rut\xC3\xADu og einn",
          "42"  => "Fj\xC3\xB6rut\xC3\xADu og tveir",
          "43"  => pack("H*","466ac3b6727574c3ad75206f6720c3be72c3ad72"),
          "44"  => "fj\xC3\xB6rut\xC3\xADu og fj\xC3\xB3rir",
          "45"  => "fj\xC3\xB6rut\xC3\xADu og fimm",
          "46"  => "Fj\xC3\xB6rut\xC3\xADu og sex",
          "47"  => "fj\xC3\xB6rut\xC3\xADu og sj\xC3\xB6",
          "48"  => "fj\xC3\xB6rut\xC3\xADu og \xC3\xA1tta",
          "49"  => "fj\xC3\xB6rut\xC3\xADu og n\xC3\xADu",
          "50"  => "fimmt\xC3\xADu",
          "51"  => "Fimmt\xC3\xADu og einn",
          "52"  => "fimmt\xC3\xADu og tveir",
          "53"  => "fimmt\xC3\xADu og \xC3\xBEr\xC3\xADr",
          "54"  => "Fimmt\xC3\xADu og fj\xC3\xB3rir",
          "55"  => "Fimmt\xC3\xADu og fimm",
          "56"  => "Fimmt\xC3\xADu og sex",
          "57"  => "Fimmt\xC3\xADu og sj\xC3\xB6",
          "58"  => "Fimmt\xC3\xADu og \xC3\xA1tta",
          "59"  => "Fimmt\xC3\xADu og n\xC3\xADu",
          "60"  => "sext\xC3\xADu",
          "61"  => "sext\xC3\xADu og einn",
          "62"  => "sext\xC3\xADu og tveir",
          "63"  => "sext\xC3\xADu og \xC3\xBEr\xC3\xADr",
          "64"  => "sext\xC3\xADu og fj\xC3\xB3rir",
          "65"  => "sext\xC3\xADu og fimm",
          "66"  => "sext\xC3\xADu og sex",
          "67"  => "Sext\xC3\xADu og sj\xC3\xB6",
          "68"  => "sext\xC3\xADu og \xC3\xA1tta",
          "69"  => "sext\xC3\xADu og n\xC3\xADu",
          "70"  => "sj\xC3\xB6t\xC3\xADu",
          "71"  => "sj\xC3\xB6t\xC3\xADu og einn",
          "72"  => "sj\xC3\xB6t\xC3\xADu og tveir",
          "73"  => pack("H*","736ac3b674c3ad75206f6720c3be72c3ad72"),
          "74"  => "sj\xC3\xB6t\xC3\xADu og fj\xC3\xB3rir",
          "75"  => "sj\xC3\xB6t\xC3\xADu og fimm",
          "76"  => "sj\xC3\xB6t\xC3\xADu og sex",
          "77"  => "sj\xC3\xB6t\xC3\xADu og sj\xC3\xB6",
          "78"  => "sj\xC3\xB6t\xC3\xADu og \xC3\xA1tta",
          "79"  => "sj\xC3\xB6t\xC3\xADu og n\xC3\xADu",
          "80"  => "\xC3\xA1ttat\xC3\xADu",
          "81"  => "\xC3\xA1ttat\xC3\xADu og einn",
          "82"  => "attat\xC3\xADu og tveir",
          "83"  => "attat\xC3\xADu og \xC3\xBEr\xC3\xADr",
          "84"  => "\xC3\xA1ttat\xC3\xADu og fj\xC3\xB3rir",
          "85"  => "\xC3\xA1ttat\xC3\xADu og fimm",
          "86"  => "\xC3\xA1ttat\xC3\xADu og sex",
          "87"  => "\xC3\xA1ttat\xC3\xADu og sj\xC3\xB6",
          "88"  => "\xC3\x81ttat\xC3\xADu og \xC3\xA1tta",
          "89"  => "\xC3\x81ttat\xC3\xADu og n\xC3\xADu",
          "90"  => "n\xC3\xADut\xC3\xADu",
          "91"  => "n\xC3\xADut\xC3\xADu og einn",
          "92"  => "n\xC3\xADut\xC3\xADu og tveir",
          "93"  => pack("H*","6ec3ad7574c3ad75206f6720c3be72c3ad72"),
          "94"  => "n\xC3\xADut\xC3\xADu og fj\xC3\xB3rir",
          "95"  => "n\xC3\xADut\xC3\xADu og fimm",
          "96"  => "n\xC3\xADut\xC3\xADu og sex",
          "97"  => "n\xC3\xADut\xC3\xADu og sj\xC3\xB6",
          "98"  => "n\xC3\xADut\xC3\xADu og \xC3\xA1tta",
          "99"  => "n\xC3\xADut\xC3\xADu og n\xC3\xADu",
          "100" => "eitt hundra\xC3\xB0",
        },
  it => {
          "0"   => "zero",
          "1"   => "uno",
          "2"   => "due",
          "3"   => "tre",
          "4"   => "quattro",
          "5"   => "cinque",
          "6"   => "sei",
          "7"   => "sette",
          "8"   => "otto",
          "9"   => "nove",
          "10"  => "dieci",
          "11"  => "undici",
          "12"  => "dodici",
          "13"  => "tredici",
          "14"  => "quattordici",
          "15"  => "quindici",
          "16"  => "sedici",
          "17"  => "diciassette",
          "18"  => "diciotto",
          "19"  => "diciannove",
          "20"  => "venti",
          "21"  => "ventuno",
          "22"  => "ventidue",
          "23"  => "ventitre",
          "24"  => "ventiquattro",
          "25"  => "venticinque",
          "26"  => "ventisei",
          "27"  => "ventisette",
          "28"  => "ventotto",
          "29"  => "ventinove",
          "30"  => "trenta",
          "31"  => "trentuno",
          "32"  => "trentadue",
          "33"  => "trentatre",
          "34"  => "trentaquattro",
          "35"  => "trentacinque",
          "36"  => "trentasei",
          "37"  => "trentasette",
          "38"  => "trentotto",
          "39"  => "trentanove",
          "40"  => "quaranta",
          "41"  => "quarantuno",
          "42"  => "quarantadue",
          "43"  => "quarantatre",
          "44"  => "quarantaquattro",
          "45"  => "quarantacinque",
          "46"  => "quarantasei",
          "47"  => "quarantasette",
          "48"  => "quarantotto",
          "49"  => "quarantanove",
          "50"  => "cinquanta",
          "51"  => "cinquantuno",
          "52"  => "cinquantadue",
          "53"  => "cinquantatre",
          "54"  => "cinquantaquattro",
          "55"  => "cinquantacinque",
          "56"  => "cinquantasei",
          "57"  => "cinquantasette",
          "58"  => "cinquantotto",
          "59"  => "cinquantanove",
          "60"  => "sessanta",
          "61"  => "sessantuno",
          "62"  => "sessantadue",
          "63"  => "sessantatre",
          "64"  => "sessantaquattro",
          "65"  => "sessantacinque",
          "66"  => "sessantasei",
          "67"  => "sessantasette",
          "68"  => "sessantotto",
          "69"  => "sessantanove",
          "70"  => "settanta",
          "71"  => "settantuno",
          "72"  => "settantadue",
          "73"  => "settantatre",
          "74"  => "settantaquattro",
          "75"  => "settantacinque",
          "76"  => "settantasei",
          "77"  => "settantasette",
          "78"  => "settantotto",
          "79"  => "settantanove",
          "80"  => "ottanta",
          "81"  => "ottantuno",
          "82"  => "ottantadue",
          "83"  => "ottantatre",
          "84"  => "ottantaquattro",
          "85"  => "ottantacinque",
          "86"  => "ottantasei",
          "87"  => "ottantasette",
          "88"  => "ottantotto",
          "89"  => "ottantanove",
          "90"  => "novanta",
          "91"  => "novantuno",
          "92"  => "novantadue",
          "93"  => "novantatre",
          "94"  => "novantaquattro",
          "95"  => "novantacinque",
          "96"  => "novantasei",
          "97"  => "novantasette",
          "98"  => "novantotto",
          "99"  => "novantanove",
          "100" => "cento",
        },
  ja => {
          "0"   => "rei",
          "1"   => "ichi",
          "2"   => "ni",
          "3"   => "san",
          "4"   => "yon",
          "5"   => "go",
          "6"   => "roku",
          "7"   => "nana",
          "8"   => "hachi",
          "9"   => "kyuu",
          "10"  => "juu",
          "11"  => "juuichi",
          "12"  => "juuni",
          "13"  => "juusan",
          "14"  => "juushi",
          "15"  => "juugo",
          "16"  => "juuroku",
          "17"  => "juushichi",
          "18"  => "juuhachi",
          "19"  => "juuku",
          "20"  => "nijuu",
          "21"  => "nijuuichi",
          "22"  => "nijuuni",
          "23"  => "nijuusan",
          "24"  => "nijuushi",
          "25"  => "nijuugo",
          "26"  => "nijuuroku",
          "27"  => "nijuushichi",
          "28"  => "nijuuhachi",
          "29"  => "nijuuku",
          "30"  => "sanjuu",
          "31"  => "sanjuuichi",
          "32"  => "sanjuuni",
          "33"  => "sanjuusan",
          "34"  => "sanjuushi",
          "35"  => "sanjuugo",
          "36"  => "sanjuuroku",
          "37"  => "sanjuushichi",
          "38"  => "sanjuuhachi",
          "39"  => "sanjuuku",
          "40"  => "yonjuu",
          "41"  => "yonjuuichi",
          "42"  => "yonjuuni",
          "43"  => "yonjuusan",
          "44"  => "yonjuushi",
          "45"  => "yonjuugo",
          "46"  => "yonjuuroku",
          "47"  => "yonjuushichi",
          "48"  => "yonjuuhachi",
          "49"  => "yonjuuku",
          "50"  => "gojuu",
          "51"  => "gojuuichi",
          "52"  => "gojuuni",
          "53"  => "gojuusan",
          "54"  => "gojuushi",
          "55"  => "gojuugo",
          "56"  => "gojuuroku",
          "57"  => "gojuushichi",
          "58"  => "gojuuhachi",
          "59"  => "gojuuku",
          "60"  => "rokujuu",
          "61"  => "rokujuuichi",
          "62"  => "rokujuuni",
          "63"  => "rokujuusan",
          "64"  => "rokujuushi",
          "65"  => "rokujuugo",
          "66"  => "rokujuuroku",
          "67"  => "rokujuushichi",
          "68"  => "rokujuuhachi",
          "69"  => "rokujuuku",
          "70"  => "nanajuu",
          "71"  => "nanajuuichi",
          "72"  => "nanajuuni",
          "73"  => "nanajuusan",
          "74"  => "nanajuushi",
          "75"  => "nanajuugo",
          "76"  => "nanajuuroku",
          "77"  => "nanajuushichi",
          "78"  => "nanajuuhachi",
          "79"  => "nanajuuku",
          "80"  => "hachijuu",
          "81"  => "hachijuuichi",
          "82"  => "hachijuuni",
          "83"  => "hachijuusan",
          "84"  => "hachijuushi",
          "85"  => "hachijuugo",
          "86"  => "hachijuuroku",
          "87"  => "hachijuushichi",
          "88"  => "hachijuuhachi",
          "89"  => "hachijuuku",
          "90"  => "kyuujuu",
          "91"  => "kyuujuuichi",
          "92"  => "kyuujuuni",
          "93"  => "kyuujuusan",
          "94"  => "kyuujuushi",
          "95"  => "kyuujuugo",
          "96"  => "kyuujuuroku",
          "97"  => "kyuujuushichi",
          "98"  => "kyuujuuhachi",
          "99"  => "kyuujuuku",
          "100" => "hyaku",
        },
  nb => {
          "0"   => "null",
          "1"   => "en",
          "2"   => "to",
          "3"   => "tre",
          "4"   => "fire",
          "5"   => "fem",
          "6"   => "seks",
          "7"   => "syv",
          "8"   => "\xC3\xA5tte",
          "9"   => "ni",
          "10"  => "ti",
          "11"  => "elleve",
          "12"  => "tolv",
          "13"  => "tretten",
          "14"  => "fjorten",
          "15"  => "femten",
          "16"  => "seksten",
          "17"  => "sytten",
          "18"  => "atten",
          "19"  => "nitten",
          "20"  => "tjue",
          "21"  => "tjueen",
          "22"  => "tjueto",
          "23"  => "tjuetre",
          "24"  => "tjuefire",
          "25"  => "tjuefem",
          "26"  => "tjueseks",
          "27"  => "tjuesyv",
          "28"  => "tjue\xC3\xA5tte",
          "29"  => "tjueni",
          "30"  => "tretti",
          "31"  => "trettien",
          "32"  => "trettito",
          "33"  => "trettitre",
          "34"  => "trettifire",
          "35"  => "trettifem",
          "36"  => "trettiseks",
          "37"  => "trettisyv",
          "38"  => "tretti\xC3\xA5tte",
          "39"  => "trettini",
          "40"  => "f\xC3\xB8rti",
          "41"  => "f\xC3\xB8rtien",
          "42"  => "f\xC3\xB8rtito",
          "43"  => "f\xC3\xB8rtitre",
          "44"  => "f\xC3\xB8rtifire",
          "45"  => "f\xC3\xB8rtifem",
          "46"  => "f\xC3\xB8rtiseks",
          "47"  => "f\xC3\xB8rtisyv",
          "48"  => "f\xC3\xB8rti\xC3\xA5tte",
          "49"  => "f\xC3\xB8rtini",
          "50"  => "femti",
          "51"  => "femtien",
          "52"  => "femtito",
          "53"  => "femtitre",
          "54"  => "femtifire",
          "55"  => "femtifem",
          "56"  => "femtiseks",
          "57"  => "femtisyv",
          "58"  => "femti\xC3\xA5tte",
          "59"  => "femtini",
          "60"  => "seksti",
          "61"  => "sekstien",
          "62"  => "sekstito",
          "63"  => "sekstitre",
          "64"  => "sekstifire",
          "65"  => "sekstifem",
          "66"  => "sekstiseks",
          "67"  => "sekstisyv",
          "68"  => "seksti\xC3\xA5tte",
          "69"  => "sekstini",
          "70"  => "sytti",
          "71"  => "syttien",
          "72"  => "syttito",
          "73"  => "syttitre",
          "74"  => "syttifire",
          "75"  => "syttifem",
          "76"  => "syttiseks",
          "77"  => "syttisyv",
          "78"  => "sytti\xC3\xA5tte",
          "79"  => "syttini",
          "80"  => "\xC3\xA5tti",
          "81"  => "\xC3\xA5ttien",
          "82"  => "\xC3\xA5ttito",
          "83"  => "\xC3\xA5ttitre",
          "84"  => "\xC3\xA5ttifire",
          "85"  => "\xC3\xA5ttifem",
          "86"  => "\xC3\xA5ttiseks",
          "87"  => "\xC3\xA5ttisyv",
          "88"  => "\xC3\xA5tti\xC3\xA5tte",
          "89"  => "\xC3\xA5ttini",
          "90"  => "nitti",
          "91"  => "nittien",
          "92"  => "nittito",
          "93"  => "nittitre",
          "94"  => "nittifire",
          "95"  => "nittifem",
          "96"  => "nittiseks",
          "97"  => "nittisyv",
          "98"  => "nitti\xC3\xA5tte",
          "99"  => "nittini",
          "100" => "hundre",
        },
  nl => {
          "0"   => "nul",
          "1"   => "een",
          "2"   => "twee",
          "3"   => "drie",
          "4"   => "vier",
          "5"   => "vijf",
          "6"   => "zes",
          "7"   => "zeven",
          "8"   => "acht",
          "9"   => "negen",
          "10"  => "tien",
          "11"  => "elf",
          "12"  => "twaalf",
          "13"  => "dertien",
          "14"  => "veertien",
          "15"  => "vijftien",
          "16"  => "zestien",
          "17"  => "zeventien",
          "18"  => "achttien",
          "19"  => "negentien",
          "20"  => "twintig",
          "21"  => "eenentwintig",
          "22"  => "twee\xC3\xABntwintig",
          "23"  => "drie\xC3\xABntwintig",
          "24"  => "vierentwintig",
          "25"  => "vijfentwintig",
          "26"  => "zesentwintig",
          "27"  => "zevenentwintig",
          "28"  => "achtentwintig",
          "29"  => "negenentwintig",
          "30"  => "dertig",
          "31"  => "eenendertig",
          "32"  => "twee\xC3\xABndertig",
          "33"  => "drie\xC3\xABndertig",
          "34"  => "vierendertig",
          "35"  => "vijfendertig",
          "36"  => "zesendertig",
          "37"  => "zevenendertig",
          "38"  => "achtendertig",
          "39"  => "negenendertig",
          "40"  => "veertig",
          "41"  => "eenenveertig",
          "42"  => "twee\xC3\xABnveertig",
          "43"  => "drie\xC3\xABnveertig",
          "44"  => "vierenveertig",
          "45"  => "vijfenveertig",
          "46"  => "zesenveertig",
          "47"  => "zevenenveertig",
          "48"  => "achtenveertig",
          "49"  => "negenenveertig",
          "50"  => "vijftig",
          "51"  => "eenenvijftig",
          "52"  => "twee\xC3\xABnvijftig",
          "53"  => "drie\xC3\xABnvijftig",
          "54"  => "vierenvijftig",
          "55"  => "vijfenvijftig",
          "56"  => "zesenvijftig",
          "57"  => "zevenenvijftig",
          "58"  => "achtenvijftig",
          "59"  => "negenenvijftig",
          "60"  => "zestig",
          "61"  => "eenenzestig",
          "62"  => "twee\xC3\xABnzestig",
          "63"  => "drie\xC3\xABnzestig",
          "64"  => "vierenzestig",
          "65"  => "vijfenzestig",
          "66"  => "zesenzestig",
          "67"  => "zevenenzestig",
          "68"  => "achtenzestig",
          "69"  => "negenenzestig",
          "70"  => "zeventig",
          "71"  => "eenenzeventig",
          "72"  => "twee\xC3\xABnzeventig",
          "73"  => "drie\xC3\xABnzeventig",
          "74"  => "vierenzeventig",
          "75"  => "vijfenzeventig",
          "76"  => "zesenzeventig",
          "77"  => "zevenenzeventig",
          "78"  => "achtenzeventig",
          "79"  => "negenenzeventig",
          "80"  => "tachtig",
          "81"  => "eenentachtig",
          "82"  => "twee\xC3\xABntachtig",
          "83"  => "drie\xC3\xABntachtig",
          "84"  => "vierentachtig",
          "85"  => "vijfentachtig",
          "86"  => "zesentachtig",
          "87"  => "zevenentachtig",
          "88"  => "achtentachtig",
          "89"  => "negenentachtig",
          "90"  => "negentig",
          "91"  => "eenennegentig",
          "92"  => "twee\xC3\xABnnegentig",
          "93"  => "drie\xC3\xABnnegentig",
          "94"  => "vierennegentig",
          "95"  => "vijfennegentig",
          "96"  => "zesennegentig",
          "97"  => "zevenennegentig",
          "98"  => "achtennegentig",
          "99"  => "negenennegentig",
          "100" => "honderd",
        },
  pl => {
          "0"   => "zero",
          "1"   => "jeden",
          "2"   => "dwa",
          "3"   => "trzy",
          "4"   => "cztery",
          "5"   => "piec",
          "6"   => "szesc",
          "7"   => "siedem",
          "8"   => "osiem",
          "9"   => "dziewiec",
          "10"  => "dziesiec",
          "11"  => "jedenascie",
          "12"  => "dwanascie",
          "13"  => "trzynascie",
          "14"  => "czternascie",
          "15"  => "pietnascie",
          "16"  => "szesnascie",
          "17"  => "siedemnascie",
          "18"  => "osiemnascie",
          "19"  => "dziewietnascie",
          "20"  => "dwadziescia",
          "21"  => "dwadziesciajeden",
          "22"  => "dwadziesciadwa",
          "23"  => "dwadziesciatrzy",
          "24"  => "dwadziesciacztery",
          "25"  => "dwadziesciapiec",
          "26"  => "dwadziesciaszesc",
          "27"  => "dwadziesciasiedem",
          "28"  => "dwadziesciaosiem",
          "29"  => "dwadziesciadziewiec",
          "30"  => "trzydz\xC3\xACesci",
          "31"  => "trzydz\xC3\xACescijeden",
          "32"  => "trzydz\xC3\xACescidwa",
          "33"  => "trzydz\xC3\xACescitrzy",
          "34"  => "trzydz\xC3\xACescicztery",
          "35"  => "trzydz\xC3\xACescipiec",
          "36"  => "trzydz\xC3\xACesciszesc",
          "37"  => "trzydz\xC3\xACescisiedem",
          "38"  => "trzydz\xC3\xACesciosiem",
          "39"  => "trzydz\xC3\xACescidziewiec",
          "40"  => "czterdziesci",
          "41"  => "czterdziescijeden",
          "42"  => "czterdziescidwa",
          "43"  => "czterdziescitrzy",
          "44"  => "czterdziescicztery",
          "45"  => "czterdziescipiec",
          "46"  => "czterdziesciszesc",
          "47"  => "czterdziescisiedem",
          "48"  => "czterdziesciosiem",
          "49"  => "czterdziescidziewiec",
          "50"  => "piecdziesiat",
          "51"  => "piecdziesiatjeden",
          "52"  => "piecdziesiatdwa",
          "53"  => "piecdziesiattrzy",
          "54"  => "piecdziesiatcztery",
          "55"  => "piecdziesiatpiec",
          "56"  => "piecdziesiatszesc",
          "57"  => "piecdziesiatsiedem",
          "58"  => "piecdziesiatosiem",
          "59"  => "piecdziesiatdziewiec",
          "60"  => "szescdziesiat",
          "61"  => "szescdziesiatjeden",
          "62"  => "szescdziesiatdwa",
          "63"  => "szescdziesiattrzy",
          "64"  => "szescdziesiatcztery",
          "65"  => "szescdziesiatpiec",
          "66"  => "szescdziesiatszesc",
          "67"  => "szescdziesiatsiedem",
          "68"  => "szescdziesiatosiem",
          "69"  => "szescdziesiatdziewiec",
          "70"  => "siedemdziesiat",
          "71"  => "siedemdziesiatjeden",
          "72"  => "siedemdziesiatdwa",
          "73"  => "siedemdziesiattrzy",
          "74"  => "siedemdziesiatcztery",
          "75"  => "siedemdziesiatpiec",
          "76"  => "siedemdziesiatszesc",
          "77"  => "siedemdziesiatsiedem",
          "78"  => "siedemdziesiatosiem",
          "79"  => "siedemdziesiatdziewiec",
          "80"  => "osiemdziesiat",
          "81"  => "osiemdziesiatjeden",
          "82"  => "osiemdziesiatdwa",
          "83"  => "osiemdziesiattrzy",
          "84"  => "osiemdziesiatcztery",
          "85"  => "osiemdziesiatpiec",
          "86"  => "osiemdziesiatszesc",
          "87"  => "osiemdziesiatsiedem",
          "88"  => "osiemdziesiatosiem",
          "89"  => "osiemdziesiatdziewiec",
          "90"  => "dziewiecdziesiat",
          "91"  => "dziewiecdziesiatjeden",
          "92"  => "dziewiecdziesiatdwa",
          "93"  => "dziewiecdziesiattrzy",
          "94"  => "dziewiecdziesiatcztery",
          "95"  => "dziewiecdziesiatpiec",
          "96"  => "dziewiecdziesiatszesc",
          "97"  => "dziewiecdziesiatsiedem",
          "98"  => "dziewiecdziesiatosiem",
          "99"  => "dziewiecdziesiatdziewiec",
          "100" => "sto",
        },
  pt => {
          "0"   => "zero",
          "1"   => "um",
          "2"   => "dois",
          "3"   => "tr\xC3\xAAs",
          "4"   => "quatro",
          "5"   => "cinco",
          "6"   => "seis",
          "7"   => "sete",
          "8"   => "oito",
          "9"   => "nove",
          "10"  => "dez",
          "11"  => "onze",
          "12"  => "doze",
          "13"  => "treze",
          "14"  => "catorze",
          "15"  => "quinze",
          "16"  => "dezasseis",
          "17"  => "dezassete",
          "18"  => "dezoito",
          "19"  => "dezanove",
          "20"  => "vinte",
          "21"  => "vintee um",
          "22"  => "vintee dois",
          "23"  => "vintee tr\xC3\xAAs",
          "24"  => "vintee quatro",
          "25"  => "vintee cinco",
          "26"  => "vintee seis",
          "27"  => "vintee sete",
          "28"  => "vintee oito",
          "29"  => "vintee nove",
          "30"  => "trinta",
          "31"  => "trintae um",
          "32"  => "trintae dois",
          "33"  => "trintae tr\xC3\xAAs",
          "34"  => "trintae quatro",
          "35"  => "trintae cinco",
          "36"  => "trintae seis",
          "37"  => "trintae sete",
          "38"  => "trintae oito",
          "39"  => "trintae nove",
          "40"  => "quarenta",
          "41"  => "quarentae um",
          "42"  => "quarentae dois",
          "43"  => "quarentae tr\xC3\xAAs",
          "44"  => "quarentae quatro",
          "45"  => "quarentae cinco",
          "46"  => "quarentae seis",
          "47"  => "quarentae sete",
          "48"  => "quarentae oito",
          "49"  => "quarentae nove",
          "50"  => "cinquenta",
          "51"  => "cinquentae um",
          "52"  => "cinquentae dois",
          "53"  => "cinquentae tr\xC3\xAAs",
          "54"  => "cinquentae quatro",
          "55"  => "cinquentae cinco",
          "56"  => "cinquentae seis",
          "57"  => "cinquentae sete",
          "58"  => "cinquentae oito",
          "59"  => "cinquentae nove",
          "60"  => "sessenta",
          "61"  => "sessentae um",
          "62"  => "sessentae dois",
          "63"  => "sessentae tr\xC3\xAAs",
          "64"  => "sessentae quatro",
          "65"  => "sessentae cinco",
          "66"  => "sessentae seis",
          "67"  => "sessentae sete",
          "68"  => "sessentae oito",
          "69"  => "sessentae nove",
          "70"  => "setenta",
          "71"  => "setentae um",
          "72"  => "setentae dois",
          "73"  => "setentae tr\xC3\xAAs",
          "74"  => "setentae quatro",
          "75"  => "setentae cinco",
          "76"  => "setentae seis",
          "77"  => "setentae sete",
          "78"  => "setentae oito",
          "79"  => "setentae nove",
          "80"  => "oitenta",
          "81"  => "oitentae um",
          "82"  => "oitentae dois",
          "83"  => "oitentae tr\xC3\xAAs",
          "84"  => "oitentae quatro",
          "85"  => "oitentae cinco",
          "86"  => "oitentae seis",
          "87"  => "oitentae sete",
          "88"  => "oitentae oito",
          "89"  => "oitentae nove",
          "90"  => "noventa",
          "91"  => "noventae um",
          "92"  => "noventae dois",
          "93"  => "noventae tr\xC3\xAAs",
          "94"  => "noventae quatro",
          "95"  => "noventae cinco",
          "96"  => "noventae seis",
          "97"  => "noventae sete",
          "98"  => "noventae oito",
          "99"  => "noventae nove",
          "100" => "cem",
        },
  ro => {
          "0"   => "zero",
          "1"   => "unu",
          "2"   => "doi",
          "3"   => "trei",
          "4"   => "patru",
          "5"   => "cinci",
          "6"   => "sase",
          "7"   => "sapte",
          "8"   => "opt",
          "9"   => "noua",
          "10"  => "zece",
          "11"  => "unsprezece",
          "12"  => "doisprezece",
          "13"  => "treisprezece",
          "14"  => "paisprezece",
          "15"  => "cincisprezece",
          "16"  => "saisprezece",
          "17"  => "saptesprezece",
          "18"  => "optsprezece",
          "19"  => "nouasprezece",
          "20"  => "douazeci",
          "21"  => "douazecisiunu",
          "22"  => "douazecisidoi",
          "23"  => "douazecisitrei",
          "24"  => "douazecisipatru",
          "25"  => "douazecisicinci",
          "26"  => "douazecisisase",
          "27"  => "douazecisisapte",
          "28"  => "douazecisiopt",
          "29"  => "douazecisinoua",
          "30"  => "treizeci",
          "31"  => "treizecisiunu",
          "32"  => "treizecisidoi",
          "33"  => "treizecisitrei",
          "34"  => "treizecisipatru",
          "35"  => "treizecisicinci",
          "36"  => "treizecisisase",
          "37"  => "treizecisisapte",
          "38"  => "treizecisiopt",
          "39"  => "treizecisinoua",
          "40"  => "patruzeci",
          "41"  => "patruzecisiunu",
          "42"  => "patruzecisidoi",
          "43"  => "patruzecisitrei",
          "44"  => "patruzecisipatru",
          "45"  => "patruzecisicinci",
          "46"  => "patruzecisisase",
          "47"  => "patruzecisisapte",
          "48"  => "patruzecisiopt",
          "49"  => "patruzecisinoua",
          "50"  => "cincizeci",
          "51"  => "cincizecisiunu",
          "52"  => "cincizecisidoi",
          "53"  => "cincizecisitrei",
          "54"  => "cincizecisipatru",
          "55"  => "cincizecisicinci",
          "56"  => "cincizecisisase",
          "57"  => "cincizecisisapte",
          "58"  => "cincizecisiopt",
          "59"  => "cincizecisinoua",
          "60"  => "saizeci",
          "61"  => "saizecisiunu",
          "62"  => "saizecisidoi",
          "63"  => "saizecisitrei",
          "64"  => "saizecisipatru",
          "65"  => "saizecisicinci",
          "66"  => "saizecisisase",
          "67"  => "saizecisisapte",
          "68"  => "saizecisiopt",
          "69"  => "saizecisinoua",
          "70"  => "saptezeci",
          "71"  => "saptezecisiunu",
          "72"  => "saptezecisidoi",
          "73"  => "saptezecisitrei",
          "74"  => "saptezecisipatru",
          "75"  => "saptezecisicinci",
          "76"  => "saptezecisisase",
          "77"  => "saptezecisisapte",
          "78"  => "saptezecisiopt",
          "79"  => "saptezecisinoua",
          "80"  => "optzeci",
          "81"  => "optzecisiunu",
          "82"  => "optzecisidoi",
          "83"  => "optzecisitrei",
          "84"  => "optzecisipatru",
          "85"  => "optzecisicinci",
          "86"  => "optzecisisase",
          "87"  => "optzecisisapte",
          "88"  => "optzecisiopt",
          "89"  => "optzecisinoua",
          "90"  => "nouazeci",
          "91"  => "nouazecisiunu",
          "92"  => "nouazecisidoi",
          "93"  => "nouazecisitrei",
          "94"  => "nouazecisipatru",
          "95"  => "nouazecisicinci",
          "96"  => "nouazecisisase",
          "97"  => "nouazecisisapte",
          "98"  => "nouazecisiopt",
          "99"  => "nouazecisinoua",
          "100" => "o suta",
        },
  ru => {
          "0"   => "\xD0\xBD\xD0\xBE\xD0\xBB\xD1\x8C",
          "1"   => "\xD0\xBE\xD0\xB4\xD0\xB8\xD0\xBD",
          "2"   => "\xD0\xB4\xD0\xB2\xD0\xB0",
          "3"   => "\xD1\x82\xD1\x80\xD0\xB8",
          "4"   => pack("H*","d187d0b5d182d18bd180d0b5"),
          "5"   => "\xD0\xBF\xD1\x8F\xD1\x82\xD1\x8C",
          "6"   => pack("H*","d188d0b5d181d182d18c"),
          "7"   => "\xD1\x81\xD0\xB5\xD0\xBC\xD1\x8C",
          "8"   => pack("H*","d0b2d0bed181d0b5d0bcd18c"),
          "9"   => pack("H*","d0b4d0b5d0b2d18fd182d18c"),
          "10"  => pack("H*","d0b4d0b5d181d18fd182d18c"),
          "11"  => pack("H*","d0bed0b4d0b8d0bdd0bdd0b0d0b4d186d0b0d182d18c"),
          "12"  => pack("H*","d0b4d0b2d0b5d0bdd0b0d0b4d186d0b0d182d18c"),
          "13"  => pack("H*","d182d180d0b8d0bdd0b0d0b4d186d0b0d182d18c"),
          "14"  => pack("H*","d187d0b5d182d18bd180d0bdd0b0d0b4d186d0b0d182d18c"),
          "15"  => pack("H*","d0bfd18fd182d0bdd0b0d0b4d186d0b0d182d0b8"),
          "16"  => pack("H*","d188d0b5d181d182d0bdd0b0d0b4d186d0b0d182d18c"),
          "17"  => pack("H*","d181d0b5d0bcd0bdd0b0d0b4d186d0b0d182d18c"),
          "18"  => pack("H*","d0b2d0bed181d0b5d0bcd0bdd0b0d0b4d186d0b0d182d18c"),
          "19"  => pack("H*","d0b4d0b5d0b2d18fd182d0bdd0b0d0b4d186d0b0d182d0b8"),
          "20"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c"),
          "21"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d0bed0b4d0b8d0bd20d0b3d0bed0b4"),
          "22"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d0b4d0b2d0b0"),
          "23"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d182d180d0b8"),
          "24"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d187d0b5d182d18bd180d0b5"),
          "25"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d0bfd18fd182d18c"),
          "26"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d188d0b5d181d182d18c"),
          "27"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d181d0b5d0bcd18c"),
          "28"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d0b2d0bed181d0b5d0bcd18c"),
          "29"  => pack("H*","d0b4d0b2d0b0d0b4d186d0b0d182d18c20d0b4d0b5d0b2d18fd182d18c"),
          "30"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c"),
          "31"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d0bed0b4d0b8d0bd"),
          "32"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d0b4d0b2d0b0"),
          "33"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d182d180d0b8"),
          "34"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d187d0b5d182d18bd180d0b5"),
          "35"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d0bfd18fd182d18c"),
          "36"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d188d0b5d181d182d18c"),
          "37"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d181d0b5d0bcd18c"),
          "38"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d0b2d0bed181d0b5d0bcd18c"),
          "39"  => pack("H*","d182d180d0b8d0b4d186d0b0d182d18c20d0b4d0b5d0b2d18fd182d18c"),
          "40"  => pack("H*","d181d0bed180d0bed0ba"),
          "41"  => pack("H*","d181d0bed180d0bed0ba20d0bed0b4d0b8d0bd"),
          "42"  => pack("H*","d181d0bed180d0bed0ba20d0b4d0b2d0b0"),
          "43"  => pack("H*","d181d0bed180d0bed0ba20d182d180d0b8"),
          "44"  => pack("H*","d181d0bed180d0bed0ba20d187d0b5d182d18bd180d0b5"),
          "45"  => pack("H*","d181d0bed180d0bed0ba20d0bfd18fd182d18c"),
          "46"  => pack("H*","d181d0bed180d0bed0ba20d188d0b5d181d182d18c"),
          "47"  => pack("H*","d181d0bed180d0bed0ba20d181d0b5d0bcd18c"),
          "48"  => pack("H*","d181d0bed180d0bed0ba20d0b2d0bed181d0b5d0bcd18c"),
          "49"  => pack("H*","d181d0bed180d0bed0ba20d0b4d0b5d0b2d18fd182d18c"),
          "50"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd182"),
          "51"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d0bed0b4d0b8d0bd"),
          "52"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d0b4d0b2d0b0"),
          "53"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d182d180d0b8"),
          "54"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d187d0b5d182d18bd180d0b5"),
          "55"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d0bfd18fd182d18c"),
          "56"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d188d0b5d181d182d18c"),
          "57"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d181d0b5d0bcd18c"),
          "58"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d0b2d0bed181d0b5d0bcd18c"),
          "59"  => pack("H*","d0bfd18fd182d18cd0b4d0b5d181d18fd18220d0b4d0b5d0b2d18fd182d18c"),
          "60"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd182"),
          "61"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d0bed0b4d0b8d0bd"),
          "62"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d0b4d0b2d0b0"),
          "63"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d182d180d0b8"),
          "64"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d187d0b5d182d18bd180d0b5"),
          "65"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d0bfd18fd182d18c"),
          "66"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d188d0b5d181d182d18c"),
          "67"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d181d0b5d0bcd18c"),
          "68"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d0b2d0bed181d0b5d0bcd18c"),
          "69"  => pack("H*","d188d0b5d181d182d18cd0b4d0b5d181d18fd18220d0b4d0b5d0b2d18fd182d18c"),
          "70"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd182"),
          "71"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0bed0b4d0b8d0bd"),
          "72"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0b4d0b2d0b0"),
          "73"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d182d180d0b8"),
          "74"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d187d0b5d182d18bd180d0b5"),
          "75"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0bfd18fd182d18c"),
          "76"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d188d0b5d181d182d18c"),
          "77"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d181d0b5d0bcd18c"),
          "78"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0b2d0bed181d0b5d0bcd18c"),
          "79"  => pack("H*","d181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0b4d0b5d0b2d18fd182d18c"),
          "80"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd182"),
          "81"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0bed0b4d0b8d0bd"),
          "82"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0b4d0b2d0b0"),
          "83"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d182d180d0b8"),
          "84"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d187d0b5d182d18bd180d0b5"),
          "85"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0bfd18fd182d18c"),
          "86"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d188d0b5d181d182d18c"),
          "87"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d181d0b5d0bcd18c"),
          "88"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0b2d0bed181d0b5d0bcd18c"),
          "89"  => pack("H*","d0b2d0bed181d0b5d0bcd18cd0b4d0b5d181d18fd18220d0b4d0b5d0b2d18fd182d18c"),
          "90"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be"),
          "91"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d0bed0b4d0b8d0bd"),
          "92"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d0b4d0b2d0b0"),
          "93"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d182d180d0b8"),
          "94"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d187d0b5d182d18bd180d0b5"),
          "95"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d0bfd18fd182d18c"),
          "96"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d188d0b5d181d182d18c"),
          "97"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d181d0b5d0bcd18c"),
          "98"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d0b2d0bed181d0b5d0bcd18c"),
          "99"  => pack("H*","d0b4d0b5d0b2d18fd0bdd0bed181d182d0be20d0b4d0b5d0b2d18fd182d18c"),
          "100" => "\xD1\x81\xD1\x82\xD0\xBE",
        },
  sv => {
          "0"   => "noll",
          "1"   => "en",
          "2"   => "tv\xC3\xA5",
          "3"   => "tre",
          "4"   => "fyra",
          "5"   => "fem",
          "6"   => "sex",
          "7"   => "sju",
          "8"   => "\xC3\xA5tta",
          "9"   => "nio",
          "10"  => "tio",
          "11"  => "elva",
          "12"  => "tolv",
          "13"  => "tretton",
          "14"  => "fjorton",
          "15"  => "femton",
          "16"  => "sexton",
          "17"  => "sjutton",
          "18"  => "arton",
          "19"  => "nitton",
          "20"  => "tjugo",
          "21"  => "tjugoen",
          "22"  => "tjugotv\xC3\xA5",
          "23"  => "tjugotre",
          "24"  => "tjugofyra",
          "25"  => "tjugofem",
          "26"  => "tjugosex",
          "27"  => "twenty-seven",
          "28"  => "tjugo\xC3\xA5tta",
          "29"  => "tjugonio",
          "30"  => "trettio",
          "31"  => "trettioen",
          "32"  => "trettiotv\xC3\xA5",
          "33"  => "trettiotre",
          "34"  => "trettiofyra",
          "35"  => "trettiofem",
          "36"  => "trettiosex",
          "37"  => "trettiosju",
          "38"  => "thirty-eight",
          "39"  => "trettionio",
          "40"  => "forty",
          "41"  => "fyrtioen",
          "42"  => "fyrtiotv\xC3\xA5",
          "43"  => "fyrtiotre",
          "44"  => "fyrtiofyra",
          "45"  => "fyrtiofem",
          "46"  => "fyrtiosex",
          "47"  => "fyrtiosju",
          "48"  => "fyrtio\xC3\xA5tta",
          "49"  => "fyrtionio",
          "50"  => "femtio",
          "51"  => "femtioen",
          "52"  => "femtiotv\xC3\xA5",
          "53"  => "femtiotre",
          "54"  => "femtiofyra",
          "55"  => "femtiofem",
          "56"  => "femtiosex",
          "57"  => "femtiosju",
          "58"  => "Femtio\xC3\xA5tta",
          "59"  => "femtinie",
          "60"  => "sextio",
          "61"  => "sextioen",
          "62"  => "sextiotv\xC3\xA5",
          "63"  => "sextiotre",
          "64"  => "sextiofyra",
          "65"  => "sextiofem",
          "66"  => "sextiosex",
          "67"  => "sextiosju",
          "68"  => "sextio\xC3\xA5tta",
          "69"  => "sextionio",
          "70"  => "sjuttio",
          "71"  => "Sjuttio-en",
          "72"  => "sjuttiotv\xC3\xA5",
          "73"  => "sjuttiotre",
          "74"  => "sjuttiofyra",
          "75"  => "sjuttiofem",
          "76"  => "sjuttiosex",
          "77"  => "sjuttiosju",
          "78"  => "sjuttio\xC3\xA5tta",
          "79"  => "sjuttionio",
          "80"  => "\xC3\xA5ttio",
          "81"  => "\xC3\xA5ttioen",
          "82"  => "\xC3\x85ttiotv\xC3\xA5",
          "83"  => "\xC3\x85ttiotre",
          "84"  => "\xC3\xA5ttiofyra",
          "85"  => "\xC3\xA5ttiofem",
          "86"  => "\xC3\xA5ttiosex",
          "87"  => "\xC3\xA5ttiosju",
          "88"  => "\xC3\xA5ttio\xC3\xA5tta",
          "89"  => "\xC3\x85ttionio",
          "90"  => "nittio",
          "91"  => "nittioen",
          "92"  => "nittiotv\xC3\xA5",
          "93"  => "Nittiotre",
          "94"  => "nittiofyra",
          "95"  => "nittiofem",
          "96"  => "Nittiosex",
          "97"  => "Nittiosju",
          "98"  => "nittio\xC3\xA5tta",
          "99"  => "nittionio",
          "100" => "hundra",
        },
  tr => {
          "0"   => "sifir",
          "1"   => "bir",
          "2"   => "iki",
          "3"   => "\xC3\xBC\xC3\xA7",
          "4"   => "d\xC3\xB6rt",
          "5"   => "bes",
          "6"   => "alti",
          "7"   => "yedi",
          "8"   => "sekiz",
          "9"   => "dokuz",
          "10"  => "on",
          "11"  => "on bir",
          "12"  => "on iki",
          "13"  => "on \xC3\xBC\xC3\xA7",
          "14"  => "on d\xC3\xB6rt",
          "15"  => "on bes",
          "16"  => "on alti",
          "17"  => "on yedi",
          "18"  => "on sekiz",
          "19"  => "on dokuz",
          "20"  => "yirmi",
          "21"  => "yirmi bir",
          "22"  => "yirmi iki",
          "23"  => "yirmi \xC3\xBC\xC3\xA7",
          "24"  => "yirmi d\xC3\xB6rt",
          "25"  => "yirmi bes",
          "26"  => "yirmi alti",
          "27"  => "yirmi yedi",
          "28"  => "yirmi sekiz",
          "29"  => "yirmi dokuz",
          "30"  => "otuz",
          "31"  => "otuz bir",
          "32"  => "otuz iki",
          "33"  => "otuz \xC3\xBC\xC3\xA7",
          "34"  => "otuz d\xC3\xB6rt",
          "35"  => "otuz bes",
          "36"  => "otuz alti",
          "37"  => "otuz yedi",
          "38"  => "otuz sekiz",
          "39"  => "otuz dokuz",
          "40"  => "kirk",
          "41"  => "kirk bir",
          "42"  => "kirk iki",
          "43"  => "kirk \xC3\xBC\xC3\xA7",
          "44"  => "kirk d\xC3\xB6rt",
          "45"  => "kirk bes",
          "46"  => "kirk alti",
          "47"  => "kirk yedi",
          "48"  => "kirk sekiz",
          "49"  => "kirk dokuz",
          "50"  => "elli",
          "51"  => "elli bir",
          "52"  => "elli iki",
          "53"  => "elli \xC3\xBC\xC3\xA7",
          "54"  => "elli d\xC3\xB6rt",
          "55"  => "elli bes",
          "56"  => "elli alti",
          "57"  => "elli yedi",
          "58"  => "elli sekiz",
          "59"  => "elli dokuz",
          "60"  => "altmis",
          "61"  => "altmis bir",
          "62"  => "altmis iki",
          "63"  => "altmis \xC3\xBC\xC3\xA7",
          "64"  => "altmis d\xC3\xB6rt",
          "65"  => "altmis bes",
          "66"  => "altmis alti",
          "67"  => "altmis yedi",
          "68"  => "altmis sekiz",
          "69"  => "altmis dokuz",
          "70"  => "yetmis",
          "71"  => "yetmis bir",
          "72"  => "yetmis iki",
          "73"  => "yetmis \xC3\xBC\xC3\xA7",
          "74"  => "yetmis d\xC3\xB6rt",
          "75"  => "yetmis bes",
          "76"  => "yetmis alti",
          "77"  => "yetmis yedi",
          "78"  => "yetmis sekiz",
          "79"  => "yetmis dokuz",
          "80"  => "seksen",
          "81"  => "seksen bir",
          "82"  => "seksen iki",
          "83"  => "seksen \xC3\xBC\xC3\xA7",
          "84"  => "seksen d\xC3\xB6rt",
          "85"  => "seksen bes",
          "86"  => "seksen alti",
          "87"  => "seksen yedi",
          "88"  => "seksen sekiz",
          "89"  => "seksen dokuz",
          "90"  => "doksan",
          "91"  => "doksan bir",
          "92"  => "doksan iki",
          "93"  => "doksan \xC3\xBC\xC3\xA7",
          "94"  => "doksan d\xC3\xB6rt",
          "95"  => "doksan bes",
          "96"  => "doksan alti",
          "97"  => "doksan yedi",
          "98"  => "doksan sekiz",
          "99"  => "doksan dokuz",
          "100" => "y\xC3\xBCz",
        },
  de=>{0=>"null",
       1=>"eins",
       2=>"zwei",
       3=>"drei",
       4=>"vier",
       5=>"fünf",
       6=>"sechs",
       7=>"sieben",
       8=>"acht",
       9=>"neun",
     10=>"zehn",
     11=>"elf",
     12=>"zwölf",
     13=>"dreizehn",
     14=>"vierzehn",
     15=>"fünfzehn",
     16=>"sechzehn",
     17=>"siebzehn",
     18=>"achtzehn",
     19=>"neunzehn",
     20=>"zwanzig",
     21=>"ein und zwanzig",
     22=>"zwei und zwanzig",
     23=>"drei und zwanzig",
     24=>"vier und zwanzig",
     25=>"fünf und zwanzig",
     26=>"sechs und zwanzig",
     27=>"sieben und zwanzig",
     28=>"acht und zwanzig",
     29=>"neun und zwanzig",
     30=>"dreiβig",
     31=>"ein und dreiβig",
     32=>"zwei und reißig",
     33=>"drei und dreißig",
     34=>"vier und dreißig",
     35=>"fünf und dreißig",
     36=>"sechs und dreißig",
     37=>"sieben und dreißig",
     38=>"acht und dreißig",
     39=>"neun und dreißig",
     40=>"vierzig",
     41=>"ein und vierzig",
     42=>"zwei und vierzig",
     43=>"drei und vierzig",
     44=>"vier und vierzig",
     45=>"fünf und vierzig",
     46=>"sechs und vierzig",
     47=>"sieben und vierzig",
     48=>"acht und vierzig",
     49=>"neun und vierzig",
     50=>"fünfzig",
     51=>"ein und fünfzig",
     52=>"zwei und fünfzig",
     53=>"drei und fünfzig",
     54=>"vier und fünfzig",
     55=>"fünf und fünfzig",
     56=>"sechs und fünfzig",
     57=>"sieben und fünfzig",
     58=>"acht und fünfzig",
     59=>"neun und fünfzig",
     60=>"sechzig",
     61=>"ein und sechzig",
     62=>"zwei und sechzig",
     63=>"drei und sechzig",
     64=>"vier und sechzig",
     65=>"fünf und sechzig",
     66=>"sechs und sechzig",
     67=>"sieben und sechzig",
     68=>"acht und sechzig",
     69=>"neun und sechzig",
     70=>"siebzig",
     71=>"ein und siebzig",
     72=>"zwei und siebzig",
     73=>"drei und siebzig",
     74=>"vier und siebzig",
     75=>"fünf und siebzig",
     76=>"sechs und siebzig",
     77=>"sieben und siebzig",
     78=>"acht und siebzig",
     79=>"neun und siebzig",
     80=>"achtzig",
     81=>"ein und achtzig",
     82=>"zwei und achtzig",
     83=>"drei und achtzig",
     84=>"vier und achtzig",
     85=>"fünf und achtzig",
     86=>"sechs und achtzig",
     87=>"sieben und achtzig",
     88=>"acht und achtzig",
     89=>"neun und achtzig",
     90=>"neunzig",
     91=>"ein und neunzig",
     92=>"zwei und neunzig",
     93=>"drei und neunzig",
     94=>"vier und neunzig",
     95=>"fünf und neunzig",
     96=>"sechs und neunzig",
     97=>"sieben und neunzig",
     98=>"acht und neunzig",
     99=>"neun und neunzig",
    100=>"ein hundert",
   },
  fr=>{0=>'zéro',
1=>'un',
2=>'deux',
3=>'trois',
4=>'quatre',
5=>'cinq',
6=>'six',
7=>'sept',
8=>'huit',
9=>'neuf',
10=>'dix',
11=>'onze',
12=>'douze',
13=>'treize',
14=>'quatorze',
15=>'quinze',
16=>'seize',
17=>'dix-sept',
18=>'dix-huit',
19=>'dix neuf',
20=>'vingt',
21=>'vingt et un',
22=>'vingt-deux',
23=>'vingt-trois',
24=>'vingt-quatre',
25=>'vingt-cinq',
26=>'vingt-six',
27=>'vingt-sept',
28=>'vingt-huit',
29=>'vingt-neuf',
30=>'trente',
31=>'trente et un',
32=>'trente-deux',
33=>'trente-trois',
34=>'trente-quatre',
35=>'trente-cinq',
36=>'trente-six',
37=>'trente-sept',
38=>'trente-huit',
39=>'trente-neuf',
40=>'quarante',
41=>'quarante et un',
42=>'quarante-deux',
43=>'quarante-trois',
44=>'quarante-quatre',
45=>'quarante-cinq',
46=>'quarante-six',
47=>'quarante-sept',
48=>'quarante-huit',
49=>'quarante-neuf',
50=>'cinquante',
51=>'cinquante et un',
52=>'cinquante-deux',
53=>'cinquante-trois',
54=>'cinquante-quatre',
55=>'cinquante-cinq',
56=>'cinquante-six',
57=>'cinquante-sept',
58=>'cinquante-huit',
59=>'cinquante-neuf',
60=>'soixante',
61=>'soixante et un',
62=>'soixante-deux',
63=>'soixante-trois',
64=>'soixante-quatre',
65=>'soixante-cinq',
66=>'soixante-six',
67=>'soixante-sept',
68=>'soixante-huit',
69=>'soixante-neuf',
70=>'soixante-dix',
71=>'soixante et onze',
72=>'soixante-douze',
73=>'soixante-treize',
74=>'soixante-quatorze',
75=>'soixante-quinze',
76=>'soixante-seize',
77=>'soixante-dix-sept',
78=>'soixante-dix-huit',
79=>'soixante-dix-neuf',
80=>'quatre-vingts',
81=>'quatre-vingt-un',
82=>'quatre-vingt-deux',
83=>'quatre-vingt-trois',
84=>'quatre-vingt-quatre',
85=>'quatre-vingt-cinq',
86=>'quatre-vingt-six',
87=>'quatre-vingt-sept',
88=>'quatre-vingt-huit',
89=>'quatre-vingt-neuf',
90=>'quatre-vingt-dix',
91=>'quatre-vingt-un',
92=>'quatre-vingt-douze',
93=>'quatre-vingt-treize',
94=>'quatre-vingt-quatorze',
95=>'quatre-vingt-quinze',
96=>'quatre-vingt-seize',
97=>'quatre-vingt-dix-sept',
98=>'quatre-vingt-dix-huit',
99=>'quatre-vingt-dix-neuf',
100=>'cent',},

}}

#-------------------------------------------------------------------------------
# Test
#-------------------------------------------------------------------------------

sub test
 {eval join('', <Text::Numbers::100::DATA>) || die $@
 }

test unless caller();

# Documentation
#extractDocumentation unless caller;

#-------------------------------------------------------------------------------
# Export
#-------------------------------------------------------------------------------

require Exporter;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

@ISA          = qw(Exporter);
@EXPORT       = qw();
@EXPORT_OK    = qw();
%EXPORT_TAGS  = (all=>[@EXPORT, @EXPORT_OK]);

1;

=pod

=encoding utf-8

=head1 Name

Text::Numbers::100 - Translate the numbers from 0 to 100 into various languages

=head1 Synopsis

 use Text::Numbers::100;

 ok Text::Numbers::100::translate(qw(es), 42) eq "cuarentay dos";
 ok Text::Numbers::100::translate(qw(de), 42) eq "zwei und vierzig";

=head1 Description

 Text::Numbers::100::translate($language, $number)

Translates a number from 0 to 100 into text in the following languages:

 cy da de en es fr is it ja nb nl pl pt ro ru sv tr

=head1 Installation

Standard Module::Build process for building and installing modules:

  perl Build.PL
  ./Build
  ./Build test
  ./Build install

=head1 Author

philiprbrenan@gmail.com

http://www.appaapps.com

=head1 Copyright

Copyright (c) 2017 Philip R Brenan.

This module is free software. It may be used, redistributed and/or modified
under the same terms as Perl itself.

=cut

__DATA__
use Test::More tests=>3;

ok Text::Numbers::100::translate(qw(es), 42) eq "cuarentay dos";
ok Text::Numbers::100::translate(qw(de), 42) eq "zwei und vierzig";
ok join(' ', Text::Numbers::100::languages) eq
   join(' ', qw(cy da de en es fr is it ja nb nl pl pt ro ru sv tr));
