#!/usr/bin/perl

use strict;
use warnings;

use Device::BusPirate;
use Getopt::Long;

GetOptions(
   'p|pirate=s' => \my $PIRATE,
   'b|baud=i'   => \my $BAUD,
   'i|interface=s' => \(my $INTERFACE = "SPI4"),
) or exit 1;

my $pirate = Device::BusPirate->new(
   serial => $PIRATE,
   baud   => $BAUD,
);

my $chip = $pirate->mount_chip( "SSD1306-$INTERFACE" )->get;

$chip->power(1)->get;

$SIG{INT} = $SIG{TERM} = sub { exit 1; };

END {
   $chip and $chip->power(0)->get;
   $pirate and $pirate->stop;
}

sub send_cmd { $chip->send_cmd( @_ ) }

$chip->init->get;

$chip->display( 1 )->get;
$chip->display_lamptest( 1 )->get;

sleep 3;

$chip->display_lamptest( 0 )->get;

sleep 2;

$chip->send_display( join "", ("\x5A") x (128*8) )->get;

sleep 5;

$chip->display( 0 )->get;
