package Bencher::Scenario::PERLANCAR::PERLANCARwarningsStartup;

our $DATE = '2016-04-13'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup overhead of warnings vs PERLANCAR::warnings::*',
    module_startup => 1,
    participants => [
        {module  => 'strict'},
        {module  => 'warnings'},
        {modules => ['strict', 'warnings']},
        {module  => 'PERLANCAR::warnings::all'},
        {modules => ['strict', 'PERLANCAR::warnings::all']},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of warnings vs PERLANCAR::warnings::*

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::PERLANCARwarningsStartup - Benchmark startup overhead of warnings vs PERLANCAR::warnings::*

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::PERLANCAR::PERLANCARwarningsStartup (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-04-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::PERLANCARwarningsStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<strict> 1.09

L<warnings> 1.32

L<PERLANCAR::warnings::all>

=head1 BENCHMARK PARTICIPANTS

=over

=item * strict (perl_code)

L<strict>



=item * warnings (perl_code)

L<warnings>



=item * strict+warnings (perl_code)

L<strict+warnings>



=item * PERLANCAR::warnings::all (perl_code)

L<PERLANCAR::warnings::all>



=item * strict+PERLANCAR::warnings::all (perl_code)

L<strict+PERLANCAR::warnings::all>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::PERLANCARwarningsStartup >>):

 +---------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                     | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------------------+-----------+------------------------+------------+---------+---------+
 | strict+warnings                 | 6         | 1.9                    | 1          | 3.9e-05 | 21      |
 | warnings                        | 5.6       | 1.5                    | 1.1        | 1.7e-05 | 20      |
 | strict+PERLANCAR::warnings::all | 4.9       | 0.800000000000001      | 1.2        | 4.6e-05 | 20      |
 | strict                          | 4.7       | 0.600000000000001      | 1.3        | 2.8e-05 | 20      |
 | PERLANCAR::warnings::all        | 4.4       | 0.300000000000001      | 1.4        | 1.9e-05 | 20      |
 | perl -e1 (baseline)             | 4.1       | 0                      | 1.5        | 1.2e-05 | 23      |
 +---------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
